/*
 * Decompiled with CFR 0.152.
 */
package jemu.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;

public class Compressor {
    public static byte[] gZip(byte[] input) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
            GZIPOutputStream gin = new GZIPOutputStream(bos);
            gin.write(input);
            gin.close();
            try {
                bos.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            byte[] compressedData = bos.toByteArray();
            return compressedData;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] gUnzip(byte[] input) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(input);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
            GZIPInputStream gin = new GZIPInputStream(bis);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = gin.read(buf)) > 0) {
                try {
                    bos.write(buf, 0, len);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            gin.close();
            byte[] decompressedData = bos.toByteArray();
            return decompressedData;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return Compressor.decompress(input);
        }
    }

    public static byte[] decompress(byte[] compressedData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                // empty catch block
                break;
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] decompressedData = bos.toByteArray();
        return decompressedData;
    }

    public static byte[] compress(byte[] input) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] compressedData = bos.toByteArray();
        return compressedData;
    }
}

