/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.cpu;

import java.util.ArrayList;
import java.util.List;
import jemu.core.Util;
import jemu.core.cpu.ProgramCounterObserver;
import jemu.core.device.Device;
import jemu.core.device.DeviceMapping;
import jemu.ui.Switches;

public abstract class Processor
extends Device {
    public int actualAddress;
    protected Device memory;
    protected DeviceMapping[] inputDevice = new DeviceMapping[0];
    protected DeviceMapping[] outputDevice = new DeviceMapping[0];
    protected Device cycleDevice = null;
    protected Device interruptDevice = null;
    protected int interruptPending = 0;
    protected long cycles = 0L;
    protected long cyclesPerSecond;
    private long cyclePreviousProgramCounter = 1048575L;
    protected boolean stopped = false;
    private List<ProgramCounterObserver> programCounterObservers = new ArrayList<ProgramCounterObserver>();

    public Processor(String type, long cyclesPerSecond) {
        super(type);
        this.cyclesPerSecond = cyclesPerSecond;
    }

    public void cycle(int count) {
        int cycleProgramCounter;
        while (count > 0) {
            ++this.cycles;
            this.cycleDevice.cycle();
            --count;
        }
        if (Switches.breakpoints && (long)(cycleProgramCounter = this.getProgramCounter()) != this.cyclePreviousProgramCounter) {
            this.notifyProgramCounterObservers();
            this.cyclePreviousProgramCounter = cycleProgramCounter;
        }
    }

    @Override
    public void cycle() {
        this.cycle(1);
    }

    @Override
    public void reset() {
        this.cycles = 0L;
    }

    public long getCycles() {
        return this.cycles;
    }

    public abstract void step();

    public abstract void stepOver();

    public void run() {
        this.stopped = false;
        do {
            this.step();
        } while (!this.stopped);
    }

    public void runTo(int address) {
        this.stopped = false;
        do {
            this.step();
        } while (!this.stopped && this.getProgramCounter() != address);
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    public final int readWord(int addr) {
        return this.readByte(addr) + (this.readByte(addr + 1 & 0xFFFF) << 8);
    }

    public final void writeWord(int addr, int value) {
        this.writeByte(addr, value);
        this.writeByte(addr + 1 & 0xFFFF, value >> 8);
    }

    @Override
    public int readByte(int address) {
        return this.memory.readByte(address);
    }

    @Override
    public int writeByte(int address, int value) {
        return this.memory.writeByte(address, value);
    }

    public final int in(int port) {
        int result = 255;
        for (int i = 0; i < this.inputDevice.length; ++i) {
            result &= this.inputDevice[i].readPort(port);
        }
        return result;
    }

    public final void out(int port, int value) {
        for (int i = 0; i < this.outputDevice.length; ++i) {
            try {
                this.outputDevice[i].writePort(port, value);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public final void setMemoryDevice(Device value) {
        this.memory = value;
    }

    public final Device getMemoryDevice() {
        return this.memory;
    }

    public final void addInputDeviceMapping(DeviceMapping value) {
        this.inputDevice = (DeviceMapping[])Util.arrayInsert(this.inputDevice, this.inputDevice.length, 1, value);
    }

    public final void removeInputDeviceMapping(DeviceMapping value) {
        this.inputDevice = (DeviceMapping[])Util.arrayDeleteElement(this.inputDevice, value);
    }

    public final void addOutputDeviceMapping(DeviceMapping value) {
        this.outputDevice = (DeviceMapping[])Util.arrayInsert(this.outputDevice, this.outputDevice.length, 1, value);
    }

    public final void removeOutputDeviceMapping(DeviceMapping value) {
        this.outputDevice = (DeviceMapping[])Util.arrayDeleteElement(this.outputDevice, value);
    }

    public final void setCycleDevice(Device value) {
        this.cycleDevice = value;
    }

    public final void setInterruptDevice(Device value) {
        this.interruptDevice = value;
    }

    @Override
    public void setInterrupt(int mask) {
        this.interruptPending |= mask;
    }

    @Override
    public void clearInterrupt(int mask) {
        this.interruptPending &= ~mask;
    }

    public abstract String getState();

    public abstract int getProgramCounter();

    public abstract int getStackPointer();

    public long getCyclesPerSecond() {
        return this.cyclesPerSecond;
    }

    public void setCyclesPerSecond(long value) {
        this.cyclesPerSecond = value;
    }

    public void attachProgramCounterObserver(ProgramCounterObserver o) {
        this.programCounterObservers.add(o);
    }

    public void detachProgramCounterObserver(ProgramCounterObserver o) {
        this.programCounterObservers.remove(o);
    }

    public void notifyProgramCounterObservers() {
        int address;
        this.actualAddress = address = this.getProgramCounter();
        if (!this.programCounterObservers.isEmpty()) {
            try {
                for (ProgramCounterObserver o : this.programCounterObservers) {
                    o.update(address);
                }
            }
            catch (Exception e) {
                System.err.println("A bug happened");
            }
        }
    }
}

