/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.floppy;

import jemu.core.device.Device;
import jemu.core.device.floppy.DiscImage;
import jemu.core.device.floppy.DriveListener;

public class Drive
extends Device {
    protected boolean DEBUG = false;
    public static final int HEAD_0 = 1;
    public static final int HEAD_1 = 2;
    public static final int BOTH_HEADS = 3;
    protected boolean ready = true;
    protected boolean active = false;
    protected boolean writeProtected = true;
    protected int cylinder = 0;
    protected int head = 0;
    protected int sector = 0;
    protected int sides = 1;
    protected DiscImage[] discs = new DiscImage[2];
    protected DriveListener activeListener = null;
    private int forcedHead = 0;

    public Drive(int sides) {
        super(null);
        this.setSides(sides);
    }

    public void setSides(int sides) {
        this.sides = sides;
        this.name = (sides == 1 ? "Single" : "Double") + "-Sided Floppy Drive";
    }

    public void setDisc(int heads, DiscImage value) {
        if ((heads & 1) != 0) {
            this.discs[0] = value;
        }
        if ((heads & 2) != 0) {
            this.discs[1] = value;
        }
    }

    public DiscImage getDisc(int head) {
        return this.discs[head];
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isWriteProtected() {
        this.writeProtected = false;
        return this.writeProtected;
    }

    public void setActiveListener(DriveListener value) {
        this.activeListener = value;
    }

    public void setActive(boolean value) {
        if (this.active != value) {
            this.active = value;
            if (this.activeListener != null) {
                this.activeListener.driveActiveChanged(this, this.active);
            }
        }
    }

    public void setCylinder(int value) {
        this.cylinder = value;
    }

    public int getCylinder() {
        return this.cylinder;
    }

    public void setHead(int value) {
        if (this.sides != 2) {
            this.head = 0;
            return;
        }
        this.head = (value | this.forcedHead) & 1;
    }

    public void setForcedHead(int head) {
        this.forcedHead = head;
    }

    public int getForcedHead() {
        return this.forcedHead;
    }

    public int getHead() {
        return this.head;
    }

    public int getSides() {
        return this.sides;
    }

    public int getSectorCount() {
        return this.discs[this.head] == null ? 0 : this.discs[this.head].getSectorCount(this.cylinder, this.head);
    }

    public int[] getNextSectorID() {
        int[] nArray;
        if (this.discs[this.head] == null) {
            return null;
        }
        int count = this.discs[this.head].getSectorCount(this.cylinder, this.head);
        if (count > 0) {
            this.sector = (this.sector + 1) % count;
            nArray = this.discs[this.head].getSectorID(this.cylinder, this.head, this.sector);
        } else {
            nArray = null;
        }
        return nArray;
    }

    public int[] getSectorID() {
        if (this.discs[this.head] == null) {
            return null;
        }
        int count = this.discs[this.head].getSectorCount(this.cylinder, this.head);
        return count > 0 ? this.discs[this.head].getSectorID(this.cylinder, this.head, this.sector %= count) : null;
    }

    public int[] getReadID() {
        if (this.discs[this.head] == null) {
            return null;
        }
        int count = this.discs[this.head].getSectorCount(this.cylinder, this.head);
        return count > 0 ? this.discs[this.head].getSectorID(this.cylinder, this.head, this.sector %= count) : null;
    }

    public void removeAllSectorsFromTrack() {
        if (this.discs[this.head] != null) {
            this.discs[this.head].removeAllSectorsFromTrack(this.cylinder, this.head);
        }
    }

    public void addSectorToTrack(int c, int h, int r, int n, int fillerByte) {
        if (this.discs[this.head] != null) {
            this.discs[this.head].addSectorToTrack(this.cylinder, this.head, c, h, r, n, fillerByte);
        }
    }

    public int getST1ForSector(int c, int h, int r, int n) {
        if (this.DEBUG) {
            System.out.println(" C:" + c + " H:" + h + " R:" + r + " N:" + n);
        }
        return this.discs[this.head] == null ? 0 : this.discs[this.head].getST1ForSector(this.cylinder, this.head, c, h, r, n);
    }

    public int getST2ForSector(int c, int h, int r, int n) {
        if (this.DEBUG) {
            System.out.println(" C:" + c + " H:" + h + " R:" + r + " N:" + n);
        }
        return this.discs[this.head] == null ? 0 : this.discs[this.head].getST2ForSector(this.cylinder, this.head, c, h, r, n);
    }

    public void setST1ForSector(int c, int h, int r, int n, int st1) {
        if (this.DEBUG) {
            System.out.println(" C:" + c + " H:" + h + " R:" + r + " N:" + n);
        }
        this.discs[this.head].setST1ForSector(this.cylinder, this.head, c, h, r, n, st1);
    }

    public void setST2ForSector(int c, int h, int r, int n, int st2) {
        if (this.DEBUG) {
            System.out.println(" C:" + c + " H:" + h + " R:" + r + " N:" + n);
        }
        this.discs[this.head].setST2ForSector(this.cylinder, this.head, c, h, r, n, st2);
    }

    public byte[] getSector(int c, int h, int r, int n) {
        if (this.DEBUG) {
            System.out.println(" C:" + c + " H:" + h + " R:" + r + " N:" + n);
        }
        return this.discs[this.head] == null ? null : this.discs[this.head].readSector(this.cylinder, this.head, c, h, r, n);
    }

    public void resetSector() {
        this.sector = 0;
    }

    public void writeSector(int c, int h, int r, int n, byte[] data) {
        if (this.discs[this.head] != null) {
            this.discs[this.head].writeSector(this.cylinder, this.head, c, h, r, n, data);
        }
    }

    public int getTracks() {
        if (this.discs[this.head] != null) {
            return this.discs[this.head].getNoOfTracks();
        }
        return 0;
    }

    public boolean step(int dir) {
        this.cylinder += dir;
        if (this.cylinder < 0) {
            this.cylinder = 0;
        }
        return this.cylinder == 0;
    }
}

