/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.floppy;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.JFrame;
import jemu.settings.Settings;
import jemu.ui.JEMU;

public class virtualDrive
extends JFrame
implements MouseListener,
MouseMotionListener {
    int x;
    int y;
    public int oldtrackpos;
    public int trackpos;
    protected boolean isClicked;
    protected boolean init = true;
    protected int oldY = 10;
    final String text = "a little graphic demo in Java";
    final URL dhead = this.getClass().getResource("drive_head.png");
    Image drivehead = this.getToolkit().getImage(this.dhead);
    final URL driv = this.getClass().getResource("drive.png");
    Image drivebase = this.getToolkit().getImage(this.driv);
    static boolean showIt;
    static boolean hideIt;
    public static boolean ledOn;
    int multipler = 2;
    public static Color LED_OFF;

    public void update() {
        if (this.init) {
            int x = Integer.parseInt(Settings.get("floppy_xpos", "0"));
            int y = Integer.parseInt(Settings.get("floppy_ypos", "0"));
            this.multipler = Integer.parseInt(Settings.get("floppy_zoom", "1"));
            this.setLocation(x, y);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.rePaint();
            this.init = false;
        }
        if (showIt && !this.isVisible()) {
            this.setVisible(true);
        }
        if (hideIt && this.isVisible()) {
            this.setVisible(false);
        }
        this.repaint();
    }

    public static void Show() {
        showIt = true;
        hideIt = false;
    }

    public static void Hide() {
        hideIt = true;
        showIt = false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.oldtrackpos != this.trackpos) {
            this.trackpos = this.trackpos % 42 / 2;
            this.trackpos *= this.multipler;
        }
        this.oldtrackpos = this.trackpos;
        g.drawImage(this.drivebase, 0, 0, this.drivebase.getWidth(this) * this.multipler, this.drivebase.getHeight(this) * this.multipler, this);
        g.drawImage(this.drivehead, 35 * this.multipler, 22 * this.multipler + this.trackpos, this.drivehead.getWidth(this) * this.multipler, this.drivehead.getHeight(this) * this.multipler, this);
        if (JEMU.ledOn) {
            g.setColor(Color.RED);
        } else {
            g.setColor(LED_OFF);
        }
        g.fillRect(6 * this.multipler, 158 * this.multipler, 8 * this.multipler, 2 * this.multipler);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int x = me.getXOnScreen();
        int y = me.getYOnScreen();
        int xf = this.getWidth() / 2;
        int yf = this.getHeight() / 2;
        this.setLocation(x - xf, y - yf);
        Settings.set("floppy_xpos", "" + (x - xf));
        Settings.set("floppy_ypos", "" + (y - yf));
    }

    protected void rePaint() {
        System.out.println("Zoomfactor is: " + this.multipler);
        this.setSize(98 * this.multipler, 160 * this.multipler);
        this.oldY = this.getHeight();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if ((e.getModifiers() & 0x10) == 0) {
                if (this.multipler > 1) {
                    --this.multipler;
                    Settings.set("floppy_zoom", "" + this.multipler);
                    this.rePaint();
                }
            } else if (this.multipler < 4) {
                ++this.multipler;
                Settings.set("floppy_zoom", "" + this.multipler);
                this.rePaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        ledOn = false;
        LED_OFF = new Color(144, 0, 0);
    }
}

