/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.io;

import jemu.core.device.Device;
import jemu.core.device.IOPort;

public class R6522
extends Device {
    public static final int PORT_A = 0;
    public static final int PORT_B = 1;
    protected static final int INT_CA2 = 1;
    protected static final int INT_CA1 = 2;
    protected static final int INT_SHIFT = 4;
    protected static final int INT_CB2 = 8;
    protected static final int INT_CB1 = 16;
    protected static final int INT_T2 = 32;
    protected static final int INT_T1 = 64;
    protected static final int INT_ANY = 128;
    protected static final int INT_SET = 128;
    protected static final int CA1_POSITIVE = 1;
    protected static final int CA2_OUTPUT = 8;
    protected static final int CA2_POSITIVE = 4;
    protected static final int CA2_CLEAR = 10;
    protected static final int CA2_INDEPENDENT = 2;
    protected static final int T1_FREE_RUN = 64;
    protected static final int T1_PB7 = 128;
    protected static final int T2_PB6 = 32;
    protected IOPort[] ports = new IOPort[]{new IOPort(0), new IOPort(0)};
    protected int t1c;
    protected int t1l;
    protected int t2c;
    protected int t2l;
    protected int sr;
    protected int acr;
    protected int pcr;
    protected int ifr;
    protected int ier;
    protected boolean ca1;
    protected boolean ca2;
    protected boolean cb1;
    protected boolean cb2;
    protected boolean nint;
    protected Device interruptDevice;
    protected int interruptMask;
    protected boolean t1int = false;
    protected boolean t2int = false;

    public R6522() {
        super("R6522 VIA");
        this.reset();
    }

    @Override
    public void reset() {
        this.ports[0].setPortMode(0);
        this.ports[1].setPortMode(0);
        this.ier = 128;
    }

    public void setInterruptDevice(Device device, int mask) {
        this.interruptDevice = device;
        this.interruptMask = mask;
    }

    @Override
    public int readPort(int port) {
        switch (port & 0xF) {
            case 0: {
                return this.ports[1].read();
            }
            case 1: {
                if ((this.pcr & 0xA) != 2) {
                    this.setIFR(this.ifr & 0xFFFFFFFC);
                } else {
                    this.setIFR(this.ifr & 0xFFFFFFFD);
                }
            }
            case 15: {
                return this.ports[0].read();
            }
            case 2: {
                return this.ports[1].getPortMode();
            }
            case 3: {
                return this.ports[0].getPortMode();
            }
            case 4: {
                this.setIFR(this.ifr & 0xFFFFFFBF);
                return this.t1c & 0xFF;
            }
            case 5: {
                return this.t1c >> 8;
            }
            case 6: {
                return this.t1l & 0xFF;
            }
            case 7: {
                return this.t1l >> 8;
            }
            case 8: {
                this.setIFR(this.ifr & 0xFFFFFFDF);
                return this.t2c & 0xFF;
            }
            case 9: {
                return this.t2c >> 8;
            }
            case 10: {
                return this.sr;
            }
            case 11: {
                return this.acr;
            }
            case 12: {
                return this.pcr;
            }
            case 13: {
                return this.ifr;
            }
        }
        return this.ier;
    }

    @Override
    public void writePort(int port, int value) {
        switch (port & 0xF) {
            case 0: {
                this.ports[1].write(value);
                break;
            }
            case 1: {
                if ((this.pcr & 0xA) != 2) {
                    this.setIFR(this.ifr & 0xFFFFFFFC);
                } else {
                    this.setIFR(this.ifr & 0xFFFFFFFD);
                }
            }
            case 15: {
                this.ports[0].write(value);
                break;
            }
            case 2: {
                this.ports[1].setPortMode(value);
                break;
            }
            case 3: {
                this.ports[0].setPortMode(value);
                break;
            }
            case 4: 
            case 6: {
                this.t1l = this.t1l & 0xFF00 | value;
                break;
            }
            case 5: {
                this.setIFR(this.ifr & 0xFFFFFFBF);
                this.t1c = this.t1l = this.t1l & 0xFF | value << 8;
                if ((this.acr & 0x80) != 0) {
                    this.ports[1].write(this.ports[1].getOutput() & 0x7F);
                }
                this.t1int = true;
                break;
            }
            case 7: {
                this.setIFR(this.ifr & 0xFFFFFFBF);
                this.t1l = this.t1l & 0xFF | value << 8;
                break;
            }
            case 8: {
                this.t2l = value;
                break;
            }
            case 9: {
                this.setIFR(this.ifr & 0xFFFFFFDF);
                this.t2c = this.t2l | value << 8;
                this.t2int = true;
                break;
            }
            case 10: {
                this.sr = value;
                break;
            }
            case 11: {
                this.acr = value;
                break;
            }
            case 12: {
                this.pcr = value;
                break;
            }
            case 13: {
                this.setIFR(this.ifr & ~(value & 0x7F));
                break;
            }
            case 14: {
                this.ier = (value & 0x80) != 0 ? (this.ier |= value) : (this.ier &= ~(value & 0x7F));
                this.setIFR(this.ifr);
            }
        }
    }

    protected void setIFR(int value) {
        int oldInt = this.ifr & 0x80;
        if ((value & this.ier & 0x7F) != 0) {
            this.ifr = value | 0x80;
            if (oldInt == 0 && this.interruptDevice != null) {
                this.interruptDevice.setInterrupt(this.interruptMask);
            }
        } else {
            this.ifr = value & 0x7F;
            if (oldInt != 0 && this.interruptDevice != null) {
                this.interruptDevice.clearInterrupt(this.interruptMask);
            }
        }
    }

    public IOPort getPort(int port) {
        return this.ports[port];
    }

    public void setCA1(boolean value) {
        if (this.ca1 != value) {
            this.ca1 = value;
            if ((this.pcr & 1) != 0 == value) {
                this.setIFR(this.ifr | 2);
            }
        }
    }

    public void setCA2(boolean value) {
        if (this.ca2 != value) {
            this.ca2 = value;
            if ((this.pcr & 8) == 0 && (this.pcr & 4) != 0 == value) {
                this.setIFR(this.ifr | 1);
            }
        }
    }

    @Override
    public void cycle() {
        if (this.t1c == 65535) {
            if ((this.acr & 0x40) != 0) {
                this.t1c = this.t1l;
                if ((this.acr & 0x80) != 0) {
                    this.ports[1].write(this.ports[1].getOutput() ^ 0x80);
                }
                this.setIFR(this.ifr | 0x40);
            } else if (this.t1int) {
                if ((this.acr & 0x80) != 0) {
                    this.ports[1].write(this.ports[1].getOutput() | 0x80);
                }
                this.setIFR(this.ifr | 0x40);
                this.t1int = false;
            } else {
                this.t1c = 65534;
            }
        } else {
            this.t1c = this.t1c - 1 & 0xFFFF;
        }
        if ((this.acr & 0x20) == 0) {
            if (this.t2int && this.t2c == 0) {
                this.setIFR(this.ifr | 0x20);
                this.t2int = false;
            }
            this.t2c = this.t2c - 1 & 0xFFFF;
        }
    }
}

