/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.printer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import jemu.core.Util;
import jemu.core.device.printer.Font2;
import jemu.core.device.printer.PrinterFont;
import jemu.core.device.printer.SmallFont;
import jemu.core.samples.Samples;
import jemu.system.cpc.CPC;
import jemu.ui.Display;
import jemu.ui.paint.PaintCanvas;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DMP2000
extends JPanel {
    boolean printeron = true;
    int font = 0;
    PaintCanvas canvas;
    PrinterFont font1;
    SmallFont font2;
    Font2 font3;
    byte[] letter;
    BufferedImage page;
    BufferedImage pageout;
    BufferedImage matrixpage;
    BufferedImage gfx;
    BufferedImage paper;
    Thread printer;
    int zoomx;
    int zoomy;
    int xdpi;
    int ydpi;
    boolean condensed = false;
    boolean halfheight = false;
    boolean doublewidth = false;
    boolean doubleheight = false;
    boolean draft = true;
    protected int printerWidth;
    protected int printerHeight;
    int left;
    int right;
    int pwidth;
    int pheight;
    boolean NLQ = false;
    Thread printerthread;
    int hq = 1;
    BufferedImage glass;
    boolean plotting;
    boolean minitext;
    private JComboBox fchooser;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JCheckBox jCheckBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private Panel panel1;
    private Panel panel2;
    private Panel panel3;
    private JSlider phead;
    private JCheckBox preview;
    private JLabel printarea;
    private JCheckBox recycle;
    private JSlider ribbon;
    int head = 0;
    int step = 2;
    int ppos = 0;
    int yloc = 0;
    int yprint = 0;
    int painthole = 0;
    Color recycling = new Color(0, 0, 0, 30);
    Graphics2D g2;
    protected boolean feedpage = false;
    protected boolean storep = true;
    boolean feeding;
    BufferedImage parea;
    int count = 0;
    boolean painted;
    boolean painting;
    int headx = 0;
    int charwidth;
    int charheight;
    int oldfont = -1;
    int ypos = 4;
    boolean bold = false;
    boolean italic = false;
    boolean uppercase = false;
    boolean preparechar = false;
    boolean definechar = false;
    boolean defineNLQ = false;
    boolean control = false;

    public DMP2000() {
        this.printerthread = new Thread(){

            @Override
            public void run() {
                DMP2000.this.paper = DMP2000.this.readImage("paper.png");
                DMP2000.this.glass = DMP2000.this.readImage("glossywindow.png");
                int psize = 1240;
                DMP2000.this.pwidth = psize * DMP2000.this.hq;
                DMP2000.this.pheight = (int)((double)psize * 1.41 * (double)DMP2000.this.hq);
                DMP2000.this.pageout = new BufferedImage(DMP2000.this.pwidth, DMP2000.this.pheight, 4);
                DMP2000.this.canvas = new PaintCanvas();
                DMP2000.this.left = 4;
                DMP2000.this.right = 3;
                DMP2000.this.font1 = new PrinterFont();
                DMP2000.this.font2 = new SmallFont();
                DMP2000.this.font3 = new Font2();
                DMP2000.this.zoomx = 6;
                DMP2000.this.zoomy = 6;
                DMP2000.this.xdpi = 8;
                DMP2000.this.ydpi = 12;
                DMP2000.this.printerWidth = 595;
                DMP2000.this.printerHeight = 760;
                DMP2000.this.initComponents();
                DMP2000.this.page = new BufferedImage(DMP2000.this.printerWidth, DMP2000.this.printerHeight, 4);
                DMP2000.this.matrixpage = new BufferedImage(DMP2000.this.printerWidth * DMP2000.this.zoomx, DMP2000.this.printerHeight * DMP2000.this.zoomy, 4);
                DMP2000.this.pageout = new BufferedImage(DMP2000.this.pwidth, DMP2000.this.pheight, 4);
            }
        };
        this.printerthread.run();
    }

    public void setHQ() {
        this.hq = this.jCheckBox1.isSelected() ? 2 : 1;
        int psize = 1240;
        this.pwidth = psize * this.hq;
        this.pheight = (int)((double)psize * 1.41 * (double)this.hq);
        this.pageout = new BufferedImage(this.pwidth, this.pheight, 4);
    }

    public void loadImage() {
        this.gfx = new BufferedImage(640, 400, 1);
        Graphics b = this.gfx.getGraphics();
        Graphics2D g3 = (Graphics2D)b;
        g3.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        b = g3;
        b.drawImage(Display.image, -64, -72, 768, 544, null);
        this.rasterImage(this.gfx);
    }

    public void rasterImage(BufferedImage image) {
        this.canvas.rasterval = 20;
        int[] palette = new int[]{0, 0xFFFFFF};
        this.canvas.buildCPCScreen(image, palette);
    }

    public void printLine(byte[] data) {
    }

    public void plot() {
        if (this.plotting) {
            return;
        }
        Thread plot = new Thread(){

            @Override
            public void run() {
                DMP2000.this.plotting = true;
                if (DMP2000.this.ppos < DMP2000.this.leftmargin(DMP2000.this.left)) {
                    DMP2000.this.ppos = DMP2000.this.leftmargin(DMP2000.this.left);
                }
                Graphics t = DMP2000.this.parea.getGraphics();
                if (DMP2000.this.g2 == null) {
                    DMP2000.this.g2 = (Graphics2D)t;
                    DMP2000.this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                t = DMP2000.this.g2;
                int xoffset = DMP2000.this.ppos;
                int yoffset = DMP2000.this.ypos;
                Graphics g = DMP2000.this.page.getGraphics();
                Graphics r = DMP2000.this.matrixpage.getGraphics();
                Graphics2D gg = (Graphics2D)r;
                gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                r = gg;
                int needlex = 0;
                int needley = 0;
                int width = DMP2000.this.gfx.getWidth();
                int height = DMP2000.this.gfx.getHeight();
                int weakness = DMP2000.this.ribbon.getValue();
                double xf = 0.0;
                double yf = 0.0;
                for (int yd = 0; yd < height; ++yd) {
                    yf = DMP2000.this.halfheight ? (yf += 0.5) : (DMP2000.this.doubleheight ? (yf += 2.0) : (yf += 1.0));
                    xf = 0.0;
                    int y = (int)yf;
                    for (int xd = 0; xd < width; ++xd) {
                        Color test2 = new Color(DMP2000.this.gfx.getRGB(xd, yd));
                        xf = DMP2000.this.condensed ? (xf += 0.6) : (DMP2000.this.doublewidth ? (xf += 2.0) : (xf += 1.0));
                        int x = (int)xf;
                        int h = test2.getGreen();
                        if (h != 0 || x + xoffset > DMP2000.this.printerWidth - DMP2000.this.rightmargin(DMP2000.this.right)) continue;
                        DMP2000.this.makeNoise(DMP2000.this.random(6), needley);
                        if (needlex > 6) {
                            needlex = 0;
                        }
                        int v = DMP2000.this.random(weakness);
                        g.setColor(new Color(v, v, v, 230));
                        g.drawLine(x + xoffset, y + yoffset, x + xoffset, y + yoffset);
                        int xx = (x + xoffset) * DMP2000.this.zoomx;
                        int yy = (y + yoffset) * DMP2000.this.zoomy;
                        r.setColor(new Color(v, v, v, 140));
                        r.fillOval(xx, yy, DMP2000.this.zoomx - 1, DMP2000.this.zoomy - 1);
                        v = DMP2000.this.random(weakness);
                        r.setColor(new Color(v, v, v, 230));
                        r.fillOval(xx + DMP2000.this.zoomx / 2, yy + DMP2000.this.zoomy / 2, DMP2000.this.zoomx - 3, DMP2000.this.zoomy - 3);
                        if (!DMP2000.this.NLQ) continue;
                        v = DMP2000.this.random(weakness);
                        r.setColor(new Color(v, v, v, 140));
                        r.fillOval(xx, yy + 1, DMP2000.this.zoomx - 1, DMP2000.this.zoomy - 1);
                        r.fillOval(xx, yy + 2, DMP2000.this.zoomx - 1, DMP2000.this.zoomy - 1);
                        r.fillOval(xx, yy + 3, DMP2000.this.zoomx - 1, DMP2000.this.zoomy - 1);
                        r.fillOval(xx + 1, yy, DMP2000.this.zoomx - 1, DMP2000.this.zoomy - 1);
                        v = DMP2000.this.random(weakness);
                        r.setColor(new Color(v, v, v, 230));
                        r.fillOval(xx + 2, yy + 1, DMP2000.this.zoomx - 1, DMP2000.this.zoomy - 1);
                        r.fillOval(xx + 2, yy + 2, DMP2000.this.zoomx - 1, DMP2000.this.zoomy - 1);
                        r.fillOval(xx + 2, yy + 3, DMP2000.this.zoomx - 1, DMP2000.this.zoomy - 1);
                        r.fillOval(xx + 3, yy, DMP2000.this.zoomx - 1, DMP2000.this.zoomy - 1);
                    }
                    if (needley++ <= 8) continue;
                    needley = 0;
                    Samples.CARRET.play();
                    DMP2000.this.rest(5);
                    if (DMP2000.this.halfheight) {
                        DMP2000.this.ypos += 4;
                        DMP2000.this.yprint += 4;
                    } else {
                        DMP2000.this.ypos += 8;
                        DMP2000.this.yprint += 8;
                    }
                    DMP2000.this.checkPage(g, t, true);
                }
                DMP2000.this.PaperFeed(true);
                DMP2000.this.plotting = false;
            }
        };
        plot.start();
    }

    public int leftmargin(int width) {
        return width * 8;
    }

    public int rightmargin(int width) {
        return (width + 1) * 8;
    }

    public void halfheight(boolean halfh) {
        this.halfheight = halfh;
        this.ydpi = this.halfheight ? 6 : 12;
    }

    public void mini(boolean halfh) {
        this.minitext = halfh;
        this.halfheight = halfh;
        this.condensed = halfh;
        if (this.halfheight) {
            this.ydpi = 6;
            this.xdpi = 4;
        } else {
            this.ydpi = 12;
            this.xdpi = 8;
        }
    }

    public void condensed(boolean cond) {
        this.condensed = cond;
        this.xdpi = cond ? 5 : 8;
    }

    public void doublewidth(boolean dwidth) {
        this.doublewidth = dwidth;
        this.xdpi = this.doublewidth ? 16 : 8;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.phead = new JSlider();
        this.printarea = new JLabel();
        this.jPanel3 = new JPanel();
        this.panel1 = new Panel();
        this.panel2 = new Panel();
        this.panel3 = new Panel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.ribbon = new JSlider();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.recycle = new JCheckBox();
        this.fchooser = new JComboBox();
        this.preview = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.jPanel1.setBackground(new Color(40, 40, 40));
        this.jPanel2.setBackground(new Color(80, 80, 80));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.phead.setBackground(new Color(0, 0, 0));
        this.phead.setForeground(new Color(51, 51, 51));
        this.phead.setMaximum(650);
        this.phead.setPaintTrack(false);
        this.phead.setValue(0);
        this.jPanel2.add((Component)this.phead, new AbsoluteConstraints(10, 360, 650, -1));
        this.printarea.setBackground(new Color(51, 51, 51));
        this.printarea.setDoubleBuffered(true);
        this.printarea.setOpaque(true);
        this.jPanel2.add((Component)this.printarea, new AbsoluteConstraints(10, 0, 650, 360));
        this.jPanel3.setBackground(new Color(90, 90, 90));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setLayout(new AbsoluteLayout());
        this.panel1.setBackground(new Color(0, 255, 0));
        GroupLayout panel1Layout = new GroupLayout(this.panel1);
        this.panel1.setLayout(panel1Layout);
        panel1Layout.setHorizontalGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 11, Short.MAX_VALUE));
        panel1Layout.setVerticalGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 5, Short.MAX_VALUE));
        this.jPanel3.add((Component)this.panel1, new AbsoluteConstraints(10, 30, 11, 5));
        this.panel2.setBackground(new Color(255, 102, 0));
        this.panel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                DMP2000.this.panel2MouseReleased(evt);
            }
        });
        GroupLayout panel2Layout = new GroupLayout(this.panel2);
        this.panel2.setLayout(panel2Layout);
        panel2Layout.setHorizontalGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 11, Short.MAX_VALUE));
        panel2Layout.setVerticalGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 5, Short.MAX_VALUE));
        this.jPanel3.add((Component)this.panel2, new AbsoluteConstraints(10, 70, 11, 5));
        this.panel3.setBackground(new Color(0, 255, 0));
        GroupLayout panel3Layout = new GroupLayout(this.panel3);
        this.panel3.setLayout(panel3Layout);
        panel3Layout.setHorizontalGroup(panel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 11, Short.MAX_VALUE));
        panel3Layout.setVerticalGroup(panel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 5, Short.MAX_VALUE));
        this.jPanel3.add((Component)this.panel3, new AbsoluteConstraints(10, 100, 11, 5));
        this.jButton1.setFont(new Font("Tahoma", 0, 10));
        this.jButton1.setText("Power");
        this.jButton1.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMP2000.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.jButton1, new AbsoluteConstraints(50, 90, 36, -1));
        this.jButton2.setFont(new Font("Tahoma", 0, 10));
        this.jButton2.setText("Online");
        this.jButton2.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMP2000.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.jButton2, new AbsoluteConstraints(50, 20, 36, -1));
        this.jButton3.setFont(new Font("Tahoma", 0, 10));
        this.jButton3.setText("F.F.");
        this.jButton3.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMP2000.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.jButton3, new AbsoluteConstraints(50, 60, 36, -1));
        this.ribbon.setBackground(new Color(40, 40, 40));
        this.ribbon.setMajorTickSpacing(10);
        this.ribbon.setMaximum(250);
        this.ribbon.setOrientation(1);
        this.ribbon.setPaintTicks(true);
        this.ribbon.setSnapToTicks(true);
        this.ribbon.setValue(10);
        this.jButton4.setText("Get");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMP2000.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setText("Plot");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMP2000.this.jButton5ActionPerformed(evt);
            }
        });
        this.recycle.setBackground(new Color(40, 40, 40));
        this.recycle.setForeground(new Color(255, 255, 255));
        this.recycle.setSelected(true);
        this.recycle.setText("Recycling paper");
        this.recycle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMP2000.this.recycleActionPerformed(evt);
            }
        });
        this.fchooser.setModel(new DefaultComboBoxModel<String>(new String[]{"Font 1", "Font 2", "Font 3"}));
        this.preview.setBackground(new Color(40, 40, 40));
        this.preview.setForeground(new Color(255, 255, 255));
        this.preview.setText("Preview");
        this.preview.setFocusPainted(false);
        this.preview.setFocusable(false);
        this.jCheckBox1.setBackground(new Color(40, 40, 40));
        this.jCheckBox1.setForeground(new Color(255, 255, 255));
        this.jCheckBox1.setText("HQ output");
        this.jCheckBox1.setFocusPainted(false);
        this.jCheckBox1.setFocusable(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMP2000.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.recycle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.preview).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ribbon, -2, -1, -2).addComponent(this.jButton5, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 666, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -1, 117, Short.MAX_VALUE).addComponent(this.fchooser, -2, -1, -2)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.ribbon, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5)).addComponent(this.fchooser, -2, -1, -2)).addGap(56, 56, 56).addComponent(this.jPanel3, -2, 119, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.recycle).addComponent(this.preview).addComponent(this.jCheckBox1)).addContainerGap(18, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Center");
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        if (this.printeron) {
            this.PaperFeed(true);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.printeron = !this.printeron;
        this.panel3.setBackground(this.printeron ? Color.GREEN : new Color(0, 40, 0));
        this.panel1.setBackground(CPC.printeronline ? (this.printeron ? Color.GREEN : new Color(0, 40, 0)) : new Color(0, 40, 0));
        this.panel2.setBackground(this.printeron ? new Color(255, 102, 0) : new Color(40, 20, 0));
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.loadImage();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.plot();
    }

    private void recycleActionPerformed(ActionEvent evt) {
        if (this.printeron) {
            this.PaperFeed(false);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.printeron) {
            CPC.printeronline = !CPC.printeronline;
            this.panel1.setBackground(CPC.printeronline ? Color.GREEN : new Color(0, 40, 0));
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.setHQ();
    }

    private void panel2MouseReleased(MouseEvent evt) {
        this.selfTest();
    }

    public void clearPage() {
        this.ppos = 0;
        this.ypos = 20;
        this.yprint = 0;
        Graphics g = this.page.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.page.getWidth(), this.page.getHeight());
        g.drawImage(this.paper, 0, 0, this.page.getWidth(), this.page.getHeight(), null);
        if (this.recycle.isSelected()) {
            g.setColor(this.recycling);
            g.fillRect(0, 0, this.page.getWidth(), this.page.getHeight());
        }
        this.drawPaper(g);
        g = this.matrixpage.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.matrixpage.getWidth(), this.matrixpage.getHeight());
        g.drawImage(this.paper, 0, 0, this.matrixpage.getWidth(), this.matrixpage.getHeight(), null);
        if (this.recycle.isSelected()) {
            g.setColor(this.recycling);
            g.fillRect(0, 0, this.matrixpage.getWidth(), this.matrixpage.getHeight());
        }
        this.yloc = 340;
    }

    public void PaperFeed(final boolean storepage) {
        if (this.feeding) {
            return;
        }
        Thread feed = new Thread(){

            @Override
            public void run() {
                DMP2000.this.panel2.setBackground(new Color(40, 20, 0));
                DMP2000.this.feeding = true;
                DMP2000.this.storep = storepage;
                DMP2000.this.feedpage = true;
                while (DMP2000.this.feedpage) {
                    DMP2000.this.painted = false;
                    DMP2000.this.print(10);
                    while (!DMP2000.this.painted) {
                        DMP2000.this.rest(1);
                    }
                }
                DMP2000.this.feeding = false;
                DMP2000.this.panel2.setBackground(new Color(255, 102, 0));
            }
        };
        feed.start();
    }

    public BufferedImage readImage(String filename) {
        try {
            URL imagein = this.getClass().getResource(filename);
            BufferedImage bi = ImageIO.read(imagein);
            return bi;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void print(int input) {
        if (!this.printeron) {
            return;
        }
        if (this.parea == null) {
            this.parea = new BufferedImage(this.printarea.getWidth(), this.printarea.getHeight(), 1);
        }
        Graphics t = this.parea.getGraphics();
        Graphics g = this.page.getGraphics();
        if (this.g2 == null) {
            this.g2 = (Graphics2D)t;
            this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        t = this.g2;
        if (input == 10) {
            this.pause(10);
            this.ppos = 20;
            this.ypos += this.ydpi;
            this.yprint += this.ydpi;
            this.checkPage(g, t, true);
            this.phead.setValue(30);
            return;
        }
        if (input == 13) {
            this.pause(150);
            this.ppos = 20;
            this.checkPage(g, t, false);
            this.phead.setValue(30);
            return;
        }
        int weakness = this.ribbon.getValue();
        weakness = this.random(weakness);
        g.setColor(new Color(weakness, weakness, weakness, 200));
        if (input == 27) {
            this.control = true;
        }
        if (this.control) {
            this.control((char)input);
            return;
        }
        if (this.ppos < this.leftmargin(this.left)) {
            this.ppos = this.leftmargin(this.left);
        }
        this.plotLetter(g, this.ppos, (char)input);
        this.checkPage(g, t, false);
        this.ppos += this.xdpi;
        if (this.ppos > this.printerWidth - this.rightmargin(this.right)) {
            this.ppos = 0;
            this.ypos += this.ydpi;
            this.yprint += this.ydpi;
            this.checkPage(g, t, false);
            this.pause(100);
        }
    }

    public void pause(int pause) {
        Samples.CARRET.play();
        try {
            Thread.sleep(pause);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rest(int pause) {
        try {
            Thread.sleep(pause);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkPage(Graphics g, Graphics t, boolean paint) {
        if (this.ypos > this.printerHeight - 30) {
            if (this.storep && !this.preview.isSelected()) {
                this.savePage();
            }
            this.storep = true;
            g.setColor(new Color(0, 0, 0, 60));
            g.fillRect(0, 0, this.page.getWidth(), this.page.getHeight());
            this.paintpage(g, t);
            this.clearPage();
            this.feedpage = false;
        }
        this.phead.setValue(this.headx);
        if (paint) {
            this.paintpage(g, t);
        }
    }

    public void paintpage(Graphics g, final Graphics t) {
        if (this.painting) {
            return;
        }
        this.painting = true;
        Thread painter = new Thread(){

            @Override
            public void run() {
                t.drawImage(DMP2000.this.page, 0, DMP2000.this.yloc - DMP2000.this.yprint, 650, DMP2000.this.printerHeight + DMP2000.this.yloc - DMP2000.this.yprint, 0, 0, DMP2000.this.printerWidth, DMP2000.this.printerHeight, null);
                t.drawImage(DMP2000.this.glass, 0, 0, DMP2000.this.printarea.getWidth(), DMP2000.this.printarea.getHeight(), null);
                DMP2000.this.printarea.setIcon(new ImageIcon(DMP2000.this.parea));
                DMP2000.this.painted = true;
                DMP2000.this.painting = false;
            }
        };
        painter.start();
    }

    public void savePage() {
        String name = "printout_" + this.count++ + ".jpg";
        File check = new File(name);
        while (check.exists()) {
            name = "printout_" + this.count++ + ".jpg";
            check = new File(name);
        }
        Graphics t = this.pageout.getGraphics();
        Graphics g = this.matrixpage.getGraphics();
        Graphics2D gg = (Graphics2D)t;
        gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        t = gg;
        t.drawImage(this.matrixpage, 0, 0, this.pwidth, this.pheight, null);
        this.savescreen(this.pageout, name, "jpg");
    }

    public void dump(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.print(text.charAt(i));
        }
        this.print(10);
    }

    public void selfTest() {
        Thread self = new Thread(){

            @Override
            public void run() {
                String out = "DMP 2000 emulation";
                DMP2000.this.dump(out);
                out = "SelfTest page";
                DMP2000.this.bold = false;
                DMP2000.this.italic = false;
                DMP2000.this.dump(out);
                DMP2000.this.print(10);
                out = "------------------------------------------------------------------";
                DMP2000.this.dump(out);
                DMP2000.this.print(10);
                DMP2000.this.print(10);
                for (int t = 0; t < 2; ++t) {
                    for (int k = 0; k < 2; ++k) {
                        for (int x = 0; x < 2; ++x) {
                            DMP2000.this.condensed(!DMP2000.this.condensed);
                            for (int i = 0; i < 2; ++i) {
                                for (int p = 0; p < 2; ++p) {
                                    for (int y = 32; y < 128; ++y) {
                                        DMP2000.this.print(y);
                                    }
                                    DMP2000.this.bold = !DMP2000.this.bold;
                                }
                                DMP2000.this.print(10);
                                DMP2000.this.italic = !DMP2000.this.italic;
                            }
                            DMP2000.this.print(10);
                            out = DMP2000.this.condensed ? "-----------------------------------------------------------------------------------------------------------" : "------------------------------------------------------------------";
                            DMP2000.this.dump(out);
                        }
                        DMP2000.this.NLQ = !DMP2000.this.NLQ;
                    }
                    DMP2000.this.mini(!DMP2000.this.minitext);
                }
                DMP2000.this.mini(false);
                DMP2000.this.PaperFeed(true);
                DMP2000.this.bold = false;
                DMP2000.this.NLQ = false;
                DMP2000.this.italic = false;
            }
        };
        self.start();
    }

    public void savescreen(BufferedImage ima, String filename, String filetype) {
        try {
            File file = new File(filename);
            ImageIO.write((RenderedImage)ima, filetype, file);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void drawPaper(Graphics g) {
        for (int i = 0; i < this.printerHeight; i += 10) {
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(20, i, 20, i + 4);
            g.drawLine(this.printerWidth - 20, i, this.printerWidth - 20, i + 4);
            ++this.painthole;
            if (this.painthole != 3) continue;
            g.setColor(Color.BLACK);
            this.painthole = 0;
            g.fillOval(4, i, 8, 8);
            g.fillOval(this.printerWidth - 14, i, 8, 8);
        }
    }

    public void setLetter(char let) {
        this.font = this.fchooser.getSelectedIndex();
        block0 : switch (this.font) {
            case 0: {
                this.charwidth = this.font1.width;
                this.charheight = this.font1.height;
                if (this.letter == null || this.oldfont != this.font) {
                    this.oldfont = this.font;
                    this.letter = new byte[this.font1.char32.length];
                }
                switch (let) {
                    case ' ': {
                        System.arraycopy(this.font1.char32, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '!': {
                        System.arraycopy(this.font1.char33, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\"': {
                        System.arraycopy(this.font1.char34, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '#': {
                        System.arraycopy(this.font1.char35, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '$': {
                        System.arraycopy(this.font1.char36, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '%': {
                        System.arraycopy(this.font1.char37, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '&': {
                        System.arraycopy(this.font1.char38, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\'': {
                        System.arraycopy(this.font1.char39, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '(': {
                        System.arraycopy(this.font1.char40, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ')': {
                        System.arraycopy(this.font1.char41, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '*': {
                        System.arraycopy(this.font1.char42, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '+': {
                        System.arraycopy(this.font1.char43, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ',': {
                        System.arraycopy(this.font1.char44, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '-': {
                        System.arraycopy(this.font1.char45, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '.': {
                        System.arraycopy(this.font1.char46, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '/': {
                        System.arraycopy(this.font1.char47, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '0': {
                        System.arraycopy(this.font1.char48, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '1': {
                        System.arraycopy(this.font1.char49, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '2': {
                        System.arraycopy(this.font1.char50, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '3': {
                        System.arraycopy(this.font1.char51, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '4': {
                        System.arraycopy(this.font1.char52, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '5': {
                        System.arraycopy(this.font1.char53, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '6': {
                        System.arraycopy(this.font1.char54, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '7': {
                        System.arraycopy(this.font1.char55, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '8': {
                        System.arraycopy(this.font1.char56, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '9': {
                        System.arraycopy(this.font1.char57, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ':': {
                        System.arraycopy(this.font1.char58, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ';': {
                        System.arraycopy(this.font1.char59, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '<': {
                        System.arraycopy(this.font1.char60, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '=': {
                        System.arraycopy(this.font1.char61, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '>': {
                        System.arraycopy(this.font1.char62, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '?': {
                        System.arraycopy(this.font1.char63, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '@': {
                        System.arraycopy(this.font1.char64, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'A': {
                        System.arraycopy(this.font1.char65, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'B': {
                        System.arraycopy(this.font1.char66, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'C': {
                        System.arraycopy(this.font1.char67, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'D': {
                        System.arraycopy(this.font1.char68, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'E': {
                        System.arraycopy(this.font1.char69, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'F': {
                        System.arraycopy(this.font1.char70, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'G': {
                        System.arraycopy(this.font1.char71, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'H': {
                        System.arraycopy(this.font1.char72, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'I': {
                        System.arraycopy(this.font1.char73, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'J': {
                        System.arraycopy(this.font1.char74, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'K': {
                        System.arraycopy(this.font1.char75, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'L': {
                        System.arraycopy(this.font1.char76, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'M': {
                        System.arraycopy(this.font1.char77, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'N': {
                        System.arraycopy(this.font1.char78, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'O': {
                        System.arraycopy(this.font1.char79, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'P': {
                        System.arraycopy(this.font1.char80, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'Q': {
                        System.arraycopy(this.font1.char81, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'R': {
                        System.arraycopy(this.font1.char82, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'S': {
                        System.arraycopy(this.font1.char83, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'T': {
                        System.arraycopy(this.font1.char84, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'U': {
                        System.arraycopy(this.font1.char85, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'V': {
                        System.arraycopy(this.font1.char86, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'W': {
                        System.arraycopy(this.font1.char87, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'X': {
                        System.arraycopy(this.font1.char88, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'Y': {
                        System.arraycopy(this.font1.char89, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'Z': {
                        System.arraycopy(this.font1.char90, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '[': {
                        System.arraycopy(this.font1.char91, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\\': {
                        System.arraycopy(this.font1.char92, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ']': {
                        System.arraycopy(this.font1.char93, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '^': {
                        System.arraycopy(this.font1.char94, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '_': {
                        System.arraycopy(this.font1.char95, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '`': {
                        System.arraycopy(this.font1.char96, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'a': {
                        System.arraycopy(this.font1.char97, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'b': {
                        System.arraycopy(this.font1.char98, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'c': {
                        System.arraycopy(this.font1.char99, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'd': {
                        System.arraycopy(this.font1.char100, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'e': {
                        System.arraycopy(this.font1.char101, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'f': {
                        System.arraycopy(this.font1.char102, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'g': {
                        System.arraycopy(this.font1.char103, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'h': {
                        System.arraycopy(this.font1.char104, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'i': {
                        System.arraycopy(this.font1.char105, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'j': {
                        System.arraycopy(this.font1.char106, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'k': {
                        System.arraycopy(this.font1.char107, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'l': {
                        System.arraycopy(this.font1.char108, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'm': {
                        System.arraycopy(this.font1.char109, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'n': {
                        System.arraycopy(this.font1.char110, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'o': {
                        System.arraycopy(this.font1.char111, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'p': {
                        System.arraycopy(this.font1.char112, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'q': {
                        System.arraycopy(this.font1.char113, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'r': {
                        System.arraycopy(this.font1.char114, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 's': {
                        System.arraycopy(this.font1.char115, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 't': {
                        System.arraycopy(this.font1.char116, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'u': {
                        System.arraycopy(this.font1.char117, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'v': {
                        System.arraycopy(this.font1.char118, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'w': {
                        System.arraycopy(this.font1.char119, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'x': {
                        System.arraycopy(this.font1.char120, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'y': {
                        System.arraycopy(this.font1.char121, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'z': {
                        System.arraycopy(this.font1.char122, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '{': {
                        System.arraycopy(this.font1.char123, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '|': {
                        System.arraycopy(this.font1.char124, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '}': {
                        System.arraycopy(this.font1.char125, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '~': {
                        System.arraycopy(this.font1.char126, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\u007f': {
                        System.arraycopy(this.font1.char127, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\u0080': {
                        System.arraycopy(this.font1.char128, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\u001f': {
                        System.arraycopy(this.font1.charTest, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                }
                System.arraycopy(this.font1.char32, 0, this.letter, 0, this.letter.length);
                break;
            }
            case 1: {
                this.charwidth = this.font2.width;
                this.charheight = this.font2.height;
                if (this.letter == null || this.oldfont != this.font) {
                    this.oldfont = this.font;
                    this.letter = new byte[this.font2.char32.length];
                }
                switch (let) {
                    case ' ': {
                        System.arraycopy(this.font2.char32, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '!': {
                        System.arraycopy(this.font2.char33, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\"': {
                        System.arraycopy(this.font2.char34, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '#': {
                        System.arraycopy(this.font2.char35, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '$': {
                        System.arraycopy(this.font2.char36, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '%': {
                        System.arraycopy(this.font2.char37, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '&': {
                        System.arraycopy(this.font2.char38, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\'': {
                        System.arraycopy(this.font2.char39, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '(': {
                        System.arraycopy(this.font2.char40, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ')': {
                        System.arraycopy(this.font2.char41, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '*': {
                        System.arraycopy(this.font2.char42, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '+': {
                        System.arraycopy(this.font2.char43, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ',': {
                        System.arraycopy(this.font2.char44, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '-': {
                        System.arraycopy(this.font2.char45, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '.': {
                        System.arraycopy(this.font2.char46, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '/': {
                        System.arraycopy(this.font2.char47, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '0': {
                        System.arraycopy(this.font2.char48, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '1': {
                        System.arraycopy(this.font2.char49, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '2': {
                        System.arraycopy(this.font2.char50, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '3': {
                        System.arraycopy(this.font2.char51, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '4': {
                        System.arraycopy(this.font2.char52, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '5': {
                        System.arraycopy(this.font2.char53, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '6': {
                        System.arraycopy(this.font2.char54, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '7': {
                        System.arraycopy(this.font2.char55, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '8': {
                        System.arraycopy(this.font2.char56, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '9': {
                        System.arraycopy(this.font2.char57, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ':': {
                        System.arraycopy(this.font2.char58, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ';': {
                        System.arraycopy(this.font2.char59, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '<': {
                        System.arraycopy(this.font2.char60, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '=': {
                        System.arraycopy(this.font2.char61, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '>': {
                        System.arraycopy(this.font2.char62, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '?': {
                        System.arraycopy(this.font2.char63, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '@': {
                        System.arraycopy(this.font2.char64, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'A': {
                        System.arraycopy(this.font2.char65, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'B': {
                        System.arraycopy(this.font2.char66, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'C': {
                        System.arraycopy(this.font2.char67, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'D': {
                        System.arraycopy(this.font2.char68, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'E': {
                        System.arraycopy(this.font2.char69, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'F': {
                        System.arraycopy(this.font2.char70, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'G': {
                        System.arraycopy(this.font2.char71, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'H': {
                        System.arraycopy(this.font2.char72, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'I': {
                        System.arraycopy(this.font2.char73, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'J': {
                        System.arraycopy(this.font2.char74, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'K': {
                        System.arraycopy(this.font2.char75, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'L': {
                        System.arraycopy(this.font2.char76, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'M': {
                        System.arraycopy(this.font2.char77, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'N': {
                        System.arraycopy(this.font2.char78, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'O': {
                        System.arraycopy(this.font2.char79, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'P': {
                        System.arraycopy(this.font2.char80, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'Q': {
                        System.arraycopy(this.font2.char81, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'R': {
                        System.arraycopy(this.font2.char82, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'S': {
                        System.arraycopy(this.font2.char83, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'T': {
                        System.arraycopy(this.font2.char84, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'U': {
                        System.arraycopy(this.font2.char85, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'V': {
                        System.arraycopy(this.font2.char86, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'W': {
                        System.arraycopy(this.font2.char87, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'X': {
                        System.arraycopy(this.font2.char88, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'Y': {
                        System.arraycopy(this.font2.char89, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'Z': {
                        System.arraycopy(this.font2.char90, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '[': {
                        System.arraycopy(this.font2.char91, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\\': {
                        System.arraycopy(this.font2.char92, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ']': {
                        System.arraycopy(this.font2.char93, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '^': {
                        System.arraycopy(this.font2.char94, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '_': {
                        System.arraycopy(this.font2.char95, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '`': {
                        System.arraycopy(this.font2.char96, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'a': {
                        System.arraycopy(this.font2.char97, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'b': {
                        System.arraycopy(this.font2.char98, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'c': {
                        System.arraycopy(this.font2.char99, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'd': {
                        System.arraycopy(this.font2.char100, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'e': {
                        System.arraycopy(this.font2.char101, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'f': {
                        System.arraycopy(this.font2.char102, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'g': {
                        System.arraycopy(this.font2.char103, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'h': {
                        System.arraycopy(this.font2.char104, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'i': {
                        System.arraycopy(this.font2.char105, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'j': {
                        System.arraycopy(this.font2.char106, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'k': {
                        System.arraycopy(this.font2.char107, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'l': {
                        System.arraycopy(this.font2.char108, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'm': {
                        System.arraycopy(this.font2.char109, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'n': {
                        System.arraycopy(this.font2.char110, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'o': {
                        System.arraycopy(this.font2.char111, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'p': {
                        System.arraycopy(this.font2.char112, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'q': {
                        System.arraycopy(this.font2.char113, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'r': {
                        System.arraycopy(this.font2.char114, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 's': {
                        System.arraycopy(this.font2.char115, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 't': {
                        System.arraycopy(this.font2.char116, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'u': {
                        System.arraycopy(this.font2.char117, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'v': {
                        System.arraycopy(this.font2.char118, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'w': {
                        System.arraycopy(this.font2.char119, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'x': {
                        System.arraycopy(this.font2.char120, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'y': {
                        System.arraycopy(this.font2.char121, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'z': {
                        System.arraycopy(this.font2.char122, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '{': {
                        System.arraycopy(this.font2.char123, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '|': {
                        System.arraycopy(this.font2.char124, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '}': {
                        System.arraycopy(this.font2.char125, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '~': {
                        System.arraycopy(this.font2.char126, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\u007f': {
                        System.arraycopy(this.font2.char127, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\u0080': {
                        System.arraycopy(this.font2.char128, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\u001f': {
                        System.arraycopy(this.font2.charTest, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                }
                System.arraycopy(this.font2.char32, 0, this.letter, 0, this.letter.length);
                break;
            }
            case 2: {
                this.charwidth = this.font3.width;
                this.charheight = this.font3.height;
                if (this.letter == null || this.oldfont != this.font) {
                    this.oldfont = this.font;
                    this.letter = new byte[this.font3.char32.length];
                }
                switch (let) {
                    case ' ': {
                        System.arraycopy(this.font3.char32, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '!': {
                        System.arraycopy(this.font3.char33, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\"': {
                        System.arraycopy(this.font3.char34, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '#': {
                        System.arraycopy(this.font3.char35, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '$': {
                        System.arraycopy(this.font3.char36, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '%': {
                        System.arraycopy(this.font3.char37, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '&': {
                        System.arraycopy(this.font3.char38, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\'': {
                        System.arraycopy(this.font3.char39, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '(': {
                        System.arraycopy(this.font3.char40, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ')': {
                        System.arraycopy(this.font3.char41, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '*': {
                        System.arraycopy(this.font3.char42, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '+': {
                        System.arraycopy(this.font3.char43, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ',': {
                        System.arraycopy(this.font3.char44, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '-': {
                        System.arraycopy(this.font3.char45, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '.': {
                        System.arraycopy(this.font3.char46, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '/': {
                        System.arraycopy(this.font3.char47, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '0': {
                        System.arraycopy(this.font3.char48, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '1': {
                        System.arraycopy(this.font3.char49, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '2': {
                        System.arraycopy(this.font3.char50, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '3': {
                        System.arraycopy(this.font3.char51, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '4': {
                        System.arraycopy(this.font3.char52, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '5': {
                        System.arraycopy(this.font3.char53, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '6': {
                        System.arraycopy(this.font3.char54, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '7': {
                        System.arraycopy(this.font3.char55, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '8': {
                        System.arraycopy(this.font3.char56, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '9': {
                        System.arraycopy(this.font3.char57, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ':': {
                        System.arraycopy(this.font3.char58, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ';': {
                        System.arraycopy(this.font3.char59, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '<': {
                        System.arraycopy(this.font3.char60, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '=': {
                        System.arraycopy(this.font3.char61, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '>': {
                        System.arraycopy(this.font3.char62, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '?': {
                        System.arraycopy(this.font3.char63, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '@': {
                        System.arraycopy(this.font3.char64, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'A': {
                        System.arraycopy(this.font3.char65, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'B': {
                        System.arraycopy(this.font3.char66, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'C': {
                        System.arraycopy(this.font3.char67, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'D': {
                        System.arraycopy(this.font3.char68, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'E': {
                        System.arraycopy(this.font3.char69, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'F': {
                        System.arraycopy(this.font3.char70, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'G': {
                        System.arraycopy(this.font3.char71, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'H': {
                        System.arraycopy(this.font3.char72, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'I': {
                        System.arraycopy(this.font3.char73, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'J': {
                        System.arraycopy(this.font3.char74, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'K': {
                        System.arraycopy(this.font3.char75, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'L': {
                        System.arraycopy(this.font3.char76, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'M': {
                        System.arraycopy(this.font3.char77, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'N': {
                        System.arraycopy(this.font3.char78, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'O': {
                        System.arraycopy(this.font3.char79, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'P': {
                        System.arraycopy(this.font3.char80, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'Q': {
                        System.arraycopy(this.font3.char81, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'R': {
                        System.arraycopy(this.font3.char82, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'S': {
                        System.arraycopy(this.font3.char83, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'T': {
                        System.arraycopy(this.font3.char84, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'U': {
                        System.arraycopy(this.font3.char85, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'V': {
                        System.arraycopy(this.font3.char86, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'W': {
                        System.arraycopy(this.font3.char87, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'X': {
                        System.arraycopy(this.font3.char88, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'Y': {
                        System.arraycopy(this.font3.char89, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'Z': {
                        System.arraycopy(this.font3.char90, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '[': {
                        System.arraycopy(this.font3.char91, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\\': {
                        System.arraycopy(this.font3.char92, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case ']': {
                        System.arraycopy(this.font3.char93, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '^': {
                        System.arraycopy(this.font3.char94, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '_': {
                        System.arraycopy(this.font3.char95, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '`': {
                        System.arraycopy(this.font3.char96, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'a': {
                        System.arraycopy(this.font3.char97, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'b': {
                        System.arraycopy(this.font3.char98, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'c': {
                        System.arraycopy(this.font3.char99, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'd': {
                        System.arraycopy(this.font3.char100, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'e': {
                        System.arraycopy(this.font3.char101, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'f': {
                        System.arraycopy(this.font3.char102, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'g': {
                        System.arraycopy(this.font3.char103, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'h': {
                        System.arraycopy(this.font3.char104, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'i': {
                        System.arraycopy(this.font3.char105, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'j': {
                        System.arraycopy(this.font3.char106, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'k': {
                        System.arraycopy(this.font3.char107, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'l': {
                        System.arraycopy(this.font3.char108, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'm': {
                        System.arraycopy(this.font3.char109, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'n': {
                        System.arraycopy(this.font3.char110, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'o': {
                        System.arraycopy(this.font3.char111, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'p': {
                        System.arraycopy(this.font3.char112, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'q': {
                        System.arraycopy(this.font3.char113, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'r': {
                        System.arraycopy(this.font3.char114, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 's': {
                        System.arraycopy(this.font3.char115, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 't': {
                        System.arraycopy(this.font3.char116, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'u': {
                        System.arraycopy(this.font3.char117, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'v': {
                        System.arraycopy(this.font3.char118, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'w': {
                        System.arraycopy(this.font3.char119, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'x': {
                        System.arraycopy(this.font3.char120, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'y': {
                        System.arraycopy(this.font3.char121, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case 'z': {
                        System.arraycopy(this.font3.char122, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '{': {
                        System.arraycopy(this.font3.char123, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '|': {
                        System.arraycopy(this.font3.char124, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '}': {
                        System.arraycopy(this.font3.char125, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '~': {
                        System.arraycopy(this.font3.char126, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\u007f': {
                        System.arraycopy(this.font3.char127, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\u0080': {
                        System.arraycopy(this.font3.char128, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                    case '\u001f': {
                        System.arraycopy(this.font3.charTest, 0, this.letter, 0, this.letter.length);
                        break block0;
                    }
                }
                System.arraycopy(this.font3.char32, 0, this.letter, 0, this.letter.length);
            }
        }
    }

    public void control(char let) {
        this.ppos -= this.xdpi;
        if (this.definechar) {
            this.defineChar(let);
            return;
        }
        switch (let) {
            case '\u001b': {
                return;
            }
            case '\u0000': {
                if (this.preparechar) {
                    this.preparechar = false;
                    this.definechar = true;
                    return;
                }
                if (this.defineNLQ) {
                    this.NLQ = false;
                    this.defineNLQ = false;
                    this.control = false;
                    return;
                }
            }
            case '\u0001': {
                if (!this.defineNLQ) break;
                this.defineNLQ = false;
                this.NLQ = true;
                this.control = false;
                return;
            }
            case 'x': {
                this.defineNLQ = true;
                return;
            }
            case 'M': {
                this.mini(true);
                this.control = false;
                break;
            }
            case 'P': {
                this.mini(false);
                this.control = false;
                break;
            }
            case '&': {
                this.preparechar = true;
                return;
            }
            case '4': {
                this.italic = true;
                this.control = false;
                break;
            }
            case '5': {
                this.italic = false;
                this.control = false;
                break;
            }
            case 'E': {
                this.bold = true;
                this.control = false;
                break;
            }
            case 'F': {
                this.bold = false;
                this.control = false;
                break;
            }
            default: {
                this.control = false;
            }
        }
        this.defineNLQ = false;
    }

    public void defineChar(char let) {
    }

    public void plotLetter(Graphics g, int pos, char let) {
        Graphics r = this.matrixpage.getGraphics();
        Graphics2D gg = (Graphics2D)r;
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        r = gg;
        if (this.uppercase) {
            String ucase = "" + let;
            ucase = ucase.toUpperCase();
            let = ucase.charAt(0);
        }
        this.setLetter(let);
        int offset = 0;
        double xadd = 0.0;
        if (this.italic) {
            xadd = 3.0;
        }
        double xd = 0.0;
        double yd = 0.0;
        for (int y = 0; y < this.charheight; ++y) {
            yd = this.halfheight ? (yd += 0.5) : (this.doubleheight ? (yd += 2.0) : (yd += 1.0));
            xd = 0.0;
            int weakness = this.ribbon.getValue();
            for (int x = 0; x < this.charwidth; ++x) {
                xd = this.condensed ? (xd += 0.6) : (this.doublewidth ? (xd += 2.0) : (xd += 1.0));
                this.headx = (int)((xd + (double)((int)xadd) + (double)pos) * 1.12) - 6;
                if (this.letter[offset++] == 0) continue;
                g.drawLine((int)xd + (int)xadd + pos, (int)yd + this.ypos, (int)xd + (int)xadd + pos, (int)yd + this.ypos);
                if (this.NLQ) {
                    g.drawLine((int)xd + (int)xadd + pos, (int)yd + this.ypos + 1, (int)xd + (int)xadd + pos, (int)yd + this.ypos);
                }
                if (this.bold) {
                    if (!this.minitext) {
                        g.drawLine((int)xd + (int)xadd + pos + 1, (int)yd + this.ypos + 1, (int)xd + (int)xadd + pos + 1, (int)yd + this.ypos);
                    }
                    g.drawLine((int)xd + (int)xadd + pos + 1, (int)yd + this.ypos, (int)xd + (int)xadd + pos + 1, (int)yd + this.ypos);
                }
                int xx = (int)((xd + xadd + (double)pos) * (double)this.zoomx);
                int yy = (int)((yd + (double)this.ypos) * (double)this.zoomy);
                int v = this.random(weakness);
                r.setColor(new Color(v, v, v, 140));
                r.fillOval(xx, yy, this.zoomx - 1, this.zoomy - 1);
                if (this.NLQ) {
                    v = this.random(weakness);
                    r.setColor(new Color(v, v, v, 230));
                    r.fillOval(xx, yy + 1, this.zoomx - 1, this.zoomy - 1);
                    r.fillOval(xx, yy + 2, this.zoomx - 1, this.zoomy - 1);
                    r.fillOval(xx, yy + 3, this.zoomx - 1, this.zoomy - 1);
                    if (!this.minitext) {
                        v = this.random(weakness);
                        r.setColor(new Color(v, v, v, 230));
                        r.fillOval(xx + 2, yy, this.zoomx - 1, this.zoomy - 1);
                        r.fillOval(xx + 2, yy + 1, this.zoomx - 1, this.zoomy - 1);
                        r.fillOval(xx + 2, yy + 2, this.zoomx - 1, this.zoomy - 1);
                        r.fillOval(xx + 2, yy + 3, this.zoomx - 1, this.zoomy - 1);
                    }
                }
                if (this.doubleheight) {
                    r.fillOval(xx, yy + this.zoomy / 2, this.zoomx - 1, this.zoomy - 1);
                }
                if (this.doublewidth) {
                    r.fillOval(xx + this.zoomy / 2, yy, this.zoomx - 1, this.zoomy - 1);
                }
                r.setColor(new Color(v, v, v, 230));
                r.fillOval(xx, yy, this.zoomx - 4, this.zoomy - 4);
                v = this.random(weakness);
                if (this.bold) {
                    r.setColor(new Color(v, v, v, 140));
                    r.fillOval(xx + this.zoomx - 2, yy, this.zoomx - 1, this.zoomy - 1);
                    v = this.random(weakness);
                    r.setColor(new Color(v, v, v, 230));
                    r.fillOval(xx + this.zoomx - 2, yy, this.zoomx - 4, this.zoomy - 4);
                    if (this.NLQ) {
                        r.setColor(new Color(v, v, v, 140));
                        r.fillOval(xx + 3, yy + 2, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.fillOval(xx + 6, yy + 2, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.setColor(new Color(v, v, v, 230));
                        r.fillOval(xx + 3, yy + 4, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.fillOval(xx + 6, yy + 4, this.zoomx, this.zoomy);
                        r.setColor(new Color(v, v, v, 140));
                        r.fillOval(xx + 5, yy + 2, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.fillOval(xx + 8, yy + 3, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.setColor(new Color(v, v, v, 230));
                        r.fillOval(xx + 5, yy + 4, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.fillOval(xx + 8, yy + 5, this.zoomx, this.zoomy);
                    }
                    if (this.doublewidth) {
                        r.setColor(new Color(v, v, v, 140));
                        r.fillOval(xx + this.zoomy / 2 + 2, yy + 2, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.fillOval(xx + this.zoomy / 2 + 4, yy + 2, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.setColor(new Color(v, v, v, 230));
                        r.fillOval(xx + this.zoomy / 2 + 2, yy, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.setColor(new Color(v, v, v, 230));
                        r.fillOval(xx + this.zoomy / 2 + 4, yy, this.zoomx, this.zoomy);
                    }
                    if (this.doubleheight) {
                        r.setColor(new Color(v, v, v, 140));
                        r.fillOval(xx + 2, yy + this.zoomy / 2 + 2, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.fillOval(xx + 4, yy + this.zoomy / 2 + 2, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.setColor(new Color(v, v, v, 230));
                        r.fillOval(xx + 2, yy + this.zoomy / 2, this.zoomx, this.zoomy);
                        v = this.random(weakness);
                        r.setColor(new Color(v, v, v, 230));
                        r.fillOval(xx + 4, yy + this.zoomy / 2, this.zoomx, this.zoomy);
                    }
                }
                this.makeNoise(x, y);
            }
            if (!this.italic) continue;
            xadd -= 0.6;
        }
    }

    public int random(int value) {
        return Util.random(value);
    }

    public void makeNoise(int x, int y) {
        if (x == 0) {
            switch (y) {
                case 0: {
                    Samples.NEEDLE1.play();
                    break;
                }
                case 1: {
                    Samples.NEEDLE2.play();
                    break;
                }
                case 2: {
                    Samples.NEEDLE3.play();
                    break;
                }
                case 3: {
                    Samples.NEEDLE4.play();
                    break;
                }
                case 4: {
                    Samples.NEEDLE5.play();
                    break;
                }
                case 5: {
                    Samples.NEEDLE6.play();
                    break;
                }
                case 6: {
                    Samples.NEEDLE7.play();
                    break;
                }
                case 7: {
                    Samples.NEEDLE8.play();
                }
            }
        }
        if (x == 1) {
            switch (y) {
                case 0: {
                    Samples.NEEDLE11.play();
                    break;
                }
                case 1: {
                    Samples.NEEDLE21.play();
                    break;
                }
                case 2: {
                    Samples.NEEDLE31.play();
                    break;
                }
                case 3: {
                    Samples.NEEDLE41.play();
                    break;
                }
                case 4: {
                    Samples.NEEDLE51.play();
                    break;
                }
                case 5: {
                    Samples.NEEDLE61.play();
                    break;
                }
                case 6: {
                    Samples.NEEDLE71.play();
                    break;
                }
                case 7: {
                    Samples.NEEDLE81.play();
                }
            }
        }
        if (x == 2) {
            switch (y) {
                case 0: {
                    Samples.NEEDLE12.play();
                    break;
                }
                case 1: {
                    Samples.NEEDLE22.play();
                    break;
                }
                case 2: {
                    Samples.NEEDLE32.play();
                    break;
                }
                case 3: {
                    Samples.NEEDLE42.play();
                    break;
                }
                case 4: {
                    Samples.NEEDLE52.play();
                    break;
                }
                case 5: {
                    Samples.NEEDLE62.play();
                    break;
                }
                case 6: {
                    Samples.NEEDLE72.play();
                    break;
                }
                case 7: {
                    Samples.NEEDLE82.play();
                }
            }
        }
        if (x == 3) {
            switch (y) {
                case 0: {
                    Samples.NEEDLE13.play();
                    break;
                }
                case 1: {
                    Samples.NEEDLE23.play();
                    break;
                }
                case 2: {
                    Samples.NEEDLE33.play();
                    break;
                }
                case 3: {
                    Samples.NEEDLE43.play();
                    break;
                }
                case 4: {
                    Samples.NEEDLE53.play();
                    break;
                }
                case 5: {
                    Samples.NEEDLE63.play();
                    break;
                }
                case 6: {
                    Samples.NEEDLE73.play();
                    break;
                }
                case 7: {
                    Samples.NEEDLE83.play();
                }
            }
        }
        if (x == 4) {
            switch (y) {
                case 0: {
                    Samples.NEEDLE14.play();
                    break;
                }
                case 1: {
                    Samples.NEEDLE24.play();
                    break;
                }
                case 2: {
                    Samples.NEEDLE34.play();
                    break;
                }
                case 3: {
                    Samples.NEEDLE44.play();
                    break;
                }
                case 4: {
                    Samples.NEEDLE54.play();
                    break;
                }
                case 5: {
                    Samples.NEEDLE64.play();
                    break;
                }
                case 6: {
                    Samples.NEEDLE74.play();
                    break;
                }
                case 7: {
                    Samples.NEEDLE84.play();
                }
            }
        }
        if (x == 5) {
            switch (y) {
                case 0: {
                    Samples.NEEDLE15.play();
                    break;
                }
                case 1: {
                    Samples.NEEDLE25.play();
                    break;
                }
                case 2: {
                    Samples.NEEDLE35.play();
                    break;
                }
                case 3: {
                    Samples.NEEDLE45.play();
                    break;
                }
                case 4: {
                    Samples.NEEDLE55.play();
                    break;
                }
                case 5: {
                    Samples.NEEDLE65.play();
                    break;
                }
                case 6: {
                    Samples.NEEDLE75.play();
                    break;
                }
                case 7: {
                    Samples.NEEDLE85.play();
                }
            }
        }
        if (x == 6) {
            switch (y) {
                case 0: {
                    Samples.NEEDLE16.play();
                    break;
                }
                case 1: {
                    Samples.NEEDLE26.play();
                    break;
                }
                case 2: {
                    Samples.NEEDLE36.play();
                    break;
                }
                case 3: {
                    Samples.NEEDLE46.play();
                    break;
                }
                case 4: {
                    Samples.NEEDLE56.play();
                    break;
                }
                case 5: {
                    Samples.NEEDLE66.play();
                    break;
                }
                case 6: {
                    Samples.NEEDLE76.play();
                    break;
                }
                case 7: {
                    Samples.NEEDLE86.play();
                }
            }
        }
    }
}

