/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.printer;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jemu.core.device.printer.DMP2000;
import jemu.core.device.printer.PrinterDevice;
import jemu.core.device.printer.TextPrinter;
import jemu.ui.Switches;

public class Printer
extends PrinterDevice {
    TextPrinter textprinter;
    DMP2000 dmp;
    public Thread printer;
    boolean isRunning = false;
    boolean init = true;
    final JFrame frame = new JFrame("Amstrad DMP 2000");
    public boolean matrixprinter = false;

    public Printer() {
        super("Amstrad DMP 2000");
    }

    public void init() {
        this.printer = new Thread(){

            @Override
            public void run() {
                if (Printer.this.dmp == null) {
                    Printer.this.dmp = new DMP2000();
                    Printer.this.frame.setLayout(new BorderLayout());
                    Printer.this.frame.add((Component)Printer.this.dmp, "Center");
                    Printer.this.frame.setDefaultCloseOperation(1);
                    Printer.this.frame.pack();
                    Printer.this.frame.setAlwaysOnTop(false);
                }
                Printer.this.dmp.print(10);
                Printer.this.dmp.ypos -= Printer.this.dmp.ydpi;
                Printer.this.dmp.yprint -= Printer.this.dmp.ydpi;
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Printer.this.dmp.clearPage();
                            Printer.this.dmp.PaperFeed(false);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Printer.this.isRunning = true;
            }
        };
    }

    @Override
    public void writePort(int port, int value) {
        if (this.matrixprinter) {
            if (Switches.Printer && !this.isRunning) {
                this.frame.setVisible(true);
                this.init();
                this.printer.start();
            } else if (this.isRunning && Switches.Printer && !this.frame.isVisible() && value > 32 && value < 120) {
                System.err.println(value);
                this.frame.setVisible(true);
            }
        }
        if ((value & 0x80) != 0 && Switches.Printer) {
            value &= 0x7F;
            if (this.matrixprinter) {
                this.dmp.print(value);
            } else {
                if (this.textprinter == null) {
                    this.textprinter = new TextPrinter();
                }
                this.textprinter.print(value);
            }
        }
    }
}

