/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.printer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import jemu.ui.Desktop;
import jemu.ui.JEMU;
import jemu.ui.Switches;

public class TextPrinter
extends WindowAdapter
implements WindowListener,
ActionListener {
    JFileChooser saveFileChooser = new JFileChooser();
    protected GridBagConstraints gbcConstraints = null;
    static boolean visible = false;
    public static JFrame typeconsole;
    public static String autotext;
    public static JTextArea textArea;
    public JButton button2 = new JButton("  Clear output  ");
    public JButton button3 = new JButton("    Copy text    ");
    public JButton button4 = new JButton(" Save Output ");
    public JButton smaller = new JButton("  Textsize -  ");
    public JButton bigger = new JButton("  Textsize +  ");
    public JButton FontB = new JButton(" Select Font + ");
    public static JButton Online;
    public static int textSize;
    public static String FontName1;
    public static String FontName2;
    public static String FontName3;
    public static String FontName4;
    public static String FontName5;
    public static String FontName6;
    public static String FontName7;
    public static String FontName8;
    public static String FontName9;
    public static int fontc;
    public static String FontName;
    public String dump = "";

    public TextPrinter() {
        typeconsole = new JFrame("JavaCPC Printer");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = new Dimension(screenSize.width / 2, screenSize.height / 2);
        int x = frameSize.width / 2 + 110;
        int y = frameSize.height / 2 + 60;
        typeconsole.setBounds(x, y, 640, 480);
        typeconsole.setAlwaysOnTop(true);
        textArea = new JTextArea();
        textArea.setEditable(true);
        textArea.setAutoscrolls(true);
        textArea.setBackground(Color.WHITE);
        textArea.setForeground(Color.BLACK);
        textArea.setCaretColor(Color.RED);
        textArea.setSelectedTextColor(Color.GRAY);
        textArea.setSelectionColor(Color.ORANGE);
        textArea.setBorder(new BevelBorder(1));
        this.button2.setCursor(Cursor.getPredefinedCursor(12));
        this.button2.setForeground(Color.LIGHT_GRAY);
        this.button2.setBackground(Color.DARK_GRAY);
        this.button2.setBorder(new BevelBorder(0));
        this.button3.setCursor(Cursor.getPredefinedCursor(12));
        this.button3.setForeground(Color.LIGHT_GRAY);
        this.button3.setBackground(Color.DARK_GRAY);
        this.button3.setBorder(new BevelBorder(0));
        this.button4.setCursor(Cursor.getPredefinedCursor(12));
        this.button4.setForeground(Color.LIGHT_GRAY);
        this.button4.setBackground(Color.DARK_GRAY);
        this.button4.setBorder(new BevelBorder(0));
        this.smaller.setCursor(Cursor.getPredefinedCursor(12));
        this.smaller.setForeground(Color.LIGHT_GRAY);
        this.smaller.setBackground(Color.DARK_GRAY);
        this.smaller.setBorder(new BevelBorder(0));
        this.bigger.setCursor(Cursor.getPredefinedCursor(12));
        this.bigger.setForeground(Color.LIGHT_GRAY);
        this.bigger.setBackground(Color.DARK_GRAY);
        this.bigger.setBorder(new BevelBorder(0));
        this.FontB.setCursor(Cursor.getPredefinedCursor(12));
        this.FontB.setForeground(Color.LIGHT_GRAY);
        this.FontB.setBackground(Color.DARK_GRAY);
        this.FontB.setBorder(new BevelBorder(0));
        Online.setCursor(Cursor.getPredefinedCursor(12));
        Online.setBorder(new BevelBorder(0));
        TextPrinter.OnlineButton();
        typeconsole.getContentPane().setLayout(new GridBagLayout());
        typeconsole.add((Component)this.button2, this.getGridBagConstraints(2, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)this.button3, this.getGridBagConstraints(3, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)this.button4, this.getGridBagConstraints(4, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)this.smaller, this.getGridBagConstraints(5, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)this.bigger, this.getGridBagConstraints(6, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)this.FontB, this.getGridBagConstraints(7, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)Online, this.getGridBagConstraints(8, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)new JScrollPane(textArea), this.getGridBagConstraints(1, 1, 1.0, 1.0, 8, 1));
        typeconsole.setVisible(false);
        typeconsole.addWindowListener(this);
        this.button2.addActionListener(this);
        this.button2.setFocusable(false);
        this.button3.addActionListener(this);
        this.button3.setFocusable(false);
        this.button4.addActionListener(this);
        this.button4.setFocusable(false);
        this.smaller.addActionListener(this);
        this.smaller.setFocusable(false);
        this.bigger.addActionListener(this);
        this.bigger.setFocusable(false);
        this.FontB.addActionListener(this);
        this.FontB.setFocusable(false);
        Online.addActionListener(this);
        Online.setFocusable(false);
    }

    private GridBagConstraints getGridBagConstraints(int x, int y, double weightx, double weighty, int width, int fill) {
        if (this.gbcConstraints == null) {
            this.gbcConstraints = new GridBagConstraints();
        }
        this.gbcConstraints.gridx = x;
        this.gbcConstraints.gridy = y;
        this.gbcConstraints.weightx = weightx;
        this.gbcConstraints.weighty = weighty;
        this.gbcConstraints.gridwidth = width;
        this.gbcConstraints.fill = fill;
        return this.gbcConstraints;
    }

    @Override
    public synchronized void windowClosing(WindowEvent evt) {
        typeconsole.setVisible(false);
        visible = false;
    }

    public void print(int value) {
        this.dump = this.dump + "" + (char)value;
        if ((char)value == '\r') {
            if (!visible && JEMU.iframe == null) {
                TextPrinter.OnlineButton();
                typeconsole.setVisible(true);
                visible = true;
            }
            if (JEMU.iframe != null && !Desktop.printframe.isVisible()) {
                Desktop.printframe.setVisible(true);
            }
            if (Switches.printEffect) {
                textArea.setFont(new Font(FontName, 0, 3));
                textSize = 3;
            } else {
                textArea.setFont(new Font(FontName, 0, textSize));
            }
            textArea.append(this.dump);
            Desktop.printout.append(this.dump);
            textArea.select(2000000000, 2000000000);
            Desktop.printout.select(2000000000, 2000000000);
            this.dump = "";
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.button2) {
            TextPrinter.ClearPrinter();
        }
        if (evt.getSource() == this.smaller) {
            TextPrinter.Smaller();
        }
        if (evt.getSource() == this.bigger) {
            TextPrinter.Bigger();
        }
        if (evt.getSource() == this.FontB) {
            TextPrinter.FontSelector();
        }
        if (evt.getSource() == Online) {
            TextPrinter.PrinterCheck();
        }
        if (evt.getSource() == this.button3) {
            TextPrinter.Copy();
        }
        if (evt.getSource() == this.button4) {
            this.saveFile();
        }
    }

    public static void MakeVisible() {
        typeconsole.setVisible(true);
        visible = true;
    }

    public static void MakeInvisible() {
        typeconsole.setVisible(false);
        visible = false;
    }

    public static void Smaller() {
        if (textSize >= 2) {
            --textSize;
        }
        textArea.setFont(new Font(FontName, 0, textSize));
    }

    public static void Bigger() {
        if (textSize <= 150) {
            ++textSize;
        }
        textArea.setFont(new Font(FontName, 0, textSize));
    }

    public static void FontSelector() {
        fontc = fontc <= 9 ? ++fontc : 1;
        if (fontc == 1) {
            FontName = FontName1;
        }
        if (fontc == 2) {
            FontName = FontName2;
        }
        if (fontc == 3) {
            FontName = FontName3;
        }
        if (fontc == 4) {
            FontName = FontName4;
        }
        if (fontc == 5) {
            FontName = FontName5;
        }
        if (fontc == 6) {
            FontName = FontName6;
        }
        if (fontc == 7) {
            FontName = FontName7;
        }
        if (fontc == 8) {
            FontName = FontName8;
        }
        if (fontc == 9) {
            FontName = FontName9;
        }
        textArea.setFont(new Font(FontName, 0, textSize));
    }

    public static void PrinterCheck() {
        Switches.Printer = !Switches.Printer;
        TextPrinter.OnlineButton();
    }

    public static void OnlineButton() {
        if (Switches.Printer) {
            Online.setForeground(Color.WHITE);
            Online.setBackground(Color.GREEN);
        } else {
            Online.setForeground(Color.BLACK);
            Online.setBackground(Color.RED);
        }
    }

    public static void ClearPrinter() {
        textArea.setText("");
    }

    public static void Copy() {
        if (!textArea.getText().equals("")) {
            textArea.selectAll();
            textArea.copy();
            textArea.paste();
        }
    }

    public static void setFont() {
        textArea.setFont(new Font(FontName, 0, textSize));
    }

    public void saveFile() {
        FileDialog filedia = new FileDialog((Frame)typeconsole, "Save ASCII...", 1);
        filedia.setFile("*.txt: *.asm; *.bas");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            filename = filedia.getDirectory() + filedia.getFile();
            String savename = filename;
            if (!(savename.toLowerCase().endsWith(".txt") || savename.toLowerCase().endsWith(".asm") || savename.toLowerCase().endsWith(".bas"))) {
                savename = savename + ".txt";
            }
            File file = new File(savename);
            String gettext = textArea.getText();
            try {
                FileWriter fw = new FileWriter(file);
                fw.write(gettext);
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        filedia.dispose();
    }

    static {
        Online = new JButton(" Online ");
        textSize = 12;
        FontName1 = "Monospaced";
        FontName2 = "Courier New";
        FontName3 = "Trebuchet MS";
        FontName4 = "Verdana";
        FontName5 = "OCR A Std";
        FontName6 = "Old English Text MT";
        FontName7 = "Arial";
        FontName8 = "Arial Narrow";
        FontName9 = "Arial Bold";
        fontc = 1;
        FontName = FontName1;
    }
}

