/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JLabel;
import jemu.core.device.sound.AY_3_8910;

public class BufferDisplay {
    private final int CANVAS_WIDTH = 400;
    private final int CANVAS_HEIGHT = 128;
    public String left = "Left Channel";
    public String right = "Right Channel";
    private int OldlevelR;
    private int OldlevelL = 0;
    private int OldposR;
    private int OldposL = 0;
    public JLabel display;
    byte[] data;
    int oldl;
    int oldr;
    int oldi;
    Color darkred = new Color(128, 0, 0, 128);
    Color darkgreen = new Color(0, 128, 0, 128);
    int skip = 0;

    public BufferDisplay() {
        this.display = new JLabel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (BufferDisplay.this.data == null) {
                    return;
                }
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, 400, 128);
                BufferDisplay.this.oldi = 0;
                g.setColor(Color.yellow);
                g.drawString(BufferDisplay.this.left, 10, 108);
                g.drawString(BufferDisplay.this.right, 10, 20);
                for (int i = 1; i < BufferDisplay.this.data.length; i += 2) {
                    int r = BufferDisplay.this.data[i] & 0xFF;
                    int l = BufferDisplay.this.data[i - 1] & 0xFF;
                    if (AY_3_8910.digiblast) {
                        r /= 2;
                        l /= 2;
                        r += 32;
                        l += 32;
                    }
                    g.setColor(BufferDisplay.this.darkgreen);
                    g.drawLine(i, 128 - r / 2, i, 64);
                    g.drawLine(i + 1, 128 - r / 2, i + 1, 64);
                    g.setColor(BufferDisplay.this.darkred);
                    g.drawLine(i + 1, 0 + l / 2, i + 1, 64);
                    g.drawLine(i, 0 + l / 2, i, 64);
                    g.setColor(Color.GREEN);
                    g.drawLine(i, 128 - r / 2, BufferDisplay.this.oldi, BufferDisplay.this.oldl);
                    g.setColor(Color.RED);
                    g.drawLine(i + 1, 0 + l / 2, BufferDisplay.this.oldi + 1, BufferDisplay.this.oldr);
                    BufferDisplay.this.oldr = 0 + l / 2;
                    BufferDisplay.this.oldl = 128 - r / 2;
                    BufferDisplay.this.oldi = i;
                }
            }
        };
        this.display.setBackground(Color.DARK_GRAY);
        this.display.setForeground(Color.GREEN);
        this.display.setSize(400, 128);
        this.display.setDoubleBuffered(false);
    }

    public void paintWAV(byte[] input) {
        ++this.skip;
        if (this.skip == 15) {
            this.skip = 0;
            this.data = new byte[input.length];
            System.arraycopy(input, 0, this.data, 0, this.data.length);
            this.display.repaint();
        }
    }
}

