/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.speech;

import jemu.core.Util;
import jemu.core.device.speech.Speech;
import jemu.core.device.speech.SpeechDevice;

public class SSA1
extends SpeechDevice {
    public static int LRQ;
    public static int SBY;
    protected boolean DEBUG = false;
    protected int speechCount = 0;
    protected int speechlength = 0;
    protected int length = 0;
    protected int phonemelength = 0;
    public boolean doCycle = false;
    protected Speech speech = new Speech();

    public SSA1() {
        super("Amstrad SSA-1 Speech Synthesizer");
        LRQ = 128;
        SBY = 0;
    }

    @Override
    public int readPort(int port) {
        if (Speech.enabled && Speech.SSA) {
            if (this.DEBUG) {
                System.out.println("Port read on " + Util.hex((short)port) + " - " + Util.hex((short)(LRQ | SBY)));
            }
            return LRQ | SBY;
        }
        return 255;
    }

    @Override
    public void writePort(int port, int value) {
        if (Speech.enabled && Speech.SSA) {
            this.speechCount = 0;
            this.doCycle = true;
            this.phonemelength = Speech.lengths[value & 0x3F];
            this.speechlength += this.phonemelength * 312;
            this.length = this.speechlength;
            this.speech.SpeechByte = this.speech.SpeechByte + Util.hex(value & 0x3F).substring(6) + ",";
            if (this.DEBUG) {
                System.out.println("Port write to " + Util.hex((short)port) + " - Value:" + Util.hex((short)value));
            }
        }
    }

    public void writelPort(int port, int value) {
        if (Speech.enabled && Speech.SSA) {
            LRQ = 0;
            SBY = 64;
            this.phonemelength = Speech.lengths[value];
            this.doCycle = true;
            this.speechCount = 0;
            this.speech.Translate(Util.hex(value).substring(6) + ",");
            if (this.DEBUG) {
                System.out.println("Port write to " + Util.hex((short)port) + " - Value:" + Util.hex((short)value));
            }
        }
    }

    @Override
    public void reset() {
        LRQ = 128;
        SBY = 0;
        this.speech.SpeechByte = "";
    }

    public void cyclle() {
        ++this.speechCount;
        if (this.speechCount == this.phonemelength) {
            this.doCycle = false;
        }
    }

    @Override
    public void cycle() {
        int counter = 156000;
        ++this.speechCount;
        SBY = this.speechCount < this.phonemelength ? 64 : 0;
        if (this.speechlength > 0) {
            --this.speechlength;
            LRQ = 0;
            if (this.speechlength == 0) {
                LRQ = 128;
                this.speechCount = counter - this.length;
            }
        }
        if (this.speechCount == counter) {
            this.speechlength = 0;
            this.speechCount = 0;
            this.speech.Translate(this.speech.SpeechByte);
            this.doCycle = false;
            SBY = 0;
        }
    }
}

