/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.tape;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import jemu.system.cpc.CPC;

public class GraphicDisplay
extends JPanel {
    Graphics page;
    BufferedImage panel = new BufferedImage(246, 20, 1);
    private final int CANVAS_WIDTH = 246;
    private final int CANVAS_HEIGHT = 20;
    public String message = "";
    private int oldlevel = 0;
    private int oldi = 0;
    Color green;
    Color red;

    public GraphicDisplay() {
        this.page = this.panel.getGraphics();
        this.setBackground(Color.BLACK);
        this.setForeground(Color.GRAY);
        this.setSize(246, 20);
        this.setPreferredSize(new Dimension(246, 20));
        this.page.setFont(new Font("Arial", 1, 9));
        this.page.setColor(Color.WHITE);
        this.green = new Color(0, 128, 0);
        this.red = new Color(128, 0, 0);
    }

    public void paintWAV() {
        this.page.clearRect(0, 0, 246, 20);
        int divider = 10;
        this.oldi = 0;
        for (int i = 0; i < 2500; i += divider) {
            int level = 0;
            if (CPC.tapesample != null && CPC.tape_band_pos + i < CPC.tapesample.length) {
                level = CPC.tapesample[CPC.tape_band_pos + i] & 0xFF;
            }
            if ((level /= 12) < 10) {
                this.page.setColor(this.red);
            } else {
                this.page.setColor(this.green);
            }
            this.page.drawLine(this.oldi, this.oldlevel, i / divider, 21 - level);
            this.oldlevel = 21 - level;
            this.oldi = i / divider;
        }
        this.showText();
    }

    public void showText(String text) {
        this.page.setColor(Color.WHITE);
        this.page.drawString(text, 1, 20);
        this.page.drawString(text, 2, 20);
        try {
            this.getGraphics().drawImage(this.panel, 0, 0, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showText() {
        this.page.setColor(Color.WHITE);
        this.page.drawString(this.message, 1, 20);
        this.page.drawString(this.message, 2, 20);
        try {
            this.getGraphics().drawImage(this.panel, 0, 0, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

