/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.renderer;

import jemu.core.Util;
import jemu.core.device.crtc.Basic6845;
import jemu.core.renderer.Renderer;
import jemu.system.cpc.CPC;
import jemu.ui.Switches;

public class MonitorRenderer
extends Renderer {
    public static final int HSYNC_MIN = 0x3F0000;
    public static final int HSYNC_MAX = 0x410000;
    public static final int HSYNC_MID = 0x400000;
    public static final int HSYNC_MAX_DEC = 204800;
    public static final int HSYNC_MAX_INC = 204800;
    public static int HSYNC_ADJUST = 8;
    public static final int HSYNC_FREE_ADJUST = 128;
    int freq = Switches.frequency;
    public static final int VHOLD_MIN = 250;
    public static final int VHOLD_MAX = 380;
    public static final int VHOLD_MID = 295;
    public static final int VHOLD_MIN_RANGE = 46;
    public static final int VHOLD_MAX_RANGE = 74;
    protected long frequency = 1000000L;
    protected int adder = 65536;
    protected int hPos = 0;
    protected int vPos = 0;
    protected int monitorLine = 0;
    protected int monHFree = 0x400000;
    protected int monHSync = 0x400000;
    protected int monHHalf = 0x200000;
    protected boolean inHSync = false;
    protected boolean hadHSync = false;
    protected int hStart = 0;
    protected int hLess = 0;
    protected int hMore = 0;
    protected int vAdjust = -3;
    protected int vSync = 0;
    protected boolean inVSync = false;
    protected int vSyncMin = 0;
    protected int vSyncMax = 0;
    protected int vSyncLen = 0x800000;
    protected int vhold = 45;
    protected boolean debug = false;
    int direction = 0;

    public MonitorRenderer(String type) {
        super(type);
        this.setVHold(Switches.vhold - 45);
        if (Switches.frequency == 0) {
            this.setVHold(Switches.vhold - 70);
        }
    }

    public void setCycleFrequency(long value) {
        this.adder = (int)(65536000000L / value);
        System.out.println("Frequency=" + value + ", adder=" + this.adder);
    }

    public void hSyncStart() {
        this.hStart = this.hPos;
        this.hadHSync = true;
        this.inHSync = true;
    }

    public void hSyncEnd() {
        if (this.inHSync) {
            this.inHSync = false;
            this.adjustMoreLess(this.hPos);
        }
    }

    protected void adjustMoreLess(int pos) {
        if (pos <= this.monHHalf) {
            this.hLess += pos - this.hStart;
        } else if (this.hStart >= this.monHHalf) {
            this.hMore += pos - this.hStart;
        } else {
            this.hLess += this.monHHalf - this.hStart;
            this.hMore += pos - this.monHHalf;
        }
    }

    public void vSyncStart() {
        if (!this.inVSync) {
            if (this.debug) {
                System.out.println("vSync Start: " + this.vPos + ", hPos=" + this.hPos);
            }
            this.vSync = -this.hPos;
            this.inVSync = true;
        }
    }

    public void vSyncEnd() {
        if (this.inVSync) {
            this.inVSync = false;
            this.vSync += this.hPos;
            this.checkVSync();
            if (this.debug) {
                System.out.println("vSync End: " + this.vPos + ", hPos=" + this.hPos + ", length=" + Integer.toHexString(this.vSync));
            }
        }
    }

    public void hSync() {
    }

    public void vSync(boolean interlace) {
    }

    public void vSync() {
    }

    public void clock() {
        if (this.vhold != Switches.vhold || this.freq != Switches.frequency) {
            this.freq = Switches.frequency;
            this.setVHold(Switches.vhold - 45);
            if (Switches.frequency == 0) {
                this.setVHold(Switches.vhold - 70);
            }
            this.vhold = Switches.vhold;
        }
        if (this.inHSync && !this.inVSync) {
            this.direction = this.hPos < this.monHHalf ? -256 : (this.hPos > this.monHHalf ? 256 : 0);
            this.hPos += this.direction;
        }
        this.hPos += this.adder;
        if (this.hPos >= this.monHSync) {
            int base;
            int adjust;
            if (this.inHSync) {
                this.adjustMoreLess(this.monHSync);
                this.hStart = 0;
            }
            if (this.hLess > this.hMore) {
                int diff = this.hLess - this.hMore;
                adjust = Math.min(204800, diff / HSYNC_ADJUST);
                if (adjust == 0) {
                    adjust = diff;
                }
                if ((base = adjust / 128) == 0) {
                    base = 1;
                }
            } else if (this.hMore > this.hLess) {
                int diff = this.hMore - this.hLess;
                adjust = -Math.min(204800, diff / HSYNC_ADJUST);
                if (adjust == 0) {
                    adjust = -diff;
                }
                if ((base = adjust / 128) == 0) {
                    base = -1;
                }
            } else if (this.hadHSync) {
                adjust = this.inHSync ? 0 : 128;
                base = adjust / 128;
            } else {
                adjust = 0;
                base = 0;
            }
            this.hPos -= this.monHSync;
            this.vSync += this.monHSync;
            ++this.monitorLine;
            this.hSync();
            this.monHSync = Math.max(0x3F0000, Math.min(0x410000, this.monHFree + adjust));
            this.monHFree = Math.max(0x3F0000, Math.min(0x410000, this.monHFree + base));
            this.hLess = 0;
            this.hMore = 0;
            this.hStart = 0;
            this.hadHSync = this.inHSync;
            ++this.vPos;
            if (this.inVSync || Basic6845.CRTCCollision) {
                this.checkVSync();
            }
        }
    }

    protected void checkVSync() {
        if (this.vPos >= this.vSyncMin && (this.vSync > this.monHSync || this.vPos >= this.vSyncMax)) {
            boolean interlace = this.vSync - this.monHSync < this.monHHalf;
            this.monitorLine = (250 - this.vPos) / 2 + this.vAdjust - (interlace ? 1 : 0);
            this.debug = false;
            if (this.debug) {
                System.out.println("VSync: vPos=" + this.vPos + ", VH-vP=" + (250 - this.vPos) + ", vSync=" + Util.hex(this.vSync) + ", row=" + this.monitorLine + ", monHSync=" + Util.hex(this.monHSync) + ", inVSync=" + this.inVSync + ", interlace=" + interlace + ", hPos=" + this.hPos);
            }
            if (Basic6845.CRTCCollision) {
                this.vSync();
            } else {
                this.vSync(interlace);
            }
            this.vPos = 0;
            CPC.updateable = true;
        }
    }

    protected void checkVSyncb() {
        if (this.vPos >= this.vSyncMin && (this.vSync > this.monHSync || this.vPos >= this.vSyncMax)) {
            boolean interlace = this.vSync - this.monHSync < this.monHHalf;
            this.monitorLine = (250 - this.vPos) / 2 + this.vAdjust - (interlace ? 1 : 0);
            if (this.debug) {
                System.out.println("VSync: vPos=" + this.vPos + ", VH-vP=" + (250 - this.vPos) + ", vSync=" + Util.hex(this.vSync) + ", row=" + this.monitorLine + ", monHSync=" + Util.hex(this.monHSync) + ", inVSync=" + this.inVSync + ", interlace=" + interlace + ", hPos=" + this.hPos);
            }
            this.vSync();
            CPC.updateable = true;
            this.vPos = 0;
        }
    }

    public void setVHold(int value) {
        this.vSyncMin = value + 295;
        this.vSyncMax = this.vSyncMin + 46 + Math.round((this.vSyncMin - 250) * 28 / 130);
    }

    public void setVerticalAdjust(int value) {
        this.vAdjust = value;
    }
}

