/*
 * Decompiled with CFR 0.152.
 */
package jemu.settings;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;

public class FavSettings {
    private static File file = new File(System.getProperty("user.home"), "/JavaCPC/favsettings.ini");
    private static File removeme = new File(System.getProperty("user.home"), "/JavaCPC/favsettings.xml");
    private static final FavSettings instance = new FavSettings();
    private final Properties props = new Properties();
    public static final String DSKICON = "icon_image_";
    public static final String DSKLABEL = "icon_label_";
    public static final String DSKTEXT = "icon_text_";
    public static final String DSKPOSX = "icon_pos_x_";
    public static final String DSKPOSY = "icon_pos_y_";

    private FavSettings() {
        try {
            if (System.getSecurityManager() != null) {
                file.mkdir();
                System.getSecurityManager().checkRead(file.getAbsolutePath());
            }
            this.props.load(new FileInputStream(file));
            if (removeme.exists()) {
                removeme.delete();
            }
            System.out.println("loaded " + this.props.size() + " favourites settings");
        }
        catch (Throwable t) {
            this.CreateFirst();
            this.redo();
        }
    }

    private void redo() {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkRead(file.getAbsolutePath());
            }
            this.props.load(new FileInputStream(file));
            System.out.println("loaded " + this.props.size() + " favourites settings");
        }
        catch (Throwable t) {
            System.out.println("can't load user settings (" + t.getMessage() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CreateFirst() {
        String name = "favsettings.ini";
        byte[] buffer = null;
        int offs = 0;
        try {
            InputStream stream = null;
            try {
                int read;
                int size;
                InputStream is;
                stream = is = this.getClass().getResourceAsStream(name);
                buffer = new byte[size];
                for (size = is.available(); size > 0; size -= read) {
                    read = stream.read(buffer, offs, size);
                    if (read == -1) {
                        break;
                    }
                    offs += read;
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("File not found...");
        }
        if (buffer != null) {
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                bos.write(buffer);
                bos.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = FavSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static void setBoolean(String key, boolean value) {
        FavSettings.instance.props.setProperty(key, value ? "true" : "false");
        FavSettings.save();
    }

    public static String get(String key, String defaultValue) {
        String value = FavSettings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void set(String key, String value) {
        if (value.equals(FavSettings.get(key, null))) {
            return;
        }
        FavSettings.instance.props.setProperty(key, value);
        FavSettings.save();
    }

    private static void save() {
        try {
            File f = new File(System.getProperty("user.home"), "JavaCPC");
            f.mkdir();
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkWrite(file.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(file);
            FavSettings.instance.props.store(fos, "[Favourite - Settings]");
        }
        catch (Throwable t) {
            System.out.println("can't save user settings (" + t.getMessage() + ")");
        }
    }
}

