/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import jemu.core.Util;
import jemu.core.device.Device;

public class Baslist {
    protected int charPos = 0;
    String[] Keywords = new String[]{"AFTER", "AUTO", "BORDER", "CALL", "CAT", "CHAIN", "CLEAR", "CLG", "CLOSEIN", "CLOSEOUT", "CLS", "CONT", "DATA", "DEF", "DEFINT", "DEFREAL", "DEFSTR", "DEG", "DELETE", "DIM", "DRAW", "DRAWR", "EDIT", "ELSE", "END", "ENT", "ENV", "ERASE", "ERROR", "EVERY", "FOR", "GOSUB", "GOTO", "IF", "INK", "INPUT", "KEY", "LET", "LINE", "LIST", "LOAD", "LOCATE", "MEMORY", "MERGE", "MID$", "MODE", "MOVE", "MOVER", "NEXT", "NEW", "ON", "ON BREAK", "ON ERROR GOTO", "SQ", "OPENIN", "OPENOUT", "ORIGIN", "OUT", "PAPER", "PEN", "PLOT", "PLOTR", "POKE", "PRINT", "'", "RAD", "RANDOMIZE", "READ", "RELEASE", "REM", "RENUM", "RESTORE", "RESUME", "RETURN", "RUN", "SAVE", "SOUND", "SPEED", "STOP", "SYMBOL", "TAG", "TAGOFF", "TROFF", "TRON", "WAIT", "WEND", "WHILE", "WIDTH", "WINDOW", "WRITE", "ZONE", "DI", "EI", "FILL", "GRAPHICS", "MASK", "FRAME", "CURSOR", null, "ERL", "FN", "SPC", "STEP", "SWAP", null, null, "TAB", "THEN", "TO", "USING", ">", "=", ">=", "<", "<>", "<=", "+", "-", "*", "/", "^", "\\", "AND", "MOD", "OR", "XOR", "NOT", null};
    String[] AdditionalKeywords = new String[]{"ABS", "ASC", "ATN", "CHR$", "CINT", "COS", "CREAL", "EXP", "FIX", "FRE", "INKEY", "INP", "INT", "JOY", "LEN", "LOG", "LOG10", "LOWER$", "PEEK", "REMAIN", "SGN", "SIN", "SPACE$", "SQ", "SQR", "STR$", "TAN", "UNT", "UPPER$", "VAL", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "EOF", "ERR", "HIMEM", "INKEY$", "PI", "RND", "TIME", "XPOS", "YPOS", "DERR", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "BIN$", "DEC$", "HEX$", "INSTR", "LEFT$", "MAX", "MIN", "POS", "RIGHT$", "ROUND", "STRING$", "TEST", "TESTR", "COPYCHR$", "VPOS", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    String result = "";

    protected char[] DisplayVariable(char[] pLinePtr) {
        char ch;
        do {
            ch = pLinePtr[this.charPos];
            ++this.charPos;
            this.result = this.result + (char)(ch & 0x7F);
        } while ((ch & 0x80) == 0);
        return pLinePtr;
    }

    protected void TranslateLine(char[] pLinePtr, long LineLength) {
        char Token2;
        char[] pLocalLinePtr = pLinePtr;
        this.charPos = 0;
        block19: do {
            Token2 = pLocalLinePtr[this.charPos];
            ++this.charPos;
            switch (Token2) {
                case '\u0000': {
                    break;
                }
                case '\u0001': {
                    if (pLocalLinePtr[0] == '\u0097' || pLocalLinePtr[0] == '\u00c0') continue block19;
                    this.result = this.result + ":";
                    break;
                }
                case '\u0002': {
                    this.charPos += 2;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    this.result = this.result + "%";
                    break;
                }
                case '\u0003': {
                    this.charPos += 2;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    this.result = this.result + "$";
                    break;
                }
                case '\u0004': {
                    this.charPos += 2;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    this.result = this.result + "!";
                    break;
                }
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': {
                    this.charPos += 2;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    break;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': {
                    int Number2 = Token2 - 14;
                    this.result = this.result + (Number2 & 0xFF);
                    break;
                }
                case '\u0019': {
                    int Number2 = (short)(pLocalLinePtr[this.charPos] & 0xFF);
                    this.result = this.result + (Number2 & 0xFF);
                    ++this.charPos;
                    break;
                }
                case '\u001a': {
                    int Number2 = (short)(pLocalLinePtr[0] & 0xFF | (pLocalLinePtr[1] & 0xFF) << 8);
                    this.result = this.result + (Number2 & 0xFFFF);
                    this.charPos += 2;
                    break;
                }
                case '\u001b': {
                    boolean bIgnoreDigit = true;
                    short Number3 = (short)(pLocalLinePtr[this.charPos] & 0xFF | (pLocalLinePtr[this.charPos + 1] & 0xFF) << 8);
                    this.result = this.result + "&X";
                    for (int j = 0; j < 16; ++j) {
                        int bd = Number3 >> 15 - j & 1;
                        if (bd != 0) {
                            bIgnoreDigit = false;
                        }
                        if (bIgnoreDigit) continue;
                        this.result = this.result + (48 + bd);
                    }
                    this.charPos += 2;
                    break;
                }
                case '\u001c': {
                    int Number2 = (short)(pLocalLinePtr[this.charPos] & 0xFF | (pLocalLinePtr[this.charPos + 1] & 0xFF) << 8);
                    String r = Util.hex((short)(Number2 & 0xFFFF));
                    while (r.startsWith("0")) {
                        r = r.substring(1);
                    }
                    this.result = this.result + "&" + r;
                    this.charPos += 2;
                    break;
                }
                case '\u001d': {
                    break;
                }
                case '\u001e': {
                    int Number2 = (short)(pLocalLinePtr[this.charPos] & 0xFF | (pLocalLinePtr[this.charPos + 1] & 0xFF) << 8);
                    this.result = this.result + (Number2 & 0xFFFF);
                    this.charPos += 2;
                    break;
                }
                case '\u001f': {
                    char exponent = pLocalLinePtr[this.charPos + 4];
                    long mantissa = (pLocalLinePtr[this.charPos + 3] & 0x7F) << 24 | (pLocalLinePtr[this.charPos + 2] & 0xFF) << 16 | (pLocalLinePtr[this.charPos + 1] & 0xFF) << 8 | pLocalLinePtr[this.charPos] & 0xFF;
                    char sign = (char)(pLocalLinePtr[this.charPos + 3] & 0x80);
                    if (sign != '\u0000') {
                        this.result = this.result + "-";
                    }
                    this.charPos += 5;
                    break;
                }
                case '\"': {
                    char ch = Token2;
                    this.result = this.result + ch;
                    do {
                        ch = pLocalLinePtr[this.charPos];
                        ++this.charPos;
                        if (ch == '\u0000') {
                            --this.charPos;
                            continue;
                        }
                        this.result = this.result + ch;
                    } while (ch != '\"' && ch != '\u0000');
                    break;
                }
                case '\u00ff': {
                    char Keyword = pLocalLinePtr[this.charPos];
                    ++this.charPos;
                    if (this.AdditionalKeywords[Keyword & 0xFF] == null) continue block19;
                    this.result = this.result + this.AdditionalKeywords[Keyword & 0xFF];
                    break;
                }
                case '|': {
                    this.result = this.result + "|";
                    ++this.charPos;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    break;
                }
                default: {
                    if (Token2 >= '\u0080' && Token2 <= '\u00fe') {
                        char NextToken;
                        if (this.Keywords[Token2 - 128] != null) {
                            this.result = this.result + this.Keywords[Token2 - 128];
                        }
                        if (Token2 != '\u00bf' || (NextToken = pLocalLinePtr[0]) != '\u00ff' && (NextToken < '\u0080' || NextToken > '\u00fe') && (NextToken < '\u0002' || NextToken > '\r')) continue block19;
                        this.result = this.result + " ";
                        break;
                    }
                    if (Token2 >= ' ' && Token2 <= '\u007f') {
                        this.result = this.result + (char)Token2;
                        break;
                    }
                    if (this.Keywords[Token2 & 0x7F] == null) continue block19;
                    this.result = this.result + this.Keywords[Token2 & 0x7F];
                }
            }
        } while (Token2 != '\u0000');
    }

    public static void main(String[] args) {
        File test2 = new File("CODE.BAS");
        String basresult = "";
        try {
            Baslist list = new Baslist();
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(test2));
            byte[] data = new byte[bin.available()];
            bin.read(data);
            bin.close();
            int baspos = 0;
            while (baspos < data.length) {
                int linelength = Device.getWord(data, baspos) - 4;
                if (linelength == 0) continue;
                int linenumber = Device.getWord(data, baspos + 2);
                char[] code = new char[linelength];
                int pos = 0;
                for (int i = baspos += 4; i < baspos + linelength; ++i) {
                    code[pos++] = (char)data[i];
                }
                basresult = basresult + linenumber + " ";
                list.result = "";
                list.TranslateLine(code, linelength);
                baspos += linelength;
                basresult = basresult + list.result + "\r\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(basresult);
    }
}

