/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import javax.swing.ImageIcon;
import jemu.core.device.MultiFace.MultiFace;
import jemu.core.device.memory.DynamicMemory;
import jemu.settings.Settings;
import jemu.system.cpc.GateArray;
import jemu.ui.Desktop;
import jemu.ui.Switches;

public class CPCMemory
extends DynamicMemory {
    protected Calendar cal = Calendar.getInstance();
    public static int upperRom;
    public static int plusRom;
    protected int ramtype = 0;
    public static final int TYPE_64K = 0;
    public static final int TYPE_128K = 1;
    public static final int TYPE_256K = 15;
    public static final int TYPE_SILICON_DISC = 240;
    public static final int TYPE_128_SILICON_DISC = 241;
    public static final int TYPE_512K = 255;
    protected int[] baseRAM = new int[8];
    protected int[] readMap = new int[8];
    protected int[] writeMap = new int[8];
    protected int ramTYPE;
    protected boolean lower = true;
    protected boolean upper = true;
    public boolean plus = false;
    public boolean multi = false;
    protected int upperROM = 0;
    protected int plusROM = 0;
    protected int bankRAM = -1;
    protected static final int BASE_RAM = 0;
    protected static final int BASE_LOWROM = 9;
    protected static final int BASE_UPROM = 10;
    protected static final int BASE_ASIC = 42;
    protected static final int BASE_PLUS = 43;
    protected static final int BASE_MULTIFACE = 75;
    protected boolean asiclocked = true;
    protected boolean asicRamActive = false;
    int lowRomLoc;
    int lowRomPage;
    int red;
    int green;
    int blue;
    byte[] posbuf = new byte[2];
    int[] spriteX = new int[16];
    int[] spriteY = new int[16];
    int spritepos;
    int[] oldmag = new int[16];
    int[] magnify = new int[]{0, 1, 2, 4};
    int[] xmag = new int[16];
    int[] ymag = new int[16];
    int[] mag = new int[16];
    protected Color[] sprites = new Color[16];
    int[][] sprdata = new int[16][256];
    public BufferedImage[] spriteImg = new BufferedImage[16];
    String[] CheckInfo = new String[]{"reset", "setROM", "setLowerEnabled", "setMultiEnabled", "setUpperEnabled", "setUpperROM", "setRamBank"};
    protected boolean roms32 = false;
    boolean useplus;
    public int selInk;
    int oldInk;
    boolean DEBUG_MF2 = false;
    int[] lowRom = new int[]{0, 16384, 32768};
    int region;

    public CPCMemory(int type) {
        super("CPC Memory", 65536, 76);
        this.enable32Roms(Settings.getBoolean("32_roms_enabled", false));
        this.ramtype = type;
        this.setRAMType(type);
        this.reset();
    }

    public int getRamType() {
        return this.ramtype;
    }

    public int readFromAsic(int address) {
        return this.mem[this.baseAddr[42] + (address & 0x3FFF)] & 0xFF;
    }

    public void writeToAsic(int address, int value) {
        this.mem[this.baseAddr[42] + (address & 0x3FFF)] = (byte)value;
    }

    public void spritepalette() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.setSprite(i);
        }
        for (i = 0; i < 16; ++i) {
            this.blue = this.readFromAsic(25634 + i * 2) & 0xF;
            this.red = this.readFromAsic(25634 + i * 2) >> 4 & 0xF;
            this.green = this.readFromAsic(25635 + i * 2) & 0xF;
            this.setSpritePalette(i, this.red, this.green, this.blue);
        }
    }

    public void spritepalette(int i) {
        this.setSprite(i);
        this.blue = this.readFromAsic(25634 + i * 2) & 0xF;
        this.red = this.readFromAsic(25634 + i * 2) >> 4 & 0xF;
        this.green = this.readFromAsic(25635 + i * 2) & 0xF;
        this.setSpritePalette(i, this.red, this.green, this.blue);
    }

    public void eraseSprite(int index) {
        this.mag[index] = 0;
        this.oldmag[index] = -1;
        this.spriteX[index] = -2000;
        this.spriteY[index] = -2000;
        this.xmag[index] = 0;
        this.ymag[index] = 0;
    }

    public void setSpritePos(int index) {
        this.spritepos = 24576 + index * 8;
        this.posbuf[0] = (byte)this.readFromAsic(this.spritepos);
        this.posbuf[1] = (byte)this.readFromAsic(this.spritepos + 1);
        this.spriteX[index] = CPCMemory.getWord(this.posbuf, 0);
        if ((this.spriteX[index] & 0x300) == 768) {
            int n = index;
            this.spriteX[n] = this.spriteX[n] | 0xFF00;
        }
        if ((this.spriteX[index] & 0x8000) != 0) {
            this.spriteX[index] = -(0 - this.spriteX[index] & 0xFFFF);
        }
        this.posbuf[0] = (byte)this.readFromAsic(this.spritepos + 2);
        this.posbuf[1] = (byte)this.readFromAsic(this.spritepos + 3);
        this.spriteY[index] = CPCMemory.getWord(this.posbuf, 0);
        if ((this.spriteY[index] & 0x100) == 256) {
            int n = index;
            this.spriteY[n] = this.spriteY[n] | 0xFF00;
        }
        if ((this.spriteY[index] & 0x8000) != 0) {
            this.spriteY[index] = -(0 - this.spriteY[index] & 0xFFFF);
        }
    }

    public void setMag(int index) {
        this.spritepos = 24576 + index * 8;
        for (int i = 0; i < 4; ++i) {
            this.mag[index] = this.readFromAsic(this.spritepos + 4 + i) & 0xF;
            if (this.mag[index] != 0) break;
        }
        if (this.mag[index] != this.oldmag[index]) {
            this.xmag[index] = this.magnify[this.mag[index] >> 2 & 3];
            this.ymag[index] = this.magnify[this.mag[index] & 3];
        }
        this.oldmag[index] = this.mag[index];
    }

    public int getXM(int index) {
        return this.xmag[index];
    }

    public int getYM(int index) {
        return this.ymag[index];
    }

    public int getSpriteX(int index) {
        this.setSpritePos(index);
        return this.spriteX[index];
    }

    public int getSpriteY(int index) {
        return this.spriteY[index] * 2;
    }

    public void setSpritePalette(int pen, int r, int g, int b) {
        this.sprites[pen] = new Color((r &= 0xF) * 17, (g &= 0xF) * 17, (b &= 0xF) * 17);
    }

    public int[] getSprite(int index) {
        this.spritepalette(index);
        return this.sprdata[index];
    }

    public void setSprite(int index) {
        try {
            this.spritepos = 16384 + index * 256;
            for (int i = 0; i < this.sprdata[index].length; ++i) {
                int val = 0;
                val = this.readFromAsic(i + this.spritepos) & 0xF;
                this.sprdata[index][i] = val > 0 ? this.sprites[val - 1].getRGB() : -123456789;
            }
            this.putSpriteImg(index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void putSpriteImg(int index) {
        if (this.sprites[index] == null) {
            return;
        }
        BufferedImage spriteI = new BufferedImage(32, 32, 2);
        int xoff = 0;
        int yoff = 0;
        for (int y = 0; y < 32; y += 2) {
            for (int x = 0; x < 32; x += 2) {
                int rgb = this.sprdata[index][yoff * 16 + xoff];
                if (rgb == -123456789) {
                    rgb = 0;
                }
                ++xoff;
                spriteI.setRGB(x, y, rgb);
                spriteI.setRGB(x + 1, y, rgb);
                spriteI.setRGB(x + 1, y + 1, rgb);
                spriteI.setRGB(x, y + 1, rgb);
            }
            xoff = 0;
            ++yoff;
        }
        switch (index) {
            case 0: {
                Desktop.sprite1.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 1: {
                Desktop.sprite2.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 2: {
                Desktop.sprite3.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 3: {
                Desktop.sprite4.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 4: {
                Desktop.sprite5.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 5: {
                Desktop.sprite6.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 6: {
                Desktop.sprite7.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 7: {
                Desktop.sprite8.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 8: {
                Desktop.sprite9.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 9: {
                Desktop.sprite10.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 10: {
                Desktop.sprite11.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 11: {
                Desktop.sprite12.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 12: {
                Desktop.sprite13.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 13: {
                Desktop.sprite14.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 14: {
                Desktop.sprite15.setIcon(new ImageIcon(spriteI));
                break;
            }
            case 15: {
                Desktop.sprite16.setIcon(new ImageIcon(spriteI));
            }
        }
    }

    public void pluspalette(int ink) {
        this.blue = this.readFromAsic(25600 + ink * 2) & 0xF;
        this.red = this.readFromAsic(25600 + ink * 2) >> 4 & 0xF;
        this.green = this.readFromAsic(25601 + ink * 2) & 0xF;
        GateArray.setPlusPalette(ink, this.red, this.green, this.blue);
    }

    public void setPlus(boolean pl) {
        this.plus = pl;
    }

    @Override
    public void reset() {
        this.lowRomLoc = 0;
        this.lowRomPage = 0;
        System.out.println("Memory reset!");
        this.setRAMBank(192);
        this.asiclocked = true;
        this.asicRamActive = false;
        this.upper = false;
        this.lower = true;
        this.multi = false;
        this.useplus = false;
        this.upperROM = 0;
        this.plusROM = 0;
        this.remap();
        GateArray.cpc.psg.resetRegisters();
    }

    public void setRAMType(int value) {
        this.ramTYPE = value;
        this.getMem(0, 65536);
        for (int i = 1; i < 9; ++i) {
            if ((this.ramTYPE & 1) != 0) {
                this.getMem(i, 65536);
            } else {
                this.freeMem(i, 65536);
            }
            this.ramTYPE >>= 1;
        }
        this.getMem(42, 16384);
        this.getMem(75, 16384);
    }

    public int getRAMType() {
        return this.ramtype;
    }

    public void setLowerROM(byte[] data) {
        this.setROM(9, data);
    }

    public void setMultiROM(byte[] data) {
        this.setROM(75, data);
    }

    public void setUpperROM(int rom, byte[] data) {
        this.setROM(10 + (rom & (this.roms32 ? 31 : 15)), data);
    }

    public void enable32Roms(boolean enable) {
        this.roms32 = enable;
        Settings.setBoolean("32_roms_enabled", this.roms32);
    }

    public void setPlusROM(int rom, byte[] data) {
        this.setROM(43 + rom, data);
    }

    protected void setROM(int base, byte[] data) {
        try {
            System.out.println("Putting rom to base " + base);
            if (data == null || data.length == 0) {
                this.freeMem(base, 16384);
            } else {
                if (base == 10) {
                    Switches.ROM = data[2] == 0 ? "CPC464" : (data[2] == 1 ? "CPC664" : (data[2] == 2 || data[2] == 4 ? "CPC6128" : "UNKNOWN"));
                    GateArray.cpc.setOS();
                    System.out.println("Your selected Basic ROM is for " + Switches.ROM);
                }
                base = this.getMem(base, 16384);
                System.arraycopy(data, 0, this.mem, base, Math.min(16384, data.length));
            }
            this.remap();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void setLowerEnabled(boolean value) {
        if (this.lower != value) {
            this.lower = value;
            this.remap();
        }
    }

    public void setMultiEnabled(boolean value) {
        if (this.multi != value) {
            this.multi = value;
            this.remap();
        }
    }

    public void setUpperEnabled(boolean value) {
        if (this.upper != value) {
            this.upper = value;
            this.remap();
        }
    }

    public void setUpperROM(int value) {
        if (this.plus && value > 127) {
            this.useplus = true;
            if (this.plusROM != (value &= 0x1F)) {
                this.plusROM = value;
                this.remap();
            }
            plusRom = value;
        } else {
            upperRom = value;
            if (this.plus) {
                if ((value &= 0xF) == 7) {
                    this.useplus = true;
                    value = 3;
                    if (this.plusROM != value) {
                        this.plusROM = value;
                        this.remap();
                    }
                } else {
                    this.useplus = true;
                    value = 1;
                    if (this.plusROM != value) {
                        this.plusROM = value;
                        this.remap();
                    }
                }
            } else {
                int n = this.roms32 ? 31 : 15;
                this.useplus = false;
                if (this.upperROM != (value &= n)) {
                    this.upperROM = value;
                    this.remap();
                }
            }
        }
    }

    public int getUpperROM() {
        return upperRom;
    }

    public int getPlusROM() {
        return plusRom;
    }

    public void setRAMBank(int value) {
        if (this.bankRAM != (value &= 0x3F)) {
            this.bankRAM = value;
            this.remapRAM();
            this.remap();
        }
    }

    public int getRAMBank() {
        return this.bankRAM | 0xC0;
    }

    protected void remapRAM() {
        int mask = 0;
        boolean enable128k = false;
        boolean enable256k = false;
        boolean silicondiskenabled = false;
        if (this.ramtype == 1 || this.ramtype == 241) {
            enable128k = true;
        }
        if (this.ramtype == 15) {
            enable256k = true;
        }
        if (this.ramtype == 241 || this.ramtype == 240) {
            silicondiskenabled = true;
        }
        if (enable128k) {
            mask |= 7;
        }
        if (enable256k) {
            mask |= 0x1F;
        }
        if (silicondiskenabled) {
            mask |= 0x3F;
        }
        if (mask != 0) {
            this.bankRAM &= mask;
        }
        int bankBase = ((this.bankRAM & 0x38) >> 3) + 0 + 1;
        if ((bankBase = this.baseAddr[bankBase]) == -1) {
            bankBase = this.baseAddr[0];
            this.bankRAM = 0;
        }
        int base = (this.bankRAM & 7) == 2 ? bankBase : this.baseAddr[0];
        for (int i = 0; i < 8; ++i) {
            this.baseRAM[i] = base + i * 8192;
        }
        if ((this.bankRAM & 5) == 1) {
            this.baseRAM[6] = bankBase + 49152;
            this.baseRAM[7] = bankBase + 57344;
            if ((this.bankRAM & 2) == 2) {
                this.baseRAM[2] = base + 49152;
                this.baseRAM[3] = base + 57344;
            }
        } else if ((this.bankRAM & 4) == 4) {
            this.baseRAM[2] = bankBase + (this.bankRAM & 3) * 16384;
            this.baseRAM[3] = this.baseRAM[2] + 8192;
        }
    }

    @Override
    public int readByte(int address) {
        try {
            if (this.multi && address > 8191 && address < 16384) {
                return MultiFace.MultifaceRam[address - 8192] & 0xFF;
            }
            if (this.getRAMBank() == 192) {
                if (address > 16383 && address < 32768 && this.asicRamActive) {
                    return this.readFromAsic(address);
                }
                if (address > 16383 && address < 32768 && this.baseRAM[3] == this.baseAddr[42] + 8192) {
                    return this.readFromAsic(address);
                }
            }
            return this.mem[this.readMap[address >> 13] + (address & 0x1FFF)] & 0xFF;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int readWriteByte(int address) {
        try {
            return this.mem[this.writeMap[address >> 13] + (address & 0x1FFF)] & 0xFF;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int readWriteByte(int address, int forcedbank, boolean forced) {
        try {
            if (address > 16383 && address < 32768) {
                int g = this.getRAMBank();
                this.setRAMBank(forcedbank);
                int b = this.mem[this.writeMap[address >> 13] + (address & 0x1FFF)] & 0xFF;
                this.setRAMBank(g);
                return b;
            }
            return this.readWriteByte(address);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int writeByte(int address, int value) {
        try {
            if (!this.plus && address > 8191 && address < 16384 && this.multi) {
                MultiFace.MultifaceRam[address - 8192] = (byte)(value & 0xFF);
            } else {
                this.mem[this.writeMap[address >> 13] + (address & 0x1FFF)] = (byte)value;
                if (address > 16383 && address < 32768 && this.asicRamActive) {
                    this.writeToAsic(address, value);
                    if (address > 25599 && address < 25634 && this.asicRamActive) {
                        this.pluspalette((address - 25600) / 2);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value & 0xFF;
    }

    public int writeBytde(int address, int value) {
        try {
            if (!this.plus && address > 8191 && address < 16384 && this.multi) {
                MultiFace.MultifaceRam[address - 8192] = (byte)(value & 0xFF);
            } else {
                if (address > 24575 && address < 32768 && this.asicRamActive) {
                    this.writeToAsic(address, value);
                    if (address > 25599 && address < 25634) {
                        this.pluspalette((address - 25600) / 2);
                    }
                    return value & 0xFF;
                }
                if (address > 16383 && address < 20480 && this.asicRamActive) {
                    this.writeToAsic(address, value);
                }
                if (this.getRAMBank() == 192 && address > 16383 && address < 32768 && this.baseRAM[2] == this.baseAddr[42]) {
                    this.writeToAsic(address, value);
                    if (address > 25599 && address < 25634 && this.baseRAM[2] == this.baseAddr[42]) {
                        this.pluspalette((address - 25600) / 2);
                    }
                    return value & 0xFF;
                }
                if (this.getRAMBank() == 192 && address > 16383 && address < 32768 && this.asicRamActive) {
                    this.writeToAsic(address, value);
                    return value & 0xFF;
                }
                this.mem[this.writeMap[address >> 13] + (address & 0x1FFF)] = (byte)value;
                if (address > 25599 && address < 25634 && this.asicRamActive) {
                    this.pluspalette((address - 25600) / 2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value & 0xFF;
    }

    public int writeBytes(int address, int value) {
        try {
            if (!this.plus && address > 8191 && address < 16384 && this.multi) {
                MultiFace.MultifaceRam[address - 8192] = (byte)(value & 0xFF);
            } else {
                if (address > 16383 && address < 32768 && this.asicRamActive && this.baseRAM[2] == this.baseAddr[42]) {
                    this.writeToAsic(address, value);
                    if (address > 25599 && address < 25634) {
                        this.pluspalette((address - 25600) / 2);
                    }
                    return value & 0xFF;
                }
                this.mem[this.writeMap[address >> 13] + (address & 0x1FFF)] = (byte)value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value & 0xFF;
    }

    @Override
    public int writeByte(int address, int value, int forcedbank, boolean forced) {
        if (address > 16383 && address < 32768) {
            int g = this.getRAMBank();
            this.setRAMBank(forcedbank);
            try {
                this.mem[this.writeMap[address >> 13] + (address & 0x1FFF)] = (byte)value;
            }
            catch (Exception e) {
                // empty catch block
            }
            int b = value & 0xFF;
            this.setRAMBank(g);
            return b;
        }
        return this.writeByte(address, value);
    }

    public void poke(int address, int value) {
        this.mem[address] = (byte)value;
    }

    public void remap() {
        this.mapRAM();
        this.mapROMs();
    }

    protected void mapRAM() {
        for (int i = 0; i < 8; ++i) {
            this.readMap[i] = this.writeMap[i] = this.baseRAM[i];
        }
    }

    public void enableAsicRam(boolean asicRamActive, int lowRomLoc, int lowRomPage, boolean asicLocked, int region) {
        this.region = region;
        this.asiclocked = asicLocked;
        this.asicRamActive = asicRamActive;
        this.lowRomLoc = lowRomLoc;
        this.lowRomPage = lowRomPage;
        this.remapRAM();
        this.remap();
    }

    public boolean getAsicActive() {
        return this.asicRamActive;
    }

    protected void mapROMs() {
        int addr;
        if (!this.plus) {
            this.useplus = false;
        }
        if (!this.plus && this.lower && (addr = this.baseAddr[9]) != -1) {
            if (!this.plus && this.multi && (addr = this.baseAddr[75]) != -1) {
                if (this.DEBUG_MF2) {
                    System.out.println("Mapping multiface ROM");
                }
                this.readMap[0] = this.baseAddr[75];
                this.readMap[1] = this.writeMap[1] = this.baseAddr[75] + 8192;
            } else {
                this.readMap[0] = addr;
                this.readMap[1] = addr + 8192;
            }
        }
        if (this.plus && this.lower && (addr = this.baseAddr[43 + this.lowRomPage]) != -1) {
            this.readMap[this.lowRomLoc] = addr;
            this.readMap[this.lowRomLoc + 1] = addr + 8192;
        }
        if (this.upper && !this.useplus) {
            addr = this.baseAddr[10 + this.upperROM];
            if (addr == -1) {
                addr = this.baseAddr[10];
            }
            if (addr != -1) {
                this.readMap[6] = addr;
                this.readMap[7] = addr + 8192;
            }
        }
        if (this.upper && this.plus && this.useplus) {
            addr = this.baseAddr[43 + this.plusROM];
            if (addr == -1) {
                addr = this.baseAddr[43];
            }
            if (addr != -1) {
                this.readMap[6] = addr;
                this.readMap[7] = addr + 8192;
            }
        }
    }

    @Override
    public void writePort(int port, int value) {
        this.setUpperROM(value);
    }

    @Override
    public int readPort(int port) {
        this.cal = Calendar.getInstance();
        int result = 255;
        if (port == 65278) {
            result = 160;
        }
        if (Settings.getBoolean("realtime_clock", false)) {
            if (port == 65266) {
                result = this.cal.get(2);
            }
            if (port == 65268) {
                result = this.cal.get(5);
            }
            if (port == 65270) {
                result = this.cal.get(11);
            }
            if (port == 65272) {
                result = this.cal.get(12);
            }
            if (port == 65274) {
                result = this.cal.get(13);
            }
            if (port == 65276) {
                result = this.cal.get(7);
            }
        }
        return result;
    }

    @Override
    public int readByte(int address, Object config) {
        return this.readByte(address);
    }
}

