/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import jemu.core.Util;
import jemu.system.cpc.CheckDOS;

public class DOSHandler
extends CheckDOS {
    protected byte[] SOURCEFILE;
    protected byte[] RESULT;
    protected byte[] HEADER = new byte[128];
    protected String internalname = "           ";
    protected int namepos = 1;
    protected int filetypepos = 18;
    protected int datalengthpos = 19;
    protected int datalocationpos = 21;
    protected int firstblockpos = 23;
    protected int filelengthpos = 24;
    protected int execaddresspos = 26;
    protected int lengthpos = 64;
    protected int checksumpos = 67;

    public byte[] addHeader(byte[] SOURCEFILE) {
        if (SOURCEFILE == null) {
            return null;
        }
        this.RESULT = new byte[SOURCEFILE.length + 128];
        System.arraycopy(this.HEADER, 0, this.RESULT, 0, 128);
        System.arraycopy(SOURCEFILE, 0, this.RESULT, 128, SOURCEFILE.length);
        SOURCEFILE = new byte[this.RESULT.length];
        System.arraycopy(this.RESULT, 0, SOURCEFILE, 0, SOURCEFILE.length);
        return this.RESULT;
    }

    public String getStart() {
        int st = DOSHandler.getWord(this.HEADER, this.datalocationpos);
        return Util.hex((short)st);
    }

    public String getLength() {
        int st = DOSHandler.getWord(this.HEADER, this.datalengthpos);
        return Util.hex((short)st);
    }

    public String getExec() {
        int st = DOSHandler.getWord(this.HEADER, this.execaddresspos);
        return Util.hex((short)st);
    }

    public int getFiletype() {
        return this.HEADER[this.filetypepos];
    }

    public void writeFile(String name) {
        if (this.SOURCEFILE == null) {
            return;
        }
        try {
            File file = new File(name);
            BufferedOutputStream in = new BufferedOutputStream(new FileOutputStream(file));
            in.write(this.SOURCEFILE);
            in.close();
        }
        catch (Exception e) {
            System.err.println("File not found / bad name");
        }
    }

    public String getName() {
        if (this.SOURCEFILE == null) {
            return "";
        }
        String build = "";
        for (int i = 1; i < 12; ++i) {
            build = build + "" + (char)this.SOURCEFILE[i];
        }
        return build;
    }

    public byte[] makeHeader(byte[] SOURCEFILE, int start, int length, String intname) {
        if (SOURCEFILE == null) {
            return null;
        }
        this.HEADER = new byte[128];
        intname = intname.replace(".", "");
        while (intname.length() > 11) {
            intname = intname.substring(0, intname.length() - 1);
        }
        intname = intname.toUpperCase();
        try {
            System.arraycopy("           ".getBytes("UTF-8"), 0, this.HEADER, this.namepos, 11);
            System.arraycopy(intname.getBytes("UTF-8"), 0, this.HEADER, this.namepos, intname.length());
        }
        catch (Exception e) {
            System.err.println("Something went wrong with " + intname);
        }
        this.HEADER[this.filetypepos] = 2;
        DOSHandler.putWord(this.HEADER, this.datalengthpos, length);
        DOSHandler.putWord(this.HEADER, this.datalocationpos, start);
        this.HEADER[this.firstblockpos] = -1;
        DOSHandler.putWord(this.HEADER, this.filelengthpos, length);
        DOSHandler.put24Bit(this.HEADER, this.lengthpos, length);
        DOSHandler.put24Bit(this.HEADER, this.checksumpos, this.ChecksumAMSDOS(this.HEADER));
        return this.addHeader(SOURCEFILE);
    }

    public static int getWord(byte[] buffer, int offs) {
        return buffer[offs] & 0xFF | buffer[offs + 1] << 8 & 0xFF00;
    }

    public static void putWord(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
    }

    public static void put24Bit(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 2] = (byte)(data >> 16 & 0xFF);
    }
}

