/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.awt.Dimension;
import jemu.core.device.crtc.Basic6845;
import jemu.core.device.crtc.CRTCListener;
import jemu.core.renderer.MonitorRenderer;
import jemu.system.cpc.CPC;
import jemu.system.cpc.CPCMemory;
import jemu.system.cpc.GraphicsDecoder;
import jemu.system.cpc.Z80;
import jemu.ui.Display;
import jemu.ui.JEMU;
import jemu.ui.Switches;

public final class GateArray
extends MonitorRenderer
implements CRTCListener {
    protected int borderHeight;
    protected static final GraphicsDecoder decoder = new GraphicsDecoder();
    protected final int HOFFSET = 718848;
    protected final int HOFFSEND = 3864576;
    protected Dimension HALF_DISPLAY_SIZE = new Dimension(384, 272);
    protected Dimension FULL_DISPLAY_SIZE = new Dimension(768, 272);
    static int returnmode = 0;
    static int rambank = 0;
    static int smode = 1;
    public static CPC cpc;
    public static Z80 z80;
    public Basic6845 crtc;
    protected int r52;
    protected int vSyncInt = 0;
    protected int interruptMask;
    protected int hSyncCount;
    protected int vSyncCount = 0;
    protected int screenMode = -1;
    protected int newMode = 0;
    protected boolean[] isBorder;
    protected boolean outHSync = false;
    public static int[] inks;
    protected byte[] fullMap;
    protected byte[] halfMap;
    protected int offset = 0;
    protected int scanStart = 0;
    protected boolean scanStarted;
    protected Renderer borderRenderer;
    protected Renderer syncRenderer;
    protected Renderer defRenderer;
    protected Renderer startRenderer;
    protected Renderer endRenderer;
    protected Renderer renderer;
    protected int endPix;
    protected int selInk = 0;
    protected boolean render = true;
    protected boolean rendering = true;
    public static byte[] screenmemory;
    protected boolean halfSize = false;
    protected int Luminance = 255;
    protected static final int[] maTranslate;
    protected static int[] CPCInks;
    protected static int[] CPCInksb;
    protected static int[] GAInks;
    public static int[] palette;
    protected static int[] Inks;
    public static int[] luminancePLUS;
    public static int[] inkTranslateColor;
    protected static final int[] original;
    protected static final int[] inkTranslateGrim;
    protected static final int[] inkTranslateGrim2;
    protected static final int[] inkTranslateCPCe;
    protected static final int[] inkTranslate3d;
    protected static final int[] inkTranslateLinear;
    protected static final int[] green;
    protected static final int[] inkTranslateGreen;
    protected static final int[] inkTranslateGrey;
    protected static final int[] inkTranslateBW;
    protected static final byte[][] fullMaps;
    protected static final byte[][] halfMaps;
    static int[] requestink;
    boolean test = false;
    boolean testbars;
    int skipsprites;
    int[][] sprite = new int[16][];
    int spriteoffset;
    int spos;
    CPCMemory spritemem;
    boolean skipsprite;
    int[] xm = new int[16];
    int[] ym = new int[16];
    int[] xpos = new int[16];
    int[] ypos = new int[16];
    int ymin;
    int ymax;
    int xmin;
    int xmax;
    int[] oldline = new int[16];
    int sproffset;
    int r3;
    static boolean use3d;

    public static void resetCPCColours() {
        System.arraycopy(original, 0, inkTranslateColor, 0, original.length);
    }

    public static void setPalette(int ink, int r, int g, int b) {
        GateArray.inkTranslateColor[GateArray.Inks[ink]] = GateArray.putRGB(GateArray.LUM(r), GateArray.LUM(g), GateArray.LUM(b));
        GateArray.resetInks();
    }

    public static void setInk(int ink, int r, int g, int b) {
        GateArray.inkTranslateColor[GateArray.Inks[ink]] = GateArray.putRGB(r, g, b);
        GateArray.resetInks();
    }

    public static void setPlusPalette(int ink, int r, int g, int b) {
        GateArray.inkTranslateColor[ink] = GateArray.putRGB(GateArray.LUM(r), GateArray.LUM(g), GateArray.LUM(b));
        GateArray.resetInkss();
    }

    public static void setPlusPalette(int ink, int value) {
        GateArray.inkTranslateColor[ink] = value;
    }

    public static void setPalette(int ink, int value) {
        GateArray.inkTranslateColor[GateArray.Inks[ink]] = value;
    }

    public static int LUM(int in) {
        return luminancePLUS[in];
    }

    @Override
    public int getVPOS() {
        return this.crtc.getVVPOS() * (this.halfSize ? 1 : 2);
    }

    @Override
    public int getHPOS() {
        return this.crtc.getHPOS() / (this.halfSize ? 2 : 1);
    }

    public GateArray(CPC cpc) {
        super("Amstrad Gate Array");
        this.setCycleFrequency(1000000L);
        GateArray.cpc = cpc;
        z80 = cpc.z80;
        this.crtc = cpc.crtc;
        this.reset();
        this.setHalfSize(false);
        for (int i = 0; i < 32; ++i) {
            GateArray.inkTranslateGreen[i] = green[GAInks[i]];
        }
    }

    public void setHalfSize(boolean value) {
        if (this.halfSize != value || this.defRenderer == null) {
            this.halfSize = value;
            this.defRenderer = this.halfSize ? new HalfRenderer() : new FullRenderer();
            this.startRenderer = this.halfSize ? new HalfStartRenderer() : new FullStartRenderer();
            this.endRenderer = this.halfSize ? new HalfEndRenderer() : new FullEndRenderer();
            this.borderRenderer = new BorderRenderer(16, this.halfSize ? 8 : 16);
            this.syncRenderer = new BorderRenderer(32, this.halfSize ? 8 : 16);
            this.renderer = this.borderRenderer;
        }
    }

    @Override
    public void reset() {
        GateArray.resetCPCColours();
        this.r52 = 0;
        this.setScreenMode(1);
        for (int i = 0; i < 33; ++i) {
            GateArray.inks[i] = -16777216;
        }
        GateArray.inks[16] = -8355712;
    }

    public void setSelectedInk(int value) {
        this.selInk = (value & 0x1F) < 16 ? value & 0xF : 16;
    }

    public int getSelectedInk() {
        return this.selInk;
    }

    public static void setInk(int index, int value) {
        GateArray.CPCInks[index] = GAInks[value & 0x1F];
        GateArray.CPCInksb[index] = value;
        GateArray.requestink[index] = value & 0x1F;
    }

    public static int getInk(int index) {
        return CPCInks[index];
    }

    public static int getInks(int index) {
        return CPCInksb[index];
    }

    @Override
    public void writePort(int port, int value) {
        if (CPC.memory.plus) {
            return;
        }
        if ((value & 0x80) == 0) {
            if ((value & 0x40) == 0) {
                this.selInk = (value &= 0x1F) < 16 ? value : 16;
            } else {
                GateArray.CPCInks[this.selInk] = GAInks[value & 0x1F];
                GateArray.CPCInksb[this.selInk] = value & 0x1F;
                GateArray.requestink[this.selInk] = value & 0x1F;
                this.updateInks(false);
            }
        } else {
            CPCMemory cpcmemory = (CPCMemory)cpc.getMemory();
            if ((value & 0x40) == 0) {
                this.setModeAndROMEnable(cpcmemory, value);
            } else {
                cpcmemory.setRAMBank(value);
                rambank = value;
            }
        }
    }

    public void updateInks(boolean method) {
        if (use3d != Display.use3d) {
            GateArray.resetInks();
        }
        use3d = Display.use3d;
        if (method) {
            // empty if block
        }
        int monitormode = Switches.monitormode;
        for (int i = 0; i < requestink.length; ++i) {
            if (requestink[i] == -1) continue;
            if (use3d) {
                switch (monitormode) {
                    case 2: {
                        GateArray.inks[i] = inkTranslateGreen[requestink[i]];
                        break;
                    }
                    case 3: {
                        GateArray.inks[i] = inkTranslateBW[requestink[i]];
                        break;
                    }
                    case 4: {
                        GateArray.inks[i] = inkTranslateGrey[requestink[i]];
                        break;
                    }
                    default: {
                        GateArray.inks[i] = inkTranslate3d[requestink[i]];
                    }
                }
                GateArray.requestink[i] = -1;
                return;
            }
            switch (monitormode) {
                case 1: {
                    GateArray.inks[i] = inkTranslateLinear[requestink[i]];
                    break;
                }
                case 2: {
                    GateArray.inks[i] = inkTranslateGreen[requestink[i]];
                    break;
                }
                case 3: {
                    GateArray.inks[i] = inkTranslateBW[requestink[i]];
                    break;
                }
                case 4: {
                    GateArray.inks[i] = inkTranslateGrey[requestink[i]];
                    break;
                }
                case 5: {
                    GateArray.inks[i] = inkTranslateCPCe[requestink[i]];
                    break;
                }
                case 6: {
                    GateArray.inks[i] = inkTranslateGrim[requestink[i]];
                    break;
                }
                default: {
                    GateArray.inks[i] = inkTranslateColor[requestink[i]];
                }
            }
            GateArray.requestink[i] = -1;
        }
    }

    public int getRAMBank() {
        return rambank;
    }

    public void setNewMode(int value) {
        this.newMode = value;
    }

    public void setModeAndROMEnable(CPCMemory memory, int value) {
        returnmode = value;
        memory.setLowerEnabled((value & 4) == 0);
        memory.setUpperEnabled((value & 8) == 0);
        if ((value & 0x10) != 0) {
            this.r52 = 0;
            this.setInterruptMask(this.interruptMask & 0x70);
        }
        this.newMode = value;
    }

    public int getMode() {
        return returnmode;
    }

    public void setScreenMode(int mode) {
        this.screenMode = mode;
        this.fullMap = fullMaps[mode];
        this.halfMap = halfMaps[mode];
    }

    @Override
    public int getScreenMode() {
        return this.screenMode;
    }

    public static int getSMode() {
        return smode;
    }

    public void setInterruptMask(int value) {
        this.interruptMask = value;
        if (this.interruptMask != 0) {
            z80.setInterrupt(1);
        } else {
            z80.clearInterrupt(1);
        }
    }

    @Override
    public void setInterrupt(int mask) {
        this.r52 &= 0x1F;
        this.setInterruptMask(this.interruptMask & 0x70);
    }

    @Override
    public void cycle() {
        if (this.test) {
            boolean bl = this.testbars = !this.testbars;
            if (this.testbars) {
                GateArray.setInk(16, 13);
            } else {
                GateArray.setInk(16, 20);
            }
            this.updateInks(true);
        }
        this.crtc.avoidCollision();
        smode = this.screenMode;
        if (this.hSyncCount == 3 || this.hSyncCount == 4) {
            this.modeCheck();
        }
        if (this.scanStarted) {
            this.crtc.checkHDisp();
            if (this.hPos < 3864576) {
                this.renderer.render();
            } else {
                this.endRenderer.render();
                this.scanStarted = false;
                this.render = false;
            }
        } else if (this.render && this.hPos >= 718848) {
            this.startRenderer.render();
            this.scanStarted = true;
        }
        this.crtc.cycle();
        if (this.inHSync) {
            ++this.hSyncCount;
            if (this.hSyncCount == 2) {
                this.outHSync = true;
                super.hSyncStart();
            }
            if (this.hSyncCount == 6) {
                this.endHSync();
            }
        }
        this.clock();
    }

    protected void endHSync() {
        if (this.outHSync) {
            super.hSyncEnd();
            if (cpc.getAsic() != null) {
                cpc.getAsic().splitScreen();
            }
        }
        this.outHSync = false;
        this.modeCheck();
    }

    @Override
    public void modeCheck() {
        if (this.screenMode != this.newMode) {
            this.setScreenMode(this.newMode & 3);
        }
    }

    @Override
    public void hSyncStart() {
        this.hSyncCount = 0;
        this.inHSync = true;
        this.renderer = this.syncRenderer;
    }

    @Override
    public void hSync() {
        this.modeCheck();
        this.render = this.rendering && this.monitorLine >= -4 && this.monitorLine < 268;
        if (this.render) {
            this.offset = this.scanStart;
            this.scanStart = Display.doublesize ? (this.scanStart += this.halfSize ? 768 : 1536) : (this.scanStart += this.halfSize ? 384 : 768);
        }
        if (this.vSyncCount > 0 && --this.vSyncCount == 0) {
            super.vSyncEnd();
        }
        this.scanStarted = false;
    }

    @Override
    public void hSyncEnd() {
        block15: {
            block16: {
                block17: {
                    block13: {
                        block14: {
                            if (CPC.memory.plus) {
                                ++this.skipsprites;
                            }
                            if (this.skipsprites == 8) {
                                this.skipsprites = 0;
                                this.renderSprites(this.getVPOS());
                            }
                            this.debug = cpc.getMode() != 3;
                            this.endHSync();
                            try {
                                if (CPC.memory.plus && cpc.getAsic().doInterrupt()) {
                                    this.r52 = 0;
                                    this.setInterruptMask(this.interruptMask | 0x80);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (++this.r52 != 52) break block13;
                            this.r52 = 0;
                            if (!cpc.getAsic().getRaster()) break block14;
                            if (CPC.memory.plus) break block13;
                        }
                        this.setInterruptMask(this.interruptMask | 0x80);
                    }
                    if (this.vSyncInt <= 0 || --this.vSyncInt != 0) break block15;
                    if (this.r52 < 32) break block16;
                    if (!cpc.getAsic().getRaster()) break block17;
                    if (CPC.memory.plus) break block16;
                }
                this.setInterruptMask(this.interruptMask | 0x80);
            }
            this.r52 = 0;
        }
        this.renderer = this.vSyncCount > 0 ? this.syncRenderer : (this.crtc.isVDisp() && this.crtc.isHDisp() ? this.defRenderer : this.borderRenderer);
    }

    @Override
    public void hDispEnd() {
        this.renderer = this.vSyncCount > 0 || this.crtc.isHSync() ? this.syncRenderer : this.borderRenderer;
    }

    @Override
    public void hDispStart() {
        this.renderer = this.vSyncCount > 0 || this.crtc.isHSync() ? this.syncRenderer : (this.crtc.isVDisp() ? this.defRenderer : this.borderRenderer);
    }

    @Override
    public void vSyncStart() {
        super.vSyncStart();
        this.vSyncCount = 25;
        this.renderer = this.syncRenderer;
        this.vSyncInt = 2;
    }

    @Override
    public void vSyncEnd() {
    }

    public void renderSprites(int monitorline) {
        if (this.spritemem == null) {
            this.spritemem = (CPCMemory)cpc.getMemory();
        }
        for (int i = 15; i > -1; --i) {
            this.spritemem.setMag(i);
            this.oldline[i] = monitorline;
            this.xm[i] = this.spritemem.getXM(i);
            this.ym[i] = this.spritemem.getYM(i);
            this.skipsprite = false;
            if (this.sprite[i] == null) {
                this.skipsprite = true;
            }
            if (this.xm[i] == 0 || this.ym[i] == 0) {
                this.skipsprite = true;
            }
            if (this.skipsprite) continue;
            this.xpos[i] = this.spritemem.getSpriteX(i) + this.xmin;
            this.ypos[i] = this.spritemem.getSpriteY(i) + this.ymin;
            if (this.skipsprite) continue;
            this.spriteoffset = this.xpos[i];
            this.spriteoffset += 768 * this.ypos[i];
            this.spos = 0;
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    if (this.sprite[i][this.spos] != -123456789) {
                        for (int cubex = 0; cubex < this.xm[i]; ++cubex) {
                            for (int cubey = 0; cubey < this.ym[i]; ++cubey) {
                                this.sproffset = this.spriteoffset + cubex + 768 * cubey * 2;
                                if (this.sproffset >= this.pixels.length || this.sproffset < 0 || this.isBorder[this.sproffset]) continue;
                                this.pixels[this.sproffset] = this.sprite[i][this.spos];
                            }
                        }
                    }
                    ++this.spos;
                    this.spriteoffset += this.xm[i];
                }
                this.spriteoffset -= 16 * this.xm[i];
                this.spriteoffset += 1536 * this.ym[i];
            }
        }
    }

    @Override
    public void vSync(boolean interlace) {
        this.borderHeight = 35 - Basic6845.getR(7) << 3;
        this.borderHeight *= 2;
        if (this.borderHeight > 400) {
            this.borderHeight = 0;
        }
        this.ymin = this.borderHeight;
        this.ymax = 558 - this.ymin;
        this.xmin = (50 - Basic6845.getR(2)) * 16;
        this.r3 = Basic6845.getR(3) & 0xF;
        if (this.r3 < 6) {
            this.xmin += this.r3 * 8;
        }
        this.r3 = Basic6845.getR(0) - 63;
        this.xmin = this.r3 > 0 ? (this.xmin += this.r3 * 32) : (this.xmin += this.r3 * 16);
        this.xmax = this.xmin + Basic6845.getR(1) * 16;
        try {
            if (this.spritemem == null) {
                this.spritemem = (CPCMemory)cpc.getMemory();
            }
            for (int i = 0; i < 16; ++i) {
                this.sprite[i] = this.spritemem.getSprite(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.offset = 0;
        this.scanStart = 0;
        cpc.vSync();
    }

    @Override
    public void vSync() {
        this.scanStart = 0;
        try {
            cpc.vSync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void vDispStart() {
    }

    public void setMemory(byte[] value) {
        screenmemory = value;
    }

    public void setRendering(boolean value) {
        this.rendering = value;
        if (!this.rendering) {
            this.scanStarted = false;
            this.render = false;
        }
    }

    public Dimension getDisplaySize(boolean large) {
        return large ? this.FULL_DISPLAY_SIZE : this.HALF_DISPLAY_SIZE;
    }

    @Override
    public void cursor() {
    }

    public static void resetInks() {
        int i;
        for (i = 0; i < 33; ++i) {
            GateArray.inks[i] = !use3d ? -14671840 : -16777216;
        }
        for (i = 0; i < 17; ++i) {
            GateArray.setInk(i, GateArray.getInks(i));
        }
    }

    public static void resetInkss() {
        for (int i = 0; i < 17; ++i) {
            GateArray.setInk(i, i);
        }
    }

    public void init() {
        this.crtc.init();
    }

    @Override
    public int PEEK(int address) {
        return CPC.PEEK(address);
    }

    @Override
    public void POKE(int address, int value) {
        CPC.POKE(address, value);
    }

    public static int putRGB(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    @Override
    public boolean getOut() {
        return this.endPix != 0;
    }

    @Override
    public int getLineNumber() {
        return this.crtc.getLineNumber();
    }

    static /* synthetic */ int[] access$302(GateArray x0, int[] x1) {
        x0.pixels = x1;
        return x1;
    }

    static /* synthetic */ int[] access$702(GateArray x0, int[] x1) {
        x0.pixels = x1;
        return x1;
    }

    static {
        inks = new int[33];
        maTranslate = new int[65536];
        CPCInks = new int[33];
        CPCInksb = new int[33];
        GAInks = new int[]{13, 27, 19, 25, 1, 7, 10, 16, 28, 29, 24, 26, 6, 8, 15, 17, 30, 31, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
        palette = new int[]{13, 13, 19, 25, 1, 7, 10, 16, 7, 25, 24, 26, 6, 8, 15, 17, 1, 19, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
        Inks = new int[]{20, 4, 21, 28, 24, 29, 12, 5, 13, 22, 6, 23, 30, 0, 31, 14, 7, 15, 18, 2, 19, 26, 25, 27, 10, 3, 11, 1, 8, 9, 16, 17};
        luminancePLUS = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
        inkTranslateColor = new int[]{0x636363, 0x636363, 65379, 0xFFFF63, 99, 16711779, 25443, 0xFF6363, 16711779, 0xFFFF63, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16737024, 0xFF63FF, 99, 65379, 65280, 65535, 0, 255, 25344, 25599, 0x630063, 0x63FF63, 6553344, 0x63FFFF, 0x630000, 6488319, 0x636300, 0x6363FF};
        original = new int[]{0x636363, 0x636363, 65379, 0xFFFF63, 99, 16711779, 25443, 0xFF6363, 16711779, 0xFFFF63, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16737024, 0xFF63FF, 99, 65379, 65280, 65535, 0, 255, 25344, 25599, 0x630063, 0x63FF63, 6553344, 0x63FFFF, 0x630000, 6488319, 0x636300, 0x6363FF};
        inkTranslateGrim = new int[]{0x677867, 0x677867, 1046648, 16316517, 133200, 15669359, 553063, 16288111, 15669359, 16316517, 16316449, 0xF7F8F8, 15212307, 0xF818F8, 16289543, 0xF889F8, 133200, 1046648, 1177614, 0x28F8F8, 1798, 659672, 552712, 1015544, 5705561, 7927920, 8452108, 7993592, 5312264, 6296040, 6780935, 7307256};
        inkTranslateGrim2 = new int[]{7241067, 7241067, 62315, 15987565, 619, 15729256, 30824, 15957355, 15729256, 15987565, 15987469, 0xFFF3F9, 15926534, 15926004, 15957261, 16417017, 619, 62315, 192513, 1045490, 513, 787188, 161793, 818164, 6881896, 7467883, 7468292, 7468020, 7078401, 7078642, 7240449, 7240694};
        inkTranslateCPCe = new int[]{0x6D6D55, 0x6D6D55, 65365, 0xFFFF55, 85, 0xFF0055, 27989, 16739669, 0xFF0055, 0xFFFF55, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16739584, 0xFF6DFF, 85, 65365, 65280, 65535, 0, 255, 27904, 28159, 7143509, 7208789, 7208704, 0x6DFFFF, 0x6D0000, 7143679, 0x6D6D00, 0x6D6DFF};
        inkTranslate3d = new int[]{0x959895, 0x959895, 2162569, 0xFFFF89, 2105481, 16720009, 2136213, 16750741, 16720009, 0xFFFF89, 0xFFFF20, 0xFEFEFE, 0xFF2020, 0xFF20FF, 16749856, 0xFF95FF, 2105481, 2162569, 0x20FF20, 0x20FFFF, 0x202020, 0x2020FF, 2135328, 2135551, 9773193, 9830281, 9830176, 0x95FFFF, 9773088, 9773311, 9803040, 0x9595FF};
        inkTranslateLinear = new int[]{0x7D7D7D, 0x7D7D7D, 65405, 0xFFFF7D, 125, 16711805, 32125, 0xFF7D7D, 16711805, 0xFFFF7D, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16743680, 0xFF7DFF, 125, 65405, 65280, 65535, 0, 255, 32000, 32255, 0x7D007D, 0x7DFF7D, 8257280, 0x7DFFFF, 0x7D0000, 8192255, 0x7D7D00, 0x7D7DFF};
        green = new int[]{1333263, 1465361, 1728789, 1860631, 1992729, 2256157, 2585633, 2717475, 2980903, 3376428, 3574063, 3837747, 3969845, 4233016, 4430907, 4760640, 4958018, 5155909, 0x54B44B, 5749070, 6012497, 6144339, 6342230, 6605657, 6869341, 6935134, 7001183, 4167223, 2717475, 7133025, 1465362, 5814862};
        inkTranslateGreen = new int[]{32000, 32000, 46336, 61184, 2560, 17152, 24576, 39168, 17152, 61184, 58624, 63488, 14592, 19456, 36864, 41728, 40960, 46336, 44032, 48896, 0, 4864, 22272, 27136, 9728, 53760, 51456, 56320, 7424, 12288, 29440, 34304};
        inkTranslateGrey = new int[]{0x7D8D7D, 0x7D8D7D, 0xB5C5B5, 0xEFFFEF, 662026, 0x435343, 0x607060, 0x99A999, 0x435343, 0xEFFFEF, 0xE5F5E5, 0xF8FFF8, 0x394939, 0x4C5C4C, 0x90A090, 0xA3B3A3, 0xA0B0A0, 0xB5C5B5, 0xACBCAC, 0xBFCFBF, 4096, 0x132313, 0x576757, 0x6A7A6A, 0x263626, 0xD2E2D2, 0xC9D9C9, 0xDCECDC, 0x1D2D1D, 0x304030, 0x738373, 0x869686};
        inkTranslateBW = new int[]{0x7D7D7D, 0x7D7D7D, 0xB5B5B5, 0xEFEFEF, 657930, 0x434343, 0x606060, 0x999999, 0x434343, 0xEFEFEF, 0xE5E5E5, 0xF8F8F8, 0x393939, 0x4C4C4C, 0x909090, 0xA3A3A3, 0xA0A0A0, 0xB5B5B5, 0xACACAC, 0xBFBFBF, 0, 0x131313, 0x575757, 0x6A6A6A, 0x262626, 0xD2D2D2, 0xC9C9C9, 0xDCDCDC, 0x1D1D1D, 0x303030, 0x737373, 0x868686};
        fullMaps = new byte[4][];
        halfMaps = new byte[4][];
        requestink = new int[17];
        for (int mode = 0; mode < 4; ++mode) {
            byte[] full = new byte[0x100000];
            byte[] half = new byte[524288];
            GateArray.fullMaps[mode] = full;
            GateArray.halfMaps[mode] = half;
            for (int i = 0; i < 524288; i += 4) {
                int b1 = i >> 3 & 0xFF;
                int b2 = i >> 11 & 0xFF;
                decoder.decodeHalf(half, i, mode, b1);
                decoder.decodeFull(full, i * 2, mode, b1);
                decoder.decodeHalf(half, i += 4, mode, b2);
                decoder.decodeFull(full, i * 2, mode, b2);
            }
        }
        for (int i = 0; i < maTranslate.length; ++i) {
            int j = i << 1;
            GateArray.maTranslate[i] = j & 0x7FE | (j & 0x6000) << 1;
        }
    }

    protected class FullEndRenderer
    extends Renderer {
        protected FullEndRenderer() {
        }

        @Override
        public void render() {
            if (screenmemory == null) {
                return;
            }
            try {
                int delay = 0;
                if (GateArray.this.renderer == GateArray.this.borderRenderer) {
                    int pix = inks[16];
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        if (++delay == 8) {
                            GateArray.this.updateInks(true);
                        }
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = pix;
                    }
                } else if (GateArray.this.renderer == GateArray.this.defRenderer) {
                    int addr = maTranslate[GateArray.this.crtc.getMA()] + ((GateArray.this.crtc.getRA() & 7) << 11);
                    int val = ((screenmemory[addr] & 0xFF) << 4) + ((screenmemory[addr + 1] & 0xFF) << 12);
                    delay = 0;
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        if (++delay == 8) {
                            GateArray.this.updateInks(true);
                        }
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = inks[GateArray.this.fullMap[val++]];
                    }
                } else {
                    int pix = inks[32];
                    delay = 0;
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        if (++delay == 8) {
                            GateArray.this.updateInks(true);
                        }
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = pix;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class FullStartRenderer
    extends Renderer {
        protected FullStartRenderer() {
        }

        @Override
        public void render() {
            if (screenmemory == null) {
                return;
            }
            try {
                GateArray.this.updateInks(true);
                int delay = 0;
                GateArray.this.endPix = 16 - (GateArray.this.hPos - 718848 >> 12 & 0xF);
                if (GateArray.this.renderer == GateArray.this.borderRenderer) {
                    int pix = inks[16];
                    delay = 0;
                    for (int i = GateArray.this.endPix; i < 16; ++i) {
                        if (delay++ == 8) {
                            GateArray.this.updateInks(true);
                        }
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = pix;
                    }
                } else if (GateArray.this.renderer == GateArray.this.defRenderer) {
                    int addr = maTranslate[GateArray.this.crtc.getMA()] + ((GateArray.this.crtc.getRA() & 7) << 11);
                    int val = ((screenmemory[addr] & 0xFF) << 4) + ((screenmemory[addr + 1] & 0xFF) << 12) + GateArray.this.endPix;
                    delay = 0;
                    for (int i = GateArray.this.endPix; i < 16; ++i) {
                        if (delay++ == 8) {
                            GateArray.this.updateInks(true);
                        }
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = inks[GateArray.this.fullMap[val++]];
                    }
                } else {
                    int pix = inks[32];
                    delay = 0;
                    for (int i = GateArray.this.endPix; i < 16; ++i) {
                        if (delay++ == 8) {
                            GateArray.this.updateInks(true);
                        }
                        GateArray.this.isBorder[GateArray.this.offset] = true;
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = pix;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class HalfEndRenderer
    extends Renderer {
        protected HalfEndRenderer() {
        }

        @Override
        public void render() {
            if (screenmemory == null) {
                return;
            }
            try {
                if (GateArray.this.renderer == GateArray.this.borderRenderer) {
                    int pix = inks[16];
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        try {
                            ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = pix;
                            continue;
                        }
                        catch (Exception ef) {
                            // empty catch block
                        }
                    }
                } else if (GateArray.this.renderer == GateArray.this.defRenderer) {
                    int addr = maTranslate[GateArray.this.crtc.getMA()] + ((GateArray.this.crtc.getRA() & 7) << 11);
                    int val = ((screenmemory[addr] & 0xFF) << 3) + ((screenmemory[addr + 1] & 0xFF) << 11);
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = inks[GateArray.this.halfMap[val++]];
                    }
                } else {
                    int pix = inks[32];
                    for (int i = 0; i < GateArray.this.endPix; ++i) {
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = pix;
                    }
                }
                GateArray.this.updateInks(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class HalfStartRenderer
    extends Renderer {
        protected HalfStartRenderer() {
        }

        @Override
        public void render() {
            if (screenmemory == null) {
                return;
            }
            try {
                GateArray.this.endPix = 8 - (GateArray.this.hPos - 718848 >> 13 & 7);
                if (GateArray.this.renderer == GateArray.this.borderRenderer) {
                    int pix = inks[16];
                    for (int i = GateArray.this.endPix; i < 8; ++i) {
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = pix;
                    }
                } else if (GateArray.this.renderer == GateArray.this.defRenderer) {
                    int addr = maTranslate[GateArray.this.crtc.getMA()] + ((GateArray.this.crtc.getRA() & 7) << 11);
                    int val = ((screenmemory[addr] & 0xFF) << 3) + ((screenmemory[addr + 1] & 0xFF) << 11) + GateArray.this.endPix;
                    for (int i = GateArray.this.endPix; i < 8; ++i) {
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = inks[GateArray.this.halfMap[val++]];
                    }
                } else {
                    int pix = inks[32];
                    for (int i = GateArray.this.endPix; i < 8; ++i) {
                        ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = pix;
                    }
                }
                GateArray.this.updateInks(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class FullRenderer
    extends Renderer {
        protected FullRenderer() {
        }

        @Override
        public void render() {
            if (screenmemory == null) {
                return;
            }
            if (GateArray.this.pixels.length < 417792) {
                GateArray.access$702(GateArray.this, new int[417792]);
            }
            try {
                int delay = 0;
                int addr = maTranslate[GateArray.this.crtc.getMA()] + ((GateArray.this.crtc.getRA() & 7) << 11);
                int val = ((screenmemory[addr] & 0xFF) << 4) + ((screenmemory[addr + 1] & 0xFF) << 12);
                for (int i = 0; i < 16; ++i) {
                    if (delay++ == 8) {
                        GateArray.this.updateInks(true);
                    }
                    GateArray.this.isBorder[GateArray.this.offset] = false;
                    ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = inks[GateArray.this.fullMap[val++]];
                }
            }
            catch (Exception e) {
                JEMU.togglesize = true;
            }
        }
    }

    protected class HalfRenderer
    extends Renderer {
        protected HalfRenderer() {
        }

        @Override
        public void render() {
            if (screenmemory == null) {
                return;
            }
            if (GateArray.this.pixels.length > 208896) {
                GateArray.access$302(GateArray.this, new int[208896]);
            }
            try {
                int i;
                int addr = maTranslate[GateArray.this.crtc.getMA()] + ((GateArray.this.crtc.getRA() & 7) << 11);
                int val = ((screenmemory[addr] & 0xFF) << 3) + ((screenmemory[addr + 1] & 0xFF) << 11);
                for (i = 0; i < 4; ++i) {
                    ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = inks[GateArray.this.halfMap[val++]];
                }
                for (i = 0; i < 4; ++i) {
                    ((GateArray)GateArray.this).pixels[GateArray.this.offset++] = inks[GateArray.this.halfMap[val++]];
                }
                GateArray.this.updateInks(true);
            }
            catch (Exception e) {
                JEMU.togglesize = true;
            }
        }
    }

    protected class BorderRenderer
    extends Renderer {
        protected int ink;
        protected int width;

        public BorderRenderer(int ink, int width) {
            this.ink = ink;
            this.width = width;
        }

        @Override
        public void render() {
            if (GateArray.this.pixels == null) {
                return;
            }
            if (GateArray.this.isBorder == null || GateArray.this.isBorder.length < 1) {
                GateArray.this.isBorder = new boolean[417792];
            }
            int pix = inks[this.ink];
            try {
                for (int i = 0; i < this.width; ++i) {
                    ((GateArray)GateArray.this).pixels[GateArray.this.offset] = pix;
                    GateArray.this.isBorder[GateArray.this.offset] = true;
                    ++GateArray.this.offset;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract class Renderer {
        protected Renderer() {
        }

        public void render() {
        }
    }
}

