/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.border.SoftBevelBorder;
import jemu.core.Util;
import jemu.system.cpc.CPC;
import jemu.system.cpc.DOSHandler;
import jemu.system.cpc.GateArray;
import jemu.system.cpc.GraphicsDecoder;
import jemu.system.cpc.Palette;

public final class GraphicsViewer
extends JFrame
implements MouseListener,
MouseMotionListener {
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphicsViewer.this.Show();
        }
    };
    Timer fire = new Timer(25, this.update);
    protected boolean editable = true;
    BufferedImage[] screen;
    GraphicsDecoder decoder;
    public static int[] pixels;
    protected JPanel[] pan;
    protected JLabel[] img;
    protected int[] addresses;
    int width = 4;
    int height = 4;
    int mode = 1;
    int zoom = 4;
    int forcedzoom = 1;
    int panels = 0;
    protected int expaddress = 0;
    protected int expindex = 0;
    protected int expx = 0;
    protected int expad = 0;
    protected int gpen = 1;
    protected boolean linear = false;
    protected Color trans = new Color(0, 0, 255, 160);
    int range = 0;
    int to = 0;
    boolean rangeset = false;
    protected boolean[] isenabled;
    JComponent content;
    Palette pal;
    JFrame prev;
    int pzoom = 4;
    DOSHandler handler;
    protected byte[] hasdata;
    protected byte[] asmdata;
    boolean write;
    boolean autoupdate;
    boolean notPainted = false;
    BufferedImage buffer;
    boolean vertical = false;
    int scrollindex = 0;
    int cellcount = 0;
    private JTextField aaddress;
    private JTextField address;
    private JTextField baddress;
    private JCheckBox bin;
    private JCheckBox bin1;
    private Button button1;
    private Button button10;
    private Button button11;
    private Button button12;
    private Button button13;
    private Button button14;
    private Button button15;
    private Button button16;
    private Button button2;
    private Button button3;
    private Button button4;
    private Button button5;
    private Button button6;
    private Button button7;
    private Button button8;
    private Button button9;
    private ButtonGroup buttonGroup1;
    private JCheckBox grid;
    private JCheckBox header;
    private JCheckBox header1;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton14;
    private JButton jButton15;
    private JButton jButton16;
    private JButton jButton17;
    private JButton jButton18;
    private JButton jButton19;
    private JButton jButton2;
    private JButton jButton20;
    private JButton jButton21;
    private JButton jButton22;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JTextField jLabel3;
    private JTextField jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JSeparator jSeparator1;
    private JToggleButton jToggleButton1;
    private JCheckBox line;
    private JToggleButton paint;
    private JLabel preview;
    private JCheckBox rom;
    private JCheckBox skipscreen;
    private JCheckBox step;
    private JPanel viewPort;
    private JTextField zm;

    public void moveBack() {
        if (this.expindex > 0) {
            for (int i = 0; i < this.panels; ++i) {
                this.img[i].setEnabled(true);
            }
            --this.expindex;
            this.expaddress = this.addresses[this.expindex];
            this.aaddress.setText(Util.hex((short)this.addresses[this.expindex]));
            this.baddress.setText(Util.hex((short)this.addresses[this.expindex]));
            this.updateCell();
            this.updateScreen(this.screen[this.expindex]);
            if (this.rangeset) {
                this.checkRange();
            } else {
                this.img[this.expindex].setEnabled(false);
            }
        }
    }

    public void moveForward() {
        if (this.expindex < this.panels - 1) {
            for (int i = 0; i < this.panels; ++i) {
                this.img[i].setEnabled(true);
            }
            ++this.expindex;
            this.expaddress = this.addresses[this.expindex];
            this.aaddress.setText(Util.hex((short)this.addresses[this.expindex]));
            this.baddress.setText(Util.hex((short)this.addresses[this.expindex]));
            this.updateCell();
            this.updateScreen(this.screen[this.expindex]);
            if (this.rangeset) {
                this.checkRange();
            } else {
                this.img[this.expindex].setEnabled(false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.preview) {
            if (this.paint.isSelected() && this.editable) {
                this.PLOT();
            }
            return;
        }
        for (int i = 0; i < this.panels; ++i) {
            this.img[i].setEnabled(true);
            if (e.getSource() != this.img[i]) continue;
            if (e.getClickCount() == 2) {
                this.rangeset = false;
                if ((e.getModifiers() & 0x10) != 0) {
                    this.rangeset = false;
                    this.address.setText(Util.hex((short)this.addresses[i]));
                    this.expaddress = this.addresses[i];
                    this.scrollindex = this.expindex = 0;
                    this.Show();
                    continue;
                }
                this.rangeset = false;
                this.expaddress = this.addresses[i];
                this.scrollindex = this.expindex = i;
                this.savescreen(this.screen[i]);
                continue;
            }
            if ((e.getModifiers() & 0x10) != 0) {
                this.range = i;
                this.rangeset = false;
                this.img[i].setEnabled(false);
                this.expaddress = this.addresses[i];
                this.scrollindex = this.expindex = i;
                this.updateScreen(this.screen[this.expindex]);
                this.aaddress.setText(Util.hex((short)this.addresses[i]));
                this.baddress.setText(Util.hex((short)this.addresses[i]));
                continue;
            }
            this.rangeset = true;
            this.to = i;
            this.checkRange();
            break;
        }
    }

    public void checkRange() {
        int f;
        if (!this.rangeset) {
            return;
        }
        for (f = 0; f < this.panels; ++f) {
            this.img[f].setEnabled(true);
        }
        if (this.range > this.to) {
            for (f = this.to; f <= this.range; ++f) {
                this.img[f].setEnabled(false);
            }
        } else if (this.range < this.to) {
            for (f = this.to; f >= this.range; --f) {
                this.img[f].setEnabled(false);
            }
        } else {
            this.rangeset = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.preview) {
            this.editable = true;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this.preview) {
            this.editable = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.preview) {
            if (this.rangeset) {
                this.checkRange();
            } else {
                this.img[this.expindex].setEnabled(false);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    public void setPalette() {
        if (this.isenabled == null) {
            this.isenabled = new boolean[16];
        }
        for (int i = 0; i < 16; ++i) {
            this.isenabled[i] = true;
            if ((this.mode == 1 || this.mode == 3) && i > 3) {
                this.isenabled[i] = false;
            }
            if (this.mode != 2 || i <= 1) continue;
            this.isenabled[i] = false;
        }
        this.button1.setVisible(this.isenabled[0]);
        this.button2.setVisible(this.isenabled[1]);
        this.button3.setVisible(this.isenabled[2]);
        this.button4.setVisible(this.isenabled[3]);
        this.button5.setVisible(this.isenabled[4]);
        this.button6.setVisible(this.isenabled[5]);
        this.button7.setVisible(this.isenabled[6]);
        this.button8.setVisible(this.isenabled[7]);
        this.button9.setVisible(this.isenabled[8]);
        this.button10.setVisible(this.isenabled[9]);
        this.button11.setVisible(this.isenabled[10]);
        this.button12.setVisible(this.isenabled[11]);
        this.button13.setVisible(this.isenabled[12]);
        this.button14.setVisible(this.isenabled[13]);
        this.button15.setVisible(this.isenabled[14]);
        this.button16.setVisible(this.isenabled[15]);
        this.pal.jPanel1.setVisible(this.isenabled[0]);
        this.pal.jPanel2.setVisible(this.isenabled[1]);
        this.pal.jPanel3.setVisible(this.isenabled[2]);
        this.pal.jPanel4.setVisible(this.isenabled[3]);
        this.pal.jPanel5.setVisible(this.isenabled[4]);
        this.pal.jPanel6.setVisible(this.isenabled[5]);
        this.pal.jPanel7.setVisible(this.isenabled[6]);
        this.pal.jPanel8.setVisible(this.isenabled[7]);
        this.pal.jPanel9.setVisible(this.isenabled[8]);
        this.pal.jPanel10.setVisible(this.isenabled[9]);
        this.pal.jPanel11.setVisible(this.isenabled[10]);
        this.pal.jPanel12.setVisible(this.isenabled[11]);
        this.pal.jPanel13.setVisible(this.isenabled[12]);
        this.pal.jPanel14.setVisible(this.isenabled[13]);
        this.pal.jPanel15.setVisible(this.isenabled[14]);
        this.pal.jPanel16.setVisible(this.isenabled[15]);
        try {
            this.prev.repaint();
            this.prev.pack();
        }
        catch (Exception e) {
            // empty catch block
        }
        block21: for (int i = 0; i < 16; ++i) {
            Color col = CPC.getCol(i);
            switch (i) {
                case 0: {
                    this.button1.setBackground(col);
                    this.pal.panel1.setBackground(col);
                    continue block21;
                }
                case 1: {
                    this.button2.setBackground(col);
                    this.pal.panel2.setBackground(col);
                    continue block21;
                }
                case 2: {
                    this.button3.setBackground(col);
                    this.pal.panel3.setBackground(col);
                    continue block21;
                }
                case 3: {
                    this.button4.setBackground(col);
                    this.pal.panel4.setBackground(col);
                    continue block21;
                }
                case 4: {
                    this.button5.setBackground(col);
                    this.pal.panel5.setBackground(col);
                    continue block21;
                }
                case 5: {
                    this.button6.setBackground(col);
                    this.pal.panel6.setBackground(col);
                    continue block21;
                }
                case 6: {
                    this.button7.setBackground(col);
                    this.pal.panel7.setBackground(col);
                    continue block21;
                }
                case 7: {
                    this.button8.setBackground(col);
                    this.pal.panel8.setBackground(col);
                    continue block21;
                }
                case 8: {
                    this.button9.setBackground(col);
                    this.pal.panel9.setBackground(col);
                    continue block21;
                }
                case 9: {
                    this.button10.setBackground(col);
                    this.pal.panel10.setBackground(col);
                    continue block21;
                }
                case 10: {
                    this.button11.setBackground(col);
                    this.pal.panel11.setBackground(col);
                    continue block21;
                }
                case 11: {
                    this.button12.setBackground(col);
                    this.pal.panel12.setBackground(col);
                    continue block21;
                }
                case 12: {
                    this.button13.setBackground(col);
                    this.pal.panel13.setBackground(col);
                    continue block21;
                }
                case 13: {
                    this.button14.setBackground(col);
                    this.pal.panel14.setBackground(col);
                    continue block21;
                }
                case 14: {
                    this.button15.setBackground(col);
                    this.pal.panel15.setBackground(col);
                    continue block21;
                }
                case 15: {
                    this.button16.setBackground(col);
                    this.pal.panel16.setBackground(col);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this.preview) {
            try {
                int x = e.getX() / this.pzoom / 8;
                int cx = e.getX() / this.pzoom;
                int y = e.getY() / (this.pzoom * 2);
                ++y;
                ++x;
                if (this.mode == 1) {
                    cx /= 2;
                }
                if (this.mode == 0) {
                    cx /= 4;
                }
                int a = this.addresses[this.expindex] + (x * y - 1);
                this.aaddress.setText(Util.hex((short)a));
                this.baddress.setText(Util.hex((short)a));
                this.expad = this.addresses[this.expindex] + (x - 1) + this.preview.getWidth() / (this.pzoom * 8) * (y - 1);
                this.expx = cx;
            }
            catch (Exception c) {
                // empty catch block
            }
            return;
        }
        for (int i = 0; i < this.panels; ++i) {
            if (e.getSource() != this.img[i]) continue;
            int x = e.getX() / 8;
            int y = e.getY() / 2;
            int a = this.addresses[i] + (++x * ++y - 1);
            this.aaddress.setText(Util.hex((short)a));
            this.baddress.setText(Util.hex((short)a));
            break;
        }
    }

    public byte[] exportBin() {
        int x = this.screen[this.expindex].getWidth() / 8 / this.zoom / this.forcedzoom;
        int y = this.screen[this.expindex].getHeight() / 2 / this.zoom / this.forcedzoom;
        int size = x * y;
        byte[] data = new byte[size];
        if (this.write) {
            System.arraycopy(GateArray.screenmemory, this.expaddress, data, 0, size);
        } else {
            for (int i = 0; i < size; ++i) {
                data[i] = (byte)CPC.memory.readByte(this.expaddress + i);
            }
        }
        System.arraycopy(GateArray.screenmemory, this.expaddress, data, 0, size);
        return data;
    }

    public byte[] exportRange() {
        int f;
        int x = 0;
        int y = 0;
        int size = 0;
        boolean off = false;
        int divider = 0;
        if (this.range > this.to) {
            this.expaddress = this.addresses[this.to];
            for (f = this.to; f <= this.range; ++f) {
                x += this.screen[f].getWidth() / 8 / this.zoom / this.forcedzoom;
                y += this.screen[f].getHeight() / 2 / this.zoom / this.forcedzoom;
                ++divider;
            }
        } else {
            this.expaddress = this.addresses[this.range];
            for (f = this.to; f >= this.range; --f) {
                x += this.screen[f].getWidth() / 8 / this.zoom / this.forcedzoom;
                y += this.screen[f].getHeight() / 2 / this.zoom / this.forcedzoom;
                ++divider;
            }
        }
        size = x * y / divider;
        byte[] data = new byte[size];
        if (this.write) {
            System.arraycopy(GateArray.screenmemory, this.expaddress, data, 0, size);
        } else {
            for (int i = 0; i < size; ++i) {
                data[i] = (byte)CPC.memory.readByte(this.expaddress + i);
            }
        }
        return data;
    }

    public void PLOT() {
        this.PLOT(this.expx, this.mode, this.expad);
    }

    public void PLOT(int x, int mode, int scraddr) {
        CPC.PLOT(this.linear, x, this.gpen, mode, scraddr);
        this.updateCell();
        this.updateScreen(this.screen[this.expindex]);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this.preview) {
            if (this.paint.isSelected() && this.editable) {
                try {
                    int x = e.getX() / this.pzoom / 8;
                    int cx = e.getX() / this.pzoom;
                    int y = e.getY() / (this.pzoom * 2);
                    ++y;
                    ++x;
                    if (this.mode == 1) {
                        cx /= 2;
                    }
                    if (this.mode == 0) {
                        cx /= 4;
                    }
                    int a = this.addresses[this.expindex] + (x * y - 1);
                    this.aaddress.setText(Util.hex((short)a));
                    this.baddress.setText(Util.hex((short)a));
                    this.expad = this.addresses[this.expindex] + (x - 1) + this.preview.getWidth() / (this.pzoom * 8) * (y - 1);
                    this.expx = cx;
                    this.PLOT();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public JComponent getPanel() {
        this.content = this.getRootPane();
        return this.content;
    }

    public GraphicsViewer() {
        this.decoder = new GraphicsDecoder();
        this.initComponents();
        this.pal = new Palette();
        this.jPanel2.add(this.pal);
        this.jPanel2.add(this.jButton19);
        this.jPanel2.add(this.jButton18);
        this.viewPort.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                GraphicsViewer.this.formMouseWheelMoved(evt);
            }
        });
        this.Show();
    }

    private void formMouseWheelMoved(MouseWheelEvent evt) {
        if (this.pan == null || this.pan[0] == null || this.pan[0].getWidth() < 1) {
            return;
        }
        try {
            int capture = Util.hexValue(this.address.getText());
            if (evt.getUnitsToScroll() > 0) {
                int endcapture = capture + this.screen[0].getWidth() / 8 / this.zoom / this.forcedzoom * this.cellcount * (this.screen[0].getHeight() / 2 / this.zoom / this.forcedzoom);
                this.address.setText(Util.hex((short)(endcapture &= 0xFFFF)));
                this.Show();
            } else if (evt.getUnitsToScroll() < 0) {
                int endcapture = capture - this.screen[0].getWidth() / 8 / this.zoom / this.forcedzoom * this.cellcount * (this.screen[0].getHeight() / 2 / this.zoom / this.forcedzoom);
                this.address.setText(Util.hex((short)(endcapture &= 0xFFFF)));
                this.Show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateScreen(BufferedImage ima) {
        int z = this.pzoom;
        int w = ima.getWidth() * z;
        int h = ima.getHeight() * z;
        w /= this.zoom;
        h /= this.zoom;
        if (this.buffer == null || this.buffer.getWidth() != (w /= this.forcedzoom) || this.buffer.getHeight() != (h /= this.forcedzoom)) {
            this.buffer = new BufferedImage(w, h, 1);
        }
        this.buffer.getGraphics().drawImage(ima, 0, 0, w, h, null);
        this.preview.setIcon(new ImageIcon(this.buffer));
    }

    public void savescreen(BufferedImage ima) {
        if (this.prev == null) {
            this.prev = new JFrame("Edit cell");
            this.prev.setLayout(new BorderLayout());
            this.prev.add((Component)this.jPanel1, "Center");
            this.prev.setResizable(false);
            this.prev.setDefaultCloseOperation(1);
        }
        int w = ima.getWidth();
        int h = ima.getHeight();
        w /= this.forcedzoom;
        h /= this.forcedzoom;
        w /= this.zoom;
        h /= this.zoom;
        this.buffer = new BufferedImage(w *= this.pzoom, h *= this.pzoom, 1);
        this.buffer.getGraphics().drawImage(ima, 0, 0, w, h, null);
        this.preview.setIcon(new ImageIcon(this.buffer));
        this.preview.addMouseListener(this);
        this.preview.addMouseMotionListener(this);
        this.prev.pack();
        this.prev.setAlwaysOnTop(true);
        this.prev.setVisible(true);
    }

    public void copy() {
        this.hasdata = this.rangeset ? this.exportRange() : this.exportBin();
    }

    public void paste() {
        if (this.hasdata == null) {
            return;
        }
        try {
            System.arraycopy(this.hasdata, 0, GateArray.screenmemory, this.expaddress, this.hasdata.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Show();
    }

    public void exportASM() {
        String islinear = "";
        if (this.linear) {
            islinear = "_linear";
        }
        String output = "        ;;'";
        int g = this.expaddress;
        if (this.rangeset) {
            if (this.range > this.to) {
                output = output + "range_" + Util.hex((short)this.addresses[this.to]) + "-" + Util.hex((short)this.addresses[this.range]) + islinear;
                g = this.addresses[this.to];
            } else {
                output = output + "range_" + Util.hex((short)this.addresses[this.range]) + "-" + Util.hex((short)this.addresses[this.to]) + islinear;
                g = this.addresses[this.range];
            }
        } else {
            output = output + "cell_" + Util.hex((short)this.expaddress) + islinear;
        }
        output = output + "\r\n        ;; width:" + this.width + " - height:" + this.height;
        output = output + "\r\n\r\n        ORG     &";
        if (this.rangeset) {
            output = this.range > this.to ? output + Util.hex((short)this.addresses[this.to]) : output + Util.hex((short)this.addresses[this.range]);
            this.asmdata = this.exportRange();
        } else {
            output = output + Util.hex((short)this.expaddress);
            this.asmdata = this.exportBin();
        }
        output = output + "\r\n\r\n.sprite" + islinear + "_" + Util.hex((short)g) + "\r\n";
        int h = 0;
        for (int i = 0; i < this.asmdata.length; i += this.width) {
            output = output + "        DB      ";
            for (int j = 0; j < this.width; ++j) {
                try {
                    output = output + "&" + Util.hex(this.asmdata[i + j]);
                    ++g;
                    if (j >= this.width - 1) continue;
                    output = output + ",";
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            output = output + "\r\n";
            if (++h < this.height || i >= this.asmdata.length - this.width) continue;
            output = output + "\r\n.sprite" + islinear + "_" + Util.hex((short)g) + "\r\n";
            h = 0;
        }
        try {
            File file = this.rangeset ? (this.range > this.to ? new File("range_" + Util.hex((short)this.addresses[this.to]) + "-" + Util.hex((short)this.addresses[this.range]) + islinear + ".asm") : new File("range_" + Util.hex((short)this.addresses[this.range]) + "-" + Util.hex((short)this.addresses[this.to]) + islinear + ".asm")) : new File("cell_" + Util.hex((short)this.expaddress) + islinear + ".asm");
            byte[] content1 = output.getBytes("UTF-8");
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bos.write(content1);
            bos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void export() {
        if (this.handler == null) {
            this.handler = new DOSHandler();
        }
        try {
            String islinear = "";
            if (this.linear) {
                islinear = "_linear";
            }
            if (this.bin.isSelected()) {
                File file = this.rangeset ? (this.range > this.to ? new File("range_" + Util.hex((short)this.addresses[this.to]) + "-" + Util.hex((short)this.addresses[this.range]) + islinear + ".bin") : new File("range_" + Util.hex((short)this.addresses[this.range]) + "-" + Util.hex((short)this.addresses[this.to]) + islinear + ".bin")) : new File("cell_" + Util.hex((short)this.expaddress) + islinear + ".bin");
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                byte[] data = null;
                data = this.rangeset ? this.exportRange() : this.exportBin();
                if (this.header.isSelected()) {
                    data = this.rangeset ? this.handler.makeHeader(data, this.expaddress, data.length, "RANGEDUMP") : this.handler.makeHeader(data, this.expaddress, data.length, "CELLDUMP");
                }
                bos.write(data);
                bos.close();
            } else if (this.rangeset) {
                BufferedImage out = null;
                if (this.range > this.to) {
                    int frames = this.range - this.to + 1;
                    File file = new File("range_" + Util.hex((short)this.addresses[this.to]) + "-" + Util.hex((short)this.addresses[this.range]) + islinear + ".png");
                    System.out.println("Case 1:Frames found: " + frames);
                    out = new BufferedImage(this.screen[0].getWidth() * frames, this.screen[0].getHeight(), 4);
                    int len = this.screen[0].getWidth();
                    int pos = 0;
                    for (int f = this.to; f < this.to + frames; ++f) {
                        out.getGraphics().drawImage(this.screen[f], pos, 0, null);
                        pos += len;
                    }
                    ImageIO.write((RenderedImage)out, "png", file);
                } else if (this.range < this.to) {
                    int frames = this.to - this.range + 1;
                    File file = new File("range_" + Util.hex((short)this.addresses[this.range]) + "-" + Util.hex((short)this.addresses[this.to]) + islinear + ".png");
                    System.out.println("Case 2:Frames found: " + frames);
                    out = new BufferedImage(this.screen[0].getWidth() * frames, this.screen[0].getHeight(), 4);
                    int len = this.screen[0].getWidth();
                    int pos = 0;
                    for (int f = this.range; f < this.range + frames; ++f) {
                        out.getGraphics().drawImage(this.screen[f], pos, 0, null);
                        pos += len;
                    }
                    ImageIO.write((RenderedImage)out, "png", file);
                }
            } else {
                File file = new File("cell_" + Util.hex((short)this.expaddress) + islinear + ".png");
                ImageIO.write((RenderedImage)this.screen[this.expindex], "png", file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Show() {
        if (this.notPainted) {
            return;
        }
        this.notPainted = true;
        this.write = !this.rom.isSelected();
        int rw = this.width * 8;
        int rh = this.height * 2;
        int insets = 1;
        if (!this.grid.isSelected()) {
            insets = 0;
        }
        int x = this.viewPort.getWidth();
        int y = this.viewPort.getHeight();
        int xPanels = x / (rw + insets);
        int yPanels = y / (rh + insets);
        this.panels = yPanels / this.zoom * (xPanels / this.zoom);
        if (this.panels < 1) {
            this.panels = 1;
        }
        this.forcedzoom = this.panels / 600;
        if (this.forcedzoom < 1) {
            this.forcedzoom = 1;
        }
        this.panels /= this.forcedzoom;
        this.pan = new JPanel[this.panels];
        this.img = new JLabel[this.panels];
        this.addresses = new int[this.panels];
        this.screen = new BufferedImage[this.panels];
        for (int i = 0; i < this.panels; ++i) {
            this.pan[i] = new JPanel();
            this.pan[i].setLayout(new BorderLayout());
            this.img[i] = new JLabel();
            this.pan[i].add((Component)this.img[i], "Center");
            this.img[i].addMouseListener(this);
            this.img[i].addMouseMotionListener(this);
        }
        int adr = 0;
        try {
            adr = Util.hexValue(this.address.getText());
        }
        catch (Exception e) {
            return;
        }
        this.viewPort.removeAll();
        for (int cells = 0; cells < this.panels; ++cells) {
            this.addresses[cells] = adr;
            if (this.grid.isSelected()) {
                this.pan[cells].setBorder(BorderFactory.createLineBorder(Color.white, 1));
            } else {
                this.pan[cells].setBorder(null);
            }
            this.pan[cells].setPreferredSize(new Dimension(rw * this.zoom * this.forcedzoom + insets, rh * this.zoom * this.forcedzoom + insets));
            this.screen[cells] = new BufferedImage(rw, rh / 2, 1);
            int size = this.screen[cells].getWidth() * this.screen[cells].getHeight();
            pixels = new int[size];
            for (int g = 0; g < pixels.length; ++g) {
                GraphicsViewer.pixels[g] = -16777216;
            }
            try {
                int h;
                int[] v;
                int g;
                WritableRaster raster = this.screen[cells].getRaster();
                if (!this.linear) {
                    for (g = 0; g < size; g += 8) {
                        v = this.decoder.pixelcolor(adr, this.mode, !this.rom.isSelected());
                        for (h = 0; h < 8; ++h) {
                            GraphicsViewer.pixels[g + h] = this.skipscreen.isSelected() && adr > 49151 ? Color.darkGray.getRGB() : (adr < 65536 ? GateArray.inks[v[h]] : Color.lightGray.getRGB());
                        }
                        ++adr;
                    }
                } else {
                    for (g = 0; g < size; g += 8) {
                        v = this.decoder.pixellinear(adr, this.mode, !this.rom.isSelected());
                        for (h = 0; h < 8; ++h) {
                            GraphicsViewer.pixels[g + h] = this.skipscreen.isSelected() && adr > 49151 ? Color.darkGray.getRGB() : (adr < 65536 ? GateArray.inks[v[h]] : Color.lightGray.getRGB());
                        }
                        ++adr;
                    }
                }
                raster.setDataElements(0, 0, this.screen[cells].getWidth(), this.screen[cells].getHeight(), pixels);
                this.buffer = new BufferedImage(rw * this.zoom * this.forcedzoom, rh * this.zoom * this.forcedzoom, 1);
                this.buffer.getGraphics().drawImage(this.screen[cells], 0, 0, rw * this.zoom * this.forcedzoom, rh * this.zoom * this.forcedzoom, null);
                this.screen[cells] = new BufferedImage(this.buffer.getWidth(), this.buffer.getHeight(), 1);
                this.screen[cells].getGraphics().drawImage(this.buffer, 0, 0, null);
                this.img[cells].setIcon(new ImageIcon(this.buffer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (adr <= 65535) continue;
            adr = 0;
        }
        int v = this.pan[0].getPreferredSize().width + this.pan[0].getInsets().right;
        this.cellcount = this.viewPort.getWidth() / v;
        for (int cells = 0; cells < this.panels; ++cells) {
            this.viewPort.add(this.pan[cells]);
        }
        this.viewPort.repaint();
        this.viewPort.updateUI();
        if (this.content == null) {
            this.repaint();
        } else {
            this.content.repaint();
        }
        try {
            this.updateScreen(this.screen[this.expindex]);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setPalette();
        this.notPainted = false;
    }

    public void updateCell() {
        int adr = this.expaddress;
        int rw = this.width * 8;
        int rh = this.height * 2;
        this.screen[this.expindex] = new BufferedImage(rw, rh / 2, 1);
        int size = this.screen[this.expindex].getWidth() * this.screen[this.expindex].getHeight();
        pixels = new int[size];
        for (int g = 0; g < pixels.length; ++g) {
            GraphicsViewer.pixels[g] = -16777110;
        }
        try {
            WritableRaster raster = this.screen[this.expindex].getRaster();
            if (!this.linear) {
                for (int g = 0; g < size; g += 8) {
                    int[] v = this.decoder.pixelcolor(adr, this.mode, !this.rom.isSelected());
                    for (int h = 0; h < 8; ++h) {
                        GraphicsViewer.pixels[g + h] = this.skipscreen.isSelected() && adr > 49151 ? Color.darkGray.getRGB() : (adr < 65536 ? GateArray.inks[v[h]] : Color.lightGray.getRGB());
                    }
                    ++adr;
                }
            } else {
                for (int g = 0; g < size; g += 8) {
                    int[] v = this.decoder.pixellinear(adr, this.mode, !this.rom.isSelected());
                    for (int h = 0; h < 8; ++h) {
                        GraphicsViewer.pixels[g + h] = this.skipscreen.isSelected() && adr > 49151 ? Color.darkGray.getRGB() : (adr < 65536 ? GateArray.inks[v[h]] : Color.lightGray.getRGB());
                    }
                    ++adr;
                }
            }
            adr &= 0xFFFF;
            raster.setDataElements(0, 0, this.screen[this.expindex].getWidth(), this.screen[this.expindex].getHeight(), pixels);
            this.buffer = new BufferedImage(rw * this.zoom, rh * this.zoom, 1);
            this.buffer.getGraphics().drawImage(this.screen[this.expindex], 0, 0, rw * this.zoom, rh * this.zoom, null);
            this.screen[this.expindex] = new BufferedImage(this.buffer.getWidth(), this.buffer.getHeight(), 1);
            this.screen[this.expindex].getGraphics().drawImage(this.buffer, 0, 0, null);
            this.img[this.expindex].setIcon(new ImageIcon(this.buffer));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.img[this.expindex].setEnabled(true);
        this.setPalette();
    }

    private void initComponents() {
        this.jButton18 = new JButton();
        this.jPanel1 = new JPanel();
        this.jButton15 = new JButton();
        this.preview = new JLabel();
        this.jPanel3 = new JPanel();
        this.button1 = new Button();
        this.button2 = new Button();
        this.button3 = new Button();
        this.button4 = new Button();
        this.button5 = new Button();
        this.button6 = new Button();
        this.button7 = new Button();
        this.button8 = new Button();
        this.button9 = new Button();
        this.button10 = new Button();
        this.button11 = new Button();
        this.button12 = new Button();
        this.button13 = new Button();
        this.button14 = new Button();
        this.button15 = new Button();
        this.button16 = new Button();
        this.bin = new JCheckBox();
        this.header = new JCheckBox();
        this.jButton13 = new JButton();
        this.jButton14 = new JButton();
        this.jLabel9 = new JLabel();
        this.baddress = new JTextField();
        this.jLabel10 = new JLabel();
        this.jButton16 = new JButton();
        this.jLabel11 = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.paint = new JToggleButton();
        this.jButton12 = new JButton();
        this.jButton1 = new JButton();
        this.jButton17 = new JButton();
        this.jButton20 = new JButton();
        this.buttonGroup1 = new ButtonGroup();
        this.jButton19 = new JButton();
        this.viewPort = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.aaddress = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel3 = new JTextField();
        this.jButton3 = new JButton();
        this.jLabel5 = new JLabel();
        this.jButton5 = new JButton();
        this.jLabel4 = new JTextField();
        this.jButton4 = new JButton();
        this.jLabel7 = new JLabel();
        this.jButton10 = new JButton();
        this.zm = new JTextField();
        this.jButton11 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButton21 = new JButton();
        this.bin1 = new JCheckBox();
        this.header1 = new JCheckBox();
        this.jButton22 = new JButton();
        this.grid = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jButton8 = new JButton();
        this.address = new JTextField();
        this.jButton9 = new JButton();
        this.step = new JCheckBox();
        this.line = new JCheckBox();
        this.jButton6 = new JButton();
        this.jLabel6 = new JLabel();
        this.jButton7 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.rom = new JCheckBox();
        this.skipscreen = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jButton18.setText("Paste");
        this.jButton18.setFocusPainted(false);
        this.jButton18.setFocusable(false);
        this.jButton18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton18ActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButton15.setText("<");
        this.jButton15.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton15ActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setLayout(new FlowLayout(1, 1, 0));
        this.button1.setFont(new Font("Monospaced", 1, 11));
        this.button1.setLabel("00");
        this.button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button1);
        this.button2.setFont(new Font("Monospaced", 1, 11));
        this.button2.setLabel("01");
        this.button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button2);
        this.button3.setFont(new Font("Monospaced", 1, 11));
        this.button3.setLabel("02");
        this.button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button3ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button3);
        this.button4.setFont(new Font("Monospaced", 1, 11));
        this.button4.setLabel("03");
        this.button4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button4ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button4);
        this.button5.setFont(new Font("Monospaced", 1, 11));
        this.button5.setLabel("04");
        this.button5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button5ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button5);
        this.button6.setFont(new Font("Monospaced", 1, 11));
        this.button6.setLabel("05");
        this.button6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button6ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button6);
        this.button7.setFont(new Font("Monospaced", 1, 11));
        this.button7.setLabel("06");
        this.button7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button7ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button7);
        this.button8.setFont(new Font("Monospaced", 1, 11));
        this.button8.setLabel("07");
        this.button8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button8ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button8);
        this.button9.setFont(new Font("Monospaced", 1, 11));
        this.button9.setLabel("08");
        this.button9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button9ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button9);
        this.button10.setFont(new Font("Monospaced", 1, 11));
        this.button10.setLabel("09");
        this.button10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button10ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button10);
        this.button11.setFont(new Font("Monospaced", 1, 11));
        this.button11.setLabel("10");
        this.button11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button11ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button11);
        this.button12.setFont(new Font("Monospaced", 1, 11));
        this.button12.setLabel("11");
        this.button12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button12ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button12);
        this.button13.setFont(new Font("Monospaced", 1, 11));
        this.button13.setLabel("12");
        this.button13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button13ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button13);
        this.button14.setFont(new Font("Monospaced", 1, 11));
        this.button14.setLabel("13");
        this.button14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button14ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button14);
        this.button15.setFont(new Font("Monospaced", 1, 11));
        this.button15.setLabel("14");
        this.button15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button15ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button15);
        this.button16.setFont(new Font("Monospaced", 1, 11));
        this.button16.setLabel("15");
        this.button16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.button16ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.button16);
        this.bin.setText("BIN");
        this.bin.setFocusPainted(false);
        this.bin.setFocusable(false);
        this.bin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.binActionPerformed(evt);
            }
        });
        this.header.setText("Header");
        this.header.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.headerActionPerformed(evt);
            }
        });
        this.jButton13.setText("-");
        this.jButton13.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton13ActionPerformed(evt);
            }
        });
        this.jButton14.setText("+");
        this.jButton14.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton14ActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Zoom");
        this.baddress.setEditable(false);
        this.baddress.setText("0000");
        this.baddress.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel10.setText("Address:");
        this.jButton16.setText(">");
        this.jButton16.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton16ActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Cell:");
        this.buttonGroup1.add(this.jToggleButton1);
        this.jToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/mouse.gif")));
        this.jToggleButton1.setSelected(true);
        this.buttonGroup1.add(this.paint);
        this.paint.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/pixel.gif")));
        this.jButton12.setText("Export");
        this.jButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton12ActionPerformed(evt);
            }
        });
        this.jButton1.setText("Copy");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton17.setText("Paste");
        this.jButton17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton17ActionPerformed(evt);
            }
        });
        this.jButton20.setText("Export ASM");
        this.jButton20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton20ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton20).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.header)).addComponent(this.preview).addComponent(this.jPanel3, -2, 252, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton13, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton14, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.baddress, -2, 43, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jToggleButton1, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paint, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton17))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton13).addComponent(this.jButton14).addComponent(this.jLabel9).addComponent(this.baddress, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.jButton15).addComponent(this.jButton16).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preview).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 50, -2).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -2, 25, -2).addComponent(this.jButton17, -2, 25, -2)).addComponent(this.jToggleButton1, -2, 25, -2).addComponent(this.paint, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton12).addComponent(this.bin).addComponent(this.header)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton20).addContainerGap()));
        this.jButton19.setText("Copy");
        this.jButton19.setFocusPainted(false);
        this.jButton19.setFocusable(false);
        this.jButton19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton19ActionPerformed(evt);
            }
        });
        this.setTitle("JavaCPC GFXViewer");
        this.setMinimumSize(new Dimension(853, 524));
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent evt) {
                GraphicsViewer.this.formWindowStateChanged(evt);
            }
        });
        this.viewPort.setBorder(new SoftBevelBorder(1));
        this.viewPort.setMinimumSize(new Dimension(100, 100));
        this.viewPort.setLayout(new FlowLayout(1, 0, 0));
        this.jPanel2.setBorder(new SoftBevelBorder(0));
        this.jPanel2.setLayout(new FlowLayout(0));
        this.jLabel8.setText("Address:");
        this.jPanel2.add(this.jLabel8);
        this.aaddress.setColumns(4);
        this.aaddress.setEditable(false);
        this.aaddress.setHorizontalAlignment(2);
        this.aaddress.setText("429C");
        this.aaddress.setBorder(null);
        this.jPanel2.add(this.aaddress);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jLabel1.setText("Width:");
        this.jPanel4.add(this.jLabel1);
        this.jButton2.setFont(new Font("Monospaced", 1, 11));
        this.jButton2.setText("-");
        this.jButton2.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton2.setFocusPainted(false);
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton2);
        this.jLabel3.setColumns(3);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("4");
        this.jLabel3.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GraphicsViewer.this.jLabel3KeyReleased(evt);
            }
        });
        this.jPanel4.add(this.jLabel3);
        this.jButton3.setFont(new Font("Monospaced", 1, 11));
        this.jButton3.setText("+");
        this.jButton3.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton3.setFocusPainted(false);
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton3);
        this.jLabel5.setText("Height:");
        this.jPanel4.add(this.jLabel5);
        this.jButton5.setFont(new Font("Monospaced", 1, 11));
        this.jButton5.setText("-");
        this.jButton5.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton5.setFocusPainted(false);
        this.jButton5.setFocusable(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton5);
        this.jLabel4.setColumns(3);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("4");
        this.jLabel4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GraphicsViewer.this.jLabel4KeyReleased(evt);
            }
        });
        this.jPanel4.add(this.jLabel4);
        this.jButton4.setFont(new Font("Monospaced", 1, 11));
        this.jButton4.setText("+");
        this.jButton4.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton4.setFocusPainted(false);
        this.jButton4.setFocusable(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton4);
        this.jLabel7.setText("Zoom:");
        this.jPanel4.add(this.jLabel7);
        this.jButton10.setFont(new Font("Monospaced", 1, 11));
        this.jButton10.setText("-");
        this.jButton10.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton10.setFocusPainted(false);
        this.jButton10.setFocusable(false);
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton10ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton10);
        this.zm.setColumns(2);
        this.zm.setHorizontalAlignment(4);
        this.zm.setText("4");
        this.zm.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GraphicsViewer.this.zmKeyReleased(evt);
            }
        });
        this.jPanel4.add(this.zm);
        this.jButton11.setFont(new Font("Monospaced", 1, 11));
        this.jButton11.setText("+");
        this.jButton11.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton11.setFocusPainted(false);
        this.jButton11.setFocusable(false);
        this.jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton11ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton11);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setPreferredSize(new Dimension(4, 22));
        this.jPanel4.add(this.jSeparator1);
        this.jButton21.setText("Export");
        this.jButton21.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton21ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton21);
        this.bin1.setText("BIN");
        this.bin1.setFocusPainted(false);
        this.bin1.setFocusable(false);
        this.bin1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.bin1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.bin1);
        this.header1.setText("Header");
        this.header1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.header1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.header1);
        this.jButton22.setText("Export ASM");
        this.jButton22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton22ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton22);
        this.grid.setSelected(true);
        this.grid.setText("Grid");
        this.grid.setFocusPainted(false);
        this.grid.setFocusable(false);
        this.grid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.gridActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.grid);
        this.jPanel5.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel5.setLayout(new FlowLayout(0));
        this.jLabel2.setText("Address: (&)");
        this.jPanel5.add(this.jLabel2);
        this.jButton8.setFont(new Font("Monospaced", 1, 11));
        this.jButton8.setText("-");
        this.jButton8.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton8.setFocusPainted(false);
        this.jButton8.setFocusable(false);
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton8ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton8);
        this.address.setColumns(4);
        this.address.setHorizontalAlignment(4);
        this.address.setText("0000");
        this.address.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GraphicsViewer.this.addressKeyReleased(evt);
            }
        });
        this.jPanel5.add(this.address);
        this.jButton9.setFont(new Font("Monospaced", 1, 11));
        this.jButton9.setText("+");
        this.jButton9.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton9.setFocusPainted(false);
        this.jButton9.setFocusable(false);
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton9ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton9);
        this.step.setText("Step field");
        this.step.setFocusPainted(false);
        this.step.setFocusable(false);
        this.step.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.stepActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.step);
        this.line.setText("Step line");
        this.line.setFocusPainted(false);
        this.line.setFocusable(false);
        this.line.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.lineActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.line);
        this.jButton6.setText("Mode");
        this.jButton6.setFocusPainted(false);
        this.jButton6.setFocusable(false);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton6ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton6);
        this.jLabel6.setFont(new Font("Monospaced", 1, 11));
        this.jLabel6.setText("1");
        this.jPanel5.add(this.jLabel6);
        this.jButton7.setText("Get");
        this.jButton7.setFocusPainted(false);
        this.jButton7.setFocusable(false);
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jButton7ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton7);
        this.jCheckBox1.setText("Linear");
        this.jCheckBox1.setFocusPainted(false);
        this.jCheckBox1.setFocusable(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jCheckBox1);
        this.rom.setText("ROM");
        this.rom.setFocusPainted(false);
        this.rom.setFocusable(false);
        this.rom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.romActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.rom);
        this.skipscreen.setText("Skip screen ram");
        this.skipscreen.setFocusPainted(false);
        this.skipscreen.setFocusable(false);
        this.skipscreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.skipscreenActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.skipscreen);
        this.jCheckBox2.setText("Auto Update");
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicsViewer.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jCheckBox2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.viewPort, GroupLayout.Alignment.LEADING, -1, 833, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, 833, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, 833, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, 833, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewPort, -1, 380, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.width > 1) {
            --this.width;
            this.Show();
        }
        this.jLabel3.setText("" + this.width);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        if (this.width < 300) {
            ++this.width;
            this.Show();
        }
        this.jLabel3.setText("" + this.width);
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        if (this.height > 1) {
            --this.height;
            this.Show();
        }
        this.jLabel4.setText("" + this.height);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        if (this.height < 300) {
            ++this.height;
            this.Show();
        }
        this.jLabel4.setText("" + this.height);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        ++this.mode;
        if (this.mode == 4) {
            this.mode = 0;
        }
        this.Show();
        this.jLabel6.setText("" + this.mode);
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.mode = GateArray.getSMode();
        this.jLabel6.setText("" + this.mode);
        this.Show();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        try {
            int adr = Util.hexValue(this.address.getText());
            adr = this.step.isSelected() ? (adr -= this.width * this.height) : (this.line.isSelected() ? (adr -= this.width) : --adr);
            if (adr < 0) {
                adr = 65535;
            }
            this.address.setText(Util.hex((short)adr));
            this.Show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        try {
            int adr = Util.hexValue(this.address.getText());
            adr = this.step.isSelected() ? (adr += this.width * this.height) : (this.line.isSelected() ? (adr += this.width) : ++adr);
            if (adr > 65535) {
                adr = 0;
            }
            this.address.setText(Util.hex((short)adr));
            this.Show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void gridActionPerformed(ActionEvent evt) {
        this.Show();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        if (this.zoom > 1) {
            --this.zoom;
        }
        this.zm.setText("" + this.zoom);
        this.Show();
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        if (this.zoom < 20) {
            ++this.zoom;
        }
        this.zm.setText("" + this.zoom);
        this.Show();
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        this.export();
    }

    private void addressKeyReleased(KeyEvent evt) {
        try {
            String ad = this.address.getText();
            int add = 0;
            try {
                add = Util.hexValue(ad);
            }
            catch (Exception e) {
                add = 0;
            }
            if (add > 65535) {
                add = 0;
            }
            this.address.setText(Util.hex((short)add));
            this.Show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void button1ActionPerformed(ActionEvent evt) {
        this.gpen = 0;
    }

    private void button2ActionPerformed(ActionEvent evt) {
        this.gpen = 1;
    }

    private void button3ActionPerformed(ActionEvent evt) {
        this.gpen = 2;
    }

    private void button4ActionPerformed(ActionEvent evt) {
        this.gpen = 3;
    }

    private void button5ActionPerformed(ActionEvent evt) {
        this.gpen = 4;
    }

    private void button6ActionPerformed(ActionEvent evt) {
        this.gpen = 5;
    }

    private void button7ActionPerformed(ActionEvent evt) {
        this.gpen = 6;
    }

    private void button8ActionPerformed(ActionEvent evt) {
        this.gpen = 7;
    }

    private void button9ActionPerformed(ActionEvent evt) {
        this.gpen = 8;
    }

    private void button10ActionPerformed(ActionEvent evt) {
        this.gpen = 9;
    }

    private void button11ActionPerformed(ActionEvent evt) {
        this.gpen = 10;
    }

    private void button12ActionPerformed(ActionEvent evt) {
        this.gpen = 11;
    }

    private void button13ActionPerformed(ActionEvent evt) {
        this.gpen = 12;
    }

    private void button14ActionPerformed(ActionEvent evt) {
        this.gpen = 13;
    }

    private void button15ActionPerformed(ActionEvent evt) {
        this.gpen = 14;
    }

    private void button16ActionPerformed(ActionEvent evt) {
        this.gpen = 15;
    }

    private void binActionPerformed(ActionEvent evt) {
        this.bin1.setSelected(this.bin.isSelected());
        this.header.setEnabled(this.bin.isSelected());
        this.header1.setEnabled(this.bin.isSelected());
    }

    private void stepActionPerformed(ActionEvent evt) {
        if (this.step.isSelected()) {
            this.line.setSelected(false);
        }
    }

    private void lineActionPerformed(ActionEvent evt) {
        if (this.line.isSelected()) {
            this.step.setSelected(false);
        }
    }

    private void jButton13ActionPerformed(ActionEvent evt) {
        if (this.pzoom > 1) {
            --this.pzoom;
        }
        this.updateScreen(this.screen[this.expindex]);
        this.prev.pack();
    }

    private void jButton14ActionPerformed(ActionEvent evt) {
        ++this.pzoom;
        this.updateScreen(this.screen[this.expindex]);
        this.prev.pack();
    }

    private void jButton15ActionPerformed(ActionEvent evt) {
        this.moveBack();
    }

    private void jButton16ActionPerformed(ActionEvent evt) {
        this.moveForward();
    }

    private void formWindowStateChanged(WindowEvent evt) {
        this.Show();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.linear = this.jCheckBox1.isSelected();
        this.Show();
    }

    private void skipscreenActionPerformed(ActionEvent evt) {
        this.Show();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.copy();
    }

    private void jButton17ActionPerformed(ActionEvent evt) {
        this.paste();
    }

    private void jButton18ActionPerformed(ActionEvent evt) {
        this.paste();
    }

    private void jButton19ActionPerformed(ActionEvent evt) {
        this.copy();
    }

    private void jLabel3KeyReleased(KeyEvent evt) {
        try {
            int z = Integer.parseInt(this.jLabel3.getText());
            if (z < 1) {
                this.jLabel3.setText("" + z);
                z = 1;
            }
            if (z > 500) {
                this.jLabel3.setText("" + z);
                z = 500;
            }
            this.width = z;
            this.Show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jLabel4KeyReleased(KeyEvent evt) {
        try {
            int z = Integer.parseInt(this.jLabel4.getText());
            if (z < 1) {
                this.jLabel4.setText("" + z);
                z = 1;
            }
            if (z > 500) {
                this.jLabel4.setText("" + z);
                z = 500;
            }
            this.height = z;
            this.Show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void zmKeyReleased(KeyEvent evt) {
        try {
            int z = Integer.parseInt(this.zm.getText());
            if (z < 1) {
                this.zm.setText("" + z);
                z = 1;
            }
            if (z > 20) {
                this.zm.setText("" + z);
                z = 20;
            }
            this.zoom = z;
            this.Show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void romActionPerformed(ActionEvent evt) {
        this.Show();
    }

    private void jButton20ActionPerformed(ActionEvent evt) {
        this.exportASM();
    }

    private void jButton21ActionPerformed(ActionEvent evt) {
        this.export();
    }

    private void bin1ActionPerformed(ActionEvent evt) {
        this.bin.setSelected(this.bin1.isSelected());
        this.header1.setEnabled(this.bin.isSelected());
        this.header.setEnabled(this.bin.isSelected());
    }

    private void jButton22ActionPerformed(ActionEvent evt) {
        this.exportASM();
    }

    private void headerActionPerformed(ActionEvent evt) {
        this.header1.setSelected(this.header.isSelected());
    }

    private void header1ActionPerformed(ActionEvent evt) {
        this.header.setSelected(this.header1.isSelected());
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        this.autoupdate = this.jCheckBox2.isSelected();
        if (this.autoupdate) {
            this.fire.start();
        } else {
            this.fire.stop();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GraphicsViewer().setVisible(true);
            }
        });
    }
}

