/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import jemu.core.device.keyboard.MatrixKeyboard;
import jemu.ui.KeyBoard;

public abstract class Keyboard
extends MatrixKeyboard {
    protected boolean DEBUG = false;
    protected int[] keyBytes = new int[16];
    protected int row = 0;
    protected int[] KeyboardData = new int[16];

    public Keyboard() {
        super("CPC Keyboard", 8, 10);
        for (int i = 0; i < this.keyBytes.length; ++i) {
            this.KeyboardData[i] = 255;
            this.keyBytes[i] = 255;
        }
        this.setKeyMappings();
        this.reset();
    }

    protected abstract void setKeyMappings();

    protected abstract void processKey(byte var1);

    protected abstract void ReleaseKey(byte var1);

    protected abstract void PressKey(byte var1);

    protected abstract boolean IsPressed(byte var1);

    protected abstract void initBytes();

    protected abstract byte[] getKeyNum();

    @Override
    protected void keyChanged(int col, int row, int oldValue, int newValue) {
        if (oldValue == 0) {
            if (newValue != 0) {
                int n = row;
                this.KeyboardData[n] = this.KeyboardData[n] & (1 << col ^ 0xFF);
            }
        } else if (newValue == 0) {
            int n = row;
            this.KeyboardData[n] = this.KeyboardData[n] | 1 << col;
        }
        System.arraycopy(this.KeyboardData, 0, this.keyBytes, 0, 16);
        if (KeyBoard.keyboardClash) {
            this.GenerateKeyboardClash();
        }
    }

    protected void GenerateKeyboardClash() {
        for (int i = 0; i < 9; ++i) {
            int Line1 = this.KeyboardData[i];
            if (Line1 == 255) continue;
            for (int j = 0; j < 9; ++j) {
                int Line2;
                if (i == j || (Line2 = this.KeyboardData[j]) == 255 || (Line1 | Line2) == 255) continue;
                Line1 &= Line1 ^ Line2 ^ 0xFF;
            }
            this.keyBytes[i] = Line1;
        }
    }

    public void setSelectedRow(int value) {
        this.row = value;
    }

    public int readSelectedRow() {
        if (this.DEBUG && this.keyBytes[this.row] != 255) {
            System.out.println("Row: " + this.row + " Data: " + this.keyBytes[this.row]);
        }
        return this.keyBytes[this.row];
    }
}

