/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.util.Vector;
import jemu.system.cpc.Keyboard;

public class KeyboardB
extends Keyboard {
    protected static final int[] KEY_MAP = new int[]{38, 39, 40, 120, 117, 114, 35, 110, 37, 12, 118, 119, 116, 112, 113, 123, 127, 65406, 10, 93, 115, 16, 92, 17, 61, 45, 91, 80, 222, 59, 47, 46, 48, 57, 79, 73, 76, 75, 77, 44, 56, 55, 85, 89, 72, 74, 78, 32, 54, 53, 82, 84, 71, 70, 66, 86, 52, 51, 69, 87, 83, 68, 67, 88, 49, 50, 27, 81, 9, 65, 20, 90, -1, -1, -1, -1, -1, -1, -1, 8};
    protected int[] previousbytes = new int[10];

    @Override
    public void setKeyMappings() {
        this.addKeyMappings(KEY_MAP);
        this.addKeyMapping(186, 5, 3);
        this.addKeyMapping(188, 7, 4);
        this.addKeyMapping(189, 1, 3);
        this.addKeyMapping(190, 7, 3);
        this.addKeyMapping(219, 2, 3);
        this.addKeyMapping(221, 3, 2);
    }

    @Override
    protected void processKey(byte keynum) {
        if ((this.keyBytes[keynum / 8] & 1 << (keynum & 7)) == 0) {
            int n = keynum / 8;
            this.keyBytes[n] = this.keyBytes[n] | 1 << (keynum & 7);
        } else {
            int n = keynum / 8;
            this.keyBytes[n] = this.keyBytes[n] & ~(1 << (keynum & 7));
        }
    }

    @Override
    protected void ReleaseKey(byte keynum) {
        int n = keynum / 8;
        this.keyBytes[n] = this.keyBytes[n] | 1 << (keynum & 7);
    }

    @Override
    protected void PressKey(byte keynum) {
        int n = keynum / 8;
        this.keyBytes[n] = this.keyBytes[n] & ~(1 << (keynum & 7));
    }

    @Override
    protected boolean IsPressed(byte keynum) {
        return (this.keyBytes[keynum / 8] & 1 << (keynum & 7)) == 0;
    }

    @Override
    protected void initBytes() {
        for (int i = 0; i < 10; ++i) {
            this.previousbytes[i] = this.keyBytes[i];
        }
    }

    @Override
    protected byte[] getKeyNum() {
        Vector<Integer> keynums = new Vector<Integer>();
        for (int i = 0; i < 10; ++i) {
            if (this.previousbytes[i] == this.keyBytes[i]) continue;
            for (int b = 0; b < 8; ++b) {
                if (((this.previousbytes[i] ^ this.keyBytes[i]) & 1 << b) == 0) continue;
                keynums.add(i * 8 + b);
            }
            this.previousbytes[i] = this.keyBytes[i];
        }
        Object[] array = keynums.toArray();
        byte[] keys = new byte[array.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (byte)Integer.parseInt(array[i].toString());
        }
        return keys;
    }
}

