/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc.plus;

import jemu.core.device.Device;
import jemu.system.cpc.CPC;
import jemu.system.cpc.CPCMemory;
import jemu.system.cpc.GateArray;
import jemu.system.cpc.Z80;

public class ASIC
extends Device {
    protected int selInk = 0;
    protected boolean DEBUG = false;
    CPC cpc;
    Z80 z80;
    boolean asicLocked;
    boolean asicRamActive;
    int lowRomLoc;
    int lowRomPage;
    protected final int[] plusPalette = new int[]{1638, 1638, 3846, 4086, 6, 246, 1542, 1782, 246, 4086, 4080, 4095, 240, 255, 1776, 1791, 6, 3846, 3840, 3855, 0, 15, 1536, 1551, 102, 3942, 3936, 3951, 96, 111, 1632, 1647};
    protected int[] ASICPalette = new int[2];
    int rambank;
    CPCMemory cpcmemory;
    int region;
    protected int[] readport = new int[65536];
    protected int[] ASIC_EnableSequence = new int[]{255, 119, 179, 81, 168, 212, 98, 57, 156, 70, 43, 21, 138, 205};
    protected final int SEQUENCE_SYNCHRONISE_FIRST_BYTE = 0;
    protected final int SEQUENCE_SYNCHRONISE_SECOND_BYTE = 1;
    protected final int SEQUENCE_RECOGNISE = 2;
    protected final int SEQUENCE_GET_LOCK_STATUS = 3;
    protected final int SEQUENCE_SYNCHRONISE_THIRD_BYTE = 4;
    protected int CurrentSequencePos;
    protected int RecogniseSequenceState;
    int returnmode;
    int linebuffer;
    byte[] splitbuffer = new byte[2];
    int splitline = 0;
    int splitaddress;

    public ASIC(CPC cpc) {
        super("Amstrad 40489 ASIC");
        this.cpc = cpc;
        this.z80 = cpc.z80;
    }

    protected void setPal(int value) {
        this.ASICPalette[0] = value & 0xFF;
        this.ASICPalette[1] = value >> 8 & 0xFF;
    }

    public boolean isLocked() {
        return this.asicLocked;
    }

    @Override
    public void writePort(int port, int value) {
        if (!CPC.memory.plus) {
            return;
        }
        this.readport[port] = value;
        if (this.cpcmemory == null) {
            this.cpcmemory = (CPCMemory)this.cpc.getMemory();
        }
        if ((port & 0x8000) == 0) {
            if ((value & 0xE0) == 160) {
                this.lowRomPage = value & 7;
                switch (value >> 3 & 3) {
                    case 0: {
                        this.asicLocked = true;
                        this.asicRamActive = false;
                        this.region = 0;
                        this.lowRomLoc = 0;
                        this.cpcmemory.enableAsicRam(this.asicRamActive, this.lowRomLoc, this.lowRomPage, this.asicLocked, this.region);
                        if (!this.DEBUG) break;
                        System.out.println("case 0: &0000-&3fff - asic RAM disabled");
                        break;
                    }
                    case 1: {
                        this.asicLocked = true;
                        this.asicRamActive = false;
                        this.region = 1;
                        this.lowRomLoc = 2;
                        this.cpcmemory.enableAsicRam(this.asicRamActive, this.lowRomLoc, this.lowRomPage, this.asicLocked, this.region);
                        if (!this.DEBUG) break;
                        System.out.println("case 1: &4000-&7fff - asic RAM disabled");
                        break;
                    }
                    case 2: {
                        this.asicLocked = true;
                        this.asicRamActive = false;
                        this.region = 2;
                        this.lowRomLoc = 4;
                        this.cpcmemory.enableAsicRam(this.asicRamActive, this.lowRomLoc, this.lowRomPage, this.asicLocked, this.region);
                        if (!this.DEBUG) break;
                        System.out.println("case 2: &8000-&bfff - asic RAM disabled");
                        break;
                    }
                    case 3: {
                        this.asicRamActive = true;
                        this.region = 0;
                        this.lowRomLoc = 0;
                        this.cpcmemory.enableAsicRam(this.asicRamActive, this.lowRomLoc, this.lowRomPage, this.asicLocked, this.region);
                        if (!this.DEBUG) break;
                        System.out.println("case 2: &0000-&3fff - asic RAM enabled");
                    }
                }
            } else if ((value & 0x80) == 0) {
                if ((value & 0x40) == 0) {
                    this.selInk = (value &= 0x1F) < 16 ? value : 16;
                    CPC.memory.selInk = this.selInk;
                } else {
                    this.setPal(this.plusPalette[value & 0x1F]);
                    CPC.memory.writeToAsic(25600 + this.selInk * 2, this.ASICPalette[0]);
                    CPC.memory.writeToAsic(25601 + this.selInk * 2, this.ASICPalette[1]);
                    GateArray.setPlusPalette(this.selInk, this.ASICPalette[0] >> 4 & 0xF, this.ASICPalette[1] & 0xF, this.ASICPalette[0] & 0xF);
                }
            } else if ((value & 0x80) != 0) {
                if ((value & 0x40) == 0) {
                    this.cpc.getGateArray().setModeAndROMEnable(this.cpcmemory, value);
                } else {
                    this.cpcmemory.setRAMBank(value);
                    this.rambank = value;
                }
            }
        }
    }

    @Override
    public int readPort(int port) {
        if ((port & 0x8000) == 0) {
            return this.readport[port];
        }
        return 0;
    }

    public void ASICSequence(int value) {
        value &= 0xFF;
        if (this.cpcmemory == null) {
            this.cpcmemory = (CPCMemory)this.cpc.getMemory();
        }
        switch (this.RecogniseSequenceState) {
            case 0: {
                if (value == 0) break;
                this.RecogniseSequenceState = 1;
                break;
            }
            case 1: {
                if (value != 0) break;
                this.RecogniseSequenceState = 4;
                break;
            }
            case 4: {
                if (value == 255) {
                    this.RecogniseSequenceState = 2;
                    this.CurrentSequencePos = 1;
                    break;
                }
                if (value == 0) break;
                this.RecogniseSequenceState = 1;
                break;
            }
            case 2: {
                if (value == 0) {
                    this.RecogniseSequenceState = 4;
                    break;
                }
                if (value == this.ASIC_EnableSequence[this.CurrentSequencePos]) {
                    ++this.CurrentSequencePos;
                    if (this.CurrentSequencePos != this.ASIC_EnableSequence.length) break;
                    this.asicLocked = true;
                    System.out.println("ASIC locked!!!");
                    this.cpcmemory.remap();
                    this.RecogniseSequenceState = 3;
                    break;
                }
                this.CurrentSequencePos = 0;
                this.RecogniseSequenceState = 1;
                break;
            }
            case 3: {
                if (value == 238) {
                    this.asicLocked = false;
                    System.out.println("ASIC Unlocked!!!");
                    this.cpcmemory.remap();
                }
                this.RecogniseSequenceState = value != 0 ? 1 : 0;
            }
        }
    }

    protected int getLineNumber() {
        return this.cpc.getGateArray().getLineNumber();
    }

    public void splitScreen() {
        try {
            this.splitline = this.cpcmemory.readFromAsic(26625);
            if (this.splitline != this.getLineNumber() || this.splitline == 0) {
                return;
            }
            this.splitbuffer[1] = (byte)this.cpcmemory.readFromAsic(26626);
            this.splitbuffer[0] = (byte)this.cpcmemory.readFromAsic(26627);
            this.splitaddress = Device.getWord(this.splitbuffer, 0);
            if (this.splitaddress != 0) {
                this.cpc.getGateArray().crtc.maCurrent = this.cpc.getGateArray().crtc.maStore = this.splitaddress & 0xFFFF;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getRaster() {
        return this.linebuffer != 0;
    }

    public boolean doInterrupt() {
        try {
            this.linebuffer = this.cpcmemory.readFromAsic(26624);
            if (this.linebuffer == this.getLineNumber() && this.linebuffer != 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

