/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jemu.system.cpc.GateArray;
import jemu.ui.Switches;

public class Autotype
extends WindowAdapter
implements WindowListener,
ActionListener {
    JFileChooser saveFileChooser = new JFileChooser(System.getProperty("/"));
    static JFileChooser loadFileChooser = new JFileChooser(System.getProperty("/"));
    protected GridBagConstraints gbcConstraints = null;
    public static JFrame typeconsole;
    public static String autotext;
    public static JTextArea textArea;
    public JButton button = new JButton(" Send text ");
    public static JCheckBox bix;
    public JButton button2 = new JButton(" Clear console ");
    public JButton button3 = new JButton(" Copy text ");
    public JButton button4 = new JButton(" Paste text ");
    public static JButton button5;
    public static JButton button6;

    public Autotype() {
        typeconsole = new JFrame("JavaCPC Autotype");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = new Dimension(screenSize.width / 2, screenSize.height / 2);
        int x = frameSize.width / 2 + 110;
        int y = frameSize.height / 2 + 60;
        typeconsole.setBounds(x, y, 540, 480);
        textArea = new JTextArea();
        typeconsole.setResizable(false);
        textArea.setLineWrap(true);
        textArea.setEditable(true);
        textArea.setAutoscrolls(true);
        typeconsole.getContentPane().setLayout(new GridBagLayout());
        typeconsole.add((Component)this.button, this.getGridBagConstraints(1, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)bix, this.getGridBagConstraints(2, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)this.button2, this.getGridBagConstraints(3, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)this.button3, this.getGridBagConstraints(4, 2, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)button5, this.getGridBagConstraints(1, 3, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)button6, this.getGridBagConstraints(2, 3, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)this.button4, this.getGridBagConstraints(3, 3, 1.0, 0.0, 1, 1));
        typeconsole.add((Component)new JScrollPane(textArea), this.getGridBagConstraints(1, 1, 1.0, 1.0, 5, 1));
        typeconsole.setAlwaysOnTop(true);
        typeconsole.setVisible(false);
        typeconsole.addWindowListener(this);
        this.button.addActionListener(this);
        this.button.setFocusable(false);
        this.button2.addActionListener(this);
        this.button2.setFocusable(false);
        this.button3.addActionListener(this);
        this.button3.setFocusable(false);
        this.button4.addActionListener(this);
        this.button4.setFocusable(false);
        button5.addActionListener(this);
        button5.setFocusable(false);
        button6.addActionListener(this);
        button6.setFocusable(false);
        Autotype.open();
    }

    private GridBagConstraints getGridBagConstraints(int x, int y, double weightx, double weighty, int width, int fill) {
        if (this.gbcConstraints == null) {
            this.gbcConstraints = new GridBagConstraints();
        }
        this.gbcConstraints.gridx = x;
        this.gbcConstraints.gridy = y;
        this.gbcConstraints.weightx = weightx;
        this.gbcConstraints.weighty = weighty;
        this.gbcConstraints.gridwidth = width;
        this.gbcConstraints.fill = fill;
        return this.gbcConstraints;
    }

    @Override
    public synchronized void windowClosing(WindowEvent evt) {
        Autotype.save();
        typeconsole.setVisible(false);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.button) {
            Autotype.SendToCPC(bix.isSelected());
        }
        if (evt.getSource() == this.button2) {
            textArea.setText("");
            Autotype.save();
        }
        if (evt.getSource() == this.button3 && !textArea.getText().equals("")) {
            textArea.selectAll();
            textArea.copy();
            textArea.paste();
        }
        if (evt.getSource() == this.button4) {
            textArea.paste();
        }
        if (evt.getSource() == button5) {
            this.openFile();
        }
        if (evt.getSource() == button6) {
            this.saveFile();
        }
    }

    public static void PasteText() {
        Autotype.save();
        textArea.setText("");
        textArea.paste();
        textArea.selectAll();
        autotext = textArea.getText();
        textArea.selectAll();
        Switches.getfromautotype = 1;
        Autotype.open();
    }

    public static void SendToCPC(boolean asbasic) {
        if (asbasic) {
            String put = textArea.getText();
            GateArray.cpc.BasicAutoType(put);
            return;
        }
        textArea.selectAll();
        autotext = textArea.getText();
        Switches.getfromautotype = 1;
        textArea.selectAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile() {
        FileDialog filedia = new FileDialog((Frame)typeconsole, "Import ASCII...", 0);
        filedia.setFile("*.txt; *.asm; *.bas");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            String loadname = filename = filedia.getDirectory() + filedia.getFile();
            File file = new File(loadname);
            StringBuffer contents = new StringBuffer();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String text = null;
                while ((text = reader.readLine()) != null) {
                    contents.append(text).append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            textArea.setText(contents.toString());
        }
        filedia.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFile() {
        Autotype.save();
        FileDialog filedia = new FileDialog((Frame)typeconsole, "Import ASCII...", 0);
        filedia.setFile("*.txt; *.asm; *.bas");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            String loadname = filename = filedia.getDirectory() + filedia.getFile();
            File file = new File(loadname);
            StringBuffer contents = new StringBuffer();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String text = null;
                while ((text = reader.readLine()) != null) {
                    contents.append(text).append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            textArea.setText(contents.toString());
            Autotype.SendToCPC(bix.isSelected());
        }
        filedia.dispose();
        Autotype.open();
    }

    public void saveFile() {
        FileDialog filedia = new FileDialog((Frame)typeconsole, "Save ASCII...", 1);
        filedia.setFile("*.txt; *.asm; *.bas");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            filename = filedia.getDirectory() + filedia.getFile();
            String savename = filename;
            if (!(savename.toLowerCase().endsWith(".txt") || savename.toLowerCase().endsWith(".asm") || savename.toLowerCase().endsWith(".bas"))) {
                savename = savename + ".txt";
            }
            File file = new File(savename);
            String exportedText = textArea.getText();
            try {
                FileWriter fw = new FileWriter(file);
                fw.write(exportedText);
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        filedia.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open() {
        File file = new File(System.getProperty("user.home"), "/JavaCPC/autotype.dat");
        StringBuffer importedText = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String text = null;
            while ((text = reader.readLine()) != null) {
                importedText.append(text).append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        textArea.setText(importedText.toString());
    }

    public static void save() {
        String exportedText = textArea.getText();
        File file = new File(System.getProperty("user.home"), "/JavaCPC/autotype.dat");
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(exportedText);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        bix = new JCheckBox("As BASIC");
        button5 = new JButton(" Load... ");
        button6 = new JButton(" Save... ");
    }
}

