/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jemu.core.Util;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.JEMU;
import jemu.ui.Main;
import jemu.ui.Switches;

public class Console
extends JInternalFrame
implements KeyListener,
ActionListener,
Runnable {
    JFileChooser saveFileChooser = new JFileChooser();
    protected GridBagConstraints gbcConstraints = null;
    public static JTextArea textArea;
    private Thread reader;
    private Thread reader2;
    private boolean quit;
    private JTextField input;
    JButton button = new JButton("Clear");
    JButton button2 = new JButton("Copy");
    JButton button3 = new JButton("Save");
    private final PipedInputStream pin = new PipedInputStream();
    private final PipedInputStream pin2 = new PipedInputStream();
    protected Font font;
    public static String command;
    String help = "\n[JavaCPC Console Commands]\n------------------------------------------------------------\n\nAvailable commands:\nreset                    - Causes a softreset\nboot                     - Tries to boot from drive 0\ndevices                  - Shows the available devices\ndigitracker              - Starts Prodatron's Digitracker\npaint                    - Starts JavaCPC Paint\nquit                     - Quits JavaCPC (Without checks!!!)\nsave                     - Saves the console content\nclear / cls              - Clears the console\nbug                      - Report a bug\ndump &start-&end         - Dump ram area\nhelp / info              - This info\n------------------------------------------------------------\n\n";
    public static String autotext;

    public Console() {
        this.setTitle("JavaCPC Console");
        this.input = new JTextField("");
        this.input.addKeyListener(this);
        textArea = new JTextArea();
        this.font = new Font("Courier new", 1, 11);
        InputStream in = this.getClass().getResourceAsStream("amstrad_cpc464.ttf");
        try {
            this.font = Font.createFont(0, in).deriveFont(0, 8.0f);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.input.setFont(this.font);
        textArea.setFont(this.font);
        textArea.setEditable(false);
        textArea.setAutoscrolls(true);
        textArea.setLineWrap(true);
        textArea.setFocusable(false);
        this.button.setCursor(Cursor.getPredefinedCursor(12));
        this.button2.setCursor(Cursor.getPredefinedCursor(12));
        this.button3.setCursor(Cursor.getPredefinedCursor(12));
        this.getContentPane().setLayout(new GridBagLayout());
        JScrollPane scrollpane = new JScrollPane(textArea);
        this.add((Component)scrollpane, this.getGridBagConstraints(0, 0, 1.0, 1.0, 4, 1));
        this.add((Component)this.input, this.getGridBagConstraints(0, 1, 0.0, 0.0, 4, 1));
        this.add((Component)this.button, this.getGridBagConstraints(0, 2, 1.0, 0.0, 1, 1));
        this.add((Component)this.button2, this.getGridBagConstraints(1, 2, 1.0, 0.0, 1, 1));
        this.add((Component)this.button3, this.getGridBagConstraints(2, 2, 1.0, 0.0, 1, 1));
        this.button.addActionListener(this);
        this.button2.addActionListener(this);
        this.button.setFocusable(false);
        this.button2.setFocusable(false);
        this.button3.setFocusable(false);
        this.button3.addActionListener(this);
        try {
            PipedOutputStream pout = new PipedOutputStream(this.pin);
            System.setOut(new PrintStream(pout, true));
        }
        catch (IOException io) {
            textArea.append("Couldn't redirect STDOUT to this console\n" + io.getMessage());
        }
        catch (SecurityException se) {
            textArea.append("Couldn't redirect STDOUT to this console\n" + se.getMessage());
        }
        try {
            PipedOutputStream pout2 = new PipedOutputStream(this.pin2);
            System.setErr(new PrintStream(pout2, true));
        }
        catch (IOException io) {
            textArea.append("Couldn't redirect STDERR to this console\n" + io.getMessage());
        }
        catch (SecurityException se) {
            textArea.append("Couldn't redirect STDERR to this console\n" + se.getMessage());
        }
        this.quit = false;
        this.reader = new Thread(this);
        this.reader.setDaemon(true);
        this.reader.start();
        this.reader2 = new Thread(this);
        this.reader2.setDaemon(true);
        this.reader2.start();
    }

    private GridBagConstraints getGridBagConstraints(int x, int y, double weightx, double weighty, int width, int fill) {
        if (this.gbcConstraints == null) {
            this.gbcConstraints = new GridBagConstraints();
        }
        this.gbcConstraints.gridx = x;
        this.gbcConstraints.gridy = y;
        this.gbcConstraints.weightx = weightx;
        this.gbcConstraints.weighty = weighty;
        this.gbcConstraints.gridwidth = width;
        this.gbcConstraints.fill = fill;
        return this.gbcConstraints;
    }

    public void clear() {
        textArea.setText("");
        Calendar cal = Calendar.getInstance();
        System.out.println("JavaCPC [v." + Main.version + Main.subversion + "]\n\n[" + cal.getTime() + "]\n");
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.button) {
            this.clear();
        }
        if (evt.getSource() == this.button2) {
            textArea.selectAll();
            textArea.copy();
            System.out.println("Console content copied to clipboard.");
        }
        if (evt.getSource() == this.button3) {
            this.saveFile();
        }
    }

    @Override
    public synchronized void run() {
        try {
            String input;
            while (Thread.currentThread() == this.reader) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (this.pin.available() != 0) {
                    input = this.readLine(this.pin);
                    textArea.append(input);
                    textArea.select(2000000000, 2000000000);
                }
                if (!this.quit) continue;
                return;
            }
            while (Thread.currentThread() == this.reader2) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (this.pin2.available() != 0) {
                    input = this.readLine(this.pin2);
                    textArea.append(input);
                    textArea.select(2000000000, 2000000000);
                }
                if (!this.quit) continue;
                return;
            }
        }
        catch (Exception e) {
            textArea.append("\nConsole reports an Internal error.");
            textArea.append("The error is: " + e);
        }
    }

    public synchronized String readLine(PipedInputStream in) throws IOException {
        int available;
        String input = "";
        while ((available = in.available()) != 0) {
            byte[] b = new byte[available];
            in.read(b);
            if (!(input = input + new String(b, 0, b.length)).endsWith("\n") && !input.endsWith("\r\n") && !this.quit) continue;
        }
        return input;
    }

    public void saveFile() {
        FileDialog filedia = new FileDialog(new Frame(), "Save ASCII...", 1);
        filedia.setFile("*.txt");
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            filename = filedia.getDirectory() + filedia.getFile();
            String savename = filename;
            if (!savename.toLowerCase().endsWith(".txt")) {
                savename = savename + ".txt";
            }
            File file = new File(savename);
            String gettext = textArea.getText();
            try {
                FileWriter fw = new FileWriter(file);
                fw.write(gettext);
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        filedia.dispose();
    }

    public void checkCommand(String input) {
        if ((input = input.toLowerCase()).equals("reset")) {
            CPC.resetcpc = true;
            return;
        }
        if (input.equals("cheat")) {
            Switches.devil = true;
            return;
        }
        if (input.equals("boot")) {
            CPC.bootthis = true;
            return;
        }
        if (input.toLowerCase().startsWith("dump")) {
            String in = input;
            in = in.replace("dump", "");
            in = in.replace(" ", "");
            String[] out = in.split("-");
            out[0] = out[0].replace("&", "");
            out[1] = out[1].replace("&", "");
            try {
                final int start = Util.hexValue(out[0]);
                int end = Util.hexValue(out[1]);
                final int length = end - start;
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        byte[] ram = new byte[65536];
                        System.arraycopy(GateArray.screenmemory, 0, ram, 0, 49152);
                        System.out.print(Util.dumpBytes(ram, start, length, true, true, true));
                    }
                };
                thread.start();
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        if (input.startsWith("devic")) {
            JEMU.dinfo = true;
            return;
        }
        if (input.equals("quit")) {
            System.exit(0);
            return;
        }
        if (input.startsWith("god")) {
            System.out.println("Hahahaha you want to be god?");
            return;
        }
        if (input.startsWith("give")) {
            System.out.println("You want me to " + input + "? Are you nuts?");
            return;
        }
        if (input.equals("digitracker")) {
            Switches.digi = true;
            return;
        }
        if (input.startsWith("run") || input.startsWith("load")) {
            autotext = input + "\r\n";
            CPC.getfromconsole = true;
            return;
        }
        if (input.startsWith("dir") || input.startsWith("cat")) {
            CPC.catdrive = 0;
            if (input.contains("0")) {
                CPC.catdrive = 0;
            }
            if (input.contains("1")) {
                CPC.catdrive = 1;
            }
            if (input.contains("2")) {
                CPC.catdrive = 2;
            }
            if (input.contains("3")) {
                CPC.catdrive = 3;
            }
            CPC.cat = true;
            return;
        }
        if (input.equals("paint") || input.equals("javacpc paint")) {
            JEMU.choosePaint(true);
            return;
        }
        if (input.equals("help") || input.equals("info")) {
            textArea.append(this.help);
            return;
        }
        if (input.equals("cls") || input.equals("clear")) {
            this.clear();
            return;
        }
        if (input.equals("save")) {
            this.saveFile();
            return;
        }
        if (input.equals("bug")) {
            JEMU.bug = true;
            return;
        }
        if (input.equals("ldaneels")) {
            JEMU.loic();
            return;
        }
        autotext = input + "\r\n";
        CPC.getfromconsole = true;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (this.input.getText().length() > 0) {
                command = this.input.getText();
                textArea.append("User command: " + command + "\n");
                this.checkCommand(command);
            }
            this.input.setText("");
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    static {
        command = "";
        autotext = "";
    }
}

