/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Vector4f;
import jemu.settings.Settings;
import jemu.ui.Display;
import jemu.ui.Switches;

public class CurvaturedScreen
extends JComponent
implements ActionListener,
FocusListener {
    boolean halfsize = true;
    protected boolean DEBUG = false;
    public JPanel pan = new JPanel();
    protected int texsizeX = 1024;
    protected int texsizeY = 512;
    int sizex = 768;
    int sizey = 272;
    protected int offx = 128;
    protected int offy = 120;
    TextureLoader loader;
    Texture2D texture;
    Appearance ap;
    BranchGroup group;
    Sphere sphere;
    final URL Mask = this.getClass().getResource("3d.png");
    final Image mask = new JPanel().getToolkit().getImage(this.Mask);
    final URL Mask2 = this.getClass().getResource("3dbezel.png");
    final Image mask2 = new JPanel().getToolkit().getImage(this.Mask2);
    final URL Glance = this.getClass().getResource("glass.png");
    final Image glance = new JPanel().getToolkit().getImage(this.Glance);
    private PolygonAttributes pa = new PolygonAttributes();
    ButtonGroup but = new ButtonGroup();
    JRadioButton but1;
    JRadioButton but2;
    JRadioButton but3;
    ConfiguredUniverse universe;
    JPanel buts = new JPanel();
    boolean running = false;
    ImageComponent2D comp;
    BufferedImage display;
    Graphics g;
    boolean skip;
    int frame;

    @Override
    public void focusLost(FocusEvent e) {
        System.out.println("3d-Panel: Focus lost");
    }

    @Override
    public void focusGained(FocusEvent e) {
        System.out.println("3d-Panel: Focus gained");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.but1) {
            this.setRenderMode(0);
        } else if (e.getSource() == this.but2) {
            this.setRenderMode(1);
        } else if (e.getSource() == this.but3) {
            this.setRenderMode(2);
        }
    }

    public CurvaturedScreen() {
        this.halfsize = Settings.getBoolean("simple_textures", true);
        if (!this.halfsize) {
            this.texsizeX = 1024;
            this.texsizeY = 1024;
            this.sizex = 768;
            this.sizey = 544;
            this.offx = 128;
            this.offy = 240;
        }
        this.display = new BufferedImage(this.texsizeX, this.texsizeY, 1);
        this.g = this.display.getGraphics();
        this.pan.setFocusable(false);
        this.but1 = new JRadioButton("Filled");
        this.but2 = new JRadioButton("Wireframe");
        this.but3 = new JRadioButton("Dots");
        this.but1.setSelected(true);
        this.buts.setLayout(new FlowLayout());
        this.but.add(this.but1);
        this.but.add(this.but2);
        this.but.add(this.but3);
        this.buts.add(this.but1);
        this.buts.add(this.but2);
        this.buts.add(this.but3);
        this.universe = new ConfiguredUniverse();
        this.universe.setVisible(false);
        this.group = new BranchGroup();
        Color3f black = new Color3f(0.1f, 0.1f, 0.1f);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f red = new Color3f(0.5f, 0.5f, 0.5f);
        this.loader = new TextureLoader((Image)new BufferedImage(this.texsizeX, this.texsizeY, 1), 2, (Component)new Container());
        this.texture = (Texture2D)this.loader.getTexture();
        this.texture.setBoundaryModeS(3);
        this.texture.setBoundaryModeT(3);
        this.texture.setBoundaryColor(new Color4f(0.0f, 1.0f, 0.0f, 0.0f));
        this.texture.setCapability(7);
        this.comp = new ImageComponent2D(1, new BufferedImage(this.texsizeX, this.texsizeY, 1));
        this.comp.setCapability(3);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        texAttr.setTextureTransform(new Transform3D());
        this.ap = new Appearance();
        this.ap.setTexture((Texture)this.texture);
        TexCoordGeneration texcoord = new TexCoordGeneration();
        Vector4f v1 = new Vector4f(1.06f, 0.0f, 0.0f, 0.5f);
        texcoord.setPlaneS(v1);
        Vector4f v2 = new Vector4f(0.0f, 1.06f, 0.0f, 0.5f);
        texcoord.setPlaneT(v2);
        this.ap.setTexCoordGeneration(texcoord);
        this.ap.setTextureAttributes(texAttr);
        this.ap.setCapability(3);
        this.pa.setCapability(3);
        this.pa.setPolygonMode(2);
        this.ap.setPolygonAttributes(this.pa);
        int primflags = 3;
        this.sphere = new Sphere(1.57f, primflags, 256, this.ap);
        this.group.addChild((Node)this.sphere);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.universe.addBranchGraph(this.group);
        this.display.setAccelerationPriority(1.0f);
        this.setRenderMode(0);
        this.init();
        this.running = true;
    }

    protected void init() {
        this.but1.addActionListener(this);
        this.but2.addActionListener(this);
        this.but3.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.pan.setLayout(new BorderLayout());
        this.pan.add((Component)this.universe.getCanvas(), "Center");
        this.pan.setPreferredSize(new Dimension(768, 544));
        this.pan.setDoubleBuffered(true);
        this.add((Component)this.pan, "Center");
        if (this.DEBUG) {
            this.add((Component)this.buts, "South");
        }
        this.universe.getCanvas().setFocusable(false);
        this.universe.getCanvas().setDoubleBufferEnable(true);
        this.setVisible(true);
        this.setFocusable(true);
    }

    public void setRenderMode(int i) {
        switch (i) {
            case 0: {
                this.pa.setPolygonMode(2);
                break;
            }
            case 1: {
                this.pa.setPolygonMode(1);
                break;
            }
            case 2: {
                this.pa.setPolygonMode(0);
            }
        }
    }

    public void update(final BufferedImage image, final boolean usemask) {
        if (Display.skipframes) {
            boolean bl = this.skip = !this.skip;
            if (this.skip) {
                return;
            }
        }
        if (!this.running) {
            if (this.DEBUG) {
                System.out.println("skipping " + this.frame++);
            }
            return;
        }
        this.running = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CurvaturedScreen.this.g.drawImage(image, CurvaturedScreen.this.offx, CurvaturedScreen.this.offy, CurvaturedScreen.this.sizex, CurvaturedScreen.this.sizey, null);
                if (usemask) {
                    if (Switches.mask) {
                        CurvaturedScreen.this.g.drawImage(CurvaturedScreen.this.mask2, CurvaturedScreen.this.offx, CurvaturedScreen.this.offy, CurvaturedScreen.this.sizex, CurvaturedScreen.this.sizey, null);
                        CurvaturedScreen.this.g.drawImage(CurvaturedScreen.this.glance, CurvaturedScreen.this.offx + 500, CurvaturedScreen.this.offy, 248, 414, null);
                    } else {
                        CurvaturedScreen.this.g.drawImage(CurvaturedScreen.this.mask, CurvaturedScreen.this.offx, CurvaturedScreen.this.offy, CurvaturedScreen.this.sizex, CurvaturedScreen.this.sizey, null);
                    }
                }
                CurvaturedScreen.this.comp.set(CurvaturedScreen.this.display);
                CurvaturedScreen.this.texture.setImage(0, (ImageComponent)CurvaturedScreen.this.comp);
                CurvaturedScreen.this.running = true;
            }
        });
    }

    public static void main(String[] args) {
        new CurvaturedScreen();
    }
}

