/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import jemu.settings.Settings;
import jemu.system.cpc.GateArray;

public class DSK2CDT
extends JPanel {
    protected String[] fromread;
    protected String[] towrite;
    FileDialog filedia;
    Thread thread;
    int speedwrite = 0;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JProgressBar progress;
    private JList read;
    private JList write;

    public DSK2CDT() {
        this.initComponents();
    }

    public static void main(String[] args) {
        DSK2CDT d = new DSK2CDT();
        JFrame fram = new JFrame("DSK2CDT");
        fram.setLayout(new BorderLayout());
        fram.add((Component)d, "Center");
        fram.pack();
        fram.setVisible(true);
    }

    private void getFiles() {
        this.fromread = GateArray.cpc.getDir();
        this.read.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return DSK2CDT.this.fromread.length;
            }

            @Override
            public Object getElementAt(int i) {
                return DSK2CDT.this.fromread[i];
            }
        });
    }

    private void putFiles() {
        if (this.towrite == null) {
            this.towrite = new String[0];
        }
        this.write.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return DSK2CDT.this.towrite.length;
            }

            @Override
            public Object getElementAt(int i) {
                return DSK2CDT.this.towrite[i];
            }
        });
    }

    private void addEntry(String entry) {
        if (this.towrite == null) {
            this.towrite = new String[1];
            this.towrite[0] = entry;
            this.putFiles();
            return;
        }
        String[] buffer = new String[this.towrite.length];
        System.arraycopy(this.towrite, 0, buffer, 0, this.towrite.length);
        this.towrite = new String[this.towrite.length + 1];
        System.arraycopy(buffer, 0, this.towrite, 0, buffer.length);
        this.towrite[this.towrite.length - 1] = entry;
        this.putFiles();
    }

    private void makeCDT() {
        if (this.towrite == null || this.towrite.length < 1) {
            this.getFiles();
            return;
        }
        if (this.filedia == null) {
            this.filedia = new FileDialog((Frame)new JFrame(), "Create CDT file", 1);
        }
        this.filedia.setFile("*.cdt");
        this.filedia.setVisible(true);
        String savename = this.filedia.getFile();
        if (savename != null) {
            savename = this.filedia.getDirectory() + this.filedia.getFile();
            if (!savename.toLowerCase().endsWith(".cdt")) {
                savename = savename + ".cdt";
            }
            this.makeCDT(savename);
        }
    }

    public String getPath() {
        return System.getProperty("user.home") + "/javacpc/temp/";
    }

    private void makeCDT(final String name) {
        this.thread = new Thread(){

            @Override
            public void run() {
                String dsk;
                File check = new File(DSK2CDT.this.getPath());
                if (!check.exists()) {
                    check.mkdir();
                }
                if ((dsk = Settings.get("file.drive0", "empty")).equals("empty") || !dsk.toLowerCase().endsWith(".dsk")) {
                    return;
                }
                File in = new File(dsk);
                File out = new File(DSK2CDT.this.getPath() + "temp0.dsk");
                try {
                    BufferedInputStream bin = new BufferedInputStream(new FileInputStream(in));
                    byte[] input = new byte[bin.available()];
                    bin.read(input);
                    bin.close();
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                    bos.write(input);
                    bos.close();
                    DSK2CDT.this.progress.setMaximum(DSK2CDT.this.towrite.length);
                    for (int i = 0; i < DSK2CDT.this.towrite.length; ++i) {
                        String inn = DSK2CDT.this.towrite[i].replace(" ", "");
                        String outt = DSK2CDT.this.getPath() + DSK2CDT.this.towrite[i].replace(" ", "");
                        String command = "tools/cpcxfs.exe " + out.toString() + " -e user " + 0 + "; get -b -f " + inn + " " + outt;
                        System.out.println(command);
                        DSK2CDT.this.Launch(command);
                        DSK2CDT.this.progress.setValue(i);
                        Thread cfr_ignored_0 = DSK2CDT.this.thread;
                        Thread.sleep(225L);
                    }
                    boolean pos = false;
                    for (int i = 0; i < DSK2CDT.this.towrite.length; ++i) {
                        String command = "";
                        String tt = DSK2CDT.this.towrite[i].replace(" ", "");
                        String dat1 = DSK2CDT.this.towrite[i];
                        while (dat1.contains("\\")) {
                            dat1 = dat1.substring(1);
                        }
                        command = i == 0 ? "tools/2cdt.exe -s " + DSK2CDT.this.speedwrite + " -n -r \"" + tt + "\" \"" + DSK2CDT.this.getPath() + tt + "\" \"" + name + "\"" : "tools/2cdt.exe -s " + DSK2CDT.this.speedwrite + " -r \"" + tt + "\" \"" + DSK2CDT.this.getPath() + tt + "\" \"" + name + "\"";
                        System.out.println(command);
                        DSK2CDT.this.Launch(command);
                        DSK2CDT.this.progress.setValue(i);
                        Thread cfr_ignored_1 = DSK2CDT.this.thread;
                        Thread.sleep(225L);
                    }
                    String[] files = check.list();
                    for (int i = 0; i < files.length; ++i) {
                        File newfile = new File(DSK2CDT.this.getPath() + files[i]);
                        if (!newfile.exists()) continue;
                        newfile.delete();
                    }
                    Thread.sleep(250L);
                    DSK2CDT.this.progress.setValue(0);
                    check.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.thread.start();
    }

    public void Launch(String command) throws InterruptedException, IOException {
        command = System.getProperty("user.home") + "/javacpc/" + command;
        Runtime.getRuntime().exec(command);
    }

    private void remEntry(int pos) {
        if (this.towrite == null || pos < 0 || pos > this.towrite.length) {
            return;
        }
        int ppos = 0;
        String[] buffer = new String[this.towrite.length];
        System.arraycopy(this.towrite, 0, buffer, 0, this.towrite.length);
        int newlength = this.towrite.length - 1;
        if (newlength > 0) {
            buffer = new String[newlength];
            for (int i = 0; i < this.towrite.length; ++i) {
                if (i == pos) continue;
                buffer[ppos++] = this.towrite[i];
            }
            this.towrite = new String[newlength];
            System.arraycopy(buffer, 0, this.towrite, 0, buffer.length);
        } else {
            this.towrite = new String[0];
        }
        this.putFiles();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.write = new JList();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.read = new JList();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.progress = new JProgressBar();
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(161);
        this.jSplitPane1.setDividerSize(8);
        this.jSplitPane1.setLastDividerLocation(161);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel2.setText("Files to write");
        this.jPanel1.add((Component)this.jLabel2, "North");
        this.write.setFont(new Font("Monospaced", 1, 12));
        this.write.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DSK2CDT.this.writeMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.write);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jLabel1.setText("Files on Disk");
        this.jPanel2.add((Component)this.jLabel1, "North");
        this.read.setFont(new Font("Monospaced", 1, 12));
        this.read.setSelectionMode(0);
        this.read.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DSK2CDT.this.readMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.read);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jButton1.setText("Get Files");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSK2CDT.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Build CDT");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSK2CDT.this.jButton2ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("SPEED WRITE 1");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSK2CDT.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 322, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progress, -1, 57, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jSplitPane1, -2, 243, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progress, -1, 23, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBox1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.getFiles();
    }

    private void readMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.addEntry(this.fromread[this.read.getSelectedIndex()]);
        }
    }

    private void writeMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.remEntry(this.write.getSelectedIndex());
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.makeCDT();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.speedwrite = this.jCheckBox1.isSelected() ? 1 : 0;
    }
}

