/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import jemu.core.Util;
import jemu.core.breakpoint.Breakpoint;
import jemu.core.breakpoint.StopBreakpoint;
import jemu.core.cpu.Processor;
import jemu.core.device.Computer;
import jemu.core.device.memory.Memory;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.ui.Breakpoints;
import jemu.ui.Display;
import jemu.ui.EButton;
import jemu.ui.EDisassembler;
import jemu.ui.EMemory;
import jemu.ui.ERegisters;
import jemu.ui.EStackPointer;
import jemu.ui.JEMU;
import jemu.ui.Switches;
import jemu.ui.ePPI;
import jemu.util.diss.Disassembler;

public class Debugger
extends JFrame
implements KeyListener,
MouseMotionListener,
MouseListener,
ItemListener,
ActionListener {
    boolean ctrl;
    boolean shift;
    Breakpoints testpoints = new Breakpoints();
    protected int[] banks = new int[]{192, 196, 197, 198, 199, 204, 205, 206, 207, 212, 213, 214, 215, 220, 221, 222, 223, 228, 229, 230, 231, 236, 237, 238, 239, 244, 245, 246, 247, 252, 253, 254, 255};
    private HashMap<Integer, Breakpoint> breakpoints = new HashMap();
    public static final Color navy = new Color(0, 0, 127);
    protected Computer computer;
    protected long startCycles = 0L;
    public static int breakaddress;
    protected int breakindex = 0;
    protected JFileChooser fileDlg = new JFileChooser();
    int storedbank = 0;
    int[] cycles = new int[65536];
    JTextArea text = new JTextArea();
    protected JButton bRun;
    protected EButton bStep;
    protected EButton bStepOver;
    protected JButton bStop;
    protected JButton bGFX;
    protected JButton bBreaks;
    protected JButton bSearch;
    protected JButton bReset;
    public JCheckBox bPoints;
    protected JCheckBox bInst;
    protected JCheckBox bFollow;
    public static JCheckBox bWinape;
    public static EDisassembler eDisassembler;
    public static EStackPointer eStackpointer;
    public static EMemory eMemory;
    protected ERegisters eRegisters;
    protected JPanel jPanel1;
    protected JPanel jPanel2;
    protected JPanel jPanel4;
    protected JPanel jPanel5;
    protected JPanel jPanelRegisters;
    protected JScrollPane jScrollPane1;
    protected JSplitPane jSplitPane1;
    protected JSplitPane jSplitPane2;
    protected JTextField lCycleCount;
    protected JLabel lCycles;
    protected JMenuItem mGoto;
    protected JMenuItem mSave;
    protected JMenuItem mFind;
    protected JMenuItem mCopy;
    protected JMenuItem mCopyHex;
    protected JMenuItem mCopyBasic;
    protected JMenuItem mBreak;
    protected JMenuItem mRemove;
    protected JMenuItem mRemoveAll;
    protected JPopupMenu popupMenu;
    protected ButtonGroup readwritegroup;
    protected JRadioButton bRead;
    protected JRadioButton bWrite;
    protected JRadioButton bAny;
    protected JComboBox bBanks;
    protected ePPI ppi;

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.ctrl = false;
        }
        if (e.getKeyCode() == 16) {
            this.shift = false;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 119) {
            if (this.shift) {
                this.computer.stepOver();
            } else {
                this.computer.step();
            }
            this.computer.repaintDisplay();
        }
        if (e.getKeyCode() == 17) {
            this.ctrl = true;
        }
        if (e.getKeyCode() == 16) {
            this.shift = true;
        }
        if (e.getKeyCode() == 67 && this.ctrl) {
            if (eDisassembler.hasFocus()) {
                this.copyDisassembly();
            } else if (eMemory.hasFocus()) {
                this.copyMemory();
            }
        }
        if (e.getKeyCode() == 70 && this.ctrl) {
            eMemory.find();
        }
        if (e.getKeyCode() == 114) {
            eMemory.find();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.popupMenu.isShowing()) {
            if (e.getSource() == eDisassembler) {
                Debugger.eDisassembler.selline = eDisassembler.getAddress(e.getY());
                eDisassembler.repaint();
                this.mBreak.setEnabled(true);
                this.mRemove.setEnabled(true);
                this.mCopyHex.setEnabled(false);
                this.mCopyBasic.setEnabled(false);
            } else {
                this.mBreak.setEnabled(false);
                this.mRemove.setEnabled(false);
                this.mCopyHex.setEnabled(true);
                this.mCopyBasic.setEnabled(true);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.popupMenu.isShowing()) {
            if (e.getSource() == eDisassembler) {
                Debugger.eDisassembler.selline = eDisassembler.getAddress(e.getY());
                eDisassembler.repaint();
                this.mBreak.setEnabled(true);
                this.mRemove.setEnabled(true);
                this.mCopyHex.setEnabled(false);
                this.mCopyBasic.setEnabled(false);
            } else {
                this.mBreak.setEnabled(false);
                this.mRemove.setEnabled(false);
                this.mCopyHex.setEnabled(true);
                this.mCopyBasic.setEnabled(true);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.bGFX) {
            this.bGFX.setBorder(new BevelBorder(0));
        }
        if (e.getSource() == this.bBreaks) {
            this.bBreaks.setBorder(new BevelBorder(0));
        }
        if (e.getSource() == this.bSearch) {
            this.bSearch.setBorder(new BevelBorder(0));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Debugger.eDisassembler.selline = -20;
        eDisassembler.repaint();
        if (e.getSource() == this.bGFX) {
            this.bGFX.setBorder(null);
        }
        if (e.getSource() == this.bBreaks) {
            this.bBreaks.setBorder(null);
        }
        if (e.getSource() == this.bSearch) {
            this.bSearch.setBorder(null);
        }
    }

    public Computer getDebuggerComputer() {
        return this.computer;
    }

    public Debugger() {
        this.initComponents();
        this.bBanks.addItemListener(this);
        this.bRead.addItemListener(this);
        this.bWrite.addItemListener(this);
        this.bAny.addItemListener(this);
        this.bRead.setSelected(true);
        this.bRun.addActionListener(this);
        this.bStop.addActionListener(this);
        this.bGFX.addActionListener(this);
        this.bBreaks.addActionListener(this);
        this.testpoints.clear.addActionListener(this);
        this.testpoints.clearall.addActionListener(this);
        this.testpoints.cycles.addActionListener(this);
        this.bSearch.addActionListener(this);
        this.bGFX.addMouseListener(this);
        this.bBreaks.addMouseListener(this);
        this.bSearch.addMouseListener(this);
        this.bReset.addActionListener(this);
        this.bPoints.addActionListener(this);
        this.bPoints.setFocusable(false);
        this.bPoints.addItemListener(this);
        this.bPoints.setSelected(Settings.getBoolean("breakpoints", false));
        this.bFollow.addActionListener(this);
        this.bFollow.setFocusable(false);
        this.bFollow.addItemListener(this);
        bWinape.setFocusable(false);
        bWinape.addItemListener(this);
        this.bInst.addActionListener(this);
        this.bInst.addItemListener(this);
        this.bInst.setSelected(Settings.getBoolean("breakinstructions", false));
        this.bInst.setFocusable(false);
        this.bStepOver.addActionListener(this);
        this.bStep.addActionListener(this);
        this.mSave.addActionListener(this);
        this.mFind.addActionListener(this);
        this.mCopy.addActionListener(this);
        this.mCopyHex.addActionListener(this);
        this.mCopyBasic.addActionListener(this);
        this.mGoto.addActionListener(this);
        this.mBreak.addActionListener(this);
        this.mRemove.addActionListener(this);
        this.mRemoveAll.addActionListener(this);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(this.getFontMetrics(eMemory.getFont()).getHeight());
        this.jScrollPane1.setBorder(new BevelBorder(1));
    }

    public void setComputer(Computer value) {
        if (this.computer != null) {
            this.computer.removeActionListener(this);
        }
        this.computer = value;
        eDisassembler.setComputer(this.computer);
        eStackpointer.setComputer(this.computer);
        eMemory.setComputer(this.computer);
        if (this.computer != null) {
            this.computer.addActionListener(this);
            this.eRegisters.setDevice(this.computer.getProcessor());
            this.updateDisplay();
        } else {
            this.eRegisters.setDevice(null);
        }
    }

    public void updateDisplay() {
        this.ppi.ppiA.setText(Util.hex((byte)this.computer.getPPI_A()));
        this.ppi.ppiB.setText(Util.hex((byte)this.computer.getPPI_B()));
        this.ppi.ppiC.setText(Util.hex((byte)this.computer.getPPI_C()));
        this.ppi.ppiControl.setText(Util.hex((byte)this.computer.getPPI_Control()));
        eDisassembler.setPC(this.computer.getProcessor().getProgramCounter());
        eStackpointer.setSP(this.computer.getProcessor().getStackPointer());
        eMemory.setAddress(this.computer.getProcessor().getProgramCounter());
        this.lCycleCount.setText(Long.toString(this.computer.getProcessor().getCycles() - this.startCycles));
        this.eRegisters.setValues();
        this.repaint();
    }

    public boolean isBreakpoint(int address) {
        return this.breakpoints.get(address) != null;
    }

    public String[] getBreakpoints() {
        int breakcount = 0;
        for (int addr = 0; addr <= 65535; ++addr) {
            if (!this.isBreakpoint(addr)) continue;
            ++breakcount;
        }
        String[] breaks = new String[breakcount];
        breakcount = 0;
        for (int addr = 0; addr <= 65535; ++addr) {
            if (!this.isBreakpoint(addr)) continue;
            breaks[breakcount] = Util.hex((short)addr);
            int n = breakcount++;
            breaks[n] = breaks[n] + "         cycles: " + this.cycles[addr];
        }
        return breaks;
    }

    public void setBanks() {
        this.bBanks.setModel(new DefaultComboBoxModel(){
            String[] strings = new String[]{"C0", "C4", "C5", "C6", "C7", "CC", "CD", "CE", "CF", "D4", "D5", "D6", "D7", "DC", "DD", "DE", "DF", "E4", "E5", "E6", "E7", "EC", "ED", "EE", "EF", "F4", "F5", "F6", "F7", "FC", "FD", "FE", "FF"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.bBanks.setSelectedIndex(0);
    }

    public void updateBreakpoints() {
        this.testpoints.points.setModel(new AbstractListModel(){
            String[] strings;
            {
                this.strings = Debugger.this.getBreakpoints();
            }

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
    }

    protected long getGotoAddress() {
        String address = JOptionPane.showInputDialog("Address: ", (Object)"#");
        if (address == null) {
            return -1L;
        }
        if ((address = address.trim()).length() == 0) {
            return -1L;
        }
        switch (address.charAt(0)) {
            case '#': 
            case '$': 
            case '&': {
                return Long.parseLong(address.substring(1), 16);
            }
        }
        return Long.parseLong(address);
    }

    public static void setDisass(int address) {
        eDisassembler.setPC(address);
    }

    public static void setEditor(int address) {
        eMemory.setAddress(address);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == bWinape) {
            this.updateDisplay();
            eDisassembler.repaint();
        }
        if (e.getSource() == this.bRead || e.getSource() == this.bWrite || e.getSource() == this.bAny) {
            if (this.computer != null && this.bAny.isSelected()) {
                this.computer.stop();
            }
            this.bBanks.setEnabled(this.bAny.isSelected());
            Debugger.eDisassembler.read = this.bRead.isSelected();
            Debugger.eDisassembler.any = this.bAny.isSelected();
            Debugger.eStackpointer.read = this.bRead.isSelected();
            Debugger.eStackpointer.any = this.bAny.isSelected();
            Debugger.eMemory.read = this.bRead.isSelected();
            Debugger.eMemory.any = this.bAny.isSelected();
            eMemory.repaint();
            eDisassembler.repaint();
            eStackpointer.repaint();
        }
        if (e.getSource() == this.bBanks && this.bAny.isSelected()) {
            if (this.computer != null) {
                this.computer.stop();
            }
            Debugger.eDisassembler.any = true;
            Debugger.eDisassembler.forcedbank = this.banks[this.bBanks.getSelectedIndex()];
            Debugger.eStackpointer.any = true;
            Debugger.eStackpointer.forcedbank = this.banks[this.bBanks.getSelectedIndex()];
            Debugger.eMemory.forcedbank = this.banks[this.bBanks.getSelectedIndex()];
            eMemory.repaint();
            eDisassembler.repaint();
            eStackpointer.repaint();
        }
        if (e.getSource() == this.bPoints) {
            Switches.breakpoints = this.bPoints.isSelected();
            Settings.setBoolean("breakpoints", this.bPoints.isSelected());
        }
        if (e.getSource() == this.bFollow) {
            JEMU.followCPU = this.bFollow.isSelected();
        }
        if (e.getSource() == this.bInst) {
            Switches.breakinsts = this.bInst.isSelected();
            Settings.setBoolean("breakinstructions", this.bInst.isSelected());
        }
    }

    public void update() {
    }

    public void Continue() {
        this.computer.start();
        CPC.resync = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.computer.clearRunToAddress();
        if (e.getSource() == this.bRun) {
            this.bRead.setSelected(true);
            this.computer.start();
            CPC.resync = true;
        } else if (e.getSource() == this.bStop) {
            this.computer.stop();
        } else if (e.getSource() == this.bGFX) {
            Display.initgfxviewer = 1;
        } else if (e.getSource() != this.bSearch) {
            if (e.getSource() == this.bBreaks) {
                this.testpoints.setVisible(true);
            } else if (e.getSource() == this.testpoints.clear) {
                this.clearBreakpoint();
            } else if (e.getSource() == this.testpoints.clearall) {
                this.removeAllBreakpoints();
            } else if (e.getSource() == this.testpoints.cycles) {
                this.setCycles();
            } else if (e.getSource() == this.bReset) {
                this.resetCycles();
            } else if (e.getSource() == this.bStep) {
                this.bRead.setSelected(true);
                this.computer.step();
                this.computer.repaintDisplay();
            } else if (e.getSource() == this.bStepOver) {
                this.bRead.setSelected(true);
                this.computer.stepOver();
                this.computer.repaintDisplay();
            } else if (e.getSource() == this.computer) {
                this.updateDisplay();
            } else if (e.getSource() == this.mGoto) {
                long address = this.getGotoAddress();
                if (address != -1L) {
                    if (this.popupMenu.getInvoker() == eDisassembler) {
                        eDisassembler.setAddress((int)address);
                    } else {
                        eMemory.setAddress((int)address);
                    }
                }
            } else if (e.getSource() == this.mBreak) {
                if (Switches.breakpoints && breakaddress > -1 && breakaddress < 65536) {
                    this.setBreakpoint(breakaddress);
                }
            } else if (e.getSource() == this.mRemove) {
                if (Switches.breakpoints) {
                    Breakpoint bp = this.breakpoints.get(breakaddress);
                    if (bp != null) {
                        this.cycles[Debugger.breakaddress] = 0;
                        bp.setCycles(0);
                        this.computer.getProcessor().detachProgramCounterObserver(bp);
                        this.breakpoints.remove(breakaddress);
                        System.out.println("StopBreakpoint removed at &" + Util.hex(breakaddress));
                    }
                    this.updateBreakpoints();
                    eDisassembler.repaint();
                    eStackpointer.repaint();
                    this.repaint();
                }
            } else if (e.getSource() == this.mRemoveAll) {
                this.removeAllBreakpoints();
                eDisassembler.repaint();
                eStackpointer.repaint();
                this.repaint();
            } else if (e.getSource() == this.mSave) {
                if (this.popupMenu.getInvoker() == eDisassembler) {
                    this.saveDisassembly();
                } else {
                    this.saveMemory();
                }
            } else if (e.getSource() == this.mCopy) {
                if (this.popupMenu.getInvoker() == eDisassembler) {
                    this.copyDisassembly();
                } else {
                    this.copyMemory();
                }
            } else if (e.getSource() == this.mFind) {
                eMemory.find();
            } else if (e.getSource() == this.mCopyHex) {
                if (this.popupMenu.getInvoker() == eDisassembler) {
                    this.copyDisassembly();
                } else {
                    this.copyMemoryAsHex();
                }
            } else if (e.getSource() == this.mCopyBasic) {
                if (this.popupMenu.getInvoker() == eDisassembler) {
                    this.copyDisassembly();
                } else {
                    this.copyMemoryAsBasic();
                }
            }
        }
        this.computer.setFrameSkip(0);
        this.computer.updateDisplay(false);
    }

    protected File showSaveDialog(String title) {
        this.fileDlg.setDialogTitle(title);
        return this.fileDlg.showSaveDialog(this.bRun) == 0 ? this.fileDlg.getSelectedFile() : null;
    }

    public void setBreakpoint(int address) {
        Breakpoint bp = this.breakpoints.get(address);
        if (bp == null) {
            bp = new StopBreakpoint(this.computer.getProcessor(), address);
            this.setCycles(address);
            this.computer.getProcessor().attachProgramCounterObserver(bp);
            this.breakpoints.put(address, bp);
            System.out.println("StopBreakpoint added at &" + Util.hex(address));
        }
        this.setCycles(address);
        bp.setCycles(this.cycles[address]);
        this.updateBreakpoints();
        eDisassembler.repaint();
        eStackpointer.repaint();
        this.repaint();
    }

    public void saveMemory() {
        this.saveMemory(Debugger.eMemory.selStart, Debugger.eMemory.selEnd);
    }

    public void copyMemory() {
        this.copyMemory(Debugger.eMemory.selStart, Debugger.eMemory.selEnd);
    }

    public void copyMemoryAsHex() {
        this.copyMemoryAsHex(Debugger.eMemory.selStart, Debugger.eMemory.selEnd);
    }

    public void copyMemoryAsBasic() {
        this.copyMemoryAsBasic(Debugger.eMemory.selStart, Debugger.eMemory.selEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMemory(int start, int end) {
        File file = this.showSaveDialog("Save Memory");
        if (file != null) {
            try {
                FileOutputStream io = new FileOutputStream(file);
                try {
                    Memory mem = this.computer.getMemory();
                    for (int addr = start; addr <= end; ++addr) {
                        if (Debugger.eDisassembler.read) {
                            io.write(mem.readByte(addr));
                            continue;
                        }
                        if (Debugger.eDisassembler.any) {
                            io.write(mem.readWriteByte(addr, Debugger.eDisassembler.forcedbank, true));
                            continue;
                        }
                        io.write(mem.readWriteByte(addr));
                    }
                }
                finally {
                    io.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void copyMemory(int start, int end) {
        try {
            Memory mem = this.computer.getMemory();
            byte[] data = new byte[end - start + 1];
            int pos = 0;
            for (int addr = start; addr <= end; ++addr) {
                data[pos] = Debugger.eDisassembler.read ? (byte)mem.readByte(addr) : (Debugger.eDisassembler.any ? (byte)mem.readWriteByte(addr, Debugger.eDisassembler.forcedbank, true) : (byte)mem.readWriteByte(addr));
                ++pos;
            }
            String result = Util.dumpBytes(data);
            this.text.setText(result);
            this.text.selectAll();
            this.text.copy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyMemoryAsHex(int start, int end) {
        try {
            Memory mem = this.computer.getMemory();
            byte[] data = new byte[end - start + 1];
            int pos = 0;
            for (int addr = start; addr <= end; ++addr) {
                data[pos] = Debugger.eDisassembler.read ? (byte)mem.readByte(addr) : (Debugger.eDisassembler.any ? (byte)mem.readWriteByte(addr, Debugger.eDisassembler.forcedbank, true) : (byte)mem.readWriteByte(addr));
                ++pos;
            }
            String result = Util.dumpBytes(data, 0, data.length, false, true, true);
            String[] res = result.split("\n");
            result = "";
            for (int i = 0; i < res.length; ++i) {
                while (res[i].contains(";")) {
                    res[i] = res[i].substring(0, res[i].length() - 1);
                }
                res[i] = res[i].substring(0, res[i].length() - 1);
                result = result + res[i] + '\r' + '\n';
            }
            this.text.setText(result);
            this.text.selectAll();
            this.text.copy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyMemoryAsBasic(int start, int end) {
        try {
            String bascode = "10 '***********************************\r\n20 '*BASIC code generated with JavaCPC*\r\n30 '***********************************\r\n40 MEMORY &" + Util.hex((short)(start - 1)) + ":adr=&" + Util.hex((short)start) + "\r\n" + "50 READ a$:IF a$=\"END\" THEN GOTO 70\r\n" + "60 a$=\"&\"+a$:a=VAL(a$):POKE adr,a:adr=adr+1:GOTO 20\r\n" + "70 PRINT\"All Data generated.\"\r\n" + "80 PRINT\"SAVE as ,b,&" + Util.hex((short)start) + ",&" + Util.hex((short)end) + "\"\r\n" + "90 END\r\n";
            int linenumber = 90;
            Memory mem = this.computer.getMemory();
            byte[] data = new byte[end - start + 1];
            int pos = 0;
            for (int addr = start; addr <= end; ++addr) {
                data[pos] = Debugger.eDisassembler.read ? (byte)mem.readByte(addr) : (Debugger.eDisassembler.any ? (byte)mem.readWriteByte(addr, Debugger.eDisassembler.forcedbank, true) : (byte)mem.readWriteByte(addr));
                ++pos;
            }
            String result = Util.dumpBytes(data, 0, data.length, false, true, true);
            String[] res = result.split("\n");
            for (int i = 0; i < res.length; ++i) {
                while (res[i].contains(";")) {
                    res[i] = res[i].substring(0, res[i].length() - 1);
                }
                while (res[i].endsWith(" ")) {
                    res[i] = res[i].substring(0, res[i].length() - 1);
                }
                while (res[i].startsWith(" ")) {
                    res[i] = res[i].substring(1);
                }
                res[i] = res[i].replace(" ", ",");
                res[i] = (linenumber += 10) + " DATA " + res[i];
                bascode = bascode + res[i] + '\r' + '\n';
            }
            bascode = bascode + (linenumber += 10) + " DATA END";
            this.text.setText(bascode);
            this.text.selectAll();
            this.text.copy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveDisassembly() {
        this.saveDisassembly(Debugger.eDisassembler.selStart, Debugger.eDisassembler.selEnd);
    }

    public void copyDisassembly() {
        this.copyDisassembly(Debugger.eDisassembler.selStart, Debugger.eDisassembler.selEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDisassembly(int start, int end) {
        File file = this.showSaveDialog("Save Disassembly");
        if (file != null) {
            String fname = file.getPath();
            if (!fname.toLowerCase().endsWith(".asm")) {
                fname = fname + ".asm";
                file = new File(fname);
            }
            int[] addr = new int[]{start};
            try {
                Calendar cal = Calendar.getInstance();
                FileOutputStream io = new FileOutputStream(file);
                try {
                    Disassembler diss = this.computer.getDisassembler();
                    Memory mem = this.computer.getMemory();
                    if (bWinape.isSelected()) {
                        io.write(("                ;; JavaCPC disassembled binary\r\n                ;; disassembled from #" + Util.hex((short)start) + " to #" + Util.hex((short)end) + "\r\n" + "                ;; " + cal.getTime() + "\r\n\r\n").getBytes());
                    } else {
                        io.write(("                ; JavaCPC disassembled binary\r\n                ; disassembled from #" + Util.hex((short)start) + " to #" + Util.hex((short)end) + "\r\n" + "                ; " + cal.getTime() + "\r\n\r\n").getBytes());
                    }
                    io.write(("                ORG     #" + Util.hex((short)start) + "\r\n\r\n").getBytes());
                    while (addr[0] <= end) {
                        String content = "                " + diss.disass(mem, addr, true, 31, 50);
                        io.write((content + "\r\n").getBytes());
                    }
                }
                finally {
                    io.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void copyDisassembly(int start, int end) {
        int[] addr = new int[]{start};
        try {
            Calendar cal = Calendar.getInstance();
            String result = "";
            Disassembler diss = this.computer.getDisassembler();
            Memory mem = this.computer.getMemory();
            result = bWinape.isSelected() ? result + "                ;; JavaCPC disassembled binary\r\n                ;; disassembled from #" + Util.hex((short)start) + " to #" + Util.hex((short)end) + "\r\n" + "                ;; " + cal.getTime() + "\r\n\r\n" : result + "                ; JavaCPC disassembled binary\r\n                ; disassembled from #" + Util.hex((short)start) + " to #" + Util.hex((short)end) + "\r\n" + "                ; " + cal.getTime() + "\r\n\r\n";
            result = result + "                ORG     #" + Util.hex((short)start) + "\r\n\r\n";
            while (addr[0] <= end) {
                String content = "                " + diss.disass(mem, addr, true, 31, 50);
                result = result + content + "\r\n";
            }
            this.text.setText(result);
            this.text.selectAll();
            this.text.copy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.readwritegroup = new ButtonGroup();
        this.bBanks = new JComboBox();
        this.bRead = new JRadioButton("Read");
        this.bWrite = new JRadioButton("Write");
        this.bAny = new JRadioButton("Any");
        this.readwritegroup.add(this.bRead);
        this.readwritegroup.add(this.bWrite);
        this.readwritegroup.add(this.bAny);
        this.ppi = new ePPI();
        this.popupMenu = new JPopupMenu();
        this.mGoto = new JMenuItem();
        this.mSave = new JMenuItem();
        this.mFind = new JMenuItem();
        this.mCopy = new JMenuItem();
        this.mCopyHex = new JMenuItem();
        this.mCopyBasic = new JMenuItem();
        this.mBreak = new JMenuItem();
        this.mRemove = new JMenuItem();
        this.mRemoveAll = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanelRegisters = new JPanel();
        this.jPanel2.setBorder(new BevelBorder(1));
        this.jPanel4.setBorder(new BevelBorder(1));
        this.jPanel5.setLayout(new BorderLayout());
        this.bRun = new JButton();
        this.bStop = new JButton();
        this.bGFX = new JButton();
        this.bSearch = new JButton();
        this.bBreaks = new JButton();
        this.bReset = new JButton();
        this.bPoints = new JCheckBox();
        this.bFollow = new JCheckBox();
        bWinape = new JCheckBox();
        this.bInst = new JCheckBox();
        this.bStep = new EButton();
        this.bStepOver = new EButton();
        this.lCycles = new JLabel();
        this.lCycleCount = new JTextField();
        this.eRegisters = new ERegisters();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane1.setFocusable(false);
        this.jSplitPane2.setFocusable(false);
        eDisassembler = new EDisassembler();
        eStackpointer = new EStackPointer();
        this.jScrollPane1 = new JScrollPane();
        eMemory = new EMemory();
        this.mFind.setText("Find...");
        this.popupMenu.add(this.mFind);
        this.mCopy.setText("Copy");
        this.popupMenu.add(this.mCopy);
        this.mCopyHex.setText("Copy as Hex-Data only");
        this.popupMenu.add(this.mCopyHex);
        this.mCopyBasic.setText("Generate BASIC code");
        this.popupMenu.add(this.mCopyBasic);
        this.mGoto.setText("Goto...");
        this.popupMenu.add(this.mGoto);
        this.mBreak.setText("Set breakpoint...");
        this.popupMenu.add(this.mBreak);
        this.mRemove.setText("Remove breakpoint...");
        this.popupMenu.add(this.mRemove);
        this.mRemoveAll.setText("Remove all breakpoints...");
        this.popupMenu.add(this.mRemoveAll);
        this.mSave.setText("Save...");
        this.popupMenu.add(this.mSave);
        this.setTitle("JavaCPC Debugger");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0));
        this.jPanel4.setLayout(new FlowLayout(0));
        this.setBanks();
        this.bRead.setFocusable(false);
        this.bWrite.setFocusable(false);
        this.bAny.setFocusable(false);
        this.bBanks.setFocusable(false);
        this.jPanel2.add(this.bRead);
        this.jPanel2.add(this.bWrite);
        this.jPanel2.add(this.bAny);
        this.jPanel2.add(new JLabel("Bank:"));
        this.jPanel2.add(this.bBanks);
        JSeparator seppel = new JSeparator(1);
        seppel.setPreferredSize(new Dimension(4, 20));
        this.jPanel2.add(seppel);
        this.bRun.setText("Run");
        this.jPanel2.add(this.bRun);
        this.bStop.setText("Stop");
        this.jPanel2.add(this.bStop);
        this.bStep.setText("Step");
        this.jPanel2.add(this.bStep);
        this.bStepOver.setText("Step Over");
        this.jPanel2.add(this.bStepOver);
        this.bPoints.setText("Breakpoints");
        this.jPanel4.add(this.bPoints);
        this.bInst.setText("Break Instructions");
        this.jPanel4.add(this.bInst);
        this.bFollow.setText("Follow");
        bWinape.setText("Winape compatible disassembly");
        this.jPanel4.add(this.bFollow);
        this.jPanel4.add(bWinape);
        bWinape.setSelected(true);
        this.bGFX.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/gfxviewer.gif")));
        this.bGFX.setBorder(null);
        this.bBreaks.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/breakpoint.gif")));
        this.bBreaks.setBorder(null);
        this.bSearch.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/search.gif")));
        this.bSearch.setBorder(null);
        this.bSearch.setFocusPainted(false);
        this.bGFX.setFocusPainted(false);
        this.bBreaks.setFocusPainted(false);
        this.bSearch.setFocusable(false);
        this.bGFX.setFocusable(false);
        this.bBreaks.setFocusable(false);
        this.jPanel4.add(this.bBreaks);
        this.jPanel4.add(this.bGFX);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.lCycles.setText("T");
        this.lCycleCount.setText("0");
        this.lCycleCount.setColumns(12);
        this.lCycleCount.setHorizontalAlignment(2);
        this.lCycleCount.setEditable(false);
        this.lCycleCount.setFocusable(false);
        this.lCycleCount.addMouseListener(this);
        this.bReset.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/reset.gif")));
        this.bReset.setText("");
        this.bReset.setBorder(new BevelBorder(0));
        this.add((Component)this.jPanel1, "Last");
        this.eRegisters.setLayout(null);
        this.jPanelRegisters.setLayout(new BorderLayout());
        JPanel jPanelE = new JPanel();
        jPanelE.add(this.lCycles);
        jPanelE.add(this.lCycleCount);
        jPanelE.add(this.bReset);
        jPanelE.setLayout(new FlowLayout(1));
        this.jPanelRegisters.add((Component)this.eRegisters, "North");
        this.jPanelRegisters.add((Component)jPanelE, "Center");
        this.jPanelRegisters.add((Component)this.ppi, "South");
        this.ppi.setVisible(true);
        this.add((Component)this.jPanelRegisters, "After");
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane2.setDividerLocation(405);
        this.jSplitPane2.setOrientation(1);
        this.jSplitPane2.setContinuousLayout(true);
        this.jSplitPane2.setOneTouchExpandable(true);
        eDisassembler.setComponentPopupMenu(this.popupMenu);
        eDisassembler.addMouseListener(this);
        eMemory.addMouseMotionListener(this);
        eDisassembler.addMouseMotionListener(this);
        eDisassembler.addKeyListener(this);
        eMemory.addKeyListener(this);
        this.jSplitPane2.setTopComponent(eDisassembler);
        this.jPanel5.add((Component)new JLabel("  Stack"), "North");
        this.jPanel5.add((Component)eStackpointer, "Center");
        this.jSplitPane2.setBottomComponent(this.jPanel5);
        eMemory.setComponentPopupMenu(this.popupMenu);
        this.jScrollPane1.setViewportView(eMemory);
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.getSource() == this.lCycleCount) {
            this.lCycleCountMouseClicked(evt);
        } else if (evt.getSource() == eDisassembler) {
            breakaddress = eDisassembler.getAddress(evt.getY());
            this.eDisassemblerMouseClicked(evt);
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    private void eDisassemblerMouseClicked(MouseEvent e) {
        int addr;
        if (e.getClickCount() == 2 && (addr = eDisassembler.getAddress(e.getY())) != -1) {
            this.computer.setRunToAddress(addr);
            this.computer.start();
        }
    }

    public void clearBreakpoint() {
        try {
            String[] breaks = this.getBreakpoints();
            int g = this.testpoints.points.getSelectedIndex();
            if (g < 0) {
                return;
            }
            String adr = breaks[g];
            while (adr.contains(" ")) {
                adr = adr.substring(0, adr.length() - 1);
            }
            int address = Util.hexValue(adr);
            Breakpoint bp = this.breakpoints.get(address);
            if (bp != null) {
                this.computer.getProcessor().detachProgramCounterObserver(bp);
                this.breakpoints.remove(address);
                System.out.println("StopBreakpoint removed at &" + Util.hex(address));
            }
            this.updateBreakpoints();
            eDisassembler.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCycles() {
        try {
            String str;
            String[] breaks = this.getBreakpoints();
            int g = this.testpoints.points.getSelectedIndex();
            if (g < 0) {
                return;
            }
            String adr = breaks[g];
            while (adr.contains(" ")) {
                adr = adr.substring(0, adr.length() - 1);
            }
            int address = Util.hexValue(adr);
            Breakpoint bp = this.breakpoints.get(address);
            if (bp != null && (str = JOptionPane.showInputDialog(null, "Cycles:", "Enter Cycles", 3)) != null) {
                int cyc;
                this.cycles[address] = cyc = Integer.parseInt(str);
                bp.setCycles(cyc);
            }
            this.updateBreakpoints();
            eDisassembler.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCycles(int address) {
        try {
            String str;
            Breakpoint bp = this.breakpoints.get(address);
            if (bp != null && (str = JOptionPane.showInputDialog(null, "Cycles: ", "Enter Cycles", 1)) != null) {
                int cyc;
                this.cycles[address] = cyc = Integer.parseInt(str);
                bp.setCycles(cyc);
            }
            this.updateBreakpoints();
            eDisassembler.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeAllBreakpoints() {
        if (Switches.breakpoints && !this.breakpoints.isEmpty()) {
            Processor p = this.computer.getProcessor();
            for (Breakpoint bp : this.breakpoints.values()) {
                this.cycles[bp.getAddress()] = 0;
                bp.setCycles(0);
                p.detachProgramCounterObserver(bp);
            }
            this.breakpoints.clear();
            System.out.println("StopBreakpoint all removed");
            this.updateBreakpoints();
            eDisassembler.repaint();
        }
    }

    public void continueAndReset() {
        this.computer.start();
        this.computer.reset();
    }

    private void resetCycles() {
        this.startCycles = this.computer.getProcessor().getCycles();
        this.lCycleCount.setText("0");
    }

    private void lCycleCountMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.resetCycles();
        }
    }
}

