/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.border.BevelBorder;
import jemu.core.Util;
import jemu.core.device.Computer;
import jemu.ui.Counter;
import jemu.ui.Debugger;
import jemu.ui.JEMU;
import jemu.ui.TimerListener;
import jemu.util.diss.Disassembler;

public class EDisassembler
extends JComponent
implements MouseWheelListener,
AdjustmentListener,
TimerListener {
    public boolean read = true;
    public boolean any = false;
    public int forcedbank = 192;
    protected static final Color selBackground = new Color(190, 190, 200);
    protected static final Color selBreakPoint = new Color(200, 0, 0);
    protected static final Color selForeground = new Color(0xFFFFFF);
    protected static final Color pcBackground = new Color(127);
    protected static final Color pcBreakPoint = new Color(0xFF8080);
    protected static final Color pcForeground = new Color(0x8080FF);
    protected JScrollBar scrollBar = new JScrollBar(1);
    protected int address = 0;
    protected int maxAddress = 65535;
    protected int pc = 0;
    protected Computer computer;
    protected int lineHeight = 0;
    protected int[] addresses = new int[0];
    protected int selAnchor = 0;
    protected int selStart = 0;
    protected int selEnd = 0;
    protected int timerY = 0;
    protected Counter counter = null;
    protected boolean inSet = false;
    Font f = new Font("Monospaced", 0, 12);
    Font fb = new Font("Monospaced", 1, 12);
    Font fc = new Font("Monospaced", 2, 12);
    final URL PCo = this.getClass().getResource("ico/go.gif");
    final Image PCi = this.getToolkit().getImage(this.PCo);
    final URL BPo = this.getClass().getResource("ico/bp.gif");
    final Image BPi = this.getToolkit().getImage(this.BPo);
    final URL SPo = this.getClass().getResource("ico/sp.gif");
    final Image SPi = this.getToolkit().getImage(this.SPo);
    public int selline;

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getUnitsToScroll() > 0) {
            if (this.scrollBar.getValue() < this.scrollBar.getMaximum() - 1) {
                this.scrollBar.setValue(this.scrollBar.getValue() + 1);
            }
        } else if (this.scrollBar.getValue() > 1) {
            this.scrollBar.setValue(this.scrollBar.getValue() - 1);
        }
    }

    public EDisassembler() {
        this.enableEvents(48L);
        this.setBackground(Color.white);
        this.setForeground(new Color(0, 128, 0));
        this.setBorder(new BevelBorder(1));
        this.setFont(new Font("Monospaced", 0, 12));
        this.setLayout(new BorderLayout());
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.setBlockIncrement(16);
        this.add((Component)this.scrollBar, "East");
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        this.setDoubleBuffered(false);
    }

    public void setComputer(Computer value) {
        this.computer = value;
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(65552);
        this.scrollBar.setVisibleAmount(16);
        this.maxAddress = this.computer.getMemory().getAddressSize() - 1;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Disassembler diss;
        Insets insets = this.getInsets();
        Rectangle rect = new Rectangle(insets.left + 1, insets.top + 1, this.getWidth() - this.scrollBar.getWidth() - insets.left - insets.right - 2, this.getHeight() - insets.top - insets.bottom - 2);
        g.setColor(this.getBackground());
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        FontMetrics fm = g.getFontMetrics();
        if (this.computer != null && (diss = this.computer.getDisassembler()) != null) {
            diss.read = this.read;
            diss.any = this.any;
            diss.forcedbank = this.forcedbank;
            int a = fm.getAscent();
            int[] addr = new int[]{this.address};
            int h = this.lineHeight = fm.getHeight();
            this.addresses = new int[(rect.height + h - 1) / h];
            int n = 0;
            for (int y = rect.y; y < rect.y + rect.height; y += fm.getHeight()) {
                int i;
                int st = fm.getHeight();
                this.addresses[n++] = addr[0];
                if (addr[0] >= this.selStart && addr[0] <= this.selEnd) {
                    g.setColor(selBackground);
                    g.fillRect(rect.x + 30, y, rect.width - 31, fm.getHeight());
                    g.drawRect(rect.x + 29, y - 1, rect.width - 30, fm.getHeight() + 1);
                    g.setColor(selForeground == null ? this.getForeground() : selForeground);
                }
                if (addr[0] == this.pc) {
                    g.setColor(Color.yellow);
                    g.fillRect(rect.x + 30, y, rect.width - 31, fm.getHeight());
                    g.drawImage(this.PCi, rect.x + 20, y + 4, this);
                }
                if (JEMU.debugger.isBreakpoint(addr[0])) {
                    g.setColor(pcBreakPoint);
                    g.fillRect(rect.x + 30, y, rect.width - 31, fm.getHeight());
                    g.drawImage(this.BPi, 3, y + 4, this);
                    g.setColor(this.getForeground());
                }
                if (addr[0] == this.selline) {
                    g.setColor(pcForeground);
                    g.drawImage(this.SPi, rect.x + rect.width - 10, y + 8, this);
                    for (int i2 = rect.x; i2 < rect.width; i2 += 8) {
                        g.drawLine(i2, y + st, i2 + 6, y + st);
                    }
                }
                g.setColor(this.getForeground());
                String line = diss.disassemble(this.computer.getMemory(), addr, true, 30, 50);
                line = line.substring(0, line.length() - 6);
                g.setFont(this.getFont());
                String l1 = "";
                g.setFont(this.f);
                for (i = 0; i < 5; ++i) {
                    l1 = l1 + "" + line.charAt(i);
                }
                g.setColor(Color.gray);
                g.drawString(l1, rect.x + 30, y + a);
                l1 = "";
                for (i = 5; i < 28; ++i) {
                    l1 = l1 + "" + line.charAt(i);
                }
                g.setColor(Color.blue);
                g.setFont(this.fb);
                g.drawString(l1, rect.x + 74, y + a);
                l1 = "";
                for (i = 28; i < line.length(); ++i) {
                    l1 = l1 + "" + line.charAt(i);
                }
                g.setFont(this.fc);
                g.setColor(this.getForeground());
                if (l1.contains(";")) {
                    int aa;
                    if (Debugger.bWinape.isSelected()) {
                        l1 = l1.substring(3);
                    }
                    String[] gg = l1.split(";");
                    String b = gg[1];
                    String AA = "" + b.charAt(0) + b.charAt(1);
                    String BB = "" + b.charAt(3) + b.charAt(4);
                    String CC = "" + b.charAt(6) + b.charAt(7);
                    String DD = "" + b.charAt(9) + b.charAt(10);
                    if (!AA.contains(" ")) {
                        try {
                            aa = Util.hexValue(AA);
                            l1 = aa > 31 && aa < 129 ? l1 + "  " + (char)aa : l1 + "  .";
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!BB.contains(" ")) {
                        try {
                            aa = Util.hexValue(BB);
                            l1 = aa > 31 && aa < 129 ? l1 + "" + (char)aa : l1 + ".";
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!CC.contains(" ")) {
                        try {
                            int aa2 = Util.hexValue(CC);
                            l1 = aa2 > 31 && aa2 < 129 ? l1 + "" + (char)aa2 : l1 + ".";
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!DD.contains(" ")) {
                        try {
                            int aa3 = Util.hexValue(DD);
                            l1 = aa3 > 31 && aa3 < 129 ? l1 + "" + (char)aa3 : l1 + ".";
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (Debugger.bWinape.isSelected()) {
                    l1 = "  ;" + l1;
                }
                g.drawString(l1, rect.x + 220, y + a);
            }
            this.scrollBar.setVisibleAmount(rect.height / h);
        }
        g.setColor(Color.black);
        g.drawRect(rect.x - 1, rect.y - 1, rect.width + 1, rect.height + 1);
    }

    public void setPC(int value) {
        this.pc = value;
        this.setAddress(this.pc, true);
    }

    public void setAddress(int value, boolean scroll) {
        this.address = Math.min(65535, value);
        this.repaint();
        if (scroll) {
            this.inSet = true;
            this.scrollBar.setValue(this.address);
            this.inSet = false;
        }
    }

    public void setAddress(int value) {
        this.setAddress(value, true);
    }

    public int getAddress(int y) {
        Insets insets = this.getInsets();
        return (y = (y - insets.top + 1) / this.lineHeight) < 0 || y >= this.addresses.length ? -1 : this.addresses[y];
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.inSet) {
            switch (e.getValue() - this.address) {
                case 1: {
                    this.nextAddress();
                    break;
                }
                case -1: {
                    this.prevAddress();
                    break;
                }
                case 16: {
                    for (int i = Math.max(1, this.addresses.length - 1); i > 0; --i) {
                        this.nextAddress();
                    }
                    break;
                }
                case -16: {
                    for (int i = Math.max(1, this.addresses.length - 1); i > 0; --i) {
                        this.prevAddress();
                    }
                    break;
                }
                default: {
                    this.setAddress(this.scrollBar.getValue());
                }
            }
            this.scrollBar.setValue(this.address);
        }
    }

    protected void nextAddress() {
        Disassembler diss = this.computer.getDisassembler();
        diss.disassemble(this.computer.getMemory(), this.addresses, false, 0, 0);
        this.setAddress(this.addresses[0], false);
    }

    protected void prevAddress() {
        int result;
        int end = this.addresses[0];
        int addr = end - 6 & 0xFFFF;
        Disassembler diss = this.computer.getDisassembler();
        do {
            result = addr;
            this.addresses[0] = addr;
            diss.disassemble(this.computer.getMemory(), this.addresses, false, 0, 0);
            addr = this.addresses[0];
            if (addr == end) continue;
            addr = result + 1 & 0xFFFF;
        } while (addr != end);
        this.addresses[0] = result;
        this.setAddress(this.addresses[0], false);
    }

    protected void setSelection(int addr, boolean range) {
        if (!range) {
            this.selStart = this.selEnd = addr;
            this.selAnchor = this.selEnd;
        } else if (addr < this.selAnchor) {
            this.selStart = addr;
            this.selEnd = this.selAnchor;
        } else {
            this.selStart = this.selAnchor;
            this.selEnd = addr;
        }
    }

    protected void startTimer(int y) {
        if (this.counter == null) {
            this.counter = new Counter(this, 50L, null);
        }
        this.timerY = y;
    }

    protected void stopTimer() {
        if (this.counter != null) {
            this.counter.stop();
            this.counter = null;
        }
    }

    @Override
    public void timerTick(Counter counter) {
        if (this.counter == counter) {
            if (this.timerY < 0) {
                this.prevAddress();
                this.setSelection(this.address, true);
            } else {
                this.nextAddress();
                this.setSelection(this.addresses[this.addresses.length - 1], true);
            }
            this.scrollBar.setValue(this.address);
            this.repaint();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getButton() == 1) {
            if (e.getID() == 501) {
                this.setSelection(this.getAddress(e.getY()), (e.getModifiers() & 1) != 0);
                Debugger.breakaddress = this.getAddress(e.getY());
                this.requestFocus();
                this.repaint();
            } else if (e.getID() == 502) {
                this.stopTimer();
            }
        } else {
            Debugger.breakaddress = this.getAddress(e.getY());
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && (e.getModifiers() & 0x10) != 0) {
            Dimension size = this.getSize();
            int y = e.getY();
            if (y >= size.height) {
                this.setSelection(this.addresses[this.addresses.length - 1], true);
                this.startTimer(y);
            } else if (y < 0) {
                this.setSelection(this.addresses[0], true);
                this.startTimer(y);
            } else {
                this.setSelection(this.getAddress(e.getY()), true);
                this.stopTimer();
            }
            this.repaint();
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            boolean shift = (e.getModifiers() & 1) != 0;
            switch (e.getKeyCode()) {
                case 36: {
                    this.setSelection(0, shift);
                    break;
                }
                case 35: {
                    this.setSelection(this.maxAddress - 1, shift);
                    break;
                }
                case 38: {
                    this.setSelection(this.address - 1, shift);
                    break;
                }
                case 40: {
                    this.setSelection(this.address + 1, shift);
                    break;
                }
                case 34: {
                    this.setSelection(this.address + 10, shift);
                    break;
                }
                case 33: {
                    this.setSelection(this.address - 10, shift);
                }
            }
        }
        super.processKeyEvent(e);
    }
}

