/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import jemu.core.Util;
import jemu.core.device.Computer;
import jemu.core.device.memory.Memory;
import jemu.ui.Counter;
import jemu.ui.Find;
import jemu.ui.TimerListener;

public class EMemory
extends JComponent
implements KeyListener,
ActionListener,
TimerListener {
    public boolean read = true;
    public boolean any = false;
    public int forcedbank = 192;
    protected static final int INVALID = 0;
    protected static final int HEX1 = 1;
    protected static final int HEX2 = 2;
    protected static final int TEXT = 3;
    protected Memory mem;
    protected Color selBackground = new Color(0, 127, 0);
    protected Color selForeground = Color.white;
    protected boolean textMode = false;
    protected boolean right = false;
    protected int selAnchor;
    protected int selStart;
    protected int selEnd;
    protected int selected;
    protected int addressDigits;
    protected int cw;
    protected int ch;
    protected int left;
    protected Counter counter;
    protected boolean cursor;
    int searchlength;
    int oldhexlength;
    int haschar;
    int lastaddress;
    boolean lasttextmode;
    int lastindex;
    Find find;

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 10) {
            this.keyReleased(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.find.input) {
            if (e.getKeyCode() == 10) {
                int value;
                if (this.find.ashex.isSelected()) {
                    String t = this.find.input.getText();
                    boolean replace = false;
                    while (t.endsWith("  ")) {
                        replace = true;
                        t = t.substring(0, t.length() - 1);
                    }
                    while (t.startsWith(" ")) {
                        t = t.substring(1);
                        replace = true;
                    }
                    if ((t = t.toUpperCase()).contains("G")) {
                        replace = true;
                        t = t.replace("G", "");
                    }
                    if (t.contains("H")) {
                        replace = true;
                        t = t.replace("H", "");
                    }
                    if (t.contains("I")) {
                        replace = true;
                        t = t.replace("I", "");
                    }
                    if (t.contains("J")) {
                        replace = true;
                        t = t.replace("J", "");
                    }
                    if (t.contains("K")) {
                        replace = true;
                        t = t.replace("K", "");
                    }
                    if (t.contains("L")) {
                        replace = true;
                        t = t.replace("L", "");
                    }
                    if (t.contains("M")) {
                        replace = true;
                        t = t.replace("M", "");
                    }
                    if (t.contains("N")) {
                        replace = true;
                        t = t.replace("N", "");
                    }
                    if (t.contains("O")) {
                        replace = true;
                        t = t.replace("O", "");
                    }
                    if (t.contains("P")) {
                        replace = true;
                        t = t.replace("P", "");
                    }
                    if (t.contains("Q")) {
                        replace = true;
                        t = t.replace("Q", "");
                    }
                    if (t.contains("R")) {
                        replace = true;
                        t = t.replace("R", "");
                    }
                    if (t.contains("S")) {
                        replace = true;
                        t = t.replace("S", "");
                    }
                    if (t.contains("T")) {
                        replace = true;
                        t = t.replace("T", "");
                    }
                    if (t.contains("U")) {
                        replace = true;
                        t = t.replace("U", "");
                    }
                    if (t.contains("V")) {
                        replace = true;
                        t = t.replace("V", "");
                    }
                    if (t.contains("W")) {
                        replace = true;
                        t = t.replace("W", "");
                    }
                    if (t.contains("X")) {
                        replace = true;
                        t = t.replace("X", "");
                    }
                    if (t.contains("Y")) {
                        replace = true;
                        t = t.replace("Y", "");
                    }
                    if (t.contains("Z")) {
                        replace = true;
                        t = t.replace("Z", "");
                    }
                    if (t.contains(",")) {
                        replace = true;
                        t = t.replace(",", " ");
                    }
                    if (t.contains(".")) {
                        replace = true;
                        t = t.replace(".", " ");
                    }
                    if (replace) {
                        this.find.input.setText(t);
                    }
                }
                if ((value = this.search(this.find.input.getText(), this.find.ashex.isSelected(), this.find.wild.isSelected())) != 999999) {
                    this.setAddress(value);
                    this.setTextMode(!this.find.ashex.isSelected());
                    this.setSelection(value + this.searchlength, true);
                } else {
                    this.setTextMode(this.lasttextmode);
                    this.setSelection(this.lastaddress, false);
                }
            } else if (this.find.ashex.isSelected()) {
                String t = this.find.input.getText();
                boolean replace = false;
                while (t.endsWith("  ")) {
                    replace = true;
                    t = t.substring(0, t.length() - 1);
                }
                while (t.startsWith(" ")) {
                    t = t.substring(1);
                    replace = true;
                }
                if ((t = t.toUpperCase()).contains("G")) {
                    replace = true;
                    t = t.replace("G", "");
                }
                if (t.contains("H")) {
                    replace = true;
                    t = t.replace("H", "");
                }
                if (t.contains("I")) {
                    replace = true;
                    t = t.replace("I", "");
                }
                if (t.contains("J")) {
                    replace = true;
                    t = t.replace("J", "");
                }
                if (t.contains("K")) {
                    replace = true;
                    t = t.replace("K", "");
                }
                if (t.contains("L")) {
                    replace = true;
                    t = t.replace("L", "");
                }
                if (t.contains("M")) {
                    replace = true;
                    t = t.replace("M", "");
                }
                if (t.contains("N")) {
                    replace = true;
                    t = t.replace("N", "");
                }
                if (t.contains("O")) {
                    replace = true;
                    t = t.replace("O", "");
                }
                if (t.contains("P")) {
                    replace = true;
                    t = t.replace("P", "");
                }
                if (t.contains("Q")) {
                    replace = true;
                    t = t.replace("Q", "");
                }
                if (t.contains("R")) {
                    replace = true;
                    t = t.replace("R", "");
                }
                if (t.contains("S")) {
                    replace = true;
                    t = t.replace("S", "");
                }
                if (t.contains("T")) {
                    replace = true;
                    t = t.replace("T", "");
                }
                if (t.contains("U")) {
                    replace = true;
                    t = t.replace("U", "");
                }
                if (t.contains("V")) {
                    replace = true;
                    t = t.replace("V", "");
                }
                if (t.contains("W")) {
                    replace = true;
                    t = t.replace("W", "");
                }
                if (t.contains("X")) {
                    replace = true;
                    t = t.replace("X", "");
                }
                if (t.contains("Y")) {
                    replace = true;
                    t = t.replace("Y", "");
                }
                if (t.contains("Z")) {
                    replace = true;
                    t = t.replace("Z", "");
                }
                if (t.contains(",")) {
                    replace = true;
                    t = t.replace(",", " ");
                }
                if (t.contains(".")) {
                    replace = true;
                    t = t.replace(".", " ");
                }
                if (replace) {
                    this.find.input.setText(t);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.find.ashex) {
            String search = this.find.input.getText();
            if (this.find.ashex.isSelected()) {
                try {
                    String result = "";
                    byte[] con = search.getBytes("UTF-8");
                    for (int i = 0; i < con.length; ++i) {
                        result = this.find.wild.isSelected() && (char)con[i] == '?' ? result + "? " : result + Util.hex(con[i]) + " ";
                    }
                    this.find.input.setText(result);
                }
                catch (Exception f) {}
            } else {
                String[] bytes = search.split(" ");
                String result = "";
                byte[] values = new byte[bytes.length];
                for (int i = 0; i < bytes.length; ++i) {
                    try {
                        values[i] = (byte)Util.hexValue(bytes[i].toUpperCase());
                        result = result + "" + (char)values[i];
                        this.searchlength = values.length - 1;
                        continue;
                    }
                    catch (Exception f) {
                        try {
                            values[i] = (byte)bytes[i].charAt(0);
                            result = result + "" + (char)values[i];
                            continue;
                        }
                        catch (Exception g) {
                            // empty catch block
                        }
                    }
                }
                this.find.input.setText(result);
            }
        }
        if (e.getSource() == this.find.search) {
            int value = this.search(this.find.input.getText(), this.find.ashex.isSelected(), this.find.wild.isSelected());
            if (value != 999999) {
                this.setAddress(value);
                this.setTextMode(!this.find.ashex.isSelected());
                this.setSelection(value + this.searchlength, true);
            } else {
                this.setTextMode(this.lasttextmode);
                this.setSelection(this.lastaddress, false);
            }
        }
    }

    public EMemory() {
        this.enableEvents(52L);
        this.setBackground(Color.white);
        this.setForeground(new Color(0, 0, 128));
        this.setLayout(new BorderLayout());
        this.setFont(new Font("Monospaced", 0, 12));
        this.setAutoscrolls(true);
        this.setFocusable(true);
        this.setDoubleBuffered(false);
    }

    public void setMemory(Memory value) {
        this.mem = value;
        this.addressDigits = Math.max(4, Integer.toHexString(this.mem.getAddressSize() - 1).length());
    }

    public void setComputer(Computer value) {
        this.setMemory(value == null ? null : value.getMemory());
    }

    public byte[] getMem() {
        byte[] buffer = new byte[65536];
        for (int i = 0; i < 65536; ++i) {
            buffer[i] = this.read ? (byte)this.mem.readByte(i, null) : (this.any ? (byte)this.mem.readWriteByte(i, null, this.forcedbank, true) : (byte)this.mem.readWriteByte(i, null));
        }
        return buffer;
    }

    public int indexOf(byte[] pattern, boolean wild) {
        int[] failure = EMemory.computeFailure(pattern, wild);
        int j = 0;
        byte[] data = this.getMem();
        if (wild) {
            for (int i = this.lastindex; i < data.length; ++i) {
                while (j > 0 && pattern[j] != data[i] && pattern[j] != 63) {
                    j = failure[j - 1];
                }
                if (pattern[j] == data[i] || pattern[j] == 63) {
                    ++j;
                }
                if (j != pattern.length) continue;
                this.lastindex = i - pattern.length + 2;
                return i - pattern.length + 1;
            }
        } else {
            for (int i = this.lastindex; i < data.length; ++i) {
                while (j > 0 && pattern[j] != data[i]) {
                    j = failure[j - 1];
                }
                if (pattern[j] == data[i]) {
                    ++j;
                }
                if (j != pattern.length) continue;
                this.lastindex = i - pattern.length + 2;
                return i - pattern.length + 1;
            }
        }
        this.lastindex = 0;
        return 999999;
    }

    private static int[] computeFailure(byte[] pattern, boolean wild) {
        int[] failure = new int[pattern.length];
        int j = 0;
        if (wild) {
            for (int i = 1; i < pattern.length; ++i) {
                while (j > 0 && pattern[j] != pattern[i] && pattern[j] != 63) {
                    j = failure[j - 1];
                }
                if (pattern[j] == pattern[i] || pattern[j] == 63) {
                    // empty if block
                }
                failure[i] = ++j;
            }
        } else {
            for (int i = 1; i < pattern.length; ++i) {
                while (j > 0 && pattern[j] != pattern[i]) {
                    j = failure[j - 1];
                }
                if (pattern[j] == pattern[i]) {
                    // empty if block
                }
                failure[i] = ++j;
            }
        }
        return failure;
    }

    public int search(String input, boolean ashex, boolean wild) {
        if (ashex) {
            input = input.replace(",", " ");
            while (input.startsWith(" ")) {
                input = input.substring(1);
            }
            while (input.endsWith(" ")) {
                input = input.substring(0, input.length() - 1);
            }
            String[] bytes = input.split(" ");
            byte[] values = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                try {
                    values[i] = (byte)Util.hexValue(bytes[i].toUpperCase());
                    this.searchlength = values.length - 1;
                    continue;
                }
                catch (Exception e) {
                    try {
                        values[i] = (byte)bytes[i].charAt(0);
                        continue;
                    }
                    catch (Exception g) {
                        System.err.println("Search for hex data failed...");
                        this.lastindex = 0;
                        return 999999;
                    }
                }
            }
            return this.indexOf(values, wild);
        }
        try {
            byte[] search = input.getBytes("UTF-8");
            this.searchlength = search.length - 1;
            return this.indexOf(search, wild);
        }
        catch (Exception e) {
            this.lastindex = 0;
            return 999999;
        }
    }

    public void find() {
        if (this.find == null) {
            this.find = new Find();
            this.find.search.addActionListener(this);
            this.find.ashex.addActionListener(this);
            this.find.input.addKeyListener(this);
        }
        this.find.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        byte[] buff = new byte[16];
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mem != null) {
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.getForeground());
            int a = fm.getAscent();
            this.ch = fm.getHeight();
            Rectangle rect = g.getClipBounds();
            Insets insets = this.getInsets();
            int row = (rect.y - insets.top) / this.ch;
            int address = row * 16;
            for (int y = insets.top + row * this.ch; y < rect.y + rect.height; y += fm.getHeight()) {
                String line;
                if (this.addressDigits > 4) {
                    line = Util.hex(address);
                    if (this.addressDigits < 8) {
                        line = line.substring(8 - this.addressDigits);
                    }
                } else {
                    line = Util.hex((short)address);
                }
                line = line + ": ";
                int w = fm.stringWidth(line);
                this.cw = w / line.length();
                this.left = w += insets.left;
                g.setColor(this.getForeground());
                int ya = y + a;
                g.drawString(line, insets.left + 4, ya);
                for (int i = 0; i < 16; ++i) {
                    buff[i] = this.read ? (byte)this.mem.readByte(address + i, null) : (this.any ? (byte)this.mem.readWriteByte(address + i, null, this.forcedbank, true) : (byte)this.mem.readWriteByte(address + i, null));
                }
                line = Util.dumpBytes(buff, 0, 16, false, true, false);
                int start = 0;
                if (this.selStart < address + 16 && this.selEnd >= address) {
                    if (this.right) {
                        int index = (this.selected - address) * 3 + 1;
                        line = line.substring(0, index - 1) + line.charAt(index) + ' ' + line.substring(index + 1);
                    } else {
                        int end;
                        if (this.textMode) {
                            int textStart = line.length() - 16;
                            start = Math.max(textStart, textStart + this.selStart - address);
                            g.drawString(line.substring(0, start), w, ya);
                            w += fm.stringWidth(line.substring(0, start));
                            end = Math.min(line.length(), textStart + this.selEnd - address + 1);
                        } else {
                            start = Math.max(0, (this.selStart - address) * 3);
                            if (start > 0) {
                                g.drawString(line.substring(0, start), w, ya);
                                w += fm.stringWidth(line.substring(0, start));
                            }
                            end = Math.min(47, (this.selEnd - address + 1) * 3 - 1);
                        }
                        int ww = fm.stringWidth(line.substring(start, end));
                        g.setColor(this.selBackground);
                        g.fillRect(w, y, ww, this.ch);
                        g.setColor(this.selForeground);
                        g.drawString(line.substring(start, end), w, ya);
                        w += ww;
                        start = end;
                        g.setColor(this.getForeground());
                    }
                }
                if (start != line.length()) {
                    g.drawString(line.substring(start), w, ya);
                }
                if ((address += 16) >= this.mem.getAddressSize()) break;
            }
            if (this.cursor) {
                Rectangle cursor = this.getRect(this.selected);
                if (this.right) {
                    cursor.x += this.cw;
                }
                g.setXORMode(Color.green);
                g.fillRect(cursor.x, cursor.y, cursor.width, cursor.height);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        return new Dimension(fm.charWidth('0') * (66 + this.addressDigits), fm.getHeight() * (this.mem == null ? 4096 : this.mem.getAddressSize() >> 4));
    }

    protected Point getCharacterCell(MouseEvent e) {
        Insets insets = this.getInsets();
        return new Point(e.getX() < this.left ? -1 : (e.getX() - this.left) / this.cw, (e.getY() - insets.top) / this.ch);
    }

    protected Rectangle getRect(int addr) {
        int y = (addr >> 4) * this.ch + this.getInsets().top;
        int x = addr & 0xF;
        x = this.textMode ? this.left + (x + 50) * this.cw : this.left + x * this.cw * 3;
        return new Rectangle(x, y, this.textMode ? this.cw : this.cw * 2, this.ch);
    }

    protected int getClickSection(Point ch) {
        int result = 0;
        if (ch.x >= 50) {
            ch.x -= 50;
            result = 3;
        } else if (ch.x >= 0) {
            switch (ch.x % 3) {
                case 0: {
                    result = 1;
                    break;
                }
                case 1: {
                    result = 2;
                }
            }
            ch.x /= 3;
        }
        ch.x = Math.max(0, Math.min(ch.x, 15));
        return result;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0 && e.getID() == 501) {
            this.requestFocus();
            Point p = this.getCharacterCell(e);
            int section = this.getClickSection(p);
            this.lasttextmode = section == 3;
            this.setTextMode(section == 3);
            this.lastaddress = this.lastindex = (p.y << 4) + p.x;
            this.setSelection((p.y << 4) + p.x, false);
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0 && e.getID() == 506) {
            Point p = this.getCharacterCell(e);
            int section = this.getClickSection(p);
            if (this.textMode && section != 3) {
                p.x = 0;
            } else if (!this.textMode && section == 3) {
                p.x = 15;
            }
            this.lastaddress = this.lastindex = (p.y << 4) + p.x;
            int addr = this.lastindex;
            this.setSelection(addr, true);
        }
        super.processMouseMotionEvent(e);
    }

    public void setTextMode(boolean value) {
        if (this.textMode != value) {
            this.textMode = value;
            this.right = false;
            this.repaint();
        }
    }

    public int getPageSize() {
        return Math.max(1, this.getSize().height / this.ch);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            boolean shift = (e.getModifiers() & 1) != 0;
            switch (e.getKeyCode()) {
                case 36: {
                    this.setSelection(0, shift);
                    break;
                }
                case 35: {
                    this.setSelection(this.mem.getAddressSize() - 1, shift);
                    break;
                }
                case 37: {
                    this.setSelection(this.selected - 1, shift);
                    break;
                }
                case 39: {
                    this.setSelection(this.selected + 1, shift);
                    break;
                }
                case 38: {
                    if (this.selected <= 15) break;
                    this.setSelection(this.selected - 16, shift);
                    break;
                }
                case 40: {
                    if (this.selected >= this.mem.getAddressSize() - 16) break;
                    this.setSelection(this.selected + 16, shift);
                    break;
                }
                case 34: {
                    this.setSelection(this.selected + this.getPageSize(), shift);
                    break;
                }
                case 33: {
                    this.setSelection(this.selected - this.getPageSize(), shift);
                    break;
                }
                case 9: {
                    if ((e.getModifiers() & 2) == 0) break;
                    this.setTextMode(!this.textMode);
                }
            }
        } else if (e.getID() == 400) {
            char ch = e.getKeyChar();
            this.repaint(this.getRect(this.selected));
            if (this.textMode) {
                if (ch < ' ' || ch < '\u007f') {
                    // empty if block
                }
                if (!this.read) {
                    if (this.any) {
                        System.out.println("Writing to bank " + Util.hex(this.forcedbank));
                        this.mem.writeByte(this.selected, ch, this.forcedbank, true);
                    } else {
                        this.mem.writeByte(this.selected, ch);
                    }
                }
                --this.selStart;
                this.setAddress(Math.min(this.mem.getAddressSize() - 1, this.selected + 1));
            } else {
                int hex = "0123456789ABCDEFabcdef".indexOf(ch);
                if (hex != -1) {
                    if (hex > 15) {
                        hex -= 6;
                    }
                    if (this.right = !this.right) {
                        if (!this.read) {
                            if (this.any) {
                                System.out.println("Writing to bank " + Util.hex(this.forcedbank));
                                this.mem.writeByte(this.selected, hex, this.forcedbank, true);
                            } else {
                                this.mem.writeByte(this.selected, hex);
                            }
                        }
                    } else {
                        if (!this.read) {
                            if (this.any) {
                                System.out.println("Writing to bank " + Util.hex(this.forcedbank));
                                this.mem.writeByte(this.selected, this.mem.readWriteByte(this.selected, null, this.forcedbank, true) << 4 | hex, this.forcedbank, true);
                            } else {
                                this.mem.writeByte(this.selected, this.mem.readWriteByte(this.selected) << 4 | hex);
                            }
                        }
                        --this.selStart;
                        this.setAddress(Math.min(this.mem.getAddressSize() - 1, this.selected + 1));
                    }
                }
            }
            this.repaint(this.getRect(this.selected));
        }
        this.cursor = this.counter != null;
        super.processKeyEvent(e);
    }

    protected void setSelection(int addr) {
        this.setSelection(addr, true);
    }

    protected void setSelection(int addr, boolean range) {
        int start;
        int end;
        this.selected = addr = Math.max(0, Math.min(this.mem.getAddressSize() - 1, addr));
        if (!range) {
            end = this.selAnchor = addr;
            start = this.selAnchor;
        } else if (addr < this.selAnchor) {
            start = addr;
            end = this.selAnchor;
        } else {
            end = addr;
            start = this.selAnchor;
        }
        if (this.right || start != this.selStart || end != this.selEnd) {
            this.right = false;
            this.selStart = start;
            this.selEnd = end;
            this.scrollRectToVisible(this.getRect(addr));
            this.repaint();
        }
    }

    public void setAddress(int addr) {
        this.setSelection(addr, false);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            if (this.counter == null) {
                this.counter = new Counter(this, 250L, null);
            }
            this.cursor = true;
        } else if (e.getID() == 1005 && this.counter != null) {
            if (this.right) {
                this.right = false;
                this.repaint(this.getRect(this.selected));
            }
            this.counter.stop();
            this.counter = null;
            this.timerTick(null);
        }
        super.processFocusEvent(e);
    }

    @Override
    public void timerTick(Counter counter) {
        this.cursor = !this.cursor && counter != null;
        this.repaint(this.getRect(this.selected));
    }
}

