/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.border.BevelBorder;
import jemu.core.Util;
import jemu.core.device.Computer;
import jemu.ui.Counter;
import jemu.ui.TimerListener;
import jemu.util.diss.Disassembler;

public class EStackPointer
extends JComponent
implements MouseWheelListener,
AdjustmentListener,
TimerListener {
    public boolean read = true;
    public boolean any = false;
    public int forcedbank = 192;
    protected JScrollBar scrollBar = new JScrollBar(1);
    protected int address = 0;
    protected int maxAddress = 65535;
    protected int pc = 0;
    protected Computer computer;
    protected int lineHeight = 0;
    protected int[] addresses = new int[0];
    protected int selAnchor = 0;
    protected int selStart = 0;
    protected int selEnd = 0;
    protected int timerY = 0;
    protected Counter counter = null;
    protected boolean inSet = false;
    protected final Color hex = new Color(0, 128, 0);

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getUnitsToScroll() > 0) {
            if (this.scrollBar.getValue() < this.scrollBar.getMaximum() - 1) {
                this.scrollBar.setValue(this.scrollBar.getValue() + 1);
            }
        } else if (this.scrollBar.getValue() > 1) {
            this.scrollBar.setValue(this.scrollBar.getValue() - 1);
        }
    }

    public EStackPointer() {
        this.enableEvents(48L);
        this.setBackground(Color.white);
        this.setForeground(new Color(0, 0, 0));
        this.setBorder(new BevelBorder(1));
        this.setFont(new Font("Monospaced", 0, 12));
        this.setLayout(new BorderLayout());
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.setBlockIncrement(16);
        this.scrollBar.setAutoscrolls(true);
        this.add((Component)this.scrollBar, "East");
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        this.setDoubleBuffered(false);
    }

    public void setComputer(Computer value) {
        this.computer = value;
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(65552);
        this.scrollBar.setVisibleAmount(16);
        this.maxAddress = this.computer.getMemory().getAddressSize() - 1;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Disassembler diss;
        Insets insets = this.getInsets();
        Rectangle rect = new Rectangle(insets.left + 1, insets.top + 1, this.getWidth() - this.scrollBar.getWidth() - insets.left - insets.right - 2, this.getHeight() - insets.top - insets.bottom - 2);
        g.setColor(this.getBackground());
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setFont(this.getFont());
        FontMetrics fm = g.getFontMetrics();
        if (this.computer != null && (diss = this.computer.getDisassembler()) != null) {
            diss.read = this.read;
            diss.any = this.any;
            diss.forcedbank = this.forcedbank;
            int a = fm.getAscent();
            int[] addr = new int[]{this.address};
            int h = this.lineHeight = fm.getHeight();
            this.addresses = new int[(rect.height + h - 1) / h];
            int n = 0;
            int val = 0;
            int gr = 0;
            for (int y = rect.y; y < rect.y + rect.height; y += fm.getHeight()) {
                val = addr[0] + gr & 0xFFFF;
                gr += 2;
                if (val == this.computer.getProcessor().getStackPointer()) {
                    g.setColor(Color.lightGray);
                    g.fillRect(rect.x, y, rect.width, fm.getHeight());
                    g.setColor(Color.blue);
                } else {
                    g.setColor(Color.white);
                    g.fillRect(rect.x, y, rect.width, fm.getHeight());
                    g.setColor(Color.black);
                }
                this.addresses[n++] = addr[0];
                int va = this.computer.getMemory().readByte(val + 1 & 0xFFFF) & 0xFF;
                int vb = this.computer.getMemory().readByte(val & 0xFFFF) & 0xFF;
                String line = " " + Util.hex((short)val);
                String l2 = Util.hex((byte)va) + Util.hex((byte)vb);
                String l3 = "";
                l3 = va > 31 && va < 129 ? l3 + "" + (char)va : l3 + ".";
                l3 = vb > 31 && vb < 129 ? l3 + "" + (char)vb : l3 + ".";
                g.setColor(Color.BLACK);
                g.drawString(line, rect.x, y + a);
                g.setColor(Color.BLUE);
                g.drawString(l2, rect.x + 50, y + a);
                g.setColor(this.hex);
                g.drawString(l3, rect.x + 90, y + a);
            }
            this.scrollBar.setVisibleAmount(rect.height / h);
        }
        g.setColor(Color.black);
        g.drawRect(rect.x - 1, rect.y - 1, rect.width + 1, rect.height + 1);
    }

    public void setSP(int value) {
        this.pc = value;
        this.setAddress(this.pc, true);
    }

    public void setAddress(int value, boolean scroll) {
        this.address = Math.min(65535, value);
        this.repaint();
        if (scroll) {
            this.inSet = true;
            this.scrollBar.setValue(this.address);
            this.inSet = false;
        }
    }

    public void setAddress(int value) {
        this.setAddress(value, true);
    }

    public int getAddress(int y) {
        Insets insets = this.getInsets();
        return (y = (y - insets.top + 1) / this.lineHeight) < 0 || y >= this.addresses.length ? -1 : this.addresses[y];
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.inSet) {
            switch (e.getValue() - this.address) {
                case 1: {
                    this.nextAddress();
                    break;
                }
                case -1: {
                    this.prevAddress();
                    break;
                }
                case 16: {
                    for (int i = Math.max(1, this.addresses.length - 1); i > 0; --i) {
                        this.nextAddress();
                    }
                    break;
                }
                case -16: {
                    for (int i = Math.max(1, this.addresses.length - 1); i > 0; --i) {
                        this.prevAddress();
                    }
                    break;
                }
                default: {
                    this.setAddress(this.scrollBar.getValue());
                }
            }
            this.scrollBar.setValue(this.address);
        }
    }

    protected void nextAddress() {
        this.addresses[0] = this.addresses[0] + 2;
        this.setAddress(this.addresses[0] & 0xFFFF, false);
    }

    protected void prevAddress() {
        this.addresses[0] = this.addresses[0] - 2;
        this.setAddress(this.addresses[0] & 0xFFFF, false);
    }

    protected void setSelection(int addr, boolean range) {
        if (!range) {
            this.selStart = this.selEnd = addr;
            this.selAnchor = this.selEnd;
        } else if (addr < this.selAnchor) {
            this.selStart = addr;
            this.selEnd = this.selAnchor;
        } else {
            this.selStart = this.selAnchor;
            this.selEnd = addr;
        }
    }

    protected void startTimer(int y) {
        if (this.counter == null) {
            this.counter = new Counter(this, 50L, null);
        }
        this.timerY = y;
    }

    protected void stopTimer() {
        if (this.counter != null) {
            this.counter.stop();
            this.counter = null;
        }
    }

    @Override
    public void timerTick(Counter counter) {
        if (this.counter == counter) {
            if (this.timerY < 0) {
                this.prevAddress();
                this.setSelection(this.address, true);
            } else {
                this.nextAddress();
                this.setSelection(this.addresses[this.addresses.length - 1], true);
            }
            this.scrollBar.setValue(this.address);
            this.repaint();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getButton() == 1) {
            if (e.getID() == 501) {
                this.setSelection(this.getAddress(e.getY()), (e.getModifiers() & 1) != 0);
                this.requestFocus();
                this.repaint();
            } else if (e.getID() == 502) {
                this.stopTimer();
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && (e.getModifiers() & 0x10) != 0) {
            Dimension size = this.getSize();
            int y = e.getY();
            if (y >= size.height) {
                this.setSelection(this.addresses[this.addresses.length - 1], true);
                this.startTimer(y);
            } else if (y < 0) {
                this.setSelection(this.addresses[0], true);
                this.startTimer(y);
            } else {
                this.setSelection(this.getAddress(e.getY()), true);
                this.stopTimer();
            }
            this.repaint();
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            boolean shift = (e.getModifiers() & 1) != 0;
            switch (e.getKeyCode()) {
                case 36: {
                    this.setSelection(0, shift);
                    break;
                }
                case 35: {
                    this.setSelection(this.maxAddress - 1, shift);
                    break;
                }
                case 38: {
                    this.setSelection(this.address - 1, shift);
                    break;
                }
                case 40: {
                    this.setSelection(this.address + 1, shift);
                    break;
                }
                case 34: {
                    this.setSelection(this.address + 10, shift);
                    break;
                }
                case 33: {
                    this.setSelection(this.address - 10, shift);
                }
            }
        }
        super.processKeyEvent(e);
    }
}

