/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class TransparentBackground
extends JComponent
implements ComponentListener,
WindowFocusListener,
Runnable {
    private JFrame _frame;
    private BufferedImage _background;
    private long _lastUpdate = 0L;
    private boolean _refreshRequested = true;
    private Robot _robot;
    private Rectangle _screenRect;
    private ConvolveOp _blurOp;
    public boolean running;
    boolean updated = false;
    boolean paintup = false;

    public TransparentBackground(JFrame frame) {
        this._frame = frame;
        try {
            this._robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
            return;
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this._screenRect = new Rectangle(dim.width, dim.height);
        float[] my_kernel = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};
        this._blurOp = new ConvolveOp(new Kernel(3, 3, my_kernel));
        this.updateBackground();
        this._frame.addComponentListener(this);
        this._frame.addWindowFocusListener(this);
        new Thread(this).start();
    }

    protected void updateBackground() {
        this.setVisible(false);
        if (!this.updated) {
            this._background = this._robot.createScreenCapture(this._screenRect);
            this.paintup = false;
        } else {
            this.paintup = true;
        }
        this.updated = true;
        this.setVisible(true);
    }

    protected void refresh() {
        if (this._frame.isVisible() && this.isVisible()) {
            this.repaint();
            this._refreshRequested = true;
            this._lastUpdate = System.currentTimeMillis();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        try {
            Point pos = this.getLocationOnScreen();
            BufferedImage buf = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            if (!this.paintup) {
                buf.getGraphics().drawImage(this._background, -pos.x, -pos.y, null);
                BufferedImage img = this._blurOp.filter(buf, null);
                g2.drawImage((Image)img, 0, 0, this);
            } else {
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, this._background.getWidth(), this._background.getHeight());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setQuit() {
        this.running = false;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.refresh();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.refresh();
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                Thread.sleep(100L);
                long now = System.currentTimeMillis();
                if (!this._refreshRequested || now - this._lastUpdate <= 1000L) continue;
                if (this._frame.isVisible()) {
                    Point location = this._frame.getLocation();
                    this._frame.setLocation(-this._frame.getWidth(), -this._frame.getHeight());
                    this.updateBackground();
                    this._frame.setLocation(location);
                    this.refresh();
                }
                this._lastUpdate = now;
                this._refreshRequested = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Transparent Window");
        TransparentBackground bg = new TransparentBackground(frame);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(bg);
        frame.pack();
        frame.setSize(200, 200);
        frame.setLocation(500, 500);
        frame.setVisible(true);
    }
}

