/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.EtchedBorder;
import jemu.ui.paint.importPCX;
import jemu.ui.paint.importTGA;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    importTGA tga;
    importPCX pcx;
    final URL cpcicon = this.getClass().getResource("cpc.gif");
    ImageIcon thumbnail = null;
    File file = null;

    public ImagePreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(200, 100));
        this.setBorder(new EtchedBorder());
        fc.addPropertyChangeListener(this);
    }

    public void loadImage() {
        try {
            if (this.file == null) {
                this.thumbnail = null;
                return;
            }
            Image buffer = null;
            try {
                if (this.file.getPath().toLowerCase().endsWith(".scr")) {
                    buffer = this.getToolkit().getImage(this.cpcicon);
                } else if (this.file.getPath().toLowerCase().endsWith(".tga")) {
                    if (this.tga == null) {
                        this.tga = new importTGA();
                    }
                    buffer = this.tga.getImage(this.file.getPath(), true);
                } else if (this.file.getPath().toLowerCase().endsWith(".pcx")) {
                    if (this.pcx == null) {
                        this.pcx = new importPCX();
                    }
                    buffer = importPCX.getImage(this.file.getPath());
                } else {
                    buffer = ImageIO.read(new File(this.file.getPath()));
                }
            }
            catch (Exception e) {
                buffer = this.getToolkit().getImage(this.cpcicon);
            }
            ImageIcon tmpIcon = new ImageIcon(buffer);
            if (tmpIcon != null) {
                this.thumbnail = tmpIcon.getIconWidth() > 190 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(190, -1, 1)) : tmpIcon;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

