/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import com.jhlabs.image.BumpFilter;
import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.DitherFilter;
import com.jhlabs.image.GainFilter;
import com.jhlabs.image.HSBAdjustFilter;
import com.jhlabs.image.QuantizeFilter;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jemu.core.Util;
import jemu.settings.DSettings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Display;
import jemu.ui.JEMU;
import jemu.ui.Switches;
import jemu.ui.paint.CPCize;
import jemu.ui.paint.ImageFileView;
import jemu.ui.paint.ImageFilter;
import jemu.ui.paint.ImagePreview;
import jemu.ui.paint.ImageProcessor;
import jemu.ui.paint.RGBColor;
import jemu.ui.paint.importPCX;
import jemu.ui.paint.importTGA;
import jemu.ui.paint.miniFont;
import jemu.ui.paint.overscanPaint;

public class OverscanCanvas
extends JLabel
implements MouseListener,
MouseMotionListener {
    public int zoomvalue = 4;
    public boolean zoomit = false;
    protected int xoffset;
    protected int yoffset;
    public boolean setzoom = false;
    public boolean overscan = true;
    Color crossfade1;
    Color crossfade2;
    public boolean stretch = false;
    JFrame zoomframe;
    Canvas zoomarea;
    BufferedImage zoompic;
    CPCize lut = new CPCize();
    RGBColor color = new RGBColor();
    public static boolean green = false;
    public int rasterval = 120;
    int[] CPCpalette;
    public static boolean blur = false;
    public static boolean sharp = false;
    float ninth = 0.25f;
    public static final float[] SHARPEN3x3 = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    public static final float[] BLUR3x3 = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};
    int[] greenscreen = new int[]{0, 2, 3, 5, 7, 9, 10, 12, 14, 15, 17, 19, 20, 22, 24, 26};
    BufferedImageOp blurOp = new ConvolveOp(new Kernel(3, 3, BLUR3x3));
    BufferedImageOp sharpOp = new ConvolveOp(new Kernel(3, 3, SHARPEN3x3));
    public String importname = null;
    protected int importscr = 0;
    String[] output = new String[]{""};
    String minitext = "";
    int textpen = 1;
    int smoothpen = 16;
    int minisize = 0;
    int transback = 16;
    boolean debug = false;
    public static int filled;
    boolean resPal = false;
    int RedPixel;
    int GreenPixel;
    int BluePixel;
    int startup = 1;
    miniFont minifont = new miniFont();
    JCheckBox restorePal = new JCheckBox("Restore palette");
    public Color random = new Color(20, 60, 90);
    public int[] realInks = new int[27];
    public int checkPal = 0;
    boolean flip;
    public int transpen = 17;
    int shapeX;
    int shapeY;
    int shapeW;
    int shapeH;
    public int bold = 0;
    public int italic = 0;
    byte[] input;
    public boolean gray = false;
    String loadname = "";
    public String showname = "JavaCPC Paint 1.0";
    BufferedImage posterizedImage = null;
    BufferedImage scrollImage = null;
    BufferedImage sourceImage = null;
    BufferedImage loadedImage = null;
    BufferedImage shapeBrush = null;
    BufferedImage CPCImage = null;
    BufferedImage CPCScreen = null;
    boolean doCycle = true;
    static int recalculate;
    int[] counted;
    protected String[] cpccolors = new String[]{"Black", "Blue", "Bright Blue", "Red", "Magenta", "Mauve", "Bright Red", "Purple", "Bright Magenta", "Green", "Cyan", "Sky Blue", "Yellow", "White", "Pastel Blue", "Orange", "Pink", "Pastel Magenta", "Bright Green", "Sea Green", "Bright Cyan", "Lime", "Pastel Green", "Pastel Cyan", "Bright Yellow", "Pastel Yellow", "Bright White"};
    protected static int[] GateArrayINKs;
    protected static int[] GateArrayColors;
    protected static final int[] GateArrayOrg;
    protected static final int[] GateArrayGreens;
    protected Color[] Col = new Color[27];
    private final int CANVAS_WIDTH = 768;
    private final int CANVAS_HEIGHT = 544;
    public int bright = 100;
    public int contrast = 100;
    public boolean keep = false;
    public boolean keepinks = false;
    public static boolean horizontal;
    public int scroll = 0;
    public int scrollb = 0;
    int cycled = 0;
    protected boolean paintscreen = false;
    public int CPCRed;
    public int CPCBlue;
    public int CPCGreen;
    int[] palcount;
    int[] outcount = new int[27];
    public String fontname = "Verdana";
    public int[] undo = new int[65535];
    final URL cursor1 = this.getClass().getResource("icons/cursor2.gif");
    final Image Cursor1 = this.getToolkit().getImage(this.cursor1);
    final URL cursor2 = this.getClass().getResource("icons/cursor1.gif");
    final Image Cursor2 = this.getToolkit().getImage(this.cursor2);
    final Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(this.Cursor1, new Point(15, 15), "Cursor");
    public int MODE_PAINT = 1;
    public int MODE_TEXT = 2;
    public int MODE_LINE = 3;
    public int MODE_RECTANGLE = 4;
    public int MODE_CIRCLE = 5;
    public int MODE_FRECT = 6;
    public int MODE_FCIRCLE = 7;
    public int MODE_IMPORT = 8;
    public int MODE_COPY = 9;
    public int MODE_PASTE = 10;
    public int MODE_MINITEXT = 11;
    public int MODE_FILL = 12;
    public int MODE = this.MODE_PAINT;
    public int textX;
    public int textY;
    public String text = "";
    public int textsize = 30;
    boolean draw = false;
    private int lineX;
    private int lineY;
    private int toX;
    private int toY;
    protected boolean paint;
    private int lastX;
    private int lastY;
    public int pen = 1;
    public int mode = GateArray.getSMode();
    protected boolean painted = true;
    protected int zoomx;
    protected int zoomy;
    int mx;
    int my;
    int count = 0;
    JFileChooser chooser = new JFileChooser();
    boolean scr;
    public static boolean plusmode;
    protected byte[] pluspalette = new byte[32];
    float[] gain = new float[]{-1.0f, -0.99f, -0.98f, -0.97f, -0.96f, -0.95f, -0.94f, -0.93f, -0.92f, -0.91f, -0.9f, -0.89f, -0.88f, -0.87f, -0.86f, -0.85f, -0.84f, -0.83f, -0.82f, -0.81f, -0.8f, -0.79f, -0.78f, -0.77f, -0.76f, -0.75f, -0.74f, -0.73f, -0.72f, -0.71f, -0.7f, -0.69f, -0.68f, -0.67f, -0.66f, -0.65f, -0.64f, -0.63f, -0.62f, -0.61f, -0.6f, -0.59f, -0.58f, -0.57f, -0.56f, -0.55f, -0.54f, -0.53f, -0.52f, -0.51f, -0.5f, -0.49f, -0.48f, -0.47f, -0.46f, -0.45f, -0.44f, -0.43f, -0.42f, -0.41f, -0.4f, -0.39f, -0.38f, -0.37f, -0.36f, -0.35f, -0.34f, -0.33f, -0.32f, -0.31f, -0.3f, -0.29f, -0.28f, -0.27f, -0.26f, -0.25f, -0.24f, -0.23f, -0.22f, -0.21f, -0.2f, -0.19f, -0.18f, -0.17f, -0.16f, -0.15f, -0.14f, -0.13f, -0.12f, -0.11f, -0.1f, -0.09f, -0.08f, -0.07f, -0.06f, -0.05f, -0.04f, -0.03f, -0.02f, -0.01f, 0.0f, 0.01f, 0.02f, 0.03f, 0.04f, 0.05f, 0.06f, 0.07f, 0.08f, 0.09f, 0.1f, 0.11f, 0.12f, 0.13f, 0.14f, 0.15f, 0.16f, 0.17f, 0.18f, 0.19f, 0.2f, 0.21f, 0.22f, 0.23f, 0.24f, 0.25f, 0.26f, 0.27f, 0.28f, 0.29f, 0.3f, 0.31f, 0.32f, 0.33f, 0.34f, 0.35f, 0.36f, 0.37f, 0.38f, 0.39f, 0.4f, 0.41f, 0.42f, 0.43f, 0.44f, 0.45f, 0.46f, 0.47f, 0.48f, 0.49f, 0.5f, 0.51f, 0.52f, 0.53f, 0.54f, 0.55f, 0.56f, 0.57f, 0.58f, 0.59f, 0.6f, 0.61f, 0.62f, 0.63f, 0.64f, 0.65f, 0.66f, 0.67f, 0.68f, 0.69f, 0.7f, 0.71f, 0.72f, 0.73f, 0.74f, 0.75f, 0.76f, 0.77f, 0.78f, 0.79f, 0.8f, 0.81f, 0.82f, 0.83f, 0.84f, 0.85f, 0.86f, 0.87f, 0.88f, 0.89f, 0.9f, 0.91f, 0.92f, 0.93f, 0.94f, 0.95f, 0.96f, 0.97f, 0.98f, 0.99f, 1.0f};
    ContrastFilter ctr = new ContrastFilter();
    GainFilter gfilt = new GainFilter();
    HSBAdjustFilter hsb = new HSBAdjustFilter();
    public int gainvalue = 150;
    public int sat = 100;
    public int hue = 100;
    int conv;
    importTGA tga;
    importPCX pcx;
    int[] palette = new int[16];
    int[] greypal = new int[]{3, 25, 16, 7, 6, 5, 10, 11, 13, 15, 0, 18, 20, 22, 23, 1};
    public double zoomfactor = 1.0;
    int oldscroll = 0;
    int oldscroll2 = 0;
    protected BufferedImage buffershow;
    public boolean dlevel;
    DitherFilter Dithering = new DitherFilter();
    BumpFilter bump = new BumpFilter();
    public boolean dobump;
    public boolean[] lockPEN = new boolean[16];
    int[] colours = new int[4096];
    int[] used = new int[4096];
    BufferedImage pseudo = new BufferedImage(768, 544, 1);
    BufferedImage pali;
    int[] pals = new int[]{0, 15, 8, 4, 1, 2, 3, 5, 6, 7, 9, 10, 11, 12, 13, 14};
    protected int autoIndex = 0;
    public boolean detected;
    int counter = 1;
    int addr;
    int addg;
    int addb;
    int dark = 85;
    int medium = 170;
    int swidth = 768;
    int sheight = 544;
    BufferedImage outimage;
    int mousebutton = 0;
    int cols = 0;
    int reset = 0;
    int cycles;
    public static boolean autostore;
    int recalc = 0;
    BufferedImage showImage = new BufferedImage(384, 272, 4);
    BufferedImage bzm = new BufferedImage(384, 272, 1);
    ItemListener restoreListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int state = itemEvent.getStateChange();
            if (state == 1) {
                OverscanCanvas.this.resPal = true;
            }
            if (state == 2) {
                OverscanCanvas.this.resPal = false;
            }
        }
    };
    int mask = 0xFFFFFF;
    protected int[] xx = new int[800];
    protected int[] yy = new int[800];
    protected int z;
    protected int xStep;
    protected Color hf;
    protected Color vfl;
    protected Color vfr;
    protected Color fr;
    protected Color fl;
    protected int fillX;
    protected int fillY;
    protected boolean showFill = true;
    protected boolean filling = false;
    boolean iszoom;
    boolean isfilling;
    public byte[][] buffer = new byte[20][31953];
    public int choosenImage = 0;
    boolean screenChanged = true;

    public OverscanCanvas() {
        int offset = 0;
        for (int r = 0; r < 16; ++r) {
            for (int g = 0; g < 16; ++g) {
                for (int b = 0; b < 16; ++b) {
                    this.colours[offset++] = GateArray.putRGB(GateArray.LUM(r), GateArray.LUM(g), GateArray.LUM(b));
                }
            }
        }
        for (int pf = 0; pf < 27; ++pf) {
            this.Col[pf] = green ? new Color(GateArrayGreens[pf]) : new Color(GateArrayColors[pf]);
        }
        this.crossfade1 = new Color(255, 80, 128);
        this.crossfade2 = new Color(128, 80, 255);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(this.cursor);
        this.setBackground(Color.white);
        this.setSize(768, 544);
        this.setPreferredSize(new Dimension(768, 544));
        this.restorePal.addItemListener(this.restoreListener);
        this.loadScreens();
        this.zoomframe = new JFrame("Zoom area"){

            @Override
            protected void processWindowEvent(WindowEvent we) {
                super.processWindowEvent(we);
                if (we.getID() == 201) {
                    overscanPaint.zoom.setSelected(false);
                }
            }
        };
        this.zoomarea = new Canvas();
        this.zoomarea.setBackground(Color.black);
        this.zoomarea.setSize(400, 400);
        this.zoomframe.add(this.zoomarea);
        this.zoomframe.pack();
        this.zoomframe.setAlwaysOnTop(true);
        this.zoomframe.setResizable(false);
        this.zoomframe.setVisible(false);
        this.zoompic = new BufferedImage(400, 400, 2);
    }

    public void Zoom() {
        if (!this.zoomframe.isVisible()) {
            return;
        }
        Graphics g = this.zoomarea.getGraphics();
        int x = 200 - this.zoomx * 4;
        int y = 200 - this.zoomy * 4;
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, 410, 410);
        g.drawImage(Display.image, x, y, this.swidth * 4, this.sheight * 4, this);
        g.drawImage(this.Cursor2, 136, 136, 128, 128, this);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.mousebutton = event.getButton();
        if (this.zoomit && this.mousebutton != 1) {
            return;
        }
        if (this.setzoom) {
            int x = event.getX();
            int y = event.getY();
            int xs = 1;
            int ys = 2;
            if (this.mode == 0) {
                xs = 4;
            }
            if (this.mode == 1) {
                xs = 2;
            }
            x = x / (xs * this.zoomvalue) * (xs * this.zoomvalue);
            y = y / (ys * this.zoomvalue) * (ys * this.zoomvalue);
            this.putScreen();
            Graphics page = this.getGraphics();
            page.setColor(new Color(Util.random(0xFFFFFF)));
            int px = x - 768 / this.zoomvalue / 2;
            int py = y - 544 / this.zoomvalue / 2;
            px = px / (xs * this.zoomvalue) * (xs * this.zoomvalue);
            py = py / (ys * this.zoomvalue) * (ys * this.zoomvalue);
            page.drawRect(px, py, 768 / this.zoomvalue, 544 / this.zoomvalue);
            return;
        }
        this.makeUndo();
        int gotX = event.getX();
        int gotY = event.getY();
        this.lastX = gotX;
        this.lastY = gotY;
        int x = this.lastX;
        int y = this.lastY / 2;
        if (this.mode == 0) {
            x /= 4;
        }
        if (this.mode == 1) {
            x /= 2;
        }
        switch (this.MODE) {
            case 1: {
                if (this.paint) {
                    this.plot(x, y, this.pen);
                }
                this.painted = true;
                this.putScreen();
                break;
            }
            case 3: {
                Point current = event.getPoint();
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 4: {
                Point current = event.getPoint();
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 5: {
                Point current = event.getPoint();
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 6: {
                Point current = event.getPoint();
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 7: {
                Point current = event.getPoint();
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
            case 9: {
                Point current = event.getPoint();
                this.lineX = gotX;
                this.lineY = gotY;
                break;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        int yc;
        int xc;
        if (this.zoomit && this.mousebutton != 1) {
            if (this.mx > event.getX()) {
                this.subX();
            }
            if (this.mx < event.getX()) {
                this.addX();
            }
            if (this.my > event.getY()) {
                this.subY();
            }
            if (this.my < event.getY()) {
                this.addY();
            }
            this.my = event.getY();
            this.mx = event.getX();
            return;
        }
        if (this.MODE == this.MODE_FILL && this.isfilling) {
            return;
        }
        if (this.setzoom) {
            int x = event.getX();
            int y = event.getY();
            int xs = 1;
            int ys = 2;
            if (this.mode == 0) {
                xs = 4;
            }
            if (this.mode == 1) {
                xs = 2;
            }
            x = x / (xs * this.zoomvalue) * (xs * this.zoomvalue);
            y = y / (ys * this.zoomvalue) * (ys * this.zoomvalue);
            this.putScreen();
            Graphics page = this.getGraphics();
            page.setColor(new Color(Util.random(0xFFFFFF)));
            int px = x - 768 / this.zoomvalue / 2;
            int py = y - 544 / this.zoomvalue / 2;
            px = px / (xs * this.zoomvalue) * (xs * this.zoomvalue);
            py = py / (ys * this.zoomvalue) * (ys * this.zoomvalue);
            page.drawRect(px, py, 768 / this.zoomvalue, 544 / this.zoomvalue);
            return;
        }
        Graphics page = this.getGraphics();
        int gotX = event.getX();
        int gotY = event.getY();
        this.zoomx = gotX;
        this.zoomy = gotY;
        filled = 0;
        int xn = gotX;
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        if (this.zoomit) {
            xc = gotX / (xs * this.zoomvalue) * (xs * this.zoomvalue);
            yc = gotY / (ys * this.zoomvalue) * (ys * this.zoomvalue);
        } else {
            xc = gotX / xs * xs;
            yc = gotY / ys * ys;
        }
        this.lineX = this.lineX / xs * xs;
        this.lineY = this.lineY / ys * ys;
        int yn = gotY / 2;
        if (this.mode == 0) {
            xn /= 4;
        }
        if (this.mode == 1) {
            xn /= 2;
        }
        int fromx = this.lineX;
        int fromy = this.lineY;
        int tox = this.toX - this.lineX;
        int toy = this.toY - this.lineY;
        if (this.toX < this.lineX) {
            fromx = this.toX;
            tox = this.lineX - this.toX;
        } else {
            fromx = this.lineX;
            tox = this.toX - this.lineX;
        }
        if (this.toY < this.lineY) {
            fromy = this.toY;
            toy = this.lineY - this.toY;
        } else {
            fromy = this.lineY;
            toy = this.toY - this.lineY;
        }
        tox = tox / xs * xs;
        toy = toy / ys * ys;
        switch (this.MODE) {
            case 1: {
                if (this.paint) {
                    this.plot(xn, yn, this.pen);
                    page.setColor(CPC.getCol(this.pen));
                }
                this.lastX = gotX;
                this.lastY = gotY;
                this.putScreen();
                this.painted = true;
                break;
            }
            case 3: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                page.setColor(this.random);
                page.drawLine(this.lineX, this.lineY, this.toX, this.toY);
                page.drawLine(this.lineX, this.lineY + 1, this.toX, this.toY + 1);
                if (this.mode == 1 || this.mode == 0) {
                    page.drawLine(this.lineX + 1, this.lineY, this.toX + 1, this.toY);
                    page.drawLine(this.lineX + 1, this.lineY + 1, this.toX + 1, this.toY + 1);
                }
                if (this.mode != 0) break;
                page.drawLine(this.lineX + 2, this.lineY, this.toX + 2, this.toY);
                page.drawLine(this.lineX + 2, this.lineY + 1, this.toX + 2, this.toY + 1);
                page.drawLine(this.lineX + 3, this.lineY, this.toX + 3, this.toY);
                page.drawLine(this.lineX + 3, this.lineY + 1, this.toX + 3, this.toY + 1);
                break;
            }
            case 4: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                page.setColor(this.random);
                page.drawRect(fromx, fromy, tox, toy);
                page.drawRect(fromx, fromy + 1, tox, toy);
                if (this.mode == 1 || this.mode == 0) {
                    page.drawRect(fromx + 1, fromy, tox, toy);
                    page.drawRect(fromx + 1, fromy + 1, tox, toy);
                }
                if (this.mode != 0) break;
                page.drawRect(fromx + 2, fromy, tox, toy);
                page.drawRect(fromx + 2, fromy + 1, tox, toy);
                page.drawRect(fromx + 3, fromy, tox, toy);
                page.drawRect(fromx + 3, fromy + 1, tox, toy);
                break;
            }
            case 5: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                this.cross(xc, yc);
                page.drawOval(fromx, fromy, tox, toy);
                break;
            }
            case 6: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                page.setColor(this.random);
                page.fillRect(fromx, fromy, tox + xs, toy + ys);
                break;
            }
            case 7: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                this.cross(xc, yc);
                page.fillOval(fromx, fromy, tox + xs, toy + ys);
                break;
            }
            case 9: {
                this.putScreen();
                this.toX = gotX;
                this.toY = gotY;
                if (green) {
                    page.setColor(CPC.getGCol(this.pen));
                } else {
                    page.setColor(CPC.getCol(this.pen));
                }
                page.setColor(this.random);
                page.drawRect(fromx, fromy, tox, toy);
                page.drawRect(fromx, fromy + 1, tox, toy);
                this.shapeX = fromx;
                this.shapeY = fromy;
                this.shapeW = tox;
                this.shapeH = toy;
                if (this.mode == 1 || this.mode == 0) {
                    page.drawRect(fromx + 1, fromy, tox, toy);
                    page.drawRect(fromx + 1, fromy + 1, tox + 1, toy);
                }
                if (this.mode != 0) break;
                page.drawRect(fromx + 2, fromy, tox, toy);
                page.drawRect(fromx + 2, fromy + 1, tox, toy);
                page.drawRect(fromx + 3, fromy, tox, toy);
                page.drawRect(fromx + 3, fromy + 1, tox, toy);
            }
        }
        this.drawCross(xc, yc, xs, ys);
    }

    public void plot(int x, int y, int p) {
        if (this.zoomit) {
            int xd = 1;
            if (this.mode == 0) {
                xd = 4;
            }
            if (this.mode == 1) {
                xd = 2;
            }
            x = x / this.zoomvalue + this.xoffset / xd;
            y = y / this.zoomvalue + this.yoffset / 2;
        }
        int w = 768;
        if (this.mode == 1) {
            w /= 2;
        }
        if (this.mode == 0) {
            w /= 4;
        }
        if (x >= 0 && y >= 0 && x <= w && y <= 272) {
            CPC.PLOT(x, y, p, this.mode, this.overscan);
        }
    }

    public void writeOverscan() {
        try {
            FileDialog filedia = new FileDialog(new Frame(), "Save overscan SCR", 1);
            filedia.setFile("*.SCR");
            filedia.setVisible(true);
            String filename = null;
            filename = filedia.getFile();
            if (filename != null) {
                filename = filedia.getDirectory() + filedia.getFile();
                if (!filename.toLowerCase().endsWith(".scr")) {
                    filename = filename + ".SCR";
                }
                if (plusmode) {
                    CPC.BIN_Export(filename, 512, 31936, 2081, true);
                } else {
                    CPC.BIN_Export(filename, 512, 31936, 2065, true);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Save Overscan image failed...");
            return;
        }
    }

    public void convertScreen() {
        filled = 0;
        recalculate = 0;
        this.MODE = this.MODE_IMPORT;
        this.chooser.addChoosableFileFilter(new ImageFilter());
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setFileView(new ImageFileView());
        this.chooser.setAccessory(new ImagePreview(this.chooser));
        this.chooser.setPreferredSize(new Dimension(640, 480));
        this.chooser.setCurrentDirectory(new File(DSettings.get("paint_path", "")));
        this.chooser.setMultiSelectionEnabled(false);
        if (this.chooser.showOpenDialog(this) == 0) {
            String filename;
            DSettings.set("paint_path", this.chooser.getSelectedFile().getPath());
            this.doCycle = false;
            this.loadname = filename = this.chooser.getSelectedFile().getAbsolutePath();
            this.showname = this.chooser.getSelectedFile().getName();
            overscanPaint.output.append("Reading " + this.loadname + " in progress...\n");
            if (this.loadname.length() > 2) {
                this.convertScreen(this.loadname);
            }
        }
    }

    public void SCRimport(String loadname) {
        filled = 0;
        this.scr = true;
        OverscanCanvas.resetCPCColours();
        System.arraycopy(CPC.pale, 0, CPC.Palcols, 0, 16);
        plusmode = false;
        try {
            int i;
            BufferedInputStream bos = new BufferedInputStream(new FileInputStream(loadname));
            this.input = new byte[bos.available()];
            this.count = 0;
            while (bos.available() > 0) {
                this.input[this.count] = (byte)bos.read();
                ++this.count;
            }
            bos.close();
            boolean plus = false;
            int start = 0;
            if (this.input.length > 31936) {
                start = 128;
            }
            plus = this.input[1569 + start] == -13;
            int address = 512;
            byte mod = this.input[1536 + start];
            System.out.println("Found: " + Util.hex(mod));
            int smode = 0;
            if (mod == -116 || mod == 0) {
                smode = 0;
            }
            if (mod == -115 || mod == 1) {
                smode = 1;
            }
            if (mod == -114 || mod == 2) {
                smode = 2;
            }
            if (!plus && smode != GateArray.getSMode()) {
                if (smode == 0) {
                    CPC.POKE(36863, 3);
                } else {
                    CPC.POKE(36863, smode);
                }
            }
            int palette = 1537 + start;
            if (!plus) {
                for (i = 0; i < 16; ++i) {
                    OverscanCanvas.INK(i, this.input[palette + i]);
                }
            }
            for (i = start; i < this.input.length; ++i) {
                GateArray.screenmemory[address++] = this.input[i];
            }
            if (plus) {
                plusmode = true;
                ImageProcessor.plus.setSelected(true);
                ImageProcessor.divider.setEnabled(true);
                ImageProcessor.dlabel.setEnabled(true);
                this.makePlus(this.input, start);
            } else {
                ImageProcessor.plus.setSelected(false);
                ImageProcessor.divider.setEnabled(false);
                ImageProcessor.dlabel.setEnabled(false);
            }
            boolean bl = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void resetCPCColours() {
        System.arraycopy(GateArrayOrg, 0, GateArrayColors, 0, GateArrayColors.length);
        GateArray.resetCPCColours();
        for (int i = 0; i < 27; ++i) {
            CPC.Palcols[i] = new Color(GateArrayColors[i]);
        }
    }

    public void makePlus(byte[] in, int start) {
        int ad = 1537 + start;
        byte mod = in[1536 + start];
        int smode = 0;
        if (mod == -116) {
            smode = 0;
        }
        if (mod == -115) {
            smode = 1;
        }
        if (mod == -114) {
            smode = 2;
        }
        if (smode != GateArray.getSMode()) {
            if (smode == 0) {
                CPC.POKE(36863, 3);
            } else {
                CPC.POKE(36863, smode);
            }
        }
        try {
            int pos = 0;
            this.pluspalette = new byte[32];
            for (int i = 0; i < 16; ++i) {
                byte p;
                this.pluspalette[pos] = p = in[ad];
                String b1 = Util.hex(p);
                this.pluspalette[pos + 1] = p = in[ad + 1];
                ad += 2;
                pos += 2;
                String b2 = Util.hex(p);
                b2 = b2.substring(1);
                String result = b1 + b2;
                String r = "" + result.charAt(0);
                String b = "" + result.charAt(1);
                String g = "" + result.charAt(2);
                result = r + r + g + g + b + b;
                CPC.Palcols[i] = new Color(Util.hexValue(result));
                OverscanCanvas.GateArrayColors[i] = Util.hexValue(result);
                GateArray.setPalette(i, Util.hexValue(result));
                OverscanCanvas.INK(i, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] getPlusPalette() {
        this.makePlusPalette();
        return this.pluspalette;
    }

    public void makePlusPalette() {
        try {
            for (int pen = 0; pen < 16; ++pen) {
                int pos = pen * 2;
                int f = GateArrayColors[pen];
                int[] rgb = this.getRGB(f);
                int r = rgb[0] >> 4;
                int g = rgb[1] >> 4;
                int b = rgb[2] >> 4;
                String R = Integer.toHexString(r);
                String G = Integer.toHexString(g);
                String B = Integer.toHexString(b);
                String result = R + B;
                int bg = Util.hexValue(result);
                this.pluspalette[pos] = (byte)bg;
                result = G;
                bg = Util.hexValue(result);
                this.pluspalette[pos + 1] = (byte)bg;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPENs() {
        int coloursToSet = 0;
        this.CPCImage = null;
        if (this.mode == 0) {
            coloursToSet = 16;
        }
        if (this.mode == 1) {
            coloursToSet = 4;
        }
        if (this.mode == 2) {
            coloursToSet = 2;
        }
        this.CPCpalette = new int[coloursToSet];
        for (int i = 0; i < coloursToSet; ++i) {
            this.CPCpalette[i] = green ? this.getCOL(CPC.getGCol(i)) : this.getCOL(CPC.getCol(i));
        }
    }

    public void refactorImage() {
        Graphics2D g2;
        filled = 0;
        int colours = 0;
        this.CPCImage = null;
        if (this.mode == 0) {
            this.CPCImage = new BufferedImage(this.swidth / 4, 272, 1);
            colours = 16;
        }
        if (this.mode == 1) {
            this.CPCImage = new BufferedImage(this.swidth / 2, 272, 1);
            colours = 4;
        }
        if (this.mode == 2) {
            this.CPCImage = new BufferedImage(this.swidth, 272, 1);
            colours = 2;
        }
        if (blur) {
            g2 = (Graphics2D)this.loadedImage.getGraphics();
            g2.drawImage(this.loadedImage, this.blurOp, 0, 0);
            this.loadedImage.getGraphics().drawImage(this.loadedImage, 0, 0, this);
        }
        if (sharp) {
            g2 = (Graphics2D)this.loadedImage.getGraphics();
            g2.drawImage(this.loadedImage, this.sharpOp, 0, 0);
            this.loadedImage.getGraphics().drawImage(this.loadedImage, 0, 0, this);
        }
        this.CPCImage.setAccelerationPriority(1.0f);
        this.CPCImage.getGraphics().drawImage(this.loadedImage, 0, 0, this.CPCImage.getWidth(), 272, this);
        this.CPCpalette = new int[colours];
        for (int i = 0; i < colours; ++i) {
            this.CPCpalette[i] = green ? this.getCOL(CPC.getGCol(i)) : this.getCOL(CPC.getCol(i));
        }
        this.buildCPCScreen(this.CPCImage, this.CPCpalette);
    }

    public BufferedImage readImage(String filename) throws IOException {
        if (this.tga == null) {
            this.tga = new importTGA();
        }
        if (this.pcx == null) {
            this.pcx = new importPCX();
        }
        BufferedImage bo = null;
        if (filename.toLowerCase().endsWith(".tga")) {
            bo = this.tga.getImage(filename, false);
        } else if (filename.toLowerCase().endsWith(".pcx")) {
            bo = importPCX.getImage(filename);
        } else {
            File imagein = new File(filename);
            BufferedImage bi = ImageIO.read(imagein);
            bo = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
            bo.getGraphics().drawImage(bi, 0, 0, this);
        }
        return bo;
    }

    public void posterize() {
        filled = 0;
        String filename = this.loadname;
        if (filename != null) {
            try {
                int n = JOptionPane.showConfirmDialog(this, "Store double sized?", "Please choose outputformat", 0);
                if (n == 0) {
                    n = 2;
                }
                BufferedImage pimage = this.readImage(filename);
                BufferedImage gimage = new BufferedImage(pimage.getWidth() * n, pimage.getHeight() * n, 4);
                gimage.getGraphics().drawImage(pimage, 0, 0, gimage.getWidth(), gimage.getHeight(), this);
                BufferedImage out = null;
                if (this.mode == 0) {
                    out = new BufferedImage(gimage.getWidth() / 4, gimage.getHeight() / 2, 4);
                }
                if (this.mode == 1) {
                    out = new BufferedImage(gimage.getWidth() / 2, gimage.getHeight() / 2, 4);
                }
                if (this.mode == 2) {
                    out = new BufferedImage(gimage.getWidth(), gimage.getHeight() / 2, 4);
                }
                out.getGraphics().drawImage(gimage, 0, 0, out.getWidth(), out.getHeight(), this);
                out = this.FilterImage(out);
                int colours = 0;
                if (this.mode == 0) {
                    colours = 16;
                }
                if (this.mode == 1) {
                    colours = 4;
                }
                if (this.mode == 2) {
                    colours = 2;
                }
                for (int i = 0; i < colours; ++i) {
                    this.CPCpalette[i] = green ? this.getCOL(CPC.getGCol(i)) : this.getCOL(CPC.getCol(i));
                }
                this.buildCPCScreen(out, this.CPCpalette);
                gimage.getGraphics().drawImage(out, 0, 0, gimage.getWidth(), gimage.getHeight(), this);
                FileDialog filedia = new FileDialog(new Frame(), "Save posterized screen", 1);
                filedia.setFile("*.png");
                filedia.setVisible(true);
                filename = null;
                filename = filedia.getFile();
                if (filename != null) {
                    filename = filedia.getDirectory() + filedia.getFile();
                    if (!filename.toLowerCase().endsWith(".png")) {
                        filename = filename + ".png";
                    }
                    this.savescreen(gimage, filename, "png");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Load failed...");
                return;
            }
        }
    }

    public void buildGreenPalette() {
        if (!green) {
            for (int i = 0; i < 16; ++i) {
                try {
                    this.palette[i] = GateArray.getInk(i);
                    OverscanCanvas.INK(i, this.greypal[i]);
                    continue;
                }
                catch (Exception e) {
                    overscanPaint.output.append("Something went wrong...\nHave you been too fast?\n");
                }
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                try {
                    OverscanCanvas.INK(i, this.palette[i]);
                    continue;
                }
                catch (Exception e) {
                    overscanPaint.output.append("Something went wrong...\nHave you been too fast?\n");
                }
            }
        }
        green = !green;
    }

    public String showname() {
        return this.showname;
    }

    public void convertScreen(String loadname) {
        int value;
        filled = 0;
        this.mode = GateArray.getSMode();
        recalculate = 0;
        this.MODE = this.MODE_IMPORT;
        this.scr = false;
        if (loadname.toLowerCase().endsWith(".scr") || loadname.toLowerCase().endsWith(".bin")) {
            this.SCRimport(loadname);
            return;
        }
        this.cycled = 0;
        this.scrollImage = null;
        this.posterizedImage = null;
        this.sourceImage = null;
        try {
            this.loadedImage = this.readImage(loadname);
        }
        catch (Exception e) {
            System.out.println("**** Error: Load failed...");
            return;
        }
        this.detected = false;
        int orig_width = this.loadedImage.getWidth();
        int orig_height = this.loadedImage.getHeight();
        int newwidth = this.swidth;
        int newheight = this.sheight;
        float ratio = (float)orig_width / (float)orig_height;
        double scale = (double)orig_width / 768.0;
        if ((double)ratio > 1.4117647) {
            scale = (double)orig_height / 544.0;
        }
        double width = (double)orig_width / scale;
        double height = (double)orig_height / scale;
        overscanPaint.ScrollUpDown.setValue(0);
        overscanPaint.ScrollLeftRight.setValue(0);
        newwidth = (int)width;
        newheight = (int)height;
        if (this.keep) {
            newwidth = (int)((double)orig_width * this.zoomfactor);
            newheight = (int)((double)orig_height * this.zoomfactor);
        }
        if (this.stretch) {
            newwidth = this.swidth;
            newheight = this.sheight;
        }
        overscanPaint.output.append("Image size: " + orig_width + "x" + orig_height + ", ratio = " + ratio + "\n");
        overscanPaint.output.append("Size viewed: 768x544, ratio = " + (float)this.swidth / (float)this.sheight + " Origin : (" + this.scroll + "," + this.scrollb + "\n");
        overscanPaint.output.select(2000000000, 2000000000);
        this.sourceImage = this.gray ? new BufferedImage(newwidth, newheight, 10) : new BufferedImage(newwidth, newheight, 1);
        this.sourceImage.getGraphics().drawImage(this.loadedImage, 0, 0, newwidth, newheight, this);
        this.loadedImage = new BufferedImage(this.sourceImage.getWidth(), this.sourceImage.getHeight(), 1);
        this.loadedImage.getGraphics().drawImage(this.sourceImage, 0, 0, newwidth, newheight, this);
        this.scrollImage = new BufferedImage(this.loadedImage.getWidth(), this.loadedImage.getHeight(), 1);
        this.scrollImage.getGraphics().drawImage(this.loadedImage, 0, 0, this.loadedImage.getWidth(), this.loadedImage.getHeight(), this);
        recalculate = 1;
        if (this.scrollImage.getHeight() - this.sheight > 0) {
            value = this.scrollImage.getHeight() - this.sheight;
            overscanPaint.ScrollUpDown.setMaximum(value);
            overscanPaint.ScrollUpDown.setEnabled(true);
        } else {
            overscanPaint.ScrollUpDown.setMaximum(0);
            overscanPaint.ScrollUpDown.setEnabled(false);
        }
        if (this.scrollImage.getWidth() - this.swidth > 0) {
            value = this.scrollImage.getWidth() - this.swidth;
            overscanPaint.ScrollLeftRight.setMaximum(value);
            overscanPaint.ScrollLeftRight.setEnabled(true);
        } else {
            overscanPaint.ScrollLeftRight.setMaximum(0);
            overscanPaint.ScrollLeftRight.setEnabled(false);
        }
        overscanPaint.ScrollUpDown.setEnabled(true);
        overscanPaint.ScrollLeftRight.setEnabled(true);
        this.posterizedImage = null;
        this.paintscreen = true;
        this.cycled = 1;
        this.clear();
        overscanPaint.output.append("Reading Ok.\n");
        overscanPaint.output.select(2000000000, 2000000000);
        this.doCycle = true;
    }

    public void scrollImage() {
        filled = 0;
        if (this.buffershow == null) {
            this.buffershow = new BufferedImage(768, 544, 1);
        }
        if (this.oldscroll != this.scrollb || this.oldscroll2 != this.scroll) {
            recalculate = 1;
            this.detected = false;
            Graphics page = this.getGraphics();
            page.drawImage(this.scrollImage, 0 - this.scrollb, 0 - this.scroll, this.swidth, this.sheight, 0, 0, this.swidth + this.scrollb, this.sheight + this.scroll, this);
            page = this.buffershow.getGraphics();
            page.drawImage(this.scrollImage, 0 - this.scrollb, 0 - this.scroll, this.swidth, this.sheight, 0, 0, this.swidth + this.scrollb, this.sheight + this.scroll, this);
            page = this.showImage.getGraphics();
            page.drawImage(this.buffershow, 0, 0, 384, 272, null);
        }
        this.oldscroll = this.scrollb;
        this.oldscroll2 = this.scroll;
    }

    public void recalculate() {
        filled = 0;
        this.loadedImage = new BufferedImage(this.swidth, this.sheight, 1);
        this.loadedImage.getGraphics().drawImage(this.scrollImage, 0 - this.scrollb, 0 - this.scroll, this.swidth, this.sheight, 0, 0, this.swidth + this.scrollb, this.sheight + this.scroll, this);
        this.loadedImage = this.FilterImage(this.loadedImage);
    }

    protected BufferedImage FilterImage(BufferedImage in) {
        Graphics2D g2;
        if (blur) {
            g2 = (Graphics2D)in.getGraphics();
            g2.drawImage(in, this.blurOp, 0, 0);
            in.getGraphics().drawImage(in, 0, 0, this);
        }
        if (sharp) {
            g2 = (Graphics2D)in.getGraphics();
            g2.drawImage(in, this.sharpOp, 0, 0);
            in.getGraphics().drawImage(in, 0, 0, this);
        }
        if (!(plusmode || this.addr == 0 && this.addg == 0 && this.addb == 0)) {
            this.ManipulateRGB(in);
        }
        int w = this.mode == 0 ? 192 : (this.mode == 1 ? 384 : 768);
        int h = 272;
        BufferedImage out = new BufferedImage(w, h, 1);
        Graphics2D g = out.createGraphics();
        g.drawImage(in, 0, 0, w, h, this);
        this.ctr.setContrast(this.gain[this.contrast] + 1.0f);
        this.ctr.setBrightness(this.gain[this.bright] + 1.0f);
        this.ctr.filter(out, out);
        this.gfilt.setGain(this.gain[this.gainvalue]);
        this.gfilt.filter(out, out);
        this.hsb.setSFactor(this.gain[this.sat]);
        this.hsb.setHFactor(this.gain[this.hue]);
        this.hsb.filter(out, out);
        if (this.dlevel) {
            this.Dithering.setLevels(2);
            this.Dithering.filter(out, out);
        }
        if (this.dobump) {
            this.bump.filter(out, out);
        }
        this.savescreen(out, "result.png", "png");
        g = in.createGraphics();
        g.drawImage(out, 0, 0, this.swidth, this.sheight, this);
        return in;
    }

    public static void setPlusInk(int i, int value) {
        CPC.Palcols[i & 0xF] = new Color(value);
        OverscanCanvas.GateArrayColors[i & 0xF] = value;
        GateArray.setPalette(i & 0xF, value);
        OverscanCanvas.INK(i & 0xF, i & 0xF);
    }

    protected int[] getRGB(int value) {
        int[] rgb = new int[]{value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF};
        return rgb;
    }

    public void ManipulateRGB(BufferedImage in) {
        for (int x = 0; x < in.getWidth(); ++x) {
            for (int y = 0; y < in.getHeight(); ++y) {
                Graphics g = in.getGraphics();
                g.setColor(this.ManipulateRGB(new Color(in.getRGB(x, y)), this.addr, this.addg, this.addb));
                g.fillRect(x, y, 1, 1);
            }
        }
    }

    public Color ManipulateRGB(Color SourceColor, int addR, int addG, int addB) {
        int r = SourceColor.getRed() + addR;
        int g = SourceColor.getGreen() + addG;
        int b = SourceColor.getBlue() + addB;
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public int RGBtoCPC(int src, boolean plus) {
        if (!plus) {
            return src < this.dark ? 0 : (src < this.medium ? 125 : 255);
        }
        return src;
    }

    public void findCPCInk(Color test2) {
        this.RedPixel = test2.getRed() & 0xFF;
        this.GreenPixel = test2.getGreen() & 0xFF;
        this.BluePixel = test2.getBlue() & 0xFF;
        if (!green) {
            this.CPCRed = this.RGBtoCPC(this.RedPixel, plusmode);
            this.CPCGreen = this.RGBtoCPC(this.GreenPixel, plusmode);
            this.CPCBlue = this.RGBtoCPC(this.BluePixel, plusmode);
        } else {
            this.CPCRed = this.RedPixel;
            this.CPCGreen = this.GreenPixel;
            this.CPCBlue = this.BluePixel;
        }
    }

    public void setPlusINK(int value) {
        this.setPlusINK(this.pen, value);
    }

    public void setPlusINK(int pen, int value) {
        CPC.Palcols[pen] = new Color(value);
        OverscanCanvas.GateArrayColors[pen] = value;
        GateArray.setPalette(pen, value);
    }

    public void setINK(int value) {
        this.setINK(this.pen, value);
    }

    public void setINK(int pen, int value) {
        Color col = new Color(value);
        this.findCPCInk(col);
        for (int i = 0; i < CPC.Palcols.length; ++i) {
            int B;
            int G;
            int R;
            int r = CPC.Palcols[i].getRed();
            int g = CPC.Palcols[i].getGreen();
            int b = CPC.Palcols[i].getBlue();
            if (!green) {
                R = this.RGBtoCPC(col.getRed(), false);
                G = this.RGBtoCPC(col.getGreen(), false);
                B = this.RGBtoCPC(col.getBlue(), false);
            } else {
                r = CPC.Greencols[i].getRed();
                g = CPC.Greencols[i].getGreen();
                b = CPC.Greencols[i].getBlue();
                R = col.getRed();
                G = col.getGreen();
                B = col.getBlue();
                int d = R + G + B;
                R = d /= 3;
                G = d;
                B = d;
            }
            if (r < R - 10 || r > R + 10 || g < G - 10 || g > G + 10 || b < B - 10 || b > B + 10) continue;
            OverscanCanvas.INK(pen, i);
            break;
        }
    }

    protected void prepareInput(BufferedImage input) {
        if (this.rasterval < 181 && !plusmode) {
            this.pseudo.getGraphics().drawImage(input, 0, 0, 768, 544, this);
        }
        int width = input.getWidth();
        int height = input.getHeight();
        int xstep = 1;
        if (this.mode == 1) {
            xstep = 2;
        }
        if (this.mode == 0) {
            xstep = 4;
        }
        Graphics v = input.getGraphics();
        if (ImageProcessor.imp.isSelected()) {
            if (!plusmode) {
                int dit;
                if (green) {
                    dit = this.rasterval;
                    this.rasterval = 120;
                    this.buildCPCScreen(input, GateArrayGreens);
                    this.rasterval = dit;
                } else {
                    dit = this.rasterval;
                    this.rasterval = 120;
                    this.buildCPCScreen(input, GateArrayColors);
                    this.rasterval = dit;
                }
                for (int xdot = 0; xdot < width; xdot += xstep) {
                    for (int ydot = 0; ydot < height; ydot += 2) {
                        int col = input.getRGB(xdot, ydot);
                        v.setColor(new Color(col));
                        v.fillRect(xdot, ydot, xstep, 2);
                    }
                }
            } else {
                for (int xdot = 0; xdot < width; xdot += xstep) {
                    for (int ydot = 0; ydot < height; ydot += 2) {
                        int col = input.getRGB(xdot, ydot);
                        int[] rgb = this.getRGB(col);
                        int r = GateArray.LUM(rgb[0] >> 4);
                        int g = GateArray.LUM(rgb[1] >> 4);
                        int b = GateArray.LUM(rgb[2] >> 4);
                        int value = GateArray.putRGB(r, g, b);
                        v.setColor(new Color(value));
                        v.fillRect(xdot, ydot, xstep, 2);
                    }
                }
            }
        }
        this.showImage.getGraphics().drawImage(input, 0, 0, 384, 272, this);
        if (this.rasterval < 181 && !plusmode) {
            input.getGraphics().drawImage(this.pseudo, 0, 0, 768, 544, this);
        }
    }

    protected void buildCPCPalette(BufferedImage input) {
        int pf;
        int q;
        int p;
        int ydot;
        int xdot;
        Graphics v = input.getGraphics();
        int tolerance = ImageProcessor.tolerance.getValue() / 10 + 1;
        this.mode = GateArray.getSMode();
        overscanPaint.output.append("Process pass 1...\n");
        if (input == null) {
            return;
        }
        int width = input.getWidth();
        int height = input.getHeight();
        int xstep = 1;
        if (width > this.swidth) {
            width = this.swidth;
        }
        if (height > this.sheight) {
            height = this.sheight;
        }
        if (this.mode == 1) {
            xstep = 2;
        }
        if (this.mode == 0) {
            xstep = 4;
        }
        int keeppen = this.pen;
        this.palcount = new int[27];
        int countr = 0;
        if (plusmode) {
            int i;
            int i2;
            for (int i3 = 0; i3 < 4096; ++i3) {
                this.used[i3] = 0;
            }
            if (this.addr != 0 || this.addg != 0 || this.addb != 0) {
                this.ManipulateRGB(input);
            }
            int offset = 0;
            int having = 0;
            int toldiv = ImageProcessor.divider.getValue() / 5 + 1;
            int tol = 0;
            boolean put = false;
            overscanPaint.output.append("Tolerance is " + tolerance + "\n");
            for (int xdot2 = 0; xdot2 < width; xdot2 += tolerance * xstep) {
                for (int ydot2 = 0; ydot2 < height; ydot2 += tolerance * 2) {
                    if (!ImageProcessor.method.isSelected() && !ImageProcessor.method1.isSelected()) {
                        if (++tol >= toldiv) {
                            tol = 0;
                            put = true;
                        }
                    } else {
                        put = true;
                    }
                    if (put) {
                        int col = input.getRGB(xdot2, ydot2);
                        int[] rgb = this.getRGB(col);
                        int r = GateArray.LUM(rgb[0] >> 4);
                        int g = GateArray.LUM(rgb[1] >> 4);
                        int b = GateArray.LUM(rgb[2] >> 4);
                        int value = GateArray.putRGB(r, g, b);
                        for (int i4 = 0; i4 < 4096; ++i4) {
                            if (i4 == 6000 || this.colours[i4] != value) continue;
                            int n = i4;
                            this.used[n] = this.used[n] + 1;
                            i4 = 6000;
                        }
                    }
                    put = false;
                }
            }
            for (int i5 = 0; i5 < 4096; ++i5) {
                if (this.used[i5] == 0) continue;
                ++having;
            }
            overscanPaint.output.append("Colours found: " + having + "\n");
            int d = 16;
            if (this.mode == 1) {
                d = 4;
            }
            int div = having >= d ? having / d : having;
            int divider = ImageProcessor.divider.getValue() / 10 + 1;
            int[] pal = new int[16];
            int[] havingcol = new int[4096];
            int[] haveused = new int[4096];
            int hoffset = 0;
            int pos = 0;
            int[] colli = new int[having];
            for (int i6 = 0; i6 < 4096; ++i6) {
                if (this.used[i6] == 0) continue;
                ++pos;
                haveused[hoffset] = this.used[i6];
                colli[hoffset++] = this.colours[i6];
            }
            int hoff = 0;
            int yoff = 0;
            String[] foof = new String[having];
            for (i2 = 0; i2 < having; ++i2) {
                foof[i2] = "" + Util.hex(colli[i2]);
            }
            Collections.sort(Arrays.asList(foof));
            for (i2 = 0; i2 < having; ++i2) {
                try {
                    colli[i2] = Util.hexValue(foof[i2]);
                    continue;
                }
                catch (Exception r) {
                    break;
                }
            }
            this.pali = new BufferedImage(having * 16, 16, 1);
            System.arraycopy(colli, 0, havingcol, 0, colli.length);
            Graphics2D g = this.pali.createGraphics();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, having * 16, 16);
            for (int i7 = 0; i7 < having; ++i7) {
                g.setColor(new Color(colli[i7]));
                g.fillRect(hoff, yoff, 16, 16);
                hoff += 16;
            }
            QuantizeFilter cop = new QuantizeFilter();
            cop.setDither(false);
            cop.setSerpentine(true);
            cop.setNumColors(16);
            cop.filter(this.pali, this.pali);
            int[] ppal = new int[16];
            for (int i8 = 0; i8 < 16; ++i8) {
                ppal[i8] = -1;
            }
            int vpos = 0;
            for (i = 0; i < having; ++i) {
                int value = this.pali.getRGB(i * 16, 8);
                put = true;
                for (int gg = 0; gg < 16; ++gg) {
                    if (ppal[gg] != value) continue;
                    put = false;
                    break;
                }
                if (!put) continue;
                ppal[vpos++] = value;
            }
            offset = 0;
            if (ImageProcessor.method1.isSelected()) {
                int dd = having / divider / 16;
                ++dd;
                int lastoff = -10;
                for (int i9 = 0; i9 < 16; ++i9) {
                    pal[i9] = havingcol[offset];
                    try {
                        offset += pos / 2 / (pos / 2 / (dd * divider));
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                int[] buff = new int[16];
                System.arraycopy(pal, 0, buff, 0, 16);
                for (int i10 = 0; i10 < 16; ++i10) {
                    pal[i10] = buff[this.pals[i10]];
                }
            } else if (!ImageProcessor.method.isSelected()) {
                System.arraycopy(ppal, 0, pal, 0, 16);
                int[] buff = new int[16];
                System.arraycopy(pal, 0, buff, 0, 16);
                for (int i11 = 0; i11 < 16; ++i11) {
                    pal[i11] = buff[this.pals[i11]];
                }
            } else {
                for (i = 0; i < having; i += div / divider) {
                    if (haveused[i] == -1) continue;
                    try {
                        pal[offset] = havingcol[i];
                        ++offset;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (offset != 16) {
                        continue;
                    }
                    break;
                }
            }
            for (int i12 = 0; i12 < 16; ++i12) {
                if (!this.lockPEN[i12]) {
                    this.setPlusINK(i12 & 0xF, pal[i12 & 0xF]);
                }
                OverscanCanvas.INK(i12 & 0xF, i12 & 0xF);
            }
            return;
        }
        if (ImageProcessor.imp.isSelected()) {
            int dit;
            if (green) {
                dit = this.rasterval;
                this.rasterval = 120;
                this.buildCPCScreen(input, GateArrayGreens);
                this.rasterval = dit;
            } else {
                dit = this.rasterval;
                this.rasterval = 120;
                this.buildCPCScreen(input, GateArrayColors);
                this.rasterval = dit;
            }
            for (xdot = 0; xdot < width; xdot += tolerance * xstep) {
                for (ydot = 0; ydot < height; ydot += tolerance * 2) {
                    int col = input.getRGB(xdot, ydot);
                    v.setColor(new Color(col));
                    v.fillRect(xdot, ydot, tolerance * xstep, tolerance * 2);
                }
            }
        }
        for (xdot = 0; xdot < width; xdot += xstep) {
            ++countr;
            for (ydot = 0; ydot < height; ydot += 2) {
                Color test2 = new Color(input.getRGB(xdot, ydot));
                this.findCPCInk(test2);
                Color peng = new Color(this.CPCRed, this.CPCGreen, this.CPCBlue);
                for (p = 0; p < 27; ++p) {
                    if (this.getCOL(this.Col[p]) != this.getCOL(peng)) continue;
                    int n = p;
                    this.palcount[n] = this.palcount[n] + 1;
                }
            }
        }
        this.count = 0;
        int[] check = new int[27];
        this.outcount = new int[270000];
        int number = 0;
        for (int p2 = 0; p2 < 27; ++p2) {
            if (this.palcount[p2] != 0) {
                ++number;
            }
            check[p2] = this.palcount[p2];
        }
        overscanPaint.output.append(number + " INKs found.\n");
        Arrays.sort(check);
        int[] recheck = new int[27];
        int collect = 16;
        for (p = 0; p < 27; ++p) {
            recheck[p] = check[26 - p];
        }
        check = recheck;
        block30: for (p = 0; p < 27; ++p) {
            for (q = 0; q < 27; ++q) {
                if (this.palcount[q] == check[p]) {
                    this.outcount[this.count] = q;
                    ++this.count;
                }
                if (this.count == collect + 1) continue block30;
            }
        }
        for (p = 0; p < 27; ++p) {
            this.realInks[p] = -1;
        }
        for (p = 0; p < 27; ++p) {
            for (q = 0; q < 27; ++q) {
                if (this.palcount[q] != check[p]) continue;
                this.realInks[p] = q;
            }
        }
        this.counted = new int[collect];
        for (int pf2 = 0; pf2 < 16; ++pf2) {
            if (this.lockPEN[pf2]) continue;
            OverscanCanvas.INK(pf2, 0);
        }
        String outtext = "Palette: (INKs) ";
        for (pf = 0; pf < collect; ++pf) {
            if (!this.lockPEN[pf]) {
                OverscanCanvas.INK(pf, this.outcount[pf]);
            }
            outtext = outtext + this.outcount[pf];
            this.counted[pf] = this.outcount[pf];
            if (pf >= collect - 1) continue;
            outtext = outtext + ",";
        }
        overscanPaint.output.append("Process pass 2...\n");
        outtext = outtext + "\n";
        for (pf = 0; pf < collect; ++pf) {
            outtext = outtext + " (" + this.cpccolors[this.outcount[pf]] + ")";
        }
        overscanPaint.output.append(outtext + "\n");
        overscanPaint.output.select(2000000000, 2000000000);
        this.pen = keeppen;
    }

    public void checkLoadImg() {
        int checksum = 0;
        for (int xdot = 0; xdot < this.loadedImage.getWidth(); xdot += 10) {
            for (int ydot = 0; ydot < this.loadedImage.getHeight(); ydot += 10) {
                Color test2 = new Color(this.loadedImage.getRGB(xdot, ydot));
                checksum += this.getCOL(test2);
            }
        }
        if (checksum == 0) {
            this.convertScreen(this.loadname);
        }
    }

    public void checkImage() {
        int checksum = 0;
        for (int xdot = 0; xdot < this.scrollImage.getWidth(); xdot += 10) {
            for (int ydot = 0; ydot < this.scrollImage.getHeight(); ydot += 10) {
                Color test2 = new Color(this.scrollImage.getRGB(xdot, ydot));
                checksum += this.getCOL(test2);
            }
        }
        if (checksum == 0) {
            this.convertScreen(this.loadname);
        }
    }

    public void savescreen(BufferedImage ima, String filename, String filetype) {
        try {
            File file = new File(filename);
            ImageIO.write((RenderedImage)ima, filetype, file);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void Autostore() {
        try {
            String append = "";
            if (this.autoIndex < 100) {
                append = append + "0";
            }
            if (this.autoIndex < 10) {
                append = append + "0";
            }
            append = append + "" + this.autoIndex++;
            File file = new File("store_" + append + ".bmp");
            ImageIO.write((RenderedImage)this.outimage, "bmp", file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void convert(boolean detect) {
        if (this.scr) {
            return;
        }
        this.scr = false;
        if (this.keepinks) {
            detect = false;
        }
        if (ImageProcessor.imp.isSelected()) {
            this.prepareInput(this.loadedImage);
        } else {
            this.showImage.getGraphics().drawImage(this.loadedImage, 0, 0, 384, 272, this);
        }
        if (detect && !this.detected) {
            System.out.println("Calculating palette...");
            try {
                this.buildCPCPalette(this.loadedImage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Done...");
            recalculate = 1;
            this.detected = true;
            return;
        }
        this.refactorImage();
        if (this.CPCImage == null) {
            return;
        }
        int width = this.CPCImage.getWidth();
        for (int y = 0; y < 272; ++y) {
            block3: for (int x = 0; x < width; ++x) {
                Color test2 = new Color(this.CPCImage.getRGB(x, y));
                this.findCPCInk(test2);
                Color peng = new Color(this.CPCRed, this.CPCGreen, this.CPCBlue);
                for (int p = 0; p < 16; ++p) {
                    if (this.getCOL(this.getColor(p)) != this.getCOL(peng)) continue;
                    this.plot(x, y, p & 0xF);
                    continue block3;
                }
            }
        }
    }

    public int replaceInk(int[] inInk) {
        int outInk = this.realInks[this.pen];
        int cols = 16;
        if (this.mode == 1) {
            cols = 4;
        }
        if (this.mode == 2) {
            cols = 2;
        }
        for (int c = 0; c < inInk.length; ++c) {
            for (int pn = 0; pn < cols; ++pn) {
                if (this.realInks[pn] != inInk[c]) continue;
                outInk = inInk[c];
                return outInk;
            }
        }
        return outInk;
    }

    public Color getCol(int index) {
        if (green) {
            return CPC.Greencols[index];
        }
        return CPC.Palcols[index];
    }

    public Color getColor(int index) {
        if (green) {
            return CPC.Greencols[GateArray.getInk(index)];
        }
        return CPC.Palcols[GateArray.getInk(index)];
    }

    public void clear() {
        for (int i = 0; i < 31936; ++i) {
            GateArray.screenmemory[512 + i] = 0;
        }
        filled = 1;
    }

    public void putScreen() {
        if (this.filling) {
            return;
        }
        Graphics page = this.getGraphics();
        this.sourceImage = new BufferedImage(this.swidth, this.sheight, 1);
        if (this.zoomit) {
            page.setColor(Color.MAGENTA);
            page.fillRect(0, 0, 800, 600);
            page.drawImage(Display.image, 0 - this.xoffset * this.zoomvalue, 0 - this.yoffset * this.zoomvalue, this.swidth * this.zoomvalue, this.sheight * this.zoomvalue, this);
            this.sourceImage.getGraphics().drawImage(Display.image, 0 - this.xoffset * this.zoomvalue, 0 - this.yoffset * this.zoomvalue, this.swidth * this.zoomvalue, this.sheight * this.zoomvalue, this);
        } else {
            page.drawImage(Display.image, 0, 0, this.swidth, this.sheight, this);
            this.sourceImage.getGraphics().drawImage(Display.image, 0, 0, this.swidth, this.sheight, this);
        }
        if (this.mode == 0) {
            this.outimage = new BufferedImage(192, 272, 1);
        }
        if (this.mode == 1) {
            this.outimage = new BufferedImage(384, 272, 1);
        }
        if (this.mode == 2) {
            this.outimage = new BufferedImage(768, 272, 1);
        }
        this.outimage.getGraphics().drawImage(this.sourceImage, 0, 0, this.outimage.getWidth(), 272, this);
        this.Zoom();
    }

    public void buildScreen(BufferedImage image) {
        for (int x = 0; x < this.swidth; ++x) {
            for (int y = 0; y < this.sheight; ++y) {
                Color test2 = new Color(image.getRGB(x, y));
                Color testb = CPC.getCol(this.pen);
                if (green) {
                    testb = CPC.getGCol(this.pen);
                }
                if (this.getCOL(test2) != this.getCOL(testb)) continue;
                int cpcX = x;
                int cpcY = y / 2;
                if (this.mode == 0) {
                    cpcX /= 4;
                }
                if (this.mode == 1) {
                    cpcX /= 2;
                }
                this.plot(cpcX, cpcY, this.pen);
            }
        }
    }

    public void putText() {
        BufferedImage off_Image = new BufferedImage(this.swidth, this.sheight, 1);
        Graphics2D page = off_Image.createGraphics();
        page.setColor(new Color(255, 113, 222));
        page.fillRect(0, 0, this.swidth, this.sheight);
        page.setFont(new Font(this.fontname, 0 + this.italic + this.bold, Integer.parseInt(overscanPaint.textsize.getText())));
        if (green) {
            page.setColor(CPC.getGCol(this.pen));
        } else {
            page.setColor(CPC.getCol(this.pen));
        }
        ((Graphics)page).drawString(overscanPaint.text.getText(), this.textX, this.textY);
        this.buildScreen(off_Image);
    }

    public void putObject(int number) {
        BufferedImage off_Image = new BufferedImage(this.swidth, this.sheight, 1);
        Graphics2D page = off_Image.createGraphics();
        page.setColor(new Color(255, 113, 222));
        page.fillRect(0, 0, this.swidth, this.sheight);
        if (green) {
            page.setColor(CPC.getGCol(this.pen));
        } else {
            page.setColor(CPC.getCol(this.pen));
        }
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        this.lineX = this.lineX / xs * xs;
        this.lineY = this.lineY / ys * ys;
        int fromx = this.lineX;
        int fromy = this.lineY;
        int tox = this.toX - this.lineX;
        int toy = this.toY - this.lineY;
        if (this.toX < this.lineX) {
            fromx = this.toX;
            tox = this.lineX - this.toX;
        } else {
            fromx = this.lineX;
            tox = this.toX - this.lineX;
        }
        if (this.toY < this.lineY) {
            fromy = this.toY;
            toy = this.lineY - this.toY;
        } else {
            fromy = this.lineY;
            toy = this.toY - this.lineY;
        }
        tox = tox / xs * xs;
        toy = toy / ys * ys;
        if (number == 1) {
            page.drawLine(this.lineX, this.lineY, this.toX, this.toY);
        }
        if (number == 2) {
            page.drawRect(fromx, fromy, tox, toy);
        }
        if (number == 3) {
            page.drawOval(fromx, fromy, tox, toy);
        }
        if (number == 4) {
            page.fillRect(fromx, fromy, tox + xs, toy + ys);
        }
        if (number == 5) {
            page.fillOval(fromx, fromy, tox + xs, toy + ys);
        }
        this.buildScreen(off_Image);
    }

    public void copyShape() {
        if (this.shapeW <= 0 || this.shapeH <= 0) {
            return;
        }
        this.putScreen();
        BufferedImage buffimg = new BufferedImage(this.swidth, this.sheight, 1);
        if (JEMU.large) {
            buffimg.getGraphics().drawImage(Display.image, 0, 0, this.swidth, this.sheight, this);
        } else {
            buffimg.getGraphics().drawImage(Display.image, 0, 0, this.sheight, this.sheight, this);
        }
        this.shapeBrush = new BufferedImage(this.shapeW, this.shapeH, 1);
        this.shapeBrush.getGraphics().drawImage(buffimg, 0 - this.shapeX, 0 - this.shapeY, this.shapeW, this.shapeH, 0, 0, this.shapeW + this.shapeX, this.shapeH + this.shapeY, this);
        int checksum = 0;
        for (int xdot = 0; xdot < this.shapeBrush.getWidth(); xdot += 2) {
            for (int ydot = 0; ydot < this.shapeBrush.getHeight(); ydot += 2) {
                Color test2 = new Color(this.shapeBrush.getRGB(xdot, ydot));
                checksum += this.getCOL(test2);
            }
        }
    }

    public void showShape(int x, int y) {
        if (this.shapeBrush == null) {
            return;
        }
        this.putScreen();
        Graphics page = this.getGraphics();
        page.drawImage(this.shapeBrush, x, y, this);
    }

    public void buildShape(int xpos, int ypos) {
        for (int pf = 0; pf < 27; ++pf) {
            this.Col[pf] = green ? new Color(GateArrayGreens[pf]) : new Color(GateArrayColors[pf]);
        }
        if (this.shapeBrush == null) {
            return;
        }
        int xs = 4;
        int ys = 2;
        int pns = 16;
        if (this.mode == 1) {
            xs = 2;
            pns = 4;
        }
        if (this.mode == 2) {
            xs = 1;
            pns = 2;
        }
        for (int x = 0; x < this.shapeBrush.getWidth(); x += xs) {
            for (int y = 0; y < this.shapeBrush.getHeight(); y += ys) {
                for (int pn = 0; pn < pns; ++pn) {
                    Color test2 = new Color(this.shapeBrush.getRGB(x, y));
                    Color testb = this.Col[GateArray.getInk(pn)];
                    int plusminus = 64;
                    if (plusmode) {
                        plusminus = 2;
                    }
                    if ((green || test2.getBlue() < testb.getBlue() - plusminus || test2.getBlue() > testb.getBlue() + plusminus || test2.getGreen() < testb.getGreen() - plusminus || test2.getGreen() > testb.getGreen() + plusminus || test2.getRed() < testb.getRed() - plusminus || test2.getRed() > testb.getRed() + plusminus) && (!green || test2.getGreen() < testb.getGreen() - 4 || test2.getGreen() > testb.getGreen() + 4)) continue;
                    int cpcX = x + xpos;
                    int cpcY = (y + ypos) / 2;
                    if (this.mode == 0) {
                        cpcX /= 4;
                    }
                    if (this.mode == 1) {
                        cpcX /= 2;
                    }
                    try {
                        if (pn == this.transpen) continue;
                        this.plot(cpcX, cpcY, pn);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void addX() {
        int xs = 1;
        if (this.mode == 1) {
            xs = 2;
        }
        if (this.mode == 0) {
            xs = 4;
        }
        this.xoffset += xs;
        this.putScreen();
    }

    public void addY() {
        this.yoffset += 2;
        this.putScreen();
    }

    public void subX() {
        if (this.mode == 1) {
            this.xoffset -= 2;
        }
        if (this.mode == 2) {
            --this.xoffset;
        }
        if (this.mode == 0) {
            this.xoffset -= 4;
        }
        this.putScreen();
    }

    public void subY() {
        this.yoffset -= 2;
        this.putScreen();
    }

    public void defineZoom(int x, int y) {
        this.xoffset = x - 768 / this.zoomvalue / 2;
        this.yoffset = y - 544 / this.zoomvalue / 2;
        if (this.xoffset < 0) {
            this.xoffset = 0;
        }
        if (this.yoffset < 0) {
            this.yoffset = 0;
        }
        while (this.xoffset + 768 / this.zoomvalue > 768) {
            --this.xoffset;
        }
        while (this.yoffset + 544 / this.zoomvalue > 544) {
            --this.yoffset;
        }
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        this.xoffset = this.xoffset / (xs * this.zoomvalue) * (xs * this.zoomvalue);
        this.yoffset = this.yoffset / (ys * this.zoomvalue) * (ys * this.zoomvalue);
        this.zoomit = true;
    }

    public void removeZoom() {
        this.zoomit = false;
        this.setzoom = false;
    }

    public void doZoom() {
        if (this.zoomit) {
            return;
        }
        this.setzoom = true;
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        int yc;
        int xc;
        this.mousebutton = event.getButton();
        if (this.setzoom) {
            this.setzoom = false;
            this.defineZoom(event.getX(), event.getY());
            return;
        }
        if (this.zoomit && this.mousebutton != 1) {
            return;
        }
        System.gc();
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        int gotX = event.getX();
        int gotY = event.getY();
        if (this.zoomit) {
            xc = gotX / (xs * this.zoomvalue) * (xs * this.zoomvalue);
            yc = gotY / (ys * this.zoomvalue) * (ys * this.zoomvalue);
        } else {
            xc = gotX / xs * xs;
            yc = gotY / ys * ys;
        }
        if (this.MODE == this.MODE_MINITEXT) {
            this.putText(xc, yc);
        }
        if (this.MODE == this.MODE_TEXT) {
            this.putText();
        }
        if (this.MODE == this.MODE_LINE) {
            this.putObject(1);
        }
        if (this.MODE == this.MODE_RECTANGLE) {
            this.putObject(2);
        }
        if (this.MODE == this.MODE_CIRCLE) {
            this.putObject(3);
        }
        if (this.MODE == this.MODE_FRECT) {
            this.putObject(4);
        }
        if (this.MODE == this.MODE_FILL) {
            this.Fill(xc, yc);
            filled = 1;
        }
        if (this.MODE == this.MODE_FCIRCLE) {
            this.putObject(5);
        }
        if (this.MODE == this.MODE_COPY) {
            this.copyShape();
            this.MODE = this.MODE_PASTE;
        } else if (this.MODE == this.MODE_PASTE && this.shapeBrush != null) {
            if (xc >= this.swidth - this.shapeBrush.getWidth()) {
                xc = this.swidth - this.shapeBrush.getWidth();
            }
            if (yc >= this.sheight - this.shapeBrush.getHeight()) {
                yc = this.sheight - this.shapeBrush.getHeight();
            }
            this.buildShape(xc, yc);
        }
        this.putScreen();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.mousebutton = event.getButton();
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.paint = true;
        this.setIcon(null);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.paint = false;
        try {
            this.setIcon(new ImageIcon(this.sourceImage));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getPlus() {
        return plusmode;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        int yc;
        int xc;
        if (this.MODE == this.MODE_FILL && this.isfilling) {
            return;
        }
        if (this.setzoom) {
            int x = event.getX();
            int y = event.getY();
            int xs = 1;
            int ys = 2;
            if (this.mode == 0) {
                xs = 4;
            }
            if (this.mode == 1) {
                xs = 2;
            }
            x = x / (xs * this.zoomvalue) * (xs * this.zoomvalue);
            y = y / (ys * this.zoomvalue) * (ys * this.zoomvalue);
            this.putScreen();
            Graphics page = this.getGraphics();
            page.setColor(new Color(Util.random(0xFFFFFF)));
            int px = x - 768 / this.zoomvalue / 2;
            int py = y - 544 / this.zoomvalue / 2;
            px = px / (xs * this.zoomvalue) * (xs * this.zoomvalue);
            py = py / (ys * this.zoomvalue) * (ys * this.zoomvalue);
            page.drawRect(px, py, 768 / this.zoomvalue, 544 / this.zoomvalue);
            return;
        }
        if (recalculate != 0) {
            return;
        }
        int xs = 1;
        int ys = 2;
        if (this.mode == 0) {
            xs = 4;
        }
        if (this.mode == 1) {
            xs = 2;
        }
        int gotX = event.getX();
        int gotY = event.getY();
        if (this.zoomit) {
            xc = gotX / (xs * this.zoomvalue) * (xs * this.zoomvalue);
            yc = gotY / (ys * this.zoomvalue) * (ys * this.zoomvalue);
        } else {
            xc = gotX / xs * xs;
            yc = gotY / ys * ys;
        }
        this.zoomx = gotX;
        this.zoomy = gotY;
        filled = 0;
        this.putScreen();
        Graphics page = this.getGraphics();
        if (this.MODE == this.MODE_MINITEXT) {
            Color check = green ? CPC.getGCol(this.textpen) : CPC.getCol(this.textpen);
            page.setColor(new Color(check.getRed(), check.getGreen(), check.getBlue(), 128));
            if (this.zoomit) {
                page.fillRect(xc, yc, this.minisize * this.zoomvalue, 10 * this.zoomvalue);
            } else {
                page.fillRect(xc, yc, this.minisize, 10);
            }
        }
        if (this.MODE == this.MODE_PAINT || this.MODE == this.MODE_LINE) {
            if (green) {
                page.setColor(CPC.getGCol(this.pen));
            } else {
                page.setColor(CPC.getCol(this.pen));
            }
            this.painted = true;
        }
        if (this.MODE == this.MODE_CIRCLE || this.MODE == this.MODE_FCIRCLE || this.MODE == this.MODE_COPY || this.MODE == this.MODE_RECTANGLE || this.MODE == this.MODE_FRECT) {
            if (green) {
                page.setColor(CPC.getGCol(this.pen));
            } else {
                page.setColor(CPC.getCol(this.pen));
            }
            this.cross(xc, yc);
            this.painted = true;
        }
        if (this.MODE == this.MODE_PASTE && this.shapeBrush != null) {
            if (xc >= this.swidth - this.shapeBrush.getWidth()) {
                xc = this.swidth - this.shapeBrush.getWidth();
            }
            if (yc >= this.sheight - this.shapeBrush.getHeight()) {
                yc = this.sheight - this.shapeBrush.getHeight();
            }
            this.showShape(xc, yc);
        }
        if (this.MODE == this.MODE_TEXT) {
            this.putScreen();
            this.textX = gotX / xs * xs;
            this.textY = gotY / ys * ys;
            page.setFont(new Font(this.fontname, 0 + this.italic + this.bold, Integer.parseInt(overscanPaint.textsize.getText())));
            if (green) {
                page.setColor(CPC.getGCol(this.pen));
            } else {
                page.setColor(CPC.getCol(this.pen));
            }
            page.drawString(overscanPaint.text.getText(), this.textX, this.textY);
        }
        this.drawCross(xc, yc, xs, ys);
    }

    public void drawCross(int xc, int yc, int xs, int ys) {
        Graphics page = this.getGraphics();
        boolean bl = this.flip = !this.flip;
        if (this.flip) {
            page.setColor(this.crossfade1);
        } else {
            page.setColor(this.crossfade2);
        }
        if (this.zoomit) {
            page.fillRect(xc, yc + 6 * this.zoomvalue, xs * this.zoomvalue, 10 * this.zoomvalue);
            page.fillRect(xc, yc - 14 * this.zoomvalue, xs * this.zoomvalue, 10 * this.zoomvalue);
            page.fillRect(xc + 6 * this.zoomvalue, yc, xs + 10 * this.zoomvalue, ys * this.zoomvalue);
            page.fillRect(xc - 16 * this.zoomvalue, yc, xs + 10 * this.zoomvalue, ys * this.zoomvalue);
            page.setColor(CPC.getCol(this.pen));
            page.fillRect(xc, yc, xs * this.zoomvalue, ys * this.zoomvalue);
        } else {
            page.fillRect(xc, yc + 6, xs, 10);
            page.fillRect(xc, yc - 14, xs, 10);
            page.fillRect(xc + 6, yc, xs + 10, ys);
            page.fillRect(xc - 16, yc, xs + 10, ys);
            page.setColor(CPC.getCol(this.pen));
            page.fillRect(xc, yc, xs, ys);
        }
    }

    public void cross(int xc, int yc) {
        Graphics page = this.getGraphics();
        page.setColor(this.random);
        page.drawLine(0, yc, this.swidth, yc);
        page.drawLine(0, yc + 1, this.swidth, yc + 1);
        page.drawLine(xc, 0, xc, this.sheight);
        if (this.mode == 1 || this.mode == 0) {
            page.drawLine(xc + 1, 0, xc + 1, this.sheight);
        }
        if (this.mode == 0) {
            page.drawLine(xc + 2, 0, xc + 2, this.sheight);
            page.drawLine(xc + 3, 0, xc + 3, this.sheight);
        }
    }

    public void cycle() {
        Switches.monitormode = green ? 2 : 0;
        if (this.showImage != null) {
            Graphics g = this.bzm.getGraphics();
            g.drawImage(this.showImage, 0, 0, 384, 272, this);
            overscanPaint.proc.image.setIcon(new ImageIcon(this.bzm));
        }
        if (autostore) {
            this.Autostore();
            autostore = false;
        }
        if (!this.isVisible()) {
            System.err.println("paint is cycling:" + this.cycles++);
        }
        ++this.reset;
        if (this.reset > 200) {
            this.reset = 0;
            overscanPaint.reset();
        }
        if (this.importname != null) {
            ++this.importscr;
            if (this.importscr == 40) {
                CPC.POKE(36863, 3);
            }
            if (this.importscr == 70) {
                this.convertScreen(this.importname);
                this.MODE = this.MODE_IMPORT;
                this.loadname = this.importname;
                this.importname = null;
                this.importscr = 0;
                if (!this.hasFocus()) {
                    this.requestFocus();
                }
            }
        }
        this.random = new Color(Util.random(255), Util.random(255), Util.random(255));
        if (filled > 0 && ++filled >= 20) {
            filled = 0;
            this.putScreen();
            overscanPaint.reset();
        }
        if (this.checkPal > 0) {
            ++this.checkPal;
            if (this.checkPal > 60) {
                this.setPal();
                filled = 1;
            }
            if (this.checkPal == 290) {
                this.checkPal = 0;
            }
        }
        if (this.doCycle) {
            if (this.MODE != this.MODE_IMPORT) {
                overscanPaint.ScrollUpDown.setEnabled(false);
                overscanPaint.ScrollLeftRight.setEnabled(false);
            } else {
                overscanPaint.ScrollUpDown.setEnabled(true);
                overscanPaint.ScrollLeftRight.setEnabled(true);
            }
            if (recalculate > 0) {
                if (++recalculate == 20) {
                    this.recalculate();
                    this.convert(true);
                }
                if (recalculate == 40) {
                    recalculate = 0;
                    overscanPaint.output.append("Size viewed: 768x544, ratio = " + (float)this.swidth / (float)this.sheight + " Origin : (" + this.scroll + "," + this.scrollb + ")\n");
                    overscanPaint.output.select(2000000000, 2000000000);
                    filled = 1;
                }
            }
            if (this.cycled > 0) {
                ++this.cycled;
                if (this.cycled == 10) {
                    this.convert(true);
                }
                if (this.cycled == 20) {
                    filled = 1;
                    this.cycled = 0;
                }
            }
        }
        this.mode = GateArray.getSMode();
    }

    public void makeUndo() {
        for (int y = 0; y < 31936; ++y) {
            this.undo[y] = GateArray.screenmemory[512 + y];
        }
    }

    public static void INK(int pen, int ink) {
        int addressA = 45529;
        int addressB = 45546;
        if (Switches.ROM.equals("CPC6128") || Switches.ROM.equals("CPC664")) {
            addressA = 47060;
            addressB = 47077;
        }
        CPC.POKE(addressA + 1 + pen, GateArrayINKs[ink]);
        CPC.POKE(addressB + 1 + pen, GateArrayINKs[ink]);
    }

    public void Undo() {
        for (int y = 0; y < 31936; ++y) {
            GateArray.screenmemory[512 + y] = (byte)this.undo[y];
        }
        filled = 1;
    }

    public void DSKLoad() {
        int y;
        JComboBox<String> filelist = new JComboBox<String>();
        String[] files = overscanPaint.files;
        for (y = 0; y < files.length; ++y) {
            files[y] = files[y].substring(0, 12);
        }
        for (y = 0; y < files.length; ++y) {
            if (!files[y].endsWith("SCR") && !files[y].endsWith("BIN")) continue;
            filelist.addItem(files[y]);
        }
        if (filelist.getItemAt(0) == null) {
            return;
        }
        Object[] object = new Object[]{filelist, this.restorePal};
        int selectedValue = JOptionPane.showOptionDialog(this, object, "Choose file:", 2, 2, null, null, null);
        if (selectedValue != 0) {
            return;
        }
        try {
            String lname = filelist.getSelectedItem().toString();
            byte[] load = lname.getBytes("UTF-8");
            for (int i = 923; i < 935; ++i) {
                CPC.POKE(36864 + i, load[i - 923]);
            }
            CPC.POKE(36863, 10);
            if (this.resPal) {
                this.checkPal = 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setPal() {
        if (plusmode) {
            this.makePlus(GateArray.screenmemory, 512);
        } else {
            int i;
            int checksum = 0;
            for (i = 0; i < 16; ++i) {
                checksum += GateArray.screenmemory[2049 + i];
            }
            if (checksum != 0) {
                for (i = 0; i < 16; ++i) {
                    OverscanCanvas.INK(i, GateArray.screenmemory[2049 + i]);
                }
                checksum = GateArray.screenmemory[2048];
                if (checksum == 0) {
                    checksum = 3;
                }
                CPC.POKE(36863, checksum);
            }
        }
        this.putScreen();
    }

    public void minitext() {
        String[] pena = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
        String[] penb = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "Off"};
        String[] transb = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "Transparent"};
        JPanel pen1 = new JPanel();
        pen1.setLayout(new FlowLayout(2, 1, 2));
        JPanel pen2 = new JPanel();
        pen2.setLayout(new FlowLayout(2, 1, 2));
        JPanel backg = new JPanel();
        backg.setLayout(new FlowLayout(2, 1, 2));
        JComboBox<String> penA = new JComboBox<String>(pena);
        JComboBox<String> penB = new JComboBox<String>(penb);
        JComboBox<String> transB = new JComboBox<String>(transb);
        penA.setSelectedIndex(this.textpen);
        penB.setSelectedIndex(this.smoothpen);
        transB.setSelectedIndex(this.transback);
        if (this.mode == 2) {
            penB.setEnabled(false);
            penB.setSelectedIndex(16);
        }
        JLabel penaa = new JLabel("Text-PEN    ");
        JLabel penbb = new JLabel("Smooth-PEN    ");
        JLabel transbb = new JLabel("Background    ");
        backg.add(transbb);
        backg.add(transB);
        pen1.add(penaa);
        pen1.add(penA);
        pen2.add(penbb);
        pen2.add(penB);
        JTextField inputtext = new JTextField();
        inputtext.setText(this.minitext);
        Object[] object = new Object[]{inputtext, pen1, pen2, backg};
        int selectedValue = JOptionPane.showOptionDialog(this, object, "Enter mini-text:", 2, 2, null, null, null);
        if (selectedValue != 0) {
            return;
        }
        try {
            int pn1 = Integer.parseInt(penA.getSelectedItem().toString());
            String pn2s = penB.getSelectedItem().toString();
            String pn3s = transB.getSelectedItem().toString();
            int pn2 = 0;
            int pn3 = 0;
            pn2 = pn2s.equals("Off") ? 16 : Integer.parseInt(penB.getSelectedItem().toString());
            pn3 = pn3s.equals("Transparent") ? 16 : Integer.parseInt(transB.getSelectedItem().toString());
            String enteredText = inputtext.getText();
            this.createText(pn1, pn2, pn3, enteredText);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void createText(int pen1, int pen2, int pen3, String text) {
        this.textpen = pen1;
        this.smoothpen = pen2;
        this.transback = pen3;
        this.minitext = text;
        text = text.toUpperCase();
        this.output = new String[text.length()];
        for (int i = 0; i < this.output.length; ++i) {
            this.output[i] = text.substring(i, i + 1);
        }
        this.minisize = this.output.length * 5;
        if (this.mode == 1) {
            this.minisize *= 2;
        }
        if (this.mode == 0) {
            this.minisize *= 4;
        }
        this.MODE = this.MODE_MINITEXT;
    }

    public void putText(int x, int y) {
        if (this.zoomit) {
            x /= this.zoomvalue;
            y /= this.zoomvalue;
            x += this.xoffset;
            y += this.yoffset;
        }
        this.iszoom = this.zoomit;
        this.zoomit = false;
        this.putScreen();
        y /= 2;
        int width = this.minisize;
        if (this.mode == 1) {
            x /= 2;
            width /= 2;
        }
        if (this.mode == 0) {
            x /= 4;
            width /= 4;
        }
        int posx = x;
        for (int i = 0; i < width / 5; ++i) {
            int[] letter = this.minifont.sp;
            if (this.output[i].equals("A")) {
                letter = this.minifont.A;
            }
            if (this.output[i].equals("B")) {
                letter = this.minifont.B;
            }
            if (this.output[i].equals("C")) {
                letter = this.minifont.C;
            }
            if (this.output[i].equals("D")) {
                letter = this.minifont.D;
            }
            if (this.output[i].equals("E")) {
                letter = this.minifont.E;
            }
            if (this.output[i].equals("F")) {
                letter = this.minifont.F;
            }
            if (this.output[i].equals("G")) {
                letter = this.minifont.G;
            }
            if (this.output[i].equals("H")) {
                letter = this.minifont.H;
            }
            if (this.output[i].equals("I")) {
                letter = this.minifont.I;
            }
            if (this.output[i].equals("J")) {
                letter = this.minifont.J;
            }
            if (this.output[i].equals("K")) {
                letter = this.minifont.K;
            }
            if (this.output[i].equals("L")) {
                letter = this.minifont.L;
            }
            if (this.output[i].equals("M")) {
                letter = this.minifont.M;
            }
            if (this.output[i].equals("N")) {
                letter = this.minifont.N;
            }
            if (this.output[i].equals("O")) {
                letter = this.minifont.O;
            }
            if (this.output[i].equals("P")) {
                letter = this.minifont.P;
            }
            if (this.output[i].equals("Q")) {
                letter = this.minifont.Q;
            }
            if (this.output[i].equals("R")) {
                letter = this.minifont.R;
            }
            if (this.output[i].equals("S")) {
                letter = this.minifont.S;
            }
            if (this.output[i].equals("T")) {
                letter = this.minifont.T;
            }
            if (this.output[i].equals("U")) {
                letter = this.minifont.U;
            }
            if (this.output[i].equals("V")) {
                letter = this.minifont.V;
            }
            if (this.output[i].equals("W")) {
                letter = this.minifont.W;
            }
            if (this.output[i].equals("X")) {
                letter = this.minifont.X;
            }
            if (this.output[i].equals("Y")) {
                letter = this.minifont.Y;
            }
            if (this.output[i].equals("Z")) {
                letter = this.minifont.Z;
            }
            if (this.output[i].equals("1")) {
                letter = this.minifont.n1;
            }
            if (this.output[i].equals("2")) {
                letter = this.minifont.n2;
            }
            if (this.output[i].equals("3")) {
                letter = this.minifont.n3;
            }
            if (this.output[i].equals("4")) {
                letter = this.minifont.n4;
            }
            if (this.output[i].equals("5")) {
                letter = this.minifont.n5;
            }
            if (this.output[i].equals("6")) {
                letter = this.minifont.n6;
            }
            if (this.output[i].equals("7")) {
                letter = this.minifont.n7;
            }
            if (this.output[i].equals("8")) {
                letter = this.minifont.n8;
            }
            if (this.output[i].equals("9")) {
                letter = this.minifont.n9;
            }
            if (this.output[i].equals("0")) {
                letter = this.minifont.n0;
            }
            if (this.output[i].equals("\u00a9")) {
                letter = this.minifont.cr;
            }
            if (this.output[i].equals("@")) {
                letter = this.minifont.at;
            }
            if (this.output[i].equals("-")) {
                letter = this.minifont.mn;
            }
            if (this.output[i].equals("+")) {
                letter = this.minifont.pl;
            }
            if (this.output[i].equals(",")) {
                letter = this.minifont.km;
            }
            if (this.output[i].equals(";")) {
                letter = this.minifont.sm;
            }
            if (this.output[i].equals(".")) {
                letter = this.minifont.pt;
            }
            if (this.output[i].equals(":")) {
                letter = this.minifont.dp;
            }
            if (this.output[i].equals("/")) {
                letter = this.minifont.sl;
            }
            if (this.output[i].equals("\\")) {
                letter = this.minifont.bs;
            }
            if (this.output[i].equals("\"")) {
                letter = this.minifont.qt;
            }
            if (this.output[i].equals("?")) {
                letter = this.minifont.qm;
            }
            if (this.output[i].equals("!")) {
                letter = this.minifont.xm;
            }
            if (this.output[i].equals("$")) {
                letter = this.minifont.dl;
            }
            if (this.output[i].equals("&")) {
                letter = this.minifont.nd;
            }
            if (this.output[i].equals("#")) {
                letter = this.minifont.rt;
            }
            if (this.output[i].equals("*")) {
                letter = this.minifont.mp;
            }
            if (this.output[i].equals("_")) {
                letter = this.minifont.us;
            }
            if (this.output[i].equals("(")) {
                letter = this.minifont.bo;
            }
            if (this.output[i].equals(")")) {
                letter = this.minifont.bc;
            }
            if (this.output[i].equals("[")) {
                letter = this.minifont.co;
            }
            if (this.output[i].equals("]")) {
                letter = this.minifont.cc;
            }
            if (this.output[i].equals("=")) {
                letter = this.minifont.eq;
            }
            if (this.output[i].equals("<")) {
                letter = this.minifont.st;
            }
            if (this.output[i].equals(">")) {
                letter = this.minifont.lt;
            }
            if (this.output[i].equals("%")) {
                letter = this.minifont.pc;
            }
            if (this.output[i].equals("|")) {
                letter = this.minifont.rx;
            }
            if (this.output[i].equals("'")) {
                letter = this.minifont.qo;
            }
            if (this.output[i].equals("{")) {
                letter = this.minifont.rc;
            }
            if (this.output[i].equals("}")) {
                letter = this.minifont.ro;
            }
            int block = 0;
            for (int ypixel = 0; ypixel < 5; ++ypixel) {
                for (int xpixel = 0; xpixel < 5; ++xpixel) {
                    if (letter[block] == 1) {
                        this.plot(posx + xpixel, y + ypixel, this.textpen);
                    }
                    if (letter[block] == 2 && this.smoothpen < 16) {
                        this.plot(posx + xpixel, y + ypixel, this.smoothpen);
                    }
                    if (letter[block] == 0 && this.transback < 16) {
                        this.plot(posx + xpixel, y + ypixel, this.transback);
                    }
                    ++block;
                }
            }
            posx += 5;
        }
        this.zoomit = this.iszoom;
        this.putScreen();
    }

    protected int getCOL(Color input) {
        return input.getRGB() & this.mask;
    }

    public void Fill(int x, int y) {
        if (this.zoomit) {
            x = x / this.zoomvalue + this.xoffset;
            y = y / this.zoomvalue + this.yoffset;
        }
        this.iszoom = this.zoomit;
        this.zoomit = false;
        this.putScreen();
        filled = 0;
        for (int pf = 0; pf < 800; ++pf) {
            this.yy[pf] = -1;
            this.xx[pf] = -1;
        }
        this.fillX = x;
        this.fillY = y;
        this.xStep = 1;
        if (this.mode == 1) {
            this.xStep = 2;
        }
        if (this.mode == 0) {
            this.xStep = 4;
        }
        this.z = 0;
        this.hf = this.test(x, y);
        if (green && this.hf == CPC.getGCol(this.pen)) {
            return;
        }
        if (!green && this.getCOL(this.hf) == this.getCOL(CPC.getCol(this.pen))) {
            return;
        }
        this.filling = true;
        this.searchUP();
        this.zoomit = this.iszoom;
        this.putScreen();
    }

    public void reCalc() {
        --this.z;
        if (this.z >= 0) {
            if (this.xx[this.z] >= 0) {
                this.fillX = this.xx[this.z];
            }
            if (this.yy[this.z] >= 0) {
                this.fillY = this.yy[this.z];
            }
        }
    }

    public void searchUP() {
        if (this.isfilling) {
            return;
        }
        Thread filler = new Thread(){

            @Override
            public void run() {
                OverscanCanvas.this.isfilling = true;
                while (OverscanCanvas.this.z >= 0) {
                    Graphics page = OverscanCanvas.this.getGraphics();
                    if (green) {
                        page.setColor(CPC.getGCol(OverscanCanvas.this.pen));
                    } else {
                        page.setColor(CPC.getCol(OverscanCanvas.this.pen));
                    }
                    while (OverscanCanvas.this.getCOL(OverscanCanvas.this.test(OverscanCanvas.this.fillX, OverscanCanvas.this.fillY)) == OverscanCanvas.this.getCOL(OverscanCanvas.this.hf) && OverscanCanvas.this.fillY < OverscanCanvas.this.sheight - 1) {
                        OverscanCanvas.this.fillY += 2;
                    }
                    OverscanCanvas.this.fillY -= 2;
                    OverscanCanvas.this.fr = OverscanCanvas.this.fl = new Color(68, 68, 68);
                    while (OverscanCanvas.this.fillY >= 0 && OverscanCanvas.this.getCOL(OverscanCanvas.this.test(OverscanCanvas.this.fillX, OverscanCanvas.this.fillY)) == OverscanCanvas.this.getCOL(OverscanCanvas.this.hf) && OverscanCanvas.this.fillX >= 0 && OverscanCanvas.this.fillX <= OverscanCanvas.this.swidth - OverscanCanvas.this.xStep) {
                        OverscanCanvas.this.vfl = OverscanCanvas.this.fl;
                        OverscanCanvas.this.fl = OverscanCanvas.this.test(OverscanCanvas.this.fillX - OverscanCanvas.this.xStep, OverscanCanvas.this.fillY);
                        if (OverscanCanvas.this.getCOL(OverscanCanvas.this.vfl) != OverscanCanvas.this.getCOL(OverscanCanvas.this.hf) && OverscanCanvas.this.getCOL(OverscanCanvas.this.fl) == OverscanCanvas.this.getCOL(OverscanCanvas.this.hf)) {
                            try {
                                if (OverscanCanvas.this.fillX >= OverscanCanvas.this.xStep) {
                                    OverscanCanvas.this.xx[OverscanCanvas.this.z] = OverscanCanvas.this.fillX - OverscanCanvas.this.xStep;
                                    OverscanCanvas.this.yy[OverscanCanvas.this.z] = OverscanCanvas.this.fillY;
                                    ++OverscanCanvas.this.z;
                                } else {
                                    OverscanCanvas.this.xx[OverscanCanvas.this.z] = 0;
                                    OverscanCanvas.this.yy[OverscanCanvas.this.z] = OverscanCanvas.this.fillY;
                                    ++OverscanCanvas.this.z;
                                }
                            }
                            catch (Exception e) {
                                filled = 1;
                                OverscanCanvas.this.filling = false;
                                OverscanCanvas.this.z = -1;
                                break;
                            }
                        }
                        OverscanCanvas.this.vfr = OverscanCanvas.this.fr;
                        OverscanCanvas.this.fr = OverscanCanvas.this.test(OverscanCanvas.this.fillX + OverscanCanvas.this.xStep, OverscanCanvas.this.fillY);
                        if (OverscanCanvas.this.getCOL(OverscanCanvas.this.vfr) != OverscanCanvas.this.getCOL(OverscanCanvas.this.hf) && OverscanCanvas.this.getCOL(OverscanCanvas.this.fr) == OverscanCanvas.this.getCOL(OverscanCanvas.this.hf)) {
                            try {
                                OverscanCanvas.this.xx[OverscanCanvas.this.z] = OverscanCanvas.this.fillX + OverscanCanvas.this.xStep;
                                OverscanCanvas.this.yy[OverscanCanvas.this.z] = OverscanCanvas.this.fillY;
                                ++OverscanCanvas.this.z;
                            }
                            catch (Exception e) {
                                filled = 1;
                                OverscanCanvas.this.filling = false;
                                OverscanCanvas.this.z = -1;
                                break;
                            }
                        }
                        int cpcY = OverscanCanvas.this.fillY / 2;
                        int cpcX = OverscanCanvas.this.fillX / OverscanCanvas.this.xStep;
                        CPC.PLOT(cpcX, cpcY, OverscanCanvas.this.pen, OverscanCanvas.this.mode, OverscanCanvas.this.overscan);
                        if (green) {
                            OverscanCanvas.this.sourceImage.getGraphics().setColor(CPC.getGCol(OverscanCanvas.this.pen));
                        } else {
                            OverscanCanvas.this.sourceImage.getGraphics().setColor(CPC.getCol(OverscanCanvas.this.pen));
                        }
                        OverscanCanvas.this.sourceImage.getGraphics().fillRect(OverscanCanvas.this.fillX, OverscanCanvas.this.fillY, OverscanCanvas.this.xStep, 2);
                        if (OverscanCanvas.this.showFill) {
                            page.fillRect(OverscanCanvas.this.fillX, OverscanCanvas.this.fillY, OverscanCanvas.this.xStep, 2);
                        }
                        OverscanCanvas.this.fillY -= 2;
                    }
                    OverscanCanvas.this.reCalc();
                }
                filled = 1;
                OverscanCanvas.this.filling = false;
                OverscanCanvas.this.isfilling = false;
            }
        };
        filler.start();
    }

    public Color test(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= this.swidth) {
            x = this.swidth - 1;
        }
        if (y >= this.sheight) {
            y = this.sheight - 1;
        }
        return new Color(this.sourceImage.getRGB(x, y));
    }

    public void buildCPCScreen(BufferedImage image, int[] colorPallet) {
        boolean dither = true;
        if (this.rasterval > 118) {
            dither = false;
        }
        int[][] cpComp = new int[colorPallet.length][3];
        for (int k = 0; k < colorPallet.length; ++k) {
            cpComp[k][0] = OverscanCanvas.red(colorPallet[k]);
            cpComp[k][1] = OverscanCanvas.green(colorPallet[k]);
            cpComp[k][2] = OverscanCanvas.blue(colorPallet[k]);
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                int pixelR = OverscanCanvas.red(pixel);
                int pixelG = OverscanCanvas.green(pixel);
                int pixelB = OverscanCanvas.blue(pixel);
                int minimumDistance = 195076;
                int ncIndex = -1;
                for (int j = 0; j < colorPallet.length; ++j) {
                    int rDiff = pixelR - cpComp[j][0];
                    int gDiff = pixelG - cpComp[j][1];
                    int bDiff = pixelB - cpComp[j][2];
                    int distance = (int)((double)(rDiff * rDiff) * 0.299 + (double)(gDiff * gDiff) * 0.587 + (double)(bDiff * bDiff) * 0.114);
                    if (distance >= minimumDistance) continue;
                    minimumDistance = distance;
                    ncIndex = j;
                }
                image.setRGB(x, y, colorPallet[ncIndex]);
                if (!dither) continue;
                for (int i = 0; i < 4; ++i) {
                    int yCoor;
                    int xCoor = i == 0 ? x + 1 : (i == 1 ? x - 1 : (i == 2 ? x : x + 1));
                    int n = yCoor = i == 0 ? y : y + 1;
                    if (xCoor < 0 || xCoor >= image.getWidth() || yCoor >= image.getHeight()) continue;
                    double factor = i == 0 ? 7.0 / (double)this.rasterval : (i == 1 ? 3.0 / (double)this.rasterval : (i == 2 ? 5.0 / (double)this.rasterval : 1.0 / (double)this.rasterval));
                    int p = image.getRGB(xCoor, yCoor);
                    int newRed = (int)Math.round((double)OverscanCanvas.red(p) + factor * (double)(pixelR - cpComp[ncIndex][0]));
                    int newGreen = (int)Math.round((double)OverscanCanvas.green(p) + factor * (double)(pixelG - cpComp[ncIndex][1]));
                    int newBlue = (int)Math.round((double)OverscanCanvas.blue(p) + factor * (double)(pixelB - cpComp[ncIndex][2]));
                    if (newRed < 0) {
                        newRed = 0;
                    }
                    if (newRed > 255) {
                        newRed = 255;
                    }
                    if (newGreen < 0) {
                        newGreen = 0;
                    }
                    if (newGreen > 255) {
                        newGreen = 255;
                    }
                    if (newBlue < 0) {
                        newBlue = 0;
                    }
                    if (newBlue > 255) {
                        newBlue = 255;
                    }
                    image.setRGB(xCoor, yCoor, -16777216 + (newRed << 16) + (newGreen << 8) + newBlue);
                }
            }
        }
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    public void storeScreen() {
        int i;
        overscanPaint.output.append("Storing screen to " + this.choosenImage + "\n");
        for (i = 0; i < 31936; ++i) {
            this.buffer[this.choosenImage][i] = GateArray.screenmemory[512 + i];
        }
        for (i = 0; i < 16; ++i) {
            this.buffer[this.choosenImage][31936 + i] = (byte)GateArray.getInk(i);
        }
        this.buffer[this.choosenImage][31952] = (byte)this.mode;
        try {
            FileOutputStream out = new FileOutputStream(System.getProperty("user.home") + "/JavaCPC/images_overscan.dat.gz");
            GZIPOutputStream gbos = new GZIPOutputStream(new BufferedOutputStream(out));
            for (int i2 = 0; i2 < 20; ++i2) {
                gbos.write(this.buffer[i2]);
            }
            gbos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadScreens() {
        if (this.screenChanged) {
            try {
                FileInputStream bos = new FileInputStream(System.getProperty("user.home") + "/JavaCPC/images_overscan.dat.gz");
                GZIPInputStream gbos = new GZIPInputStream(new BufferedInputStream(bos));
                this.input = new byte[639064];
                this.count = 0;
                while (gbos.available() != 0) {
                    this.input[this.count] = (byte)gbos.read();
                    ++this.count;
                }
                gbos.close();
                int offset = 0;
                for (int i = 0; i < 20; ++i) {
                    for (int d = 0; d < 31953; ++d) {
                        this.buffer[i][d] = this.input[offset + d];
                    }
                    offset += 31953;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.screenChanged = false;
    }

    public void restoreScreen() {
        int i;
        overscanPaint.output.append("Re-storing screen from " + this.choosenImage + "\n");
        for (i = 0; i < 31936; ++i) {
            GateArray.screenmemory[512 + i] = this.buffer[this.choosenImage][i];
        }
        for (i = 0; i < 16; ++i) {
            OverscanCanvas.INK(i, this.buffer[this.choosenImage][31936 + i]);
        }
        this.mode = this.buffer[this.choosenImage][31952];
        if (this.mode == 2) {
            CPC.POKE(36863, 2);
        }
        if (this.mode == 1) {
            CPC.POKE(36863, 1);
        }
        if (this.mode == 0) {
            CPC.POKE(36863, 3);
        }
        filled = 1;
        this.doCycle = true;
    }

    static {
        recalculate = 0;
        GateArrayINKs = new int[]{20, 4, 21, 28, 24, 29, 12, 5, 13, 22, 6, 23, 30, 0, 31, 14, 7, 15, 18, 2, 19, 26, 25, 27, 10, 3, 11};
        GateArrayColors = new int[]{0, 125, 255, 0x7D0000, 0x7D007D, 8192255, 0xFF0000, 16711805, 0xFF00FF, 32000, 32125, 32255, 0x7D7D00, 0x7D7D7D, 0x7D7DFF, 16743680, 0xFF7D7D, 0xFF7DFF, 65280, 65405, 65535, 8257280, 0x7DFF7D, 0x7DFFFF, 0xFFFF00, 0xFFFF7D, 0xFFFFFF};
        GateArrayOrg = new int[]{0, 125, 255, 0x7D0000, 0x7D007D, 8192255, 0xFF0000, 16711805, 0xFF00FF, 32000, 32125, 32255, 0x7D7D00, 0x7D7D7D, 0x7D7DFF, 16743680, 0xFF7D7D, 0xFF7DFF, 65280, 65405, 65535, 8257280, 0x7DFF7D, 0x7DFFFF, 0xFFFF00, 0xFFFF7D, 0xFFFFFF};
        GateArrayGreens = new int[]{0, 657930, 0x131313, 0x1D1D1D, 0x262626, 0x303030, 0x393939, 0x434343, 0x4C4C4C, 0x575757, 0x606060, 0x6A6A6A, 0x737373, 0x7D7D7D, 0x868686, 0x909090, 0x999999, 0xA3A3A3, 0xACACAC, 0xB5B5B5, 0xBFBFBF, 0xC9C9C9, 0xD2D2D2, 0xDCDCDC, 0xE5E5E5, 0xEFEFEF, 0xF8F8F8};
        horizontal = false;
        autostore = false;
    }
}

