/*
 * Decompiled with CFR 0.152.
 */
package jemu.util.hexeditor;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jemu.util.hexeditor.HexEditor;

class Data {
    private static final int PadSIZE = 4096;
    private byte[] leftArray;
    private int leftUsed;
    private byte[] rightArray;
    private int rightBegin;
    private int rightEnd;
    private int totalSize;

    public Data(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Data capacity " + capacity + " can't be negative");
        }
        this.leftArray = new byte[4096];
        this.rightArray = new byte[capacity + 4096];
        this.totalSize = 0;
        this.rightEnd = 0;
        this.rightBegin = 0;
        this.leftUsed = 0;
    }

    void append(int value) {
        this.put(this.size(), value);
    }

    void clear() {
        this.totalSize = 0;
        this.rightEnd = 0;
        this.rightBegin = 0;
        this.leftUsed = 0;
    }

    void delete(int position) {
        this.refreshSize();
        if (position < 0 || position >= this.totalSize) {
            this.error(position);
        } else if (position == this.leftUsed - 1) {
            --this.leftUsed;
        } else if (position == this.leftUsed) {
            ++this.rightBegin;
        } else if (position == this.totalSize - 1) {
            --this.rightEnd;
        } else if (this.split(position)) {
            ++this.rightBegin;
        }
    }

    private void error(int position) {
        throw new ArrayIndexOutOfBoundsException("Data index " + position + " is not from 0 to " + this.size());
    }

    int get(int position) {
        int result;
        if (position < 0 || position >= this.size()) {
            this.error(position);
            result = -1;
        } else {
            result = position < this.leftUsed ? this.leftArray[position] & 0xFF : this.rightArray[position - this.leftUsed + this.rightBegin] & 0xFF;
        }
        return result;
    }

    void insert(int position, int value) {
        this.refreshSize();
        if (position < 0 || position > this.totalSize) {
            this.error(position);
        } else if (position == this.leftUsed && this.leftUsed < this.leftArray.length) {
            this.leftArray[this.leftUsed++] = (byte)value;
        } else if (position == this.totalSize && this.rightEnd < this.rightArray.length) {
            this.rightArray[this.rightEnd++] = (byte)value;
        } else if (this.split(position)) {
            this.leftArray[this.leftUsed++] = (byte)value;
        }
    }

    void put(int position, int value) {
        this.refreshSize();
        if (position < 0 || position > this.totalSize) {
            this.error(position);
        } else if (position < this.leftUsed) {
            this.leftArray[position] = (byte)value;
        } else if (position < this.totalSize) {
            this.rightArray[position - this.leftUsed + this.rightBegin] = (byte)value;
        } else if (this.rightEnd < this.rightArray.length) {
            this.rightArray[this.rightEnd++] = (byte)value;
        } else if (this.split(position)) {
            this.leftArray[this.leftUsed++] = (byte)value;
        }
    }

    private void refreshSize() {
        this.totalSize = this.leftUsed + this.rightEnd - this.rightBegin;
    }

    int size() {
        this.refreshSize();
        return this.totalSize;
    }

    private boolean split(int position) {
        this.refreshSize();
        boolean result = false;
        if (position < 0 || position > this.totalSize) {
            this.error(position);
        } else {
            try {
                int i;
                byte[] newLeftArray = new byte[position + 4096];
                int count = Math.min(this.leftUsed, position);
                int newLeftUsed = 0;
                for (int i2 = 0; i2 < count; ++i2) {
                    newLeftArray[newLeftUsed++] = this.leftArray[i2];
                }
                count = position - this.leftUsed;
                int from = this.rightBegin;
                for (int i3 = 0; i3 < count; ++i3) {
                    newLeftArray[newLeftUsed++] = this.rightArray[from++];
                }
                byte[] newRightArray = new byte[this.totalSize - position + 4096];
                count = this.leftUsed - position;
                from = position;
                int newRightUsed = 0;
                for (i = 0; i < count; ++i) {
                    newRightArray[newRightUsed++] = this.leftArray[from++];
                }
                count = this.totalSize - Math.max(this.leftUsed, position);
                from = this.rightEnd - count;
                for (i = 0; i < count; ++i) {
                    newRightArray[newRightUsed++] = this.rightArray[from++];
                }
                this.leftArray = newLeftArray;
                this.leftUsed = newLeftUsed;
                this.rightArray = newRightArray;
                this.rightBegin = 0;
                this.rightEnd = newRightUsed;
                result = true;
            }
            catch (OutOfMemoryError oome) {
                Object newRightArray = null;
                Object newLeftArray = null;
                JOptionPane.showMessageDialog(new JFrame(), "Not enough memory to edit this file (" + HexEditor.formatComma.format((this.size() + 1) / 2) + " bytes).\n" + "Try increasing the Java heap size with the -Xmx option.");
            }
        }
        return result;
    }
}

