/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.lhadecompressor.LhDecoder;
import net.sourceforge.lhadecompressor.LhaException;

public class Lh4Decoder
extends LhDecoder {
    private static final int UNSIGNED_SHORT_BIT = 16;
    private static final int NT = 19;
    private static final int TBIT = 5;
    private static final int CBIT = 9;
    private static final int CODE_TABLE_SIZE = 4096;
    private int[] codeLength = new int[510];
    private int[] codeTable = new int[4096];
    private int np;
    private int positionBit;
    private int blockSize;

    public Lh4Decoder(InputStream in, long originalSize, int dictionaryBit, int np, int positionBit) {
        super(in, originalSize, dictionaryBit, 253);
        this.np = np;
        this.positionBit = positionBit;
        this.blockSize = 0;
    }

    @Override
    protected void initRead() throws LhaException, IOException {
        this.fillBitBuffer(16);
    }

    @Override
    protected int decodeCode() throws IOException {
        if (this.blockSize == 0) {
            this.blockSize = this.getBits(16);
            this.readPositionLength(19, 5, 3);
            this.readCodeLength();
            this.readPositionLength(this.np, this.positionBit, -1);
        }
        --this.blockSize;
        int j = this.codeTable[this.bitBuffer >>> 4];
        if (j < 510) {
            this.fillBitBuffer(this.codeLength[j]);
        } else {
            this.fillBitBuffer(12);
            int mask = 32768;
            while ((j = (this.bitBuffer & mask) != 0 ? this.treeRight[j] : this.treeLeft[j]) >= 510 && ((mask >>>= 1) != 0 || j != this.treeLeft[j])) {
            }
            this.fillBitBuffer(this.codeLength[j] - 12);
        }
        return j;
    }

    @Override
    protected int decodePosition() throws IOException {
        int j = this.positionTable[this.bitBuffer >>> 8];
        if (j < this.np) {
            this.fillBitBuffer(this.positionLength[j]);
        } else {
            this.fillBitBuffer(8);
            int mask = 32768;
            while ((j = (this.bitBuffer & mask) != 0 ? this.treeRight[j] : this.treeLeft[j]) >= this.np && ((mask >>>= 1) != 0 || j != this.treeLeft[j])) {
            }
            this.fillBitBuffer(this.positionLength[j] - 8);
        }
        if (j != 0) {
            j = (1 << j - 1) + this.getBits(j - 1);
        }
        return j;
    }

    private final void readPositionLength(int nn, int nbit, int i_special) throws IOException {
        int n = this.getBits(nbit);
        if (n == 0) {
            int i;
            int c = this.getBits(nbit);
            for (i = 0; i < nn; ++i) {
                this.positionLength[i] = 0;
            }
            for (i = 0; i < 256; ++i) {
                this.positionTable[i] = c;
            }
        } else {
            int max;
            int i = 0;
            int n2 = max = n < 128 ? n : 128;
            while (i < max) {
                int c = this.bitBuffer >>> 13;
                if (c != 7) {
                    this.fillBitBuffer(3);
                } else {
                    int mask = 4096;
                    while ((mask & this.bitBuffer) != 0) {
                        mask >>>= 1;
                        ++c;
                    }
                    this.fillBitBuffer(c - 3);
                }
                this.positionLength[i++] = c;
                if (i != i_special) continue;
                c = this.getBits(2);
                while (--c >= 0 && i < 128) {
                    this.positionLength[i++] = 0;
                }
            }
            while (i < nn) {
                this.positionLength[i++] = 0;
            }
            this.makeTable(nn, this.positionLength, 8, this.positionTable);
        }
    }

    private final void readCodeLength() throws IOException {
        int n = this.getBits(9);
        if (n == 0) {
            int i;
            int c = this.getBits(9);
            for (i = 0; i < 510; ++i) {
                this.codeLength[i] = 0;
            }
            for (i = 0; i < 4096; ++i) {
                this.codeTable[i] = c;
            }
        } else {
            int max;
            int i = 0;
            int n2 = max = n < 510 ? n : 510;
            while (i < max) {
                int c = this.positionTable[this.bitBuffer >>> 8];
                if (c >= 19) {
                    int mask = 128;
                    while ((c = (this.bitBuffer & mask) != 0 ? this.treeRight[c] : this.treeLeft[c]) >= 19 && ((mask >>>= 1) != 0 || c != this.treeLeft[c])) {
                    }
                }
                this.fillBitBuffer(this.positionLength[c]);
                if (c <= 2) {
                    c = c == 0 ? 1 : (c == 1 ? this.getBits(4) + 3 : this.getBits(9) + 20);
                    while (--c >= 0) {
                        this.codeLength[i++] = 0;
                    }
                    continue;
                }
                this.codeLength[i++] = c - 2;
            }
            while (i < 510) {
                this.codeLength[i++] = 0;
            }
            this.makeTable(510, this.codeLength, 12, this.codeTable);
        }
    }
}

