/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;

public class LhaEntry {
    public static final String HD_STR_ENCODING = "MS932";
    public static final String METHOD_SIG_LHD = "-lhd-";
    public static final String METHOD_SIG_LH0 = "-lh0-";
    public static final String METHOD_SIG_LH1 = "-lh1-";
    public static final String METHOD_SIG_LH2 = "-lh2-";
    public static final String METHOD_SIG_LH3 = "-lh3-";
    public static final String METHOD_SIG_LH4 = "-lh4-";
    public static final String METHOD_SIG_LH5 = "-lh5-";
    public static final String METHOD_SIG_LH6 = "-lh6-";
    public static final String METHOD_SIG_LH7 = "-lh7-";
    public static final String METHOD_SIG_LZS = "-lzs-";
    public static final String METHOD_SIG_LZ4 = "-lz4-";
    public static final String METHOD_SIG_LZ5 = "-lz5-";
    public static final byte OSID_SIG_GENERIC = 0;
    public static final byte OSID_SIG_MSDOS = 77;
    public static final byte OSID_SIG_OS2 = 50;
    public static final byte OSID_SIG_OS9 = 57;
    public static final byte OSID_SIG_OS68K = 75;
    public static final byte OSID_SIG_OS386 = 51;
    public static final byte OSID_SIG_HUMAN = 72;
    public static final byte OSID_SIG_UNIX = 85;
    public static final byte OSID_SIG_CPM = 67;
    public static final byte OSID_SIG_FLEX = 70;
    public static final byte OSID_SIG_MAC = 109;
    public static final byte OSID_SIG_RUNSER = 82;
    public static final byte OSID_SIG_JAVA = 74;
    public static final byte OSID_SIG_WIN32 = 119;
    public static final byte OSID_SIG_WINNT = 87;
    public static final byte EXHDR_SIG_COMMON = 0;
    public static final byte EXHDR_SIG_FILENAME = 1;
    public static final byte EXHDR_SIG_DIRNAME = 2;
    public static final byte EXHDR_SIG_COMMENT = 63;
    public static final byte EXHDR_SIG_DOSATTR = 64;
    public static final byte EXHDR_SIG_DOSTIMES = 65;
    public static final byte EXHDR_SIG_UNIXPERM = 80;
    public static final byte EXHDR_SIG_UNIXID = 81;
    public static final byte EXHDR_SIG_UNIXGROUPNAME = 82;
    public static final byte EXHDR_SIG_UNIXUSERNAME = 83;
    public static final byte EXHDR_SIG_UNIXLMTIME = 84;
    protected String method;
    protected long compressedSize;
    protected long originalSize;
    protected Date timeStamp;
    protected File file;
    protected int crc;
    protected boolean fcrc = false;
    protected byte os;
    protected long offset = -1L;

    protected void setMethod(String method) {
        if (method.compareTo(METHOD_SIG_LHD) != 0 && method.compareTo(METHOD_SIG_LH0) != 0 && method.compareTo(METHOD_SIG_LH1) != 0 && method.compareTo(METHOD_SIG_LH2) != 0 && method.compareTo(METHOD_SIG_LH3) != 0 && method.compareTo(METHOD_SIG_LH4) != 0 && method.compareTo(METHOD_SIG_LH5) != 0 && method.compareTo(METHOD_SIG_LH6) != 0 && method.compareTo(METHOD_SIG_LH7) != 0 && method.compareTo(METHOD_SIG_LZS) != 0 && method.compareTo(METHOD_SIG_LZ4) != 0 && method.compareTo(METHOD_SIG_LZ5) != 0) {
            return;
        }
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    protected void setCompressedSize(long compressedSize) {
        if (compressedSize < 0L || compressedSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid lzh entry compressed data size");
        }
        this.compressedSize = compressedSize;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    protected void setOriginalSize(long originalSize) {
        if (originalSize < 0L || originalSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid lha entry original data size");
        }
        this.originalSize = originalSize;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    protected void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Date getTimeStamp() {
        return (Date)this.timeStamp.clone();
    }

    protected void setDosTimeStamp(long tstamp) {
        Date ts = new Date();
        ts.setTime(LhaEntry.dosToJavaTime(tstamp));
        this.timeStamp = ts;
    }

    public long getDosTimeStamp() {
        return LhaEntry.javaToDosTime(this.timeStamp.getTime());
    }

    protected void setHeaderTimeStamp(long tstamp) {
        Date ts = new Date();
        ts.setTime(tstamp * 1000L);
        this.timeStamp = ts;
    }

    public long getHeaderTimeStamp() {
        if (this.timeStamp == null) {
            return -1L;
        }
        return this.timeStamp.getTime();
    }

    protected void setFile(String name) {
        this.file = new File(name);
    }

    protected void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    protected void setCRC(int crc) {
        this.fcrc = true;
        this.crc = crc;
    }

    public int getCRC() {
        return this.crc;
    }

    public boolean hasCRC() {
        return this.fcrc;
    }

    protected void setOS(byte os) {
        this.os = os;
    }

    public byte getOS() {
        return this.os;
    }

    public String toString() {
        return this.file.toString();
    }

    protected void setOffset(long offset) {
        if (offset < 0L || offset > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid lzh entry offset");
        }
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    private static long dosToJavaTime(long dtime) {
        GregorianCalendar c = new GregorianCalendar((int)((dtime >> 25 & 0x7FL) + 1980L), (int)((dtime >> 21 & 0xFL) - 1L), (int)(dtime >> 16 & 0x1FL), (int)(dtime >> 11 & 0x1FL), (int)(dtime >> 5 & 0x3FL), (int)(dtime << 1 & 0x3EL));
        return c.getTime().getTime();
    }

    private static long javaToDosTime(long time) {
        GregorianCalendar c = new GregorianCalendar();
        c.setGregorianChange(new Date(time));
        int year = c.get(1) + 1900;
        if (year < 1980) {
            return 0x210000L;
        }
        return year - 1980 << 25 | c.get(2) + 1 << 21 | c.get(5) << 16 | c.get(11) << 11 | c.get(12) << 5 | c.get(13) >> 1;
    }
}

