/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONTokener;

public class JSONObject {
    private HashMap myHashMap;
    public static final Object NULL = new Null();

    public JSONObject() {
        this.myHashMap = new HashMap();
    }

    public JSONObject(JSONTokener x) throws ParseException {
        this();
        if (x.next() == '%') {
            x.unescape();
        }
        x.back();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            if (x.nextClean() != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.myHashMap.put(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(String string) throws ParseException {
        this(new JSONTokener(string));
    }

    public JSONObject(Map map) {
        this.myHashMap = new HashMap(map);
    }

    public JSONObject accumulate(String key, Object value) throws NullPointerException {
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value);
        } else if (o instanceof JSONArray) {
            JSONArray a = (JSONArray)o;
            a.put(value);
        } else {
            JSONArray a = new JSONArray();
            a.put(o);
            a.put(value);
            this.put(key, a);
        }
        return this;
    }

    public Object get(String key) throws NoSuchElementException {
        Object o = this.opt(key);
        if (o == null) {
            throw new NoSuchElementException("JSONObject[" + JSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws ClassCastException, NoSuchElementException {
        Object o = this.get(key);
        if (o == Boolean.FALSE || o.equals("false")) {
            return false;
        }
        if (o == Boolean.TRUE || o.equals("true")) {
            return true;
        }
        throw new ClassCastException("JSONObject[" + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws NoSuchElementException, NumberFormatException {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        throw new NumberFormatException("JSONObject[" + JSONObject.quote(key) + "] is not a number.");
    }

    HashMap getHashMap() {
        return this.myHashMap;
    }

    public int getInt(String key) throws NoSuchElementException, NumberFormatException {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) throws NoSuchElementException {
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new NoSuchElementException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) throws NoSuchElementException {
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new NoSuchElementException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONObject.");
    }

    public String getString(String key) throws NoSuchElementException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.myHashMap.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        if (ja.length() == 0) {
            return null;
        }
        return ja;
    }

    public static String numberToString(Number n) throws ArithmeticException {
        if (n instanceof Float && (((Float)n).isInfinite() || ((Float)n).isNaN()) || n instanceof Double && (((Double)n).isInfinite() || ((Double)n).isNaN())) {
            throw new ArithmeticException("JSON can only serialize finite numbers.");
        }
        String s = n.toString().toLowerCase();
        if (s.indexOf(101) < 0 && s.indexOf(46) > 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object opt(String key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        return this.myHashMap.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            if (o == Boolean.FALSE || o.equals("false")) {
                return false;
            }
            if (o == Boolean.TRUE || o.equals("true")) {
                return true;
            }
        }
        return defaultValue;
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            try {
                return Double.parseDouble((String)o);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            try {
                return Integer.parseInt((String)o);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public JSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        return null;
    }

    public JSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        return null;
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            return o.toString();
        }
        return defaultValue;
    }

    public JSONObject put(String key, boolean value) {
        this.put(key, new Boolean(value));
        return this;
    }

    public JSONObject put(String key, double value) {
        this.put(key, new Double(value));
        return this;
    }

    public JSONObject put(String key, int value) {
        this.put(key, new Integer(value));
        return this;
    }

    public JSONObject put(String key, Object value) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            this.myHashMap.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws NullPointerException {
        if (value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block8: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.myHashMap.remove(key);
    }

    public JSONArray toJSONArray(JSONArray names) {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        Iterator keys = this.keys();
        Object o = null;
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        while (keys.hasNext()) {
            String s;
            if (o != null) {
                sb.append(',');
            }
            if ((o = (Object)this.myHashMap.get(s = keys.next().toString())) == null) continue;
            sb.append(JSONObject.quote(s));
            sb.append(':');
            if (o instanceof String) {
                sb.append(JSONObject.quote((String)o));
                continue;
            }
            if (o instanceof Number) {
                sb.append(JSONObject.numberToString((Number)o));
                continue;
            }
            sb.append(o.toString());
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) {
        Iterator keys = this.keys();
        String pad = "";
        StringBuffer sb = new StringBuffer();
        indent += indentFactor;
        for (int i = 0; i < indent; ++i) {
            pad = pad + ' ';
        }
        sb.append("{\n");
        while (keys.hasNext()) {
            String s = keys.next().toString();
            Object o = this.myHashMap.get(s);
            if (o == null) continue;
            if (sb.length() > 2) {
                sb.append(",\n");
            }
            sb.append(pad);
            sb.append(JSONObject.quote(s));
            sb.append(": ");
            if (o instanceof String) {
                sb.append(JSONObject.quote((String)o));
                continue;
            }
            if (o instanceof Number) {
                sb.append(JSONObject.numberToString((Number)o));
                continue;
            }
            if (o instanceof JSONObject) {
                sb.append(((JSONObject)o).toString(indentFactor, indent));
                continue;
            }
            if (o instanceof JSONArray) {
                sb.append(((JSONArray)o).toString(indentFactor, indent));
                continue;
            }
            sb.append(o.toString());
        }
        sb.append('}');
        return sb.toString();
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

