/*
 * Decompiled with CFR 0.152.
 */
package pacman;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import pacman.DirtyRect;
import pacman.Game;
import pacman.Lock;
import pacman.Score;
import pacman.Text;

public class Main
extends Canvas
implements Runnable {
    static final int SEED = 313210061;
    Thread thread;
    BufferedImage offScrImage;
    protected int RandomSeed = 313210061;
    DirtyRect dirty;
    Score score;
    Text text;
    Game game;
    Lock lock;

    public void init() {
        this.setSize(784, 568);
        this.setPreferredSize(new Dimension(784, 568));
        this.offScrImage = new BufferedImage(784, 568, 4);
        this.dirty = new DirtyRect(this);
        this.score = new Score(this);
        this.text = new Text(this);
        this.game = new Game(this);
        this.lock = new Lock(this);
        this.dirty.invalidate();
        this.start();
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.thread.stop();
    }

    public void draw(Graphics graphics) {
        this.dirty.reset();
        this.game.drawScreen(this.offScrImage.getGraphics());
        this.dirty.draw(graphics, this.offScrImage);
    }

    @Override
    public void paint(Graphics graphics) {
        this.dirty.invalidate();
        this.draw(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        this.draw(graphics);
    }

    @Override
    public void run() {
        while (true) {
            if (!this.lock.flag) {
                try {
                    if (this != null) {
                        // empty if block
                    }
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lock.flag = false;
            this.repaint();
        }
    }

    @Override
    public boolean gotFocus(Event event, Object object) {
        return true;
    }

    @Override
    public boolean lostFocus(Event event, Object object) {
        return true;
    }

    @Override
    public boolean keyDown(Event event, int i) {
        this.game.handleInput(event, i);
        return true;
    }

    @Override
    public boolean keyUp(Event event, int i) {
        return true;
    }

    public Image LoadImage(String string, int i, int i_0_) {
        string = string.replace("images/", "");
        System.out.println("LoadImage: " + string);
        URL url = this.getClass().getResource(string);
        System.out.println("CodeBase: " + url);
        boolean bool = false;
        Image image = this.getToolkit().getImage(url);
        Graphics graphics = this.offScrImage.getGraphics().create(0, 0, i, i_0_);
        while (!bool) {
            try {
                if (this != null) {
                    // empty if block
                }
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedexception) {
                // empty catch block
            }
            bool = graphics.drawImage(image, 0, 0, this);
        }
        graphics.dispose();
        System.out.println("LoadImage complete");
        return image;
    }

    public int random() {
        int i;
        int i_1_ = i = this.RandomSeed;
        if ((i_1_ ^= (i <<= 1)) < 0) {
            i |= 1;
        }
        if ((i *= 31055) == 0) {
            i = 313210061;
        }
        this.RandomSeed = i;
        return i;
    }

    public int random_range(int i) {
        int i_2_ = this.random();
        i_2_ = i_2_ >> 16 & 0xFFFF;
        i_2_ *= i;
        i_2_ = i_2_ >> 16 & 0xFFF;
        return i_2_;
    }
}

