/*
 * Decompiled with CFR 0.152.
 */
package tiled.core;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.imageio.ImageIO;
import tiled.core.ObjectGroup;

public class MapObject
implements Cloneable {
    private Properties properties = new Properties();
    private ObjectGroup objectGroup;
    private Rectangle bounds = new Rectangle();
    private String name = "Object";
    private String type = "";
    private String imageSource = "";
    private Image image;
    private Image scaledImage;

    public MapObject(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public Object clone() throws CloneNotSupportedException {
        MapObject clone = (MapObject)super.clone();
        clone.bounds = new Rectangle(this.bounds);
        clone.properties = (Properties)this.properties.clone();
        return clone;
    }

    public ObjectGroup getObjectGroup() {
        return this.objectGroup;
    }

    public void setObjectGroup(ObjectGroup objectGroup) {
        this.objectGroup = objectGroup;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public String getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(String source) {
        if (this.imageSource.equals(source)) {
            return;
        }
        this.imageSource = source;
        if (this.imageSource.length() > 0) {
            try {
                this.image = ImageIO.read(new File(this.imageSource));
            }
            catch (IOException e) {
                this.image = null;
            }
        } else {
            this.image = null;
        }
        this.scaledImage = null;
    }

    public Image getImage(double zoom) {
        if (this.image == null) {
            return null;
        }
        int zoomedWidth = (int)((double)this.getWidth() * zoom);
        int zoomedHeight = (int)((double)this.getHeight() * zoom);
        if (this.scaledImage == null || this.scaledImage.getWidth(null) != zoomedWidth || this.scaledImage.getHeight(null) != zoomedHeight) {
            this.scaledImage = this.image.getScaledInstance(zoomedWidth, zoomedHeight, 4);
        }
        return this.scaledImage;
    }

    public int getX() {
        return this.bounds.x;
    }

    public void setX(int x) {
        this.bounds.x = x;
    }

    public int getY() {
        return this.bounds.y;
    }

    public void setY(int y) {
        this.bounds.y = y;
    }

    public void translate(int dx, int dy) {
        this.bounds.translate(dx, dy);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public void setWidth(int width) {
        this.bounds.width = width;
    }

    public void setHeight(int height) {
        this.bounds.height = height;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    public String toString() {
        return this.type + " (" + this.getX() + "," + this.getY() + ")";
    }
}

