/*
 * Decompiled with CFR 0.152.
 */
package tiled.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import tiled.core.Tile;
import tiled.core.TilesetChangeListener;
import tiled.core.TilesetChangedEvent;
import tiled.mapeditor.util.TransparentImageFilter;
import tiled.mapeditor.util.cutter.BasicTileCutter;
import tiled.mapeditor.util.cutter.TileCutter;
import tiled.util.NumberedSet;

public class TileSet {
    private String base;
    private NumberedSet tiles = new NumberedSet();
    private NumberedSet images = new NumberedSet();
    private int firstGid;
    private long tilebmpFileLastModified;
    private TileCutter tileCutter;
    private Rectangle tileDimensions = new Rectangle();
    private int tileSpacing;
    private int tileMargin;
    private int tilesPerRow;
    private String externalSource;
    private File tilebmpFile;
    private String name;
    private Color transparentColor;
    private Properties defaultTileProperties = new Properties();
    private Image tileSetImage;
    private LinkedList<TilesetChangeListener> tilesetChangeListeners = new LinkedList();

    public void importTileBitmap(String imgFilename, TileCutter cutter) throws IOException {
        this.setTilesetImageFilename(imgFilename);
        Image image = ImageIO.read(new File(imgFilename));
        if (image == null) {
            throw new IOException("Failed to load " + this.tilebmpFile);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (this.transparentColor != null) {
            int rgb = this.transparentColor.getRGB();
            image = tk.createImage(new FilteredImageSource(((Image)image).getSource(), new TransparentImageFilter(rgb)));
        }
        BufferedImage buffered = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
        buffered.getGraphics().drawImage(image, 0, 0, null);
        this.importTileBitmap(buffered, cutter);
    }

    private void importTileBitmap(BufferedImage tilebmp, TileCutter cutter) {
        assert (tilebmp != null);
        assert (cutter != null);
        this.tileCutter = cutter;
        this.tileSetImage = tilebmp;
        cutter.setImage(tilebmp);
        this.tileDimensions = new Rectangle(cutter.getTileDimensions());
        if (cutter instanceof BasicTileCutter) {
            BasicTileCutter basicTileCutter = (BasicTileCutter)cutter;
            this.tileSpacing = basicTileCutter.getTileSpacing();
            this.tileMargin = basicTileCutter.getTileMargin();
            this.tilesPerRow = basicTileCutter.getTilesPerRow();
        }
        Image tile = cutter.getNextTile();
        while (tile != null) {
            Tile newTile = new Tile();
            newTile.setImage(this.addImage(tile));
            this.addNewTile(newTile);
            tile = cutter.getNextTile();
        }
    }

    private void refreshImportedTileBitmap() throws IOException {
        String imgFilename = this.tilebmpFile.getPath();
        Image image = ImageIO.read(new File(imgFilename));
        if (image == null) {
            throw new IOException("Failed to load " + this.tilebmpFile);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (this.transparentColor != null) {
            int rgb = this.transparentColor.getRGB();
            image = tk.createImage(new FilteredImageSource(((Image)image).getSource(), new TransparentImageFilter(rgb)));
        }
        BufferedImage buffered = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
        buffered.getGraphics().drawImage(image, 0, 0, null);
        this.refreshImportedTileBitmap(buffered);
    }

    private void refreshImportedTileBitmap(BufferedImage tilebmp) {
        assert (tilebmp != null);
        this.tileCutter.reset();
        this.tileCutter.setImage(tilebmp);
        this.tileSetImage = tilebmp;
        this.tileDimensions = new Rectangle(this.tileCutter.getTileDimensions());
        int id = 0;
        Image tile = this.tileCutter.getNextTile();
        while (tile != null) {
            int imgId = this.getTile((int)id).tileImageId;
            this.overlayImage(imgId, tile);
            tile = this.tileCutter.getNextTile();
            ++id;
        }
        this.fireTilesetChanged();
    }

    public void checkUpdate() throws IOException {
        if (this.tilebmpFile != null && this.tilebmpFile.lastModified() > this.tilebmpFileLastModified) {
            this.refreshImportedTileBitmap();
            this.tilebmpFileLastModified = this.tilebmpFile.lastModified();
        }
    }

    public void setSource(String source) {
        String oldSource = this.externalSource;
        this.externalSource = source;
        this.fireSourceChanged(oldSource, source);
    }

    public void setBaseDir(String base) {
        this.base = base;
    }

    public void setTilesetImageFilename(String name) {
        if (name != null) {
            this.tilebmpFile = new File(name);
            this.tilebmpFileLastModified = this.tilebmpFile.lastModified();
        } else {
            this.tilebmpFile = null;
        }
    }

    public void setFirstGid(int firstGid) {
        this.firstGid = firstGid;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.fireNameChanged(oldName, name);
    }

    public void setTransparentColor(Color color) {
        this.transparentColor = color;
    }

    public int addTile(Tile t) {
        if (t.getId() < 0) {
            t.setId(this.tiles.getMaxId() + 1);
        }
        if (this.tileDimensions.width < t.getWidth()) {
            this.tileDimensions.width = t.getWidth();
        }
        if (this.tileDimensions.height < t.getHeight()) {
            this.tileDimensions.height = t.getHeight();
        }
        t.getProperties().putAll((Map<?, ?>)this.defaultTileProperties);
        this.tiles.put(t.getId(), t);
        t.setTileSet(this);
        this.fireTilesetChanged();
        return t.getId();
    }

    public void addNewTile(Tile t) {
        t.setId(-1);
        this.addTile(t);
    }

    public void removeTile(int i) {
        this.tiles.remove(i);
        this.fireTilesetChanged();
    }

    public int size() {
        return this.tiles.size();
    }

    public int getMaxTileId() {
        return this.tiles.getMaxId();
    }

    public Iterator iterator() {
        return this.tiles.iterator();
    }

    public Vector<Tile> generateGaplessVector() {
        Vector<Tile> gapless = new Vector<Tile>();
        for (int i = 0; i <= this.getMaxTileId(); ++i) {
            if (this.getTile(i) == null) continue;
            gapless.add(this.getTile(i));
        }
        return gapless;
    }

    public int getTileWidth() {
        return this.tileDimensions.width;
    }

    public int getTileHeight() {
        return this.tileDimensions.height;
    }

    public int getTileSpacing() {
        return this.tileSpacing;
    }

    public int getTileMargin() {
        return this.tileMargin;
    }

    public int getTilesPerRow() {
        return this.tilesPerRow;
    }

    public Tile getTile(int i) {
        try {
            return (Tile)this.tiles.get(i);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public Tile getFirstTile() {
        Tile ret = null;
        for (int i = 0; ret == null && i <= this.getMaxTileId(); ++i) {
            ret = this.getTile(i);
        }
        return ret;
    }

    public String getSource() {
        return this.externalSource;
    }

    public String getBaseDir() {
        return this.base;
    }

    public String getTilebmpFile() {
        if (this.tilebmpFile != null) {
            try {
                return this.tilebmpFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public int getFirstGid() {
        return this.firstGid;
    }

    public String getName() {
        return this.name;
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public String toString() {
        return this.getName() + " [" + this.size() + "]";
    }

    public int getTotalImages() {
        return this.images.size();
    }

    public Enumeration<String> getImageIds() {
        Vector<String> v = new Vector<String>();
        for (int id = 0; id <= this.images.getMaxId(); ++id) {
            if (!this.images.containsId(id)) continue;
            v.add(Integer.toString(id));
        }
        return v.elements();
    }

    public int getIdByImage(Image i) {
        return this.images.indexOf(i);
    }

    public Image getImageById(int id) {
        return (Image)this.images.get(id);
    }

    public void overlayImage(int id, Image image) {
        this.images.put(id, image);
    }

    public Dimension getImageDimensions(int id) {
        Image img = (Image)this.images.get(id);
        if (img != null) {
            return new Dimension(img.getWidth(null), img.getHeight(null));
        }
        return new Dimension(0, 0);
    }

    public int addImage(Image image) {
        return this.images.findOrAdd(image);
    }

    public int addImage(Image image, int id) {
        return this.images.put(id, image);
    }

    public void removeImage(int id) {
        this.images.remove(id);
    }

    public boolean isSetFromImage() {
        return this.tileSetImage != null;
    }

    public boolean isOneForOne() {
        Iterator itr = this.iterator();
        for (int id = 0; id <= this.images.getMaxId(); ++id) {
            int relations = 0;
            itr = this.iterator();
            while (itr.hasNext()) {
                Tile t = (Tile)itr.next();
                if (t == null || t.getImageId() != id) continue;
                ++relations;
            }
            if (relations == true) continue;
            return false;
        }
        return true;
    }

    public void setDefaultProperties(Properties defaultSetProperties) {
        this.defaultTileProperties = defaultSetProperties;
    }

    public void addTilesetChangeListener(TilesetChangeListener listener) {
        this.tilesetChangeListeners.add(listener);
    }

    public void removeTilesetChangeListener(TilesetChangeListener listener) {
        this.tilesetChangeListeners.remove(listener);
    }

    private void fireTilesetChanged() {
        TilesetChangedEvent event = new TilesetChangedEvent(this);
        for (TilesetChangeListener listener : this.tilesetChangeListeners) {
            listener.tilesetChanged(event);
        }
    }

    private void fireNameChanged(String oldName, String newName) {
        TilesetChangedEvent event = new TilesetChangedEvent(this);
        for (TilesetChangeListener listener : this.tilesetChangeListeners) {
            listener.nameChanged(event, oldName, newName);
        }
    }

    private void fireSourceChanged(String oldSource, String newSource) {
        TilesetChangedEvent event = new TilesetChangedEvent(this);
        for (TilesetChangeListener listener : this.tilesetChangeListeners) {
            listener.sourceChanged(event, oldSource, newSource);
        }
    }
}

