/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor;

import java.awt.Image;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class Resources {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(Resources.class.getPackage().getName() + ".resources.gui");

    private Resources() {
    }

    public static String getString(String key) {
        return resourceBundle.getString(key);
    }

    public static Image getImage(String filename) throws IOException, IllegalArgumentException {
        return ImageIO.read(Resources.class.getResourceAsStream("resources/" + filename));
    }

    public static Icon getIcon(String filename) {
        try {
            return new ImageIcon(Resources.getImage(filename));
        }
        catch (IOException e) {
            System.out.println("Failed to load as image: " + filename);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Failed to load resource: " + filename);
        }
        return null;
    }
}

