/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.brush;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import tiled.core.MultilayerPlane;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.mapeditor.brush.AbstractBrush;
import tiled.mapeditor.brush.Brush;
import tiled.view.MapView;

public class ShapeBrush
extends AbstractBrush {
    protected Area shape;
    protected Tile paintTile;

    public ShapeBrush() {
    }

    public ShapeBrush(Area shape) {
        this.shape = shape;
    }

    public ShapeBrush(AbstractBrush sb) {
        super(sb);
        if (sb instanceof ShapeBrush) {
            this.shape = ((ShapeBrush)sb).shape;
            this.paintTile = ((ShapeBrush)sb).paintTile;
        }
    }

    public void makeCircleBrush(double rad) {
        this.shape = new Area(new Ellipse2D.Double(0.0, 0.0, rad * 2.0, rad * 2.0));
        this.resize((int)(rad * 2.0), (int)(rad * 2.0), 0, 0);
    }

    public void makeQuadBrush(Rectangle r) {
        this.shape = new Area(new Rectangle2D.Double(r.x, r.y, r.width, r.height));
        this.resize(r.width, r.height, 0, 0);
    }

    public void makePolygonBrush(Polygon p) {
    }

    public void setSize(int size) {
        if (this.shape.isRectangular()) {
            this.makeQuadBrush(new Rectangle(0, 0, size, size));
        } else if (!this.shape.isPolygonal()) {
            this.makeCircleBrush(size / 2);
        }
    }

    public void setTile(Tile t) {
        this.paintTile = t;
    }

    public Tile getTile() {
        return this.paintTile;
    }

    @Override
    public Rectangle getBounds() {
        return this.shape.getBounds();
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void drawPreview(Graphics2D g2d, Dimension dimension, MapView mv) {
        g2d.fill(this.shape);
    }

    @Override
    public void drawPreview(Graphics2D g2d, MapView mv) {
    }

    @Override
    public boolean equals(Brush brush) {
        return brush instanceof ShapeBrush && ((ShapeBrush)brush).shape.equals(this.shape);
    }

    @Override
    public void startPaint(MultilayerPlane mp, int x, int y, int button, int layer) {
        super.startPaint(mp, x, y, button, layer);
    }

    @Override
    public Rectangle doPaint(int x, int y) throws Exception {
        Rectangle shapeBounds = this.shape.getBounds();
        int centerx = x - shapeBounds.width / 2;
        int centery = y - shapeBounds.height / 2;
        super.doPaint(x, y);
        for (int layer = 0; layer < this.numLayers; ++layer) {
            TileLayer tl = (TileLayer)this.affectedMp.getLayer(this.initLayer + layer);
            if (tl == null) continue;
            for (int i = 0; i <= shapeBounds.height + 1; ++i) {
                for (int j = 0; j <= shapeBounds.width + 1; ++j) {
                    if (!this.shape.contains(j, i)) continue;
                    tl.setTileAt(j + centerx, i + centery, this.paintTile);
                }
            }
        }
        return new Rectangle(centerx, centery, shapeBounds.width, shapeBounds.height);
    }
}

