/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.util.PropertiesTableModel;
import tiled.mapeditor.widget.VerticalStaticJPanel;

public class PropertiesDialog
extends JDialog {
    protected JTable propertiesTable;
    protected final Properties properties;
    protected final PropertiesTableModel tableModel = new PropertiesTableModel();
    protected JPanel mainPanel;
    private static final String DIALOG_TITLE = Resources.getString("dialog.properties.title");
    private static final String OK_BUTTON = Resources.getString("general.button.ok");
    private static final String DELETE_BUTTON = Resources.getString("general.button.delete");
    private static final String CANCEL_BUTTON = Resources.getString("general.button.cancel");

    public PropertiesDialog(JFrame parent, Properties p) {
        super(parent, DIALOG_TITLE, true);
        this.properties = p;
        this.init();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    protected void init() {
        this.propertiesTable = new JTable(this.tableModel);
        JScrollPane propScrollPane = new JScrollPane(this.propertiesTable);
        propScrollPane.setPreferredSize(new Dimension(200, 150));
        JButton okButton = new JButton(OK_BUTTON);
        JButton cancelButton = new JButton(CANCEL_BUTTON);
        JButton deleteButton = new JButton(Resources.getIcon("gnome-delete.png"));
        deleteButton.setToolTipText(DELETE_BUTTON);
        VerticalStaticJPanel user = new VerticalStaticJPanel();
        user.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        user.setLayout(new BoxLayout(user, 0));
        user.add(Box.createGlue());
        user.add(Box.createRigidArea(new Dimension(5, 0)));
        user.add(deleteButton);
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createGlue());
        buttons.add(okButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(cancelButton);
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(propScrollPane);
        this.mainPanel.add(user);
        this.mainPanel.add(buttons);
        this.getContentPane().add(this.mainPanel);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog.this.buildPropertiesAndDispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog.this.dispose();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog.this.deleteSelected();
            }
        });
    }

    public void updateInfo() {
        this.tableModel.setProperties(this.properties);
    }

    public void getProps() {
        this.updateInfo();
        this.setVisible(true);
    }

    protected void buildPropertiesAndDispose() {
        TableCellEditor editor = this.propertiesTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)this.tableModel.getProperties());
        this.dispose();
    }

    protected void deleteSelected() {
        int i;
        int total = this.propertiesTable.getSelectedRowCount();
        Object[] keys = new Object[total];
        int[] selRows = this.propertiesTable.getSelectedRows();
        for (i = 0; i < total; ++i) {
            keys[i] = this.propertiesTable.getValueAt(selRows[i], 0);
        }
        for (i = 0; i < total; ++i) {
            if (keys[i] == null) continue;
            this.tableModel.remove(keys[i]);
        }
    }
}

