/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tiled.core.LayerLockedException;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;
import tiled.io.MapHelper;
import tiled.io.MapWriter;
import tiled.mapeditor.Resources;
import tiled.mapeditor.dialogs.TileDialog;
import tiled.mapeditor.plugin.PluginClassLoader;
import tiled.mapeditor.util.ConfirmingFileChooser;
import tiled.mapeditor.util.TiledFileFilter;
import tiled.mapeditor.util.TilesetTableModel;

public class TilesetManager
extends JDialog
implements ActionListener,
ListSelectionListener {
    private final Map map;
    private JButton saveButton;
    private JButton saveAsButton;
    private JButton embedButton;
    private JButton removeButton;
    private JButton editButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton closeButton;
    private TilesetTableModel tilesetTableModel;
    private JTable tilesetTable;
    private static final String DIALOG_TITLE = Resources.getString("dialog.tilesetmanager.title");
    private static final String CLOSE_BUTTON = Resources.getString("general.button.close");
    private static final String MOVE_UP_BUTTON = Resources.getString("dialog.tilesetmanager.button.moveup");
    private static final String MOVE_DOWN_BUTTON = Resources.getString("dialog.tilesetmanager.button.movedown");
    private static final String REMOVE_BUTTON = Resources.getString("general.button.remove");
    private static final String EMBED_BUTTON = Resources.getString("dialog.tilesetmanager.embed.button");
    private static final String SAVE_AS_BUTTON = Resources.getString("action.map.saveas.name");
    private static final String EDIT_BUTTON = Resources.getString("dialog.tilesetmanager.edit.button");
    private static final String SAVE_BUTTON = Resources.getString("action.map.save.name");
    private static final Icon REMOVE_BUTTON_ICON = Resources.getIcon("gnome-delete.png");
    private static final Icon EMBED_BUTTON_ICON = Resources.getIcon("insert-object.png");
    private static final Icon SAVE_AS_BUTTON_ICON = Resources.getIcon("document-save-as.png");
    private static final Icon EDIT_BUTTON_ICON = Resources.getIcon("gtk-edit.png");
    private static final Icon SAVE_BUTTON_ICON = Resources.getIcon("document-save.png");

    public TilesetManager(JFrame parent, Map map) {
        super(parent, DIALOG_TITLE, true);
        this.map = map;
        this.init();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void init() {
        this.tilesetTableModel = new TilesetTableModel(this.map);
        this.tilesetTable = new JTable(this.tilesetTableModel);
        this.tilesetTable.setSelectionMode(0);
        this.tilesetTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane tilesetScrollPane = new JScrollPane(this.tilesetTable);
        tilesetScrollPane.setPreferredSize(new Dimension(360, 150));
        this.saveButton = new JButton(SAVE_BUTTON_ICON);
        this.editButton = new JButton(EDIT_BUTTON_ICON);
        this.saveAsButton = new JButton(SAVE_AS_BUTTON_ICON);
        this.embedButton = new JButton(EMBED_BUTTON_ICON);
        this.removeButton = new JButton(REMOVE_BUTTON_ICON);
        this.moveUpButton = new JButton(MOVE_UP_BUTTON);
        this.moveDownButton = new JButton(MOVE_DOWN_BUTTON);
        this.closeButton = new JButton(CLOSE_BUTTON);
        this.saveButton.setActionCommand(SAVE_BUTTON);
        this.saveAsButton.setActionCommand(SAVE_AS_BUTTON);
        this.embedButton.setActionCommand(EMBED_BUTTON);
        this.removeButton.setActionCommand(REMOVE_BUTTON);
        this.editButton.setActionCommand(EDIT_BUTTON);
        this.saveButton.setMargin(new Insets(0, 0, 0, 0));
        this.saveAsButton.setMargin(new Insets(0, 0, 0, 0));
        this.embedButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeButton.setMargin(new Insets(0, 0, 0, 0));
        this.editButton.setMargin(new Insets(0, 0, 0, 0));
        this.saveButton.setToolTipText(SAVE_BUTTON);
        this.saveAsButton.setToolTipText(SAVE_AS_BUTTON);
        this.embedButton.setToolTipText(EMBED_BUTTON);
        this.removeButton.setToolTipText(REMOVE_BUTTON);
        this.editButton.setToolTipText(EDIT_BUTTON);
        this.saveButton.addActionListener(this);
        this.saveAsButton.addActionListener(this);
        this.embedButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.moveUpButton.addActionListener(this);
        this.moveDownButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add((Component)tilesetScrollPane, "Center");
        Dimension spacing = new Dimension(5, 5);
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BoxLayout(iconPanel, 3));
        iconPanel.add(this.saveButton);
        iconPanel.add(Box.createRigidArea(spacing));
        iconPanel.add(this.saveAsButton);
        iconPanel.add(Box.createRigidArea(spacing));
        iconPanel.add(this.embedButton);
        iconPanel.add(Box.createRigidArea(spacing));
        iconPanel.add(this.removeButton);
        iconPanel.add(Box.createRigidArea(spacing));
        iconPanel.add(this.editButton);
        iconPanel.add(Box.createGlue());
        mainPanel.add((Component)iconPanel, "After");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(this.moveUpButton);
        buttonPanel.add(Box.createRigidArea(spacing));
        buttonPanel.add(this.moveDownButton);
        buttonPanel.add(Box.createRigidArea(spacing));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.closeButton);
        mainPanel.add((Component)buttonPanel, "Last");
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.tilesetTable.changeSelection(0, 0, false, false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        int selectedRow = this.tilesetTable.getSelectedRow();
        Vector<TileSet> tilesets = this.map.getTilesets();
        TileSet set = null;
        try {
            set = tilesets.get(selectedRow);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (command.equals(CLOSE_BUTTON)) {
            this.dispose();
        } else if (command.equals(EDIT_BUTTON)) {
            if (this.map != null && selectedRow >= 0) {
                TileDialog tileDialog = new TileDialog((Dialog)this, set, this.map);
                tileDialog.setVisible(true);
            }
        } else if (command.equals(REMOVE_BUTTON)) {
            int ret;
            if (this.checkSetUsage(set) > 0 && (ret = JOptionPane.showConfirmDialog(this, Resources.getString("action.tileset.remove.in-use.message"), Resources.getString("action.tileset.remove.in-use.title"), 0)) != 0) {
                return;
            }
            try {
                this.map.removeTileset(set);
                this.updateTilesetTable();
            }
            catch (LayerLockedException e) {
                JOptionPane.showMessageDialog(this, Resources.getString("action.tileset.remove.error.layer-locked.message"), Resources.getString("action.tileset.remove.error.title"), 0);
            }
        } else if (command.equals(SAVE_AS_BUTTON)) {
            MapWriter[] writers;
            ConfirmingFileChooser ch = new ConfirmingFileChooser(this.map.getFilename());
            for (MapWriter writer : writers = PluginClassLoader.getInstance().getWriters()) {
                try {
                    ch.addChoosableFileFilter(new TiledFileFilter(writer.getFilter(), writer.getName()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ch.addChoosableFileFilter(new TiledFileFilter(2));
            int ret = ((JFileChooser)ch).showSaveDialog(this);
            if (ret == 0) {
                String filename = ch.getSelectedFile().getAbsolutePath();
                try {
                    MapHelper.saveTileset(set, filename);
                    set.setSource(filename);
                    this.embedButton.setEnabled(true);
                    this.saveButton.setEnabled(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (command.equals(SAVE_BUTTON)) {
            try {
                MapHelper.saveTileset(set, set.getSource());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (command.equals(EMBED_BUTTON)) {
            set.setSource(null);
            this.embedButton.setEnabled(false);
            this.saveButton.setEnabled(false);
        } else if (command.equals(MOVE_UP_BUTTON)) {
            if (selectedRow > 0) {
                int newRow = selectedRow - 1;
                this.map.swapTileSets(selectedRow, newRow);
                this.tilesetTable.getSelectionModel().setSelectionInterval(newRow, newRow);
            }
        } else if (command.equals(MOVE_DOWN_BUTTON) && selectedRow > -1 && selectedRow < this.tilesetTable.getRowCount() - 1) {
            int newRow = selectedRow + 1;
            this.map.swapTileSets(selectedRow, newRow);
            this.tilesetTable.getSelectionModel().setSelectionInterval(newRow, newRow);
        }
    }

    private void updateTilesetTable() {
        this.tilesetTable.repaint();
    }

    private int checkSetUsage(TileSet tileset) {
        int used = 0;
        Iterator tileIterator = tileset.iterator();
        block0: while (tileIterator.hasNext()) {
            Tile tile = (Tile)tileIterator.next();
            ListIterator<MapLayer> layerIterator = this.map.getLayers();
            while (layerIterator.hasNext()) {
                MapLayer ml = (MapLayer)layerIterator.next();
                if (!(ml instanceof TileLayer) || !((TileLayer)ml).isUsed(tile)) continue;
                ++used;
                continue block0;
            }
        }
        return used;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        int selectedRow = this.tilesetTable.getSelectedRow();
        this.moveUpButton.setEnabled(selectedRow > 0);
        this.moveDownButton.setEnabled(selectedRow > -1 && selectedRow < this.tilesetTable.getRowCount() - 1);
        Vector<TileSet> tilesets = this.map.getTilesets();
        TileSet set = null;
        try {
            set = tilesets.get(selectedRow);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this.editButton.setEnabled(set != null);
        this.removeButton.setEnabled(set != null);
        this.saveButton.setEnabled(set != null && set.getSource() != null);
        this.saveAsButton.setEnabled(set != null);
        this.embedButton.setEnabled(set != null && set.getSource() != null);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.tilesetTableModel.clearListeners();
    }
}

