/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.util;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import tiled.core.Map;
import tiled.core.MapChangeListener;
import tiled.core.MapChangedEvent;
import tiled.core.MapLayer;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;
import tiled.core.TilesetChangeListener;
import tiled.core.TilesetChangedEvent;
import tiled.mapeditor.Resources;

public class TilesetTableModel
extends AbstractTableModel
implements MapChangeListener,
TilesetChangeListener {
    private Map map;
    private static final String[] columnNames = new String[]{Resources.getString("dialog.tilesetmanager.table.name"), Resources.getString("dialog.tilesetmanager.table.source")};
    private static final String EMBEDDED = Resources.getString("dialog.tilesetmanager.embedded");

    public TilesetTableModel(Map map) {
        this.map = map;
        for (TileSet tileset : map.getTilesets()) {
            tileset.addTilesetChangeListener(this);
        }
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public int getRowCount() {
        if (this.map != null) {
            return this.map.getTilesets().size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Vector<TileSet> tilesets = this.map.getTilesets();
        if (row >= 0 && row < tilesets.size()) {
            TileSet tileset = tilesets.get(row);
            if (col == 0) {
                return tileset.getName();
            }
            String ret = tileset.getSource();
            if (ret == null) {
                ret = EMBEDDED;
            }
            return ret;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0) {
            return;
        }
        Vector<TileSet> tilesets = this.map.getTilesets();
        if (row >= 0 && row < tilesets.size()) {
            TileSet tileset = tilesets.get(row);
            if (col == 0) {
                tileset.setName(value.toString());
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    private int checkSetUsage(TileSet set) {
        int used = 0;
        Iterator tileIterator = set.iterator();
        block0: while (tileIterator.hasNext()) {
            Tile tile = (Tile)tileIterator.next();
            ListIterator<MapLayer> itr = this.map.getLayers();
            while (itr.hasNext()) {
                MapLayer ml = (MapLayer)itr.next();
                if (!(ml instanceof TileLayer) || !((TileLayer)ml).isUsed(tile)) continue;
                ++used;
                continue block0;
            }
        }
        return used;
    }

    @Override
    public void mapChanged(MapChangedEvent event) {
    }

    @Override
    public void tilesetAdded(MapChangedEvent event, TileSet tileset) {
        int index = this.map.getTilesets().indexOf(tileset);
        if (index == -1) {
            return;
        }
        tileset.addTilesetChangeListener(this);
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public void tilesetRemoved(MapChangedEvent event, int index) {
        this.fireTableRowsDeleted(index - 1, index);
    }

    @Override
    public void tilesetsSwapped(MapChangedEvent event, int index0, int index1) {
        this.fireTableRowsUpdated(index0, index1);
    }

    @Override
    public void tilesetChanged(TilesetChangedEvent event) {
    }

    @Override
    public void nameChanged(TilesetChangedEvent event, String oldName, String newName) {
        int index = this.map.getTilesets().indexOf(event.getTileset());
        if (index == -1) {
            return;
        }
        this.fireTableCellUpdated(index, 0);
    }

    @Override
    public void sourceChanged(TilesetChangedEvent event, String oldSource, String newSource) {
        int index = this.map.getTilesets().indexOf(event.getTileset());
        if (index == -1) {
            return;
        }
        this.fireTableCellUpdated(index, 1);
    }

    public void clearListeners() {
        Iterator<TileSet> it = this.map.getTilesets().iterator();
        while (it.hasNext()) {
            it.next().removeTilesetChangeListener(this);
        }
    }
}

