/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.LwsFrame;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import com.sun.j3d.utils.behaviors.interpolators.KBRotPosScaleSplinePathInterpolator;
import java.io.StreamTokenizer;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;

class LwsMotion
extends TextfileParser {
    String motionName;
    LwsFrame[] frames;
    int numFrames;
    int numChannels;
    boolean loop;
    float totalTime;
    int firstFrame;
    int totalFrames;
    Behavior behaviors;

    LwsMotion(StreamTokenizer streamTokenizer, int n, float f) {
        this(streamTokenizer, 0, n, f, 16);
    }

    LwsMotion(StreamTokenizer streamTokenizer, int n, int n2, float f, int n3) throws ParsingErrorException, IncorrectFormatException {
        this.debugPrinter.setValidOutput(n3);
        this.numFrames = 0;
        this.totalTime = f;
        this.firstFrame = n;
        this.totalFrames = n2;
        this.debugOutputLn(8, "about to get motion name");
        this.motionName = this.getName(streamTokenizer);
        this.debugOutputLn(8, "about to get motion");
        this.getMotion(streamTokenizer);
    }

    void getMotion(StreamTokenizer streamTokenizer) throws ParsingErrorException, IncorrectFormatException {
        int n;
        this.debugOutputLn(1, "getMotion()");
        this.numChannels = (int)this.getNumber(streamTokenizer);
        if (this.numChannels != 9) {
            throw new IncorrectFormatException(J3dUtilsI18N.getString("LwsMotion0"));
        }
        this.debugOutputLn(8, "got channels");
        this.numFrames = (int)this.getNumber(streamTokenizer);
        this.frames = new LwsFrame[this.numFrames];
        this.debugOutputLn(2, "got frames" + this.numFrames);
        for (n = 0; n < this.numFrames; ++n) {
            this.frames[n] = new LwsFrame(streamTokenizer);
        }
        this.debugOutput(8, "got all frames");
        this.getAndCheckString(streamTokenizer, "EndBehavior");
        n = (int)this.getNumber(streamTokenizer);
        this.loop = n != 1;
    }

    void fixFrames() {
        Object object;
        boolean bl = false;
        Vector<LwsFrame> vector = new Vector<LwsFrame>();
        double d = 1.5707963705062866;
        LwsFrame lwsFrame = null;
        for (int i = 1; i < this.numFrames; ++i) {
            double d2;
            LwsFrame lwsFrame2;
            double d3;
            double d4;
            LwsFrame lwsFrame3;
            LwsFrame lwsFrame4 = this.frames[i - 1];
            lwsFrame = lwsFrame3 = this.frames[i];
            vector.add(lwsFrame4);
            double d5 = 0.0;
            double d6 = lwsFrame3.getHeading();
            double d7 = lwsFrame4.getHeading();
            double d8 = Math.abs(d6 - d7);
            if (d8 > d5) {
                d5 = d8;
            }
            if ((d8 = Math.abs((d6 = lwsFrame3.getPitch()) - (d7 = lwsFrame4.getPitch()))) > d5) {
                d5 = d8;
            }
            if ((d8 = Math.abs((d6 = lwsFrame3.getBank()) - (d7 = lwsFrame4.getBank()))) > d5) {
                d5 = d8;
            }
            if (!(d5 > d)) continue;
            bl = true;
            int n = (int)(d5 / d);
            double d9 = d4 = 1.0 / (double)(n + 1);
            double d10 = this.frames[this.numFrames - 1].getFrameNum();
            double d11 = (lwsFrame3.getFrameNum() - lwsFrame4.getFrameNum()) / d10;
            if (i - 1 < 1) {
                object = this.frames[i - 1];
                d3 = 0.0;
            } else {
                object = this.frames[i - 2];
                d3 = d11 / ((lwsFrame3.getFrameNum() - ((LwsFrame)object).getFrameNum()) / d10);
            }
            if (i + 1 < this.numFrames) {
                lwsFrame2 = this.frames[i + 1];
                d2 = d11 / ((lwsFrame2.getFrameNum() - lwsFrame4.getFrameNum()) / d10);
            } else {
                lwsFrame2 = this.frames[i];
                d2 = 1.0;
            }
            for (int j = 0; j < n; ++j) {
                LwsFrame lwsFrame5 = lwsFrame3.linearValue == 1 ? new LwsFrame(lwsFrame4, lwsFrame3, d9) : new LwsFrame((LwsFrame)object, lwsFrame4, lwsFrame3, lwsFrame2, d9, d3, d2);
                d9 += d4;
                vector.add(lwsFrame5);
            }
        }
        if (lwsFrame != null) {
            vector.add(lwsFrame);
        }
        if (bl) {
            LwsFrame[] lwsFrameArray = new LwsFrame[vector.size()];
            object = vector.elements();
            int n = 0;
            while (object.hasMoreElements()) {
                lwsFrameArray[n++] = (LwsFrame)object.nextElement();
            }
            this.frames = lwsFrameArray;
            this.numFrames = this.frames.length;
            for (int i = 0; i < this.numFrames; ++i) {
                this.debugOutputLn(2, "frame " + i + " = " + this.frames[i]);
                this.frames[i].printVals();
            }
        }
    }

    int intMod(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        while (n3 > n4) {
            n3 -= n4;
        }
        return n3;
    }

    void playWithFrameTimes(Vector vector) {
        this.debugOutputLn(1, "playWithFrameTimes: firstFrame = " + this.firstFrame);
        if (this.firstFrame == 1) {
            return;
        }
        if (this.frames[this.numFrames - 1].getFrameNum() < (double)this.totalFrames) {
            int n;
            int n2 = (int)(this.frames[this.numFrames - 1].getFrameNum() + 0.4999999);
            int n3 = this.intMod(this.firstFrame, n2);
            int n4 = this.intMod(this.totalFrames, n2);
            for (n = 0; n < this.numFrames && !(this.frames[n].getFrameNum() >= (double)n3); ++n) {
            }
            int n5 = n;
            if (this.frames[n5].getFrameNum() > (double)this.firstFrame && n5 > 0) {
                --n5;
            }
            if (n3 < n4) {
                for (n = n5; n < this.numFrames && this.frames[n].getFrameNum() <= (double)n4; ++n) {
                    FrameHolder frameHolder = new FrameHolder(this.frames[n], this.frames[n].getFrameNum() - (double)n3);
                    vector.addElement(frameHolder);
                }
            } else {
                Object object;
                double d = -1.0;
                while (n < this.numFrames) {
                    d = this.frames[n].getFrameNum() - (double)n3;
                    object = new FrameHolder(this.frames[n], d);
                    vector.addElement(object);
                    ++n;
                }
                for (n = 0; n <= n5 && this.frames[n].getFrameNum() <= (double)n4; ++n) {
                    if (n == 0) {
                        object = new LwsFrame(this.frames[n], this.frames[n + 1], 1.0 / (this.frames[n + 1].getFrameNum() - this.frames[n].getFrameNum()));
                        FrameHolder frameHolder = new FrameHolder((LwsFrame)object, ((LwsFrame)object).getFrameNum() + d);
                        vector.addElement(frameHolder);
                        continue;
                    }
                    object = new FrameHolder(this.frames[n], this.frames[n].getFrameNum() + d);
                    vector.addElement(object);
                }
            }
        } else {
            FrameHolder frameHolder;
            LwsFrame lwsFrame;
            int n;
            for (n = 0; n < this.numFrames && !(this.frames[n].getFrameNum() >= (double)this.firstFrame); ++n) {
            }
            int n6 = n;
            if (this.frames[n6].getFrameNum() > (double)this.firstFrame && n6 > 0) {
                double d = (double)this.firstFrame / (this.frames[n6].getFrameNum() - this.frames[n6 - 1].getFrameNum());
                lwsFrame = new LwsFrame(this.frames[n6 - 1], this.frames[n6], d);
                frameHolder = new FrameHolder(lwsFrame, lwsFrame.getFrameNum() - (double)this.firstFrame);
                vector.addElement(frameHolder);
            }
            for (n = n6; n < this.numFrames && this.frames[n].getFrameNum() <= (double)this.totalFrames; ++n) {
                FrameHolder frameHolder2 = new FrameHolder(this.frames[n], this.frames[n].getFrameNum() - (double)this.firstFrame);
                vector.addElement(frameHolder2);
            }
            if (this.frames[n - 1].getFrameNum() < (double)this.totalFrames) {
                double d = ((double)this.totalFrames - this.frames[n - 1].getFrameNum()) / (this.frames[n].getFrameNum() - this.frames[n - 1].getFrameNum());
                lwsFrame = new LwsFrame(this.frames[n - 1], this.frames[n], d);
                frameHolder = new FrameHolder(lwsFrame, this.totalFrames - this.firstFrame);
                vector.addElement(frameHolder);
            }
        }
    }

    void createJava3dBehaviorsForFramesSubset(TransformGroup transformGroup) {
        FrameHolder frameHolder;
        this.debugOutputLn(1, "createJava3dBehaviorsForFramesSubset");
        Vector vector = new Vector();
        this.playWithFrameTimes(vector);
        long l = 0L;
        int n = this.loop ? -1 : 1;
        n = -1;
        int n2 = vector.size();
        this.debugOutputLn(2, "totalTime = " + this.totalTime);
        this.debugOutputLn(2, "loopCount = " + n);
        FrameHolder frameHolder2 = (FrameHolder)vector.elementAt(vector.size() - 1);
        LwsFrame lwsFrame = frameHolder2.frame;
        float f = 1000.0f * this.totalTime * (float)(frameHolder2.frameNumber / (double)(this.totalFrames - this.firstFrame));
        this.debugOutputLn(2, " anim time: " + f);
        this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
        if (!this.loop) {
            l = (long)(1000.0 * (double)this.totalTime - (double)f);
        }
        Alpha alpha = new Alpha(n, 1, 0L, 0L, (long)f, 0L, l, 0L, 0L, 0L);
        float[] fArray = new float[n2];
        Point3f[] point3fArray = new Point3f[n2];
        Quat4f[] quat4fArray = new Quat4f[n2];
        Point3f[] point3fArray2 = new Point3f[n2];
        Transform3D transform3D = new Transform3D();
        Matrix4d matrix4d = new Matrix4d();
        KBKeyFrame[] kBKeyFrameArray = new KBKeyFrame[n2];
        for (int i = 0; i < n2; ++i) {
            frameHolder = (FrameHolder)vector.elementAt(i);
            LwsFrame lwsFrame2 = frameHolder.frame;
            point3fArray[i] = lwsFrame2.getPosition();
            point3fArray2[i] = lwsFrame2.getScale();
            lwsFrame2.setRotationMatrix(matrix4d);
            this.debugOutputLn(2, "LwsMotion::createj3dbeh, mat = " + matrix4d);
            quat4fArray[i] = new Quat4f();
            quat4fArray[i].set(matrix4d);
            this.debugOutputLn(2, " and quat = " + quat4fArray[i]);
            fArray[i] = i == 0 ? 0.0f : (float)frameHolder.frameNumber / (float)frameHolder2.frameNumber;
            kBKeyFrameArray[i] = new KBKeyFrame(fArray[i], lwsFrame2.linearValue, point3fArray[i], (float)lwsFrame2.heading, (float)lwsFrame2.pitch, (float)lwsFrame2.bank, point3fArray2[i], (float)lwsFrame2.tension, (float)lwsFrame2.continuity, (float)lwsFrame2.bias);
            this.debugOutputLn(2, "pos, knots, quat = " + point3fArray[i] + fArray[i] + quat4fArray[i]);
        }
        KBRotPosScaleSplinePathInterpolator kBRotPosScaleSplinePathInterpolator = new KBRotPosScaleSplinePathInterpolator(alpha, transformGroup, transform3D, kBKeyFrameArray);
        if (kBRotPosScaleSplinePathInterpolator != null) {
            this.behaviors = kBRotPosScaleSplinePathInterpolator;
            frameHolder = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
            kBRotPosScaleSplinePathInterpolator.setSchedulingBounds((Bounds)frameHolder);
            transformGroup.setCapability(18);
            transformGroup.addChild((Node)this.behaviors);
        }
    }

    void createJava3dBehaviors(TransformGroup transformGroup) {
        if (this.numFrames <= 1) {
            this.behaviors = null;
        } else {
            if (this.firstFrame > 1) {
                this.createJava3dBehaviorsForFramesSubset(transformGroup);
                return;
            }
            long l = 0L;
            int n = this.loop ? -1 : 1;
            n = -1;
            this.debugOutputLn(2, "totalTime = " + this.totalTime);
            this.debugOutputLn(2, "loopCount = " + n);
            float f = 1000.0f * this.totalTime * (float)(this.frames[this.numFrames - 1].getFrameNum() / (double)this.totalFrames);
            this.debugOutputLn(2, " anim time: " + f);
            this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
            this.debugOutputLn(2, " lastFrame = " + this.frames[this.numFrames - 1].getFrameNum());
            if (!this.loop) {
                l = (long)(1000.0 * (double)this.totalTime - (double)f);
            }
            Alpha alpha = new Alpha(n, 1, 0L, 0L, (long)f, 0L, l, 0L, 0L, 0L);
            float[] fArray = new float[this.numFrames];
            Point3f[] point3fArray = new Point3f[this.numFrames];
            Quat4f[] quat4fArray = new Quat4f[this.numFrames];
            Point3f[] point3fArray2 = new Point3f[this.numFrames];
            Transform3D transform3D = new Transform3D();
            Matrix4d matrix4d = new Matrix4d();
            KBKeyFrame[] kBKeyFrameArray = new KBKeyFrame[this.numFrames];
            for (int i = 0; i < this.numFrames; ++i) {
                point3fArray[i] = this.frames[i].getPosition();
                point3fArray2[i] = this.frames[i].getScale();
                this.frames[i].setRotationMatrix(matrix4d);
                this.debugOutputLn(2, "LwsMotion::createj3dbeh, mat = " + matrix4d);
                quat4fArray[i] = new Quat4f();
                quat4fArray[i].set(matrix4d);
                this.debugOutputLn(2, " and quat = " + quat4fArray[i]);
                fArray[i] = i == 0 ? 0.0f : (float)this.frames[i].getFrameNum() / (float)this.frames[this.numFrames - 1].getFrameNum();
                kBKeyFrameArray[i] = new KBKeyFrame(fArray[i], this.frames[i].linearValue, point3fArray[i], (float)this.frames[i].heading, (float)this.frames[i].pitch, (float)this.frames[i].bank, point3fArray2[i], (float)this.frames[i].tension, (float)this.frames[i].continuity, (float)this.frames[i].bias);
                this.debugOutputLn(2, "pos, knots, quat = " + point3fArray[i] + fArray[i] + quat4fArray[i]);
            }
            KBRotPosScaleSplinePathInterpolator kBRotPosScaleSplinePathInterpolator = new KBRotPosScaleSplinePathInterpolator(alpha, transformGroup, transform3D, kBKeyFrameArray);
            if (kBRotPosScaleSplinePathInterpolator != null) {
                this.behaviors = kBRotPosScaleSplinePathInterpolator;
                BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
                kBRotPosScaleSplinePathInterpolator.setSchedulingBounds((Bounds)boundingSphere);
                transformGroup.setCapability(18);
                transformGroup.addChild((Node)this.behaviors);
            }
        }
    }

    Behavior getBehaviors() {
        return this.behaviors;
    }

    LwsFrame getFirstFrame() {
        if (this.numFrames > 0) {
            return this.frames[0];
        }
        return null;
    }

    void printVals() {
        this.debugOutputLn(2, "   motionName = " + this.motionName);
        this.debugOutputLn(2, "   numChannels = " + this.numChannels);
        this.debugOutputLn(2, "   numFrames = " + this.numFrames);
        this.debugOutputLn(2, "   loop = " + this.loop);
        for (int i = 0; i < this.numFrames; ++i) {
            this.debugOutputLn(2, "       FRAME " + i);
            this.frames[i].printVals();
        }
    }

    class FrameHolder {
        double frameNumber;
        LwsFrame frame;

        FrameHolder(LwsFrame lwsFrame, double d) {
            this.frame = lwsFrame;
            this.frameNumber = d;
        }
    }
}

