/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Chips!
// Dfinition du module        !CONFIG!=/V4!Ports!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Chips
* ------------------------------------------------------------------------------
*  Fichier     : GESTPORT.C            | Version : 0.1x
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Gestion des ports d'entre/sortie
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
*  09/01/2003              | L.DEPLANQUE             | Version 0.1u : Test
*                          |                         | nbre de ports crits
*                          |                         | simultanments (proto)
* ------------------------------------------------------------------------------
*  22/01/2004              | L.DEPLANQUE             | Version 0.1x : Ajout
*                          |                         | adresse du PC dans les
*                          |                         | traces du fichier .LOG
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <stdio.h>

#include  "types.h"
#ifdef USE_MULTIFACE
#include  "multiface.h"
#endif
#include  "config.h"
#include  "ppi.h"
#include  "crtc.h"
#include  "upd.h"
#include  "vga.h"
#include  "z80.h"
#ifdef USE_LOG
#include  "log.h"
#endif
#ifdef USE_PRINTER
#include  "printer.h"
#endif


/********************************************************* !NAME! **************
* Nom : ReadPort
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Lecture d'un port d'entre
*
* Rsultat    : La valeur du port selectionn
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
int ReadPort( int port )
{
    if ( ! ( port & 0x0480 ) )
        return( ReadUPD( port ) );

    if ( ! ( port & 0x0800 ) )
        return( ReadPPI( port ) );

#ifdef USE_LOG
    sprintf( MsgLog, "Accs lecture port %04X (PC=%04X)", port, RegPC );
    Log( MsgLog, LOG_WARNING );
#endif
    return( 0xFF );
}


/********************************************************* !NAME! **************
* Nom : WritePort
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Ecriture d'un port de sortie
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void WritePort( int port, int val )
{
#ifdef USE_LOG
    int bit = 0;
#endif

    if ( ( port & 0xC000 ) == 0x04000 )
        {
        WriteVGA( val );
#ifdef USE_LOG
        bit++;
#endif
        }

    if ( ! ( port & 0x4000 ) )
        {
        WriteCRTC( port, val );
#ifdef USE_LOG
        bit++;
#endif
        }

    if ( ! ( port & 0x2000 ) )
        {
        WriteROM( val );
#ifdef USE_LOG
        bit++;
#endif
        }

#ifdef USE_PRINTER
    if ( ! ( port & 0x1000 ) )
        {
        PrintVal( val );
#ifdef USE_LOG
        bit++;
#endif
        }
#endif

    if ( ! ( port & 0x0800 ) )
        {
        WritePPI( port, val );
#ifdef USE_LOG
        bit++;
#endif
        }

    if ( ! ( port & 0x0480 ) )
        {
        WriteUPD( port, val );
#ifdef USE_LOG
        bit++;
#endif
        }

#ifdef USE_LOG
    if ( bit != 1 )
        {
        sprintf( MsgLog, "Accs criture port %04X (PC=%04X)", port, RegPC );
        Log( MsgLog, LOG_WARNING );
        }
#endif
#ifdef USE_MULTIFACE
    if ( Multiface )
        MultifaceWriteIO( port, val );
#endif
}