/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Noyau!
// Dfinition du module        !CONFIG!=/V4!Main!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\\!./V2!\\!./V3!\\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Noyau
* ------------------------------------------------------------------------------
*  Fichier     : MAIN.C                | Version : 0.1t
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Programme principal
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
*  07/11/2002              | L.DEPLANQUE             | Ajout gestion lecture et
*                          |                         | criture cassette :
*                          |                         | fonctions WriteCas() et
*                          |                         | ReadCas() appeles 
*                          |                         | chaque Hsync.
* ------------------------------------------------------------------------------
*  03/12/2002              | L.DEPLANQUE             | Prise en compte de la
*                          |                         | directive USE_DEBUG
*                          |                         | optimisation de
*                          |                         | l'affichage et
*                          |                         | l'archivage des messages
*                          |                         | d'erreurs
* ------------------------------------------------------------------------------
*  06/01/2003              | L.DEPLANQUE             | Version 0.1t :
*                          |                         | Suppression d'un Warning
* ------------------------------------------------------------------------------
*  02/02/2004              | L.DEPLANQUE             | Version 0.1x :
*                          |                         | Modification de la
*                          |                         | frquence d'appel des
*                          |                         | fonctions lecture et
*                          |                         | critures cassettes,
*                          |                         | ajout d'une constante
*                          |                         | pour cette frquence.
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <windows.h>
#include  <stdio.h>

#include  "types.h"
#include  "plateform.h"
#include  "z80.h"
#include  "vga.h"
#include  "ppi.h"
#include  "upd.h"
#ifdef USE_MULTIFACE
#include  "multiface.h"
#endif
#include  "AY8912.h"
#include  "Sound.h"
#include  "Config.h"
#include  "crtc.h"
#ifdef USE_LOG
#include  "log.h"
#endif
#ifdef USE_PRINTER
#include  "Printer.h"
#endif
#ifdef USE_DEBUG
#include  "desasm.h"
#endif

extern HDC DeviceContext;


//
// Constante de temps avant lecture/criture cassette.
// Cette constante contient le nombre de cycles Z80  attentre
// avant appel des fonctions.
// ATTENTION : la modification de cette constante entraine un
// changement de frquence de lecture/criture des fichiers cassettes
// et peut donc causer une incompatibilit avec des fichiers de versions
// prcdentes.
//
#define     TPS_TAPE        0x180


/********************************************************* !NAME! **************
* Nom : finMain
********************************************************** !PATHS! *************
* !./V1!\\!./V2!\\!./V3!\\!./V4!\\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\\/FLE!, ligne : !./LN!
*
* Description : Fin du programme
*
********************************************************** !0! ****************/
int finMain = 0;


/********************************************************* !NAME! **************
* Nom : CntHSync
********************************************************** !PATHS! *************
* !./V1!\\!./V2!\\!./V3!\\!./V4!\\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\\/FLE!, ligne : !./LN!
*
* Description : Compteur position horizontale raster
*
********************************************************** !0! ****************/
int CntHSync = 0;


/********************************************************* !NAME! **************
* Nom : AffichePiste
********************************************************** !PATHS! *************
* !./V1!\\!./V2!\\!./V3!\\!./V4!\\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\\/FLE!, ligne : !./LN!
*
* Description : Affichage du numro de piste en cours (disquette)
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
static void AffichePiste( int * OldTrack, int CurrTrack )
{
    static char Msg[ 16 ];
    
    if ( CurrTrack != * OldTrack )
        {
        sprintf( Msg, "Piste:%02d", CurrTrack );
        TextOut( DeviceContext, 612, 544, Msg, strlen( Msg ) );
        * OldTrack = CurrTrack;
        }
}


/********************************************************* !NAME! **************
* Nom : Go
********************************************************** !PATHS! *************
* !./V1!\\!./V2!\\!./V3!\\!./V4!\\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\\/FLE!, ligne : !./LN!
*
* Description : Fonction principale : boucle d'mulation
*
* Rsultat    : /
*
* Variables globales modifies : Cont, CptInstr, CntHSync, IRQ, VBL
*
********************************************************** !0! ****************/
static void Go( void )
{
    MSG msg;
    int DebutVSync = 0, NbLignesMax = 312, CntVSync = 0;
    int TailleChar, TpsVbl = 0;
    int SyncCount = 0;
    unsigned long TimeOut, Time, OldTime = 0;
    int FrameCnt = 0;
    int OldTrack = -1;
#ifdef USE_DEBUG
    int Step = 0;
#endif
#ifdef USE_TAPE
    int OldCptInstr = 0, CntTape = 0;
#endif

    //
    // Boucle principale...
    //
    do
        {
#ifdef USE_DEBUG
        if ( DebugMode )
            {
            if ( ! Step )
                {
                Debug( DeviceContext );
                Step = 1;
                }
            if ( PeekMessage( &msg, NULL, 0,0, PM_REMOVE ) )
                DispatchMessage( &msg );

            if ( Cont )
                {
                ExecInstZ80();
                Step = 0;
                Cont = 0;
                }
            }
        else
#endif
            ExecInstZ80();

#ifdef USE_TAPE
        //
        // Extraction des bits pour E/S cassette tous les 1/TPS_TAPE cycles cpu
        //
        CntTape += ( CptInstr - OldCptInstr );
        if ( CptInstr < OldCptInstr )
            CntTape += CycleLigne;

        OldCptInstr = CptInstr;
        if ( CntTape >= TPS_TAPE )
            {
            WriteCas();
            ReadCas();
            CntTape -= TPS_TAPE;
            }
#endif
        //
        // Gestion des compteurs : cycles d'horloges, VSync et HSync du CRTC
        //
        if ( CptInstr >= CycleLigne ) // Nbre de cycles = temps d'une ligne
            {
            //
            // Trace une ligne
            //
            CptInstr -= CycleLigne;
            if ( CntVSync < 266 )
                DrawFct( CntVSync );

            CntHSync++;
            CntVSync++;
            if ( ! SyncCount )
                {
                //
                // Si 52 lignes compte -> Gnration d'une interruption
                //
                if ( CntHSync == 52 )
                    {
                    if ( PeekMessage( &msg, NULL, 0,0, PM_REMOVE ) )
                        DispatchMessage( &msg );

                    if ( ! SmallScreen )
                        AffichePiste( &OldTrack, GetCurrTrack() );
#ifdef USE_DEBUG
                    if ( ! DebugMode )
#endif
                        IRQ = 1;

                    CntHSync = 0;
                    }
                }
            else
                {
                SyncCount--;
                if ( ! SyncCount )
                    {
                    if ( CntHSync > 32 )
                        IRQ = 1;

                    CntHSync = 0;
                    }
                }
            //
            // Arriv en fin d'cran -> Raz de VSync
            //
            if ( CntVSync >= NbLignesMax )
                {
                SyncCount = 2;
                TimeOut = ( 1000000 / ( FreqLigne / NbLignesMax ) ) - 1;
#ifdef USE_SOUND
                if ( Sound )
                    Loop8912( TimeOut );
#endif
                //
                // Prise en compte des registres du format vertical du CRTC
                //
                TailleChar = RegsCRTC[ 9 ] + 1;
                CntVSync = 0;
                NbLignesMax = /*RegsCRTC[ 5 ] + */( ( 1 + RegsCRTC[ 4 ] ) * TailleChar );
                DebutVSync = RegsCRTC[ 7 ] * TailleChar; /* #### */
                //
                // Rafraichissement de l'cran...
                //
                if ( FrameCnt++ > FrameSkip )
                    {
                    FrameCnt = 0;
                    UpdateScreen();
                    }
                //
                // Synchronisation de l'image  50 Hz
                //
                if ( ! Turbo )
                    {
                    do
                        {
                        Time = GetTickCount() * 1000;
                        Sleep( Time - OldTime < 2 ? 1 : 0 );
                        }
                    while( Time - OldTime < TimeOut );
                    OldTime = Time;
                    }
                }
            //
            // Si Compteur VSync = Position d'envoi du VBL...
            //
            if ( CntVSync == DebutVSync )
                TpsVbl = 0;

            //
            // Gnration du "Vertical Blanking Line"
            //
            VBL = ( TpsVbl++ < 32 );
            }
        }
    while( ! finMain );
}


/********************************************************* !NAME! **************
* Nom : WinMain
********************************************************** !PATHS! *************
* !./V1!\\!./V2!\\!./V3!\\!./V4!\\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\\/FLE!, ligne : !./LN!
*
* Description : Point d'entre du programme
*
* Rsultat    : 0
*
* Variables globales modifies :
*
********************************************************** !0! ****************/
int APIENTRY WinMain( HINSTANCE hInstance
                    , HINSTANCE hPrevInstance
                    , LPSTR     lpCmdLine
                    , int       nCmdShow
                    )
{
    char * Msg;

    Msg = lpCmdLine;            // Eviter un warning
    hPrevInstance = 0;          // Eviter un warning
    if ( ReadConfig() )
        {
#ifdef USE_LOG
        if ( StartLog( "Z80.LOG" ) )
            {
#endif
            if ( InitMemCPC() )
                {
#ifdef USE_MULTIFACE
                if ( ! Multiface || InitMultiface() )
#endif
                    {
                    MyRegisterClass( hInstance );
                    if ( InitInstance( hInstance, nCmdShow ) )
                        {
#ifdef USE_PRINTER
                        StartPrinter( "print.txt" );
#endif
                        InitPlateforme();
                        ResetZ80();
                        ResetUPD();
#ifdef USE_SOUND
                        if ( Sound )
                            {
                            InitSound();
                            Reset8912();
                            }
#endif
                        Go();
                        EjectDiskUPD();
#ifdef USE_TAPE
                        CloseTap();
#endif
#ifdef USE_SOUND
                        if ( Sound )
                            EndSound();
#endif
#ifdef USE_PRINTER
                        EndPrinter();
#endif
                        }
                    else
                        {
                        Msg = "Impossible d'instancier la fentre de l'mulateur";
#ifdef USE_LOG
                        Log( Msg, LOG_WARNING );
#endif
                        Erreur( Msg );
                        }
                    }
#ifdef USE_MULTIFACE
                else
                    {
                    Msg = "Rom multiface non trouve";
#ifdef USE_LOG
                    Log( Msg, LOG_WARNING );
#endif
                    Erreur( Msg );
                    }
#endif
                }
            else
                {
                Msg = "Roms du CPC non trouves";
#ifdef USE_LOG
                Log( Msg, LOG_WARNING );
#endif
                Erreur( Msg );
                }

#ifdef USE_LOG
            EndLog();
            }
        else
            Erreur( "Impossible d'ouvrir le fichier de trace" );
#endif
        }
    else
        Erreur( "Fichier de configuration du CPC non trouv." );

    return( 0 );
}
