/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Accessoires!
// Dfinition du module        !CONFIG!=/V4!Emulation Disque!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Accessoires
* ------------------------------------------------------------------------------
*  Fichier     : NEWDISC.C             | Version : 0.1x
* ------------------------------------------------------------------------------
*  Date        : 21/01/2004            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Emulation acces direct au disque
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  21/01/2004              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <windows.h>
#include  <string.h>
#include  <stdio.h>

#include  "types.h"
#include  "z80.h"
#include  "vga.h"
#include  "config.h"
#include  "plateform.h"
#ifdef USE_LOG
#include  "log.h"
#endif


#ifdef USE_NEWDISC

#define SIZE_COPY_BUFF  0x100


/********************************************************* !NAME! **************
* Nom : StAmsdos
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Structures
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Structure de l'en-tte Amsdos avant les donnes des fichiers
*
********************************************************** !0! ****************/
typedef struct
    {
    UBYTE   UserNumber;             // User
    UBYTE   FileName[ 15 ];         // Nom + extension
    UBYTE   BlockNum;               // Numro du premier bloc (disquette)
    UBYTE   LastBlock;              // Numro du dernier bloc (disquette)
    UBYTE   FileType;               // Type de fichier
    USHORT  Length;                 // Longueur
    USHORT  Adress;                 // Adresse
    UBYTE   FirstBlock;             // Premier bloc de fichier (disquette)
    USHORT  LogicalLength;          // Longueur logique
    USHORT  EntryAdress;            // Point d'entre
    UBYTE   Unused[ 0x24 ];
    USHORT  RealLength;             // Longueur relle
    UBYTE   BigLength;              // Longueur relle (3 octets)
    USHORT  CheckSum;               // Checksum Amsdos
    UBYTE   Unused2[ 0x3B ];
    } StAmsdos;


/********************************************************* !NAME! **************
* Nom : NewDiscOn
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Activation/dsactivation du module mulation disque
*
********************************************************** !0! ****************/
int NewDiscOn = 0;


/********************************************************* !NAME! **************
* Nom : fOut
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Handle du fichier de sortie
*
********************************************************** !0! ****************/
static FILE * fOut = NULL;


/********************************************************* !NAME! **************
* Nom : fIn
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Handle du fichier d'entre
*
********************************************************** !0! ****************/
static FILE * fIn = NULL;


/********************************************************* !NAME! **************
* Nom : NomFic
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Nom du fichier  ouvrir
*
********************************************************** !0! ****************/
static char NomFic[ 128 ];


/********************************************************* !NAME! **************
* Nom : MemoOut
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Mmorisation fichier de sortie ouvert
*
********************************************************** !0! ****************/
static int MemoOut = 0;


/********************************************************* !NAME! **************
* Nom : MemoIn
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Mmorisation fichier d'entre ouvert
*
********************************************************** !0! ****************/
static int MemoIn = 0;


/********************************************************* !NAME! **************
* Nom : CopyMemDirect
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Buffer utilis pour les fonctions de lecture/critures directes
*
********************************************************** !0! ****************/
static UBYTE CopyMemDirect[ 0x10000 ];


/********************************************************* !NAME! **************
* Nom : CopyMem
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Buffer utilis pour les fonctions de lecture/criture d'octets
*
********************************************************** !0! ****************/
static UBYTE CopyMem[ SIZE_COPY_BUFF ];


/********************************************************* !NAME! **************
* Nom : PosCopyMem
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Position dans le buffer de lecture/criture d'octets
*
********************************************************** !0! ****************/
static int PosCopyMem = 0;


/********************************************************* !NAME! **************
* Nom : MaxCopyMem
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Taille du buffer de lecture/criture d'octets

*
********************************************************** !0! ****************/
static int MaxCopyMem = 0;


/********************************************************* !NAME! **************
* Nom : CasInOpen
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_IN_OPEN (0xBC77)
*
* Rsultat    : /
*
* Variables globales modifies : Z80, fIn, MemoIn, NomFic, PosCopyMem, 
*                                MaxCopyMem
*
********************************************************** !0! ****************/
static void CasInOpen( void )
{
    static char NomTmp[ 1024 ];
    static StAmsdos Entete;
    int i, Checksum = 0;
    UBYTE * pEntete;

    // Effectuer un "RET"
    RegPC = 0x000F;

    FLAGS &= ! FLAG_Z & ! FLAG_C;
    if ( MemoIn )
        RegA = 1;   // Code Erreur
    else
        {
        memset( NomFic, 0, sizeof( NomFic ) );
        for ( i = 0; i < RegB; i++ )
            NomFic[ i ] = ( char )toupper( Peek8Ext( ( USHORT )( RegHL + i ) ) );

        sprintf( NomTmp, "%s\\%s", DirEmuDisc, NomFic );
        fIn = fopen( NomTmp, "rb" );
        if ( ! fIn )
            {
            if ( ! strchr( NomFic, '.' ) )
                {
                sprintf( NomTmp, "%s\\%s.bas", DirEmuDisc, NomFic );
                fIn = fopen( NomTmp, "rb" );
                if ( ! fIn )
                    {
                    sprintf( NomTmp, "%s\\%s.bin", DirEmuDisc, NomFic );
                    fIn = fopen( NomTmp, "rb" );
                    }
                }
            }
        if ( fIn )
            {
#ifdef USE_LOG
            sprintf( MsgLog
                   , "Ouverture en lecture fichier %s russie."
                   , NomTmp
                   );
            Log( MsgLog, LOG_DEBUG );
#endif
            fread( &Entete, sizeof( Entete ), 1, fIn );
            pEntete = ( UBYTE * )&Entete;
            for ( i = 0; i < 67; i++ )
                Checksum += * pEntete++;

//            if ( ! Entete.Length )
//                Entete.Length = Entete.LogicalLength;

#ifdef USE_LOG
            sprintf( MsgLog , "Entete.FileType      = 0x%04X", Entete.FileType );
            Log( MsgLog, LOG_DEBUG );
            sprintf( MsgLog , "Entete.Length        = 0x%04X", Entete.Length );
            Log( MsgLog, LOG_DEBUG );
            sprintf( MsgLog , "Entete.Adress        = 0x%04X", Entete.Adress );
            Log( MsgLog, LOG_DEBUG );
            sprintf( MsgLog , "Entete.LogicalLength = 0x%04X", Entete.LogicalLength );
            Log( MsgLog, LOG_DEBUG );
            sprintf( MsgLog , "Entete.EntryAdress   = 0x%04X", Entete.EntryAdress );
            Log( MsgLog, LOG_DEBUG );
            sprintf( MsgLog , "Entete.RealLehgth    = 0x%04X", Entete.RealLength );
            Log( MsgLog, LOG_DEBUG );
#endif

            RegHL = ( USHORT )( Peek8Ext( 0xBE7D ) + ( Peek8Ext( 0xBE7E ) << 8 ) );
            FLAGS |= FLAG_C;
            for ( i = 0; i < 0x80; i++ )
                {
                Poke8Ext( ( USHORT )( RegHL + i ), * pEntete );
                Poke8Ext( ( USHORT )( RegDE + i ), * pEntete++ );
                }
            if ( Checksum == Entete.CheckSum )
                {
                RegA = Entete.FileType;
                RegBC = Entete.LogicalLength;
                RegDE = Entete.Adress;
                }
            else
                {
                RegA = 0x16;
                RegBC = 0;
                RegDE = 0;
                fseek( fIn, 0, SEEK_SET );
                }
            MemoIn = 1;
            PosCopyMem = MaxCopyMem = -1;
            }
        else
            {
#ifdef USE_LOG
            sprintf( MsgLog
                   , "Ouverture en lecture fichier %s choue."
                   , NomTmp
                   );
            Log( MsgLog, LOG_DEBUG );
#endif
            RegA = 0x06;
            }
        }
}


/********************************************************* !NAME! **************
* Nom : FlushCloseIn
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Ferme le fichier d'entre
*
* Rsultat    : /
*
* Variables globales modifies : MemoIn, fIn
*
********************************************************** !0! ****************/
void FlushCloseIn( void )
{
    if ( MemoIn )
        {
        if ( fIn )
            fclose( fIn );

        MemoIn = 0;
        fIn = NULL;
        }
}


/********************************************************* !NAME! **************
* Nom : CasInClose
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_IN_CLOSE (0xBC7A)
*
* Rsultat    : /
*
* Variables globales modifies : Z80
*
********************************************************** !0! ****************/
static void CasInClose( void )
{
    // Effectuer un "RET"
    RegPC = 0x000F;

    FLAGS &= ! FLAG_Z & ! FLAG_C;
    if ( MemoIn )
        {
        FlushCloseIn();
        FLAGS |= FLAG_C;
        RegA = 0;
#ifdef USE_LOG
        Log( "Fermeture fichier d'entre.", LOG_DEBUG );
#endif
        }
}


/********************************************************* !NAME! **************
* Nom : CasInAbandon
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_IN_ABANDON (0xBC7D)
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
static void CasInAbandon( void )
{
#ifdef USE_LOG
        Log( "Abandon fichier d'entre.", LOG_DEBUG );
#endif
    CasInClose();
}


/********************************************************* !NAME! **************
* Nom : CasInChar
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_IN_CHAR (0xBC80)
*
* Rsultat    : /
*
* Variables globales modifies : Z80, MaxCopyMem, PosCopyMem
*
********************************************************** !0! ****************/
static void CasInChar( void )
{
    // Effectuer un "RET"
    RegPC = 0x000F;

    FLAGS &= ! FLAG_Z & ! FLAG_C;
    if ( MemoIn )
        {
        if ( PosCopyMem == MaxCopyMem )
            {
            MaxCopyMem = fread( CopyMem, 1, SIZE_COPY_BUFF, fIn );
            PosCopyMem = 0;
            }
        if ( MaxCopyMem )
            {
            RegA = CopyMem[ PosCopyMem++ ];
            FLAGS |= FLAG_C;
            }
        }
}


/********************************************************* !NAME! **************
* Nom : CasInDirect
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_IN_DIRECT (0xBC83)
*
* Rsultat    : /
*
* Variables globales modifies : Z80
*
********************************************************** !0! ****************/
static void CasInDirect( void )
{
    int i, lg;

    // Effectuer un "RET"
    RegPC = 0x000F;
/*
    // Dslectionner les Roms pour ne pas crire dedans...
    SveDecodeur = DecodeurAdresse;
    WriteVGA( DecodeurAdresse | ROMINF_OFF | ROMSUP_OFF );
*/
    FLAGS &= ! FLAG_Z & ! FLAG_C;
    if ( fIn )
        {
        lg = fread( CopyMemDirect, 1, RegDE, fIn );
        for ( i = 0; i < lg; i++ )
            Poke8Ext( ( USHORT )( RegHL + i ), CopyMemDirect[ i ] );

        RegA = 0;
        FLAGS |= FLAG_C;
        }
    else
        RegA = 1;
}


/********************************************************* !NAME! **************
* Nom : CasReturn
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_RETURN (0xBC86)
*
* Rsultat    : /
*
* Variables globales modifies : Z80, PosCopyMem
*
********************************************************** !0! ****************/
static void CasReturn( void )
{
    // Effectuer un "RET"
    RegPC = 0x000F;

    if ( PosCopyMem > 0 )
        PosCopyMem--;
}


/********************************************************* !NAME! **************
* Nom : CasTestEof
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_TEST_EOF (0xBC89)
*
* Rsultat    : /
*
* Variables globales modifies : Z80
*
********************************************************** !0! ****************/
static void CasTestEof( void )
{
    // Effectuer un "RET"
    RegPC = 0x000F;

    if ( ! MaxCopyMem )
        FLAGS = ( UBYTE )( FLAGS & ! FLAG_Z & ! FLAG_C );
    else
        FLAGS = ( UBYTE )( FLAGS & ! FLAG_Z | FLAG_C );
}


/********************************************************* !NAME! **************
* Nom : CasOutOpen
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_OUT_OPEN (0xBC8C)
*
* Rsultat    : /
*
* Variables globales modifies : Z80, NomFic, PosCopyMem, MaxCopyMem
*
********************************************************** !0! ****************/
static void CasOutOpen( void )
{
    int i;

    // Effectuer un "RET"
    RegPC = 0x000F;

    FLAGS &= ! FLAG_Z & ! FLAG_C;
    if ( MemoOut )
        RegA = 1;   // Code Erreur
    else
        {
        memset( NomFic, 0, sizeof( NomFic ) );
        for ( i = 0; i < RegB; i++ )
            NomFic[ i ] = ( char )toupper( Peek8Ext( ( USHORT )( RegHL + i ) ) );

        FLAGS |= FLAG_C;
        RegHL = RegDE;
        RegA = 0;
        MemoOut = 1;
        PosCopyMem = MaxCopyMem = -1;
        }
}


/********************************************************* !NAME! **************
* Nom : FlushCloseOut
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Ferme et "flush" le fichier de sortie
*
* Rsultat    : /
*
* Variables globales modifies : fOut, MemoOut, PosCopyMem
*
********************************************************** !0! ****************/
void FlushCloseOut( void )
{
    if ( MemoOut )
        {
        if ( fOut )
            {
            if ( PosCopyMem > 0 )
                fwrite( CopyMem, 1, PosCopyMem, fOut );

            fclose( fOut );
            }
        MemoOut = 0;
        fOut = NULL;
        }
}


/********************************************************* !NAME! **************
* Nom : CasOutClose
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_OUT_CLOSE (0xBC8F)
*
* Rsultat    : /
*
* Variables globales modifies : Z80
*
********************************************************** !0! ****************/
static void CasOutClose( void )
{
    // Effectuer un "RET"
    RegPC = 0x000F;

    FLAGS &= ! FLAG_Z & ! FLAG_C;
    if ( MemoOut )
        {
        FlushCloseOut();
        FLAGS |= FLAG_C;
        RegA = 0;
#ifdef USE_LOG
        Log( "Fermeture fichier de sortie.", LOG_DEBUG );
#endif
        }
    else
        RegA = 2;   // Code Erreur
}


/********************************************************* !NAME! **************
* Nom : CasOutAbandon
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_OUT_ABANDON  (0xBC92)
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
static void CasOutAbandon( void )
{
#ifdef USE_LOG
        Log( "Abandon fichier de sortie.", LOG_DEBUG );
#endif
    CasOutClose();
}


/********************************************************* !NAME! **************
* Nom : OpenWriteFile
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Ouvre le fichier de sortie, en crant ventuellement un fichier
*               .BAK si il existe un fichier avec le mme nom.
*
* Rsultat    : /
*
* Variables globales modifies : NomFic, fOut
*
********************************************************** !0! ****************/
static void OpenWriteFile( int FileType )
{
    static char NewName[ 1024 ];
    static char NomTmp[ 1024 ];
    char * p;

    if ( ! strchr( NomFic, '.' ) && FileType != -1 )
        {
        if ( FileType & 2 )
            strcat( NomFic, ".BIN" );
        else
            strcat( NomFic, ".BAS" );
        }
    sprintf( NewName, "%s\\%s", DirEmuDisc, NomFic );
    fOut = fopen( NewName, "rb" );
    if ( ! fOut )
        {
        fOut = fopen( NewName, "wb" );
#ifdef USE_LOG
        sprintf( MsgLog
               , "Ouverture en criture fichier %s %s."
               , NewName
               , fOut ? "russie" : "choue"
               );
        Log( MsgLog, LOG_DEBUG );
#endif
        }
    else
        {
        fclose( fOut );
        sprintf( NewName, "%s\\%s", DirEmuDisc, NomFic );
        strcpy( NomTmp, NewName );
        p = strchr( NewName, '.' );
        if ( p )
            strcpy( p, ".BAK" );
        else
            strcat( NewName, ".BAK" );

        remove( NewName );
        rename( NomTmp, NewName );
        fOut = fopen( NomTmp, "wb" );
#ifdef USE_LOG
        sprintf( MsgLog
               , "Ouverture en criture fichier %s %s."
               , NomTmp
               , fOut ? "russie" : "choue"
               );
        Log( MsgLog, LOG_DEBUG );
#endif
        }
}


/********************************************************* !NAME! **************
* Nom : CasOutChar
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_OUT_CHAR (0xBC95)
*
* Rsultat    : /
*
* Variables globales modifies : Z80, PosCopyMem, MaCopyMem
*
********************************************************** !0! ****************/
static void CasOutChar( void )
{
    // Effectuer un "RET"
    RegPC = 0x000F;

    FLAGS &= ! FLAG_Z & ! FLAG_C;
    if ( ! fOut )
        {
        OpenWriteFile( -1 );
        MaxCopyMem = SIZE_COPY_BUFF;
        PosCopyMem = 0;
        }
    if ( fOut )
        {
        if ( PosCopyMem < MaxCopyMem )
            CopyMem[ PosCopyMem++ ] = RegA;
        else
            {
            fwrite( CopyMem, 1, PosCopyMem, fOut );
            PosCopyMem = 0;
            CopyMem[ PosCopyMem++ ] = RegA;
            }
        FLAGS |= FLAG_C;
        }
}


/********************************************************* !NAME! **************
* Nom : CasOutDirect
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_OUT_DIRECT (0xBC98)
*
* Rsultat    : /
*
* Variables globales modifies : Z80
*
********************************************************** !0! ****************/
static void CasOutDirect( void )
{
    static StAmsdos Entete;
    int i, SveDecodeur, Checksum = 0;
    UBYTE * pEntete;

    // Effectuer un "RET"
    RegPC = 0x000F;
    
    pEntete = ( UBYTE * )&Entete;
    Entete.Adress = RegHL;
    Entete.Length = RegDE;
    Entete.RealLength = RegDE;
    Entete.LogicalLength = RegDE;
    Entete.FileType = RegA;
    Entete.EntryAdress = RegBC;

    for ( i = 0; i < 67; i++ )
        Checksum += * pEntete++;

    Entete.CheckSum = ( USHORT )Checksum;


    // Dslectionner la Rom suprieure pour ne pas lire dedans...
    SveDecodeur = DecodeurAdresse;
    WriteVGA( DecodeurAdresse | ROMSUP_OFF );

    FLAGS &= ! FLAG_Z & ! FLAG_C;
    OpenWriteFile( Entete.FileType );
    if ( fOut )
        {
        fwrite( &Entete, sizeof( Entete ), 1, fOut );
        for ( i = 0; i < RegDE; i++ )
            CopyMemDirect[ i ] = ( UBYTE )Peek8Ext( ( USHORT )( RegHL + i ) );

        fwrite( CopyMemDirect, RegDE, 1, fOut );
        RegA = 0;
        FLAGS |= FLAG_C;
        }
    else
        RegA = 1;

    // Repoositionner les roms
    WriteVGA( SveDecodeur );
}


/********************************************************* !NAME! **************
* Nom : CasCatalog
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Emule la routine CAS_CATALOG (0xBC9B)
*
* Rsultat    : /
*
* Variables globales modifies : Z80
*
********************************************************** !0! ****************/
static void CasCatalog( void )
{
    static char Recherche[ 1024 ];
    static UBYTE AffDir[] = 
        {
        0x7E, 0xFE, 0xFF, 0x37, 0xC0, 0xE5, 0xE5, 0x54, 
        0x5D, 0x06, 0x08, 0x13, 0x1A, 0xE6, 0x7F, 0xCD, 
        0x5A, 0xBB, 0x10, 0xF7, 0x3E, 0x2E, 0xCD, 0x5A, 
        0xBB, 0x06, 0x03, 0x13, 0x1A, 0xE6, 0x7F, 0xCD, 
        0x5A, 0xBB, 0x10, 0xF7, 0x3E, 0x20, 0xCD, 0x5A, 
        0xBB, 0xDD, 0xE1, 0xDD, 0x66, 0x0D, 0xDD, 0x6E, 
        0x0C, 0x16, 0x20, 0x01, 0x9C, 0xFF, 0x3E, 0xFF, 
        0xE5, 0x3C, 0x09, 0x30, 0x04, 0xE3, 0xE1, 0x18, 
        0xF7, 0xE1, 0xB7, 0x28, 0x02, 0x16, 0x30, 0x82, 
        0xCD, 0x5A, 0xBB, 0x01, 0xF6, 0xFF, 0x3E, 0xFF, 
        0xE5, 0x3C, 0x09, 0x30, 0x04, 0xE3, 0xE1, 0x18, 
        0xF7, 0xE1, 0xB7, 0x28, 0x02, 0x16, 0x30, 0x82, 
        0xCD, 0x5A, 0xBB, 0x7D, 0xC6, 0x30, 0xCD, 0x5A, 
        0xBB, 0x3E, 0x4B, 0xCD, 0x5D, 0xBB, 0x3E, 0x20, 
        0xCD, 0x5A, 0xBB, 0xCD, 0x5A, 0xBB, 0xCD, 0x5A, 
        0xBB, 0xE1, 0x11, 0x0E, 0x00, 0x19, 0x18, 0x80
        };

    USHORT adr;
    int i, l, cnt = 0;
    char * Nom;
    char * Ext;
    BOOL Cont;
    WIN32_FIND_DATA FindData;
    HANDLE h;

    RegHL = RegDE;
    adr = ( USHORT )( RegDE + 0x780 );
    RegPC = adr;
    for ( i = 0; i < sizeof( AffDir ); i++ )
        Poke8Ext( adr++, AffDir[ i ] );

    adr = RegDE;
    Poke8Ext( adr, 0 );
    sprintf( Recherche, "%s\\*.*", DirEmuDisc );
    h = FindFirstFile( Recherche, &FindData );
    if ( h != INVALID_HANDLE_VALUE )
        {
        do
            {
            if ( FindData.dwFileAttributes != FILE_ATTRIBUTE_DIRECTORY )
                {
                Nom = FindData.cFileName;
                if ( Nom )
                    {
                    char * p = strchr( Nom, '.' );
                    if ( p )
                        {
                        * p++ = 0;
                        Ext = p;
                        }
                    else
                        Ext = "   ";

                    l = strlen( Nom );
                    Poke8Ext( adr++, 0xFF );
                    for ( i = 0; i < 8; i++ )
                        Poke8Ext( adr++, ( UBYTE )( i < l ? Nom[ i ] : ' ' ) );

                    l = strlen( Ext );
                    for ( i = 0; i < 3; i++ )
                        Poke8Ext( adr++, ( UBYTE )( i < l ? Ext[ i ] : ' ' ) );

                    l = ( FindData.nFileSizeLow + 1023 ) >> 10;
                    Poke8Ext( adr++, ( UBYTE )l );
                    Poke8Ext( adr++, ( UBYTE )( l >> 8 ) );
                    }
                }
            Cont = FindNextFile( h, &FindData );
            if ( cnt++ > 128 )  // Ne pas dpasser les 2K de buffers...
                Cont = 0;
            }
        while( Cont );
        FindClose( h );
        Poke8Ext( adr, 0 );
        }
}


/********************************************************* !NAME! **************
* Nom : NewDiscAdrPC
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Dtourne les appels aux routines CAS/Amsdos
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void NewDiscAdrPC( void )
{
    switch( RegPC )
        {
        case 0xBC77 :
            CasInOpen();
            break;

        case 0xBC7A :
            CasInClose();
            break;

        case 0xBC7D :
            CasInAbandon();
            break;

        case 0xBC80 :
            CasInChar();
            break;

        case 0xBC83 :
            CasInDirect();
            break;

        case 0xBC86 :
            CasReturn();
            break;

        case 0xBC89 :
            CasTestEof();
            break;

        case 0xBC8C :
            CasOutOpen();
            break;

        case 0xBC8F :
            CasOutClose();
            break;

        case 0xBC92 :
            CasOutAbandon();
            break;

        case 0xBC95 :
            CasOutChar();
            break;

        case 0xBC98 :
            CasOutDirect();
            break;

        case 0xBC9B :
            CasCatalog();
            break;
        }
}
#endif
