/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Noyau!
// Dfinition du module        !CONFIG!=/V4!Ecran Clavier!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Noyau
* ------------------------------------------------------------------------------
*  Fichier     : PLATEFORM.C           | Version : 0.1y
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Gestion cran, clavier
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
*  07/11/2002              | L.DEPLANQUE             | Ajout gestion lecture et
*                          |                         | criture cassette :
*                          |                         | touches F9 (lecture) et
*                          |                         | F11 (criture)
* ------------------------------------------------------------------------------
*  13/11/2002              | L.DEPLANQUE             | Passage du nom de fichier
*                          |                         | snapshot en paramtre aux
*                          |                         | fonctions LireSnap() et
*                          |                         | SauveSnap().  
* ------------------------------------------------------------------------------
*  06/01/2003              | L.DEPLANQUE             | Version 0.1t : Happy new
*                          |                         | Year
* ------------------------------------------------------------------------------
*  09/01/2003              | L.DEPLANQUE             | Version 0.1u : Ajout d'un
*                          |                         | tableau pour permettre la
*                          |                         | redfinition dynamique
*                          |                         | des touches mulant le
*                          |                         | joystick
* ------------------------------------------------------------------------------
*  03/02/2003              | L.DEPLANQUE             | Version 0.1v : Gestion
*                          |                         | localisation fichiers
*                          |                         | DSK, SNA, TAP
* ------------------------------------------------------------------------------
*  06/05/2003              | L.DEPLANQUE             | Version 0.1w : Correction
*                          |                         | d'un bug dans le mapping
*                          |                         | des touches joystick :
*                          |                         | Le membre .Ligne ne doit
*                          |                         | pas dpasser 0x0F (15)
*                          |                         | car clav[ nb=16 ]        
* ------------------------------------------------------------------------------
*  25/02/2004              | L.DEPLANQUE             | Version 0.1y : Changement
*                          |                         | du nom de l'application
*                          |                         | dans le titre de la
*                          |                         | fentre (WIN-CPC) et
*                          |                         | mise  disposition de la
*                          |                         | variable de titre        
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <windows.h>
#include  <stdio.h>

#include  "types.h"
#include  "plateform.h"
#ifdef USE_MULTIFACE
#include  "multiface.h"
#endif
#include  "snapshot.h"
#ifdef USE_NEWDISC
#include  "newdisc.h"
#endif
#include  "config.h"
#include  "sound.h"
#include  "z80.h"
#include  "ppi.h"
#include  "vga.h"
#include  "upd.h"
#include  "crtc.h"
#ifdef USE_LOG
#include  "log.h"
#endif


/********************************************************* !NAME! **************
* Nom : stToucheClav
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Structures
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Structure clavier CPC
*
********************************************************** !0! ****************/
typedef struct
    {
    UBYTE Port;
    UBYTE Ligne;
    } stToucheClav;


extern int finMain;


/********************************************************* !NAME! **************
* Nom : DeviceContext
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : structure HDC de la fentre principale
*
********************************************************** !0! ****************/
HDC DeviceContext;


/********************************************************* !NAME! **************
* Nom : Titre
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Titre de la fentre
*
********************************************************** !0! ****************/
char * Titre = "WIN-CPC - Version 0.1y       (Build " __DATE__ ")";


/********************************************************* !NAME! **************
* Nom : hInst
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Instance de l'application
*
********************************************************** !0! ****************/
static HINSTANCE hInst;


/********************************************************* !NAME! **************
* Nom : DcBitmap
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Structure HDC du bitmap reprsentant la mmoire cran CPC
*
********************************************************** !0! ****************/
static HDC DcBitmap;


/********************************************************* !NAME! **************
* Nom : MemBitmap
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Buffer contenant l'image de l'cran du CPC
*
********************************************************** !0! ****************/
static void * MemBitmap;


/********************************************************* !NAME! **************
* Nom : DrawFct
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Fonction de trac d'une ligne
*
********************************************************** !0! ****************/
pfctDraw DrawFct;


/********************************************************* !NAME! **************
* Nom : Turbo
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Mode turbo activ/dsactiv
*
********************************************************** !0! ****************/
int Turbo = 0;


/********************************************************* !NAME! **************
* Nom : DebugMode
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Mode debug activ/dsactiv
*
********************************************************** !0! ****************/
#ifdef USE_DEBUG
int DebugMode = 0;
#endif


/********************************************************* !NAME! **************
* Nom : Cont
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Droulement instructions en continu ou non
*
********************************************************** !0! ****************/
#ifdef USE_DEBUG
int Cont = 1;
#endif


/********************************************************* !NAME! **************
* Nom : TrKey
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Transformations touches PC -> CPC
*
********************************************************** !0! ****************/
static stToucheClav TrKey[ 256 ] =
    {
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x01
        { 0xFF, 0x0F },           // 0x02
        { 0xFF, 0x0F },           // 0x03
        { 0xFF, 0x0F },           // 0x04
        { 0xFF, 0x0F },           // 0x05
        { 0xFF, 0x0F },           // 0x06
        { 0xFF, 0x0F },           // 0x07
        { 0x7F, 0x09 },           // DEL
        { 0xEF, 0x08 },           // TAB
        { 0xFF, 0x0F },           // 0x0A
        { 0xFF, 0x0F },           // 0x0B
        { 0xFF, 0x0F },           // 0x0C
        { 0xFB, 0x02 },           // ENTER
        { 0xFF, 0x0F },           // 0x0E
        { 0xFF, 0x0F },           // 0x0F
        { 0xDF, 0x02 },           // SHIFT
        { 0x7F, 0x02 },           // CTRL
        { 0xFD, 0x01 },           // ALTGR -> COPY
        { 0xFF, 0x0F },           // 0x13
        { 0xBF, 0x08 },           // CAPS LOCK
        { 0xFF, 0x0F },           // 0x15
        { 0xFF, 0x0F },           // 0x16
        { 0xFF, 0x0F },           // 0x17
        { 0xFF, 0x0F },           // 0x18
        { 0xFF, 0x0F },           // 0x19
        { 0xFF, 0x0F },           // 0x1A
        { 0xFB, 0x08 },           // ESC
        { 0xFF, 0x0F },           // 0x1C
        { 0xFF, 0x0F },           // 0x1D
        { 0xFF, 0x0F },           // 0x1E
        { 0xFF, 0x0F },           // 0x1F
        { 0x7F, 0x05 },           // ' '
        { 0xFF, 0x0F },           // 0x21
        { 0xFF, 0x0F },           // 0x22
        { 0xFF, 0x0F },           // 0x23
        { 0xFF, 0x0F },           // 0x24
        { 0xFE, 0x01 },           // Fleche Gauche
        { 0xFE, 0x00 },           // Fleche Haut
        { 0xFD, 0x00 },           // Fleche Droite
        { 0xFB, 0x00 },           // Fleche Bas
        { 0xFF, 0x0F },           // 0x29
        { 0xFF, 0x0F },           // 0x2A
        { 0xFF, 0x0F },           // 0x2B
        { 0xFF, 0x0F },           // 0x2C
        { 0xFF, 0x0F },           // 0x2D
        { 0xFE, 0x02 },           // SUPPR
        { 0xFF, 0x0F },           // 0x2F
        { 0xFE, 0x04 },           // '0'
        { 0xFE, 0x08 },           // '1'
        { 0xFD, 0x08 },           // '2'
        { 0xFD, 0x07 },           // '3'
        { 0xFE, 0x07 },           // '4'
        { 0xFD, 0x06 },           // '5'
        { 0xFE, 0x06 },           // '6'
        { 0xFD, 0x05 },           // '7'
        { 0xFE, 0x05 },           // '8'
        { 0xFD, 0x04 },           // '9'
        { 0xFF, 0x0F },           // 0x3A
        { 0xFF, 0x0F },           // 0x3B
        { 0xFF, 0x0F },           // 0x3C
        { 0xFF, 0x0F },           // 0x3D
        { 0xFF, 0x0F },           // 0x3E
        { 0xFF, 0x0F },           // 0x3F
        { 0xFF, 0x0F },           // 0x40
        { 0xF7, 0x08 },           // 'A'
        { 0xBF, 0x06 },           // 'B'
        { 0xBF, 0x07 },           // 'C'
        { 0xDF, 0x07 },           // 'D'
        { 0xFB, 0x07 },           // 'E'
        { 0xDF, 0x06 },           // 'F'
        { 0xEF, 0x06 },           // 'G'
        { 0xEF, 0x05 },           // 'H'
        { 0xF7, 0x04 },           // 'I'
        { 0xDF, 0x05 },           // 'J'
        { 0xDF, 0x04 },           // 'K'
        { 0xEF, 0x04 },           // 'L'
        { 0xDF, 0x03 },           // 'M'
        { 0xBF, 0x05 },           // 'N'
        { 0xFB, 0x04 },           // 'O'
        { 0xF7, 0x03 },           // 'P'
        { 0xDF, 0x08 },           // 'Q'
        { 0xFB, 0x06 },           // 'R'
        { 0xEF, 0x07 },           // 'S'
        { 0xF7, 0x06 },           // 'T'
        { 0xFB, 0x05 },           // 'U'
        { 0x7F, 0x06 },           // 'V'
        { 0x7F, 0x08 },           // 'W'
        { 0x7F, 0x07 },           // 'X'
        { 0xF7, 0x05 },           // 'Y'
        { 0xF7, 0x07 },           // 'Z'
        { 0xFF, 0x0F },           // 0x5B
        { 0xFF, 0x0F },           // 0x5C
        { 0xFD, 0x01 },           // menu contextuel -> COPY
        { 0xFF, 0x0F },           // 0x5E
        { 0xFF, 0x0F },           // 0x5F
        { 0x7F, 0x01 },           // P'0'
        { 0xDF, 0x01 },           // P'1'
        { 0xBF, 0x01 },           // P'2'
        { 0xDF, 0x00 },           // P'3'
        { 0xEF, 0x02 },           // P'4'
        { 0xEF, 0x01 },           // P'5'
        { 0xEF, 0x00 },           // P'6'
        { 0xFB, 0x01 },           // P'7'
        { 0xF7, 0x01 },           // P'8'
        { 0xF7, 0x00 },           // P'9'
        { 0xFF, 0x0F },           // 0x6A
        { 0xFF, 0x0F },           // 0x6B
        { 0xFF, 0x0F },           // 0x6C
        { 0xFF, 0x0F },           // 0x6D
        { 0x7F, 0x00 },           // P'.'
        { 0xFF, 0x0F },           // 0x6F
        { 0xFF, 0x0F },           // 0x70
        { 0xFF, 0x0F },           // 0x71
        { 0xFF, 0x0F },           // 0x72
        { 0xFF, 0x0F },           // 0x73
        { 0xFF, 0x0F },           // 0x74
        { 0xFF, 0x0F },           // 0x75
        { 0xFF, 0x0F },           // 0x76
        { 0xFF, 0x0F },           // 0x77
        { 0xFF, 0x0F },           // 0x78
        { 0xFF, 0x0F },           // 0x79
        { 0xFF, 0x0F },           // 0x7A
        { 0xFF, 0x0F },           // 0x7B
        { 0xFF, 0x0F },           // 0x7C
        { 0xFF, 0x0F },           // 0x7D
        { 0xFF, 0x0F },           // 0x7E
        { 0xFF, 0x0F },           // 0x7F
        { 0xFF, 0x0F },           // 0x80
        { 0xFF, 0x0F },           // 0x81
        { 0xFF, 0x0F },           // 0x82
        { 0xFF, 0x0F },           // 0x83
        { 0xFF, 0x0F },           // 0x84
        { 0xFF, 0x0F },           // 0x85
        { 0xFF, 0x0F },           // 0x86
        { 0xFF, 0x0F },           // 0x87
        { 0xFF, 0x0F },           // 0x88
        { 0xFF, 0x0F },           // 0x89
        { 0xFF, 0x0F },           // 0x8A
        { 0xFF, 0x0F },           // 0x8B
        { 0xFF, 0x0F },           // 0x8C
        { 0xFF, 0x0F },           // 0x8D
        { 0xFF, 0x0F },           // 0x8E
        { 0xFF, 0x0F },           // 0x8F
        { 0xFF, 0x0F },           // 0x90
        { 0xFF, 0x0F },           // 0x91
        { 0xFF, 0x0F },           // 0x92
        { 0xFF, 0x0F },           // 0x93
        { 0xFF, 0x0F },           // 0x94
        { 0xFF, 0x0F },           // 0x95
        { 0xFF, 0x0F },           // 0x96
        { 0xFF, 0x0F },           // 0x97
        { 0xFF, 0x0F },           // 0x98
        { 0xFF, 0x0F },           // 0x99
        { 0xFF, 0x0F },           // 0x9A
        { 0xFF, 0x0F },           // 0x9B
        { 0xFF, 0x0F },           // 0x9C
        { 0xFF, 0x0F },           // 0x9D
        { 0xFF, 0x0F },           // 0x9E
        { 0xFF, 0x0F },           // 0x9F
        { 0xFF, 0x0F },           // 0xA0
        { 0xFF, 0x0F },           // 0xA1
        { 0xFF, 0x0F },           // 0xA2
        { 0xFF, 0x0F },           // 0xA3
        { 0xFF, 0x0F },           // 0xA4
        { 0xFF, 0x0F },           // 0xA5
        { 0xFF, 0x0F },           // 0xA6
        { 0xFF, 0x0F },           // 0xA7
        { 0xFF, 0x0F },           // 0xA8
        { 0xFF, 0x0F },           // 0xA9
        { 0xFF, 0x0F },           // 0xAA
        { 0xFF, 0x0F },           // 0xAB
        { 0xFF, 0x0F },           // 0xAC
        { 0xFF, 0x0F },           // 0xAD
        { 0xFF, 0x0F },           // 0xAE
        { 0xFF, 0x0F },           // 0xAF
        { 0xFF, 0x0F },           // 0xB0
        { 0xFF, 0x0F },           // 0xB1
        { 0xFF, 0x0F },           // 0xB2
        { 0xFF, 0x0F },           // 0xB3
        { 0xFF, 0x0F },           // 0xB4
        { 0xFF, 0x0F },           // 0xB5
        { 0xFF, 0x0F },           // 0xB6
        { 0xFF, 0x0F },           // 0xB7
        { 0xFF, 0x0F },           // 0xB8
        { 0xFF, 0x0F },           // 0xB9
        { 0xBF, 0x02 },           // '$'
        { 0xFE, 0x03 },           // '='
        { 0xBF, 0x04 },           // ','
        { 0xFF, 0x0F },           // 0xBD
        { 0x7F, 0x04 },           // ';'
        { 0x7F, 0x03 },           // ':'
        { 0xEF, 0x03 },           // ''
        { 0xFF, 0x0F },           // 0xC1
        { 0xFF, 0x0F },           // 0xC2
        { 0xFF, 0x0F },           // 0xC3
        { 0xFF, 0x0F },           // 0xC4
        { 0xFF, 0x0F },           // 0xC5
        { 0xFF, 0x0F },           // 0xC6
        { 0xFF, 0x0F },           // 0xC7
        { 0xFF, 0x0F },           // 0xC8
        { 0xFF, 0x0F },           // 0xC9
        { 0xFF, 0x0F },           // 0xCA
        { 0xFF, 0x0F },           // 0xCB
        { 0xFF, 0x0F },           // 0xCC
        { 0xFF, 0x0F },           // 0xCD
        { 0xFF, 0x0F },           // 0xCE
        { 0xFF, 0x0F },           // 0xCF
        { 0xFF, 0x0F },           // 0xD0
        { 0xFF, 0x0F },           // 0xD1
        { 0xFF, 0x0F },           // 0xD2
        { 0xFF, 0x0F },           // 0xD3
        { 0xFF, 0x0F },           // 0xD4
        { 0xFF, 0x0F },           // 0xD5
        { 0xFF, 0x0F },           // 0xD6
        { 0xFF, 0x0F },           // 0xD7
        { 0xFF, 0x0F },           // 0xD8
        { 0xFF, 0x0F },           // 0xD9
        { 0xFF, 0x0F },           // 0xDA
        { 0xFD, 0x03 },           // ')'
        { 0xFD, 0x02 },           // '#'
        { 0xFB, 0x03 },           // '^'
        { 0xF7, 0x02 },           // '*'
        { 0xBF, 0x03 },           // '!'
        { 0xFF, 0x0F },           // 0xE0
        { 0xFF, 0x0F },           // 0xE1
        { 0xFF, 0x0F },           // 0xE2
        { 0xFF, 0x0F },           // 0xE3
        { 0xFF, 0x0F },           // 0xE4
        { 0xFF, 0x0F },           // 0xE5
        { 0xFF, 0x0F },           // 0xE6
        { 0xFF, 0x0F },           // 0xE7
        { 0xFF, 0x0F },           // 0xE8
        { 0xFF, 0x0F },           // 0xE9
        { 0xFF, 0x0F },           // 0xEA
        { 0xFF, 0x0F },           // 0xEB
        { 0xFF, 0x0F },           // 0xEC
        { 0xFF, 0x0F },           // 0xED
        { 0xFF, 0x0F },           // 0xEE
        { 0xFF, 0x0F },           // 0xEF
        { 0xFF, 0x0F },           // 0xF0
        { 0xFF, 0x0F },           // 0xF1
        { 0xFF, 0x0F },           // 0xF2
        { 0xFF, 0x0F },           // 0xF3
        { 0xFF, 0x0F },           // 0xF4
        { 0xFF, 0x0F },           // 0xF5
        { 0xFF, 0x0F },           // 0xF6
        { 0xFF, 0x0F },           // 0xF7
        { 0xFF, 0x0F },           // 0xF8
        { 0xFF, 0x0F },           // 0xF9
        { 0xFF, 0x0F },           // 0xFA
        { 0xFF, 0x0F },           // 0xFB
        { 0xFF, 0x0F },           // 0xFC
        { 0xFF, 0x0F },           // 0xFD
        { 0xFF, 0x0F },           // 0xFE
        { 0xFF, 0x0F },           // 0xFF
    };


/********************************************************* !NAME! **************
* Nom : JoyKey
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Transformations touches PC -> Joystick CPC
*
********************************************************** !0! ****************/
static stToucheClav JoyKey[ 256 ];


/********************************************************* !NAME! **************
* Nom : TabPoints
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Conversions pixels CPC -> cran PC
*
********************************************************** !0! ****************/
static char TabPoints[ 4 ][ 256 ][ 8 ];


/********************************************************* !NAME! **************
* Nom : CalcPoints
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Calcule l'image des points  afficher  l'cran en fonction du
*               mode d'affichage du CPC (mode 0, 1 ou 2)
*
* Rsultat    : /
*
* Variables globales modifies : TabPoints
*
********************************************************** !0! ****************/
static void CalcPoints( void )
{
    int a, b, c, d, i;

    // Pour le mode 0
    for ( i = 0; i < 256; i++ )
        {
        a = ( i >> 7 )
          + ( ( i & 0x20 ) >> 3 )
          + ( ( i & 0x08 ) >> 2 )
          + ( ( i & 0x02 ) << 2 );
        b = ( ( i & 0x40 ) >> 6 )
          + ( ( i & 0x10 ) >> 2 )
          + ( ( i & 0x04 ) >> 1 )
          + ( ( i & 0x01 ) << 3 );
        TabPoints[ 0 ][ i ][ 0 ] = ( char )a;
        TabPoints[ 0 ][ i ][ 1 ] = ( char )a;
        TabPoints[ 0 ][ i ][ 2 ] = ( char )a;
        TabPoints[ 0 ][ i ][ 3 ] = ( char )a;
        TabPoints[ 0 ][ i ][ 4 ] = ( char )b;
        TabPoints[ 0 ][ i ][ 5 ] = ( char )b;
        TabPoints[ 0 ][ i ][ 6 ] = ( char )b;
        TabPoints[ 0 ][ i ][ 7 ] = ( char )b;
        }

    // Pour le mode 1
    for ( i = 0; i < 256; i++ )
        {
        a = ( i >> 7 ) + ( ( i & 0x08 ) >> 2 );
        b = ( ( i & 0x40 ) >> 6 ) + ( ( i & 0x04 ) >> 1 );
        c = ( ( i & 0x20 ) >> 5 ) + ( i & 0x02 );
        d = ( ( i & 0x10 ) >> 4 ) + ( ( i & 0x01 ) << 1 );
        TabPoints[ 1 ][ i ][ 0 ] = ( char )a;
        TabPoints[ 1 ][ i ][ 1 ] = ( char )a;
        TabPoints[ 1 ][ i ][ 2 ] = ( char )b;
        TabPoints[ 1 ][ i ][ 3 ] = ( char )b;
        TabPoints[ 1 ][ i ][ 4 ] = ( char )c;
        TabPoints[ 1 ][ i ][ 5 ] = ( char )c;
        TabPoints[ 1 ][ i ][ 6 ] = ( char )d;
        TabPoints[ 1 ][ i ][ 7 ] = ( char )d;
        }

    // Pour le mode 2
    for ( i = 0; i < 256; i++ )
        {
        TabPoints[ 2 ][ i ][ 0 ] = ( char )( i >> 7 );
        TabPoints[ 2 ][ i ][ 1 ] = ( char )( ( i & 0x40 ) >> 6 );
        TabPoints[ 2 ][ i ][ 2 ] = ( char )( ( i & 0x20 ) >> 5 );
        TabPoints[ 2 ][ i ][ 3 ] = ( char )( ( i & 0x10 ) >> 4 );
        TabPoints[ 2 ][ i ][ 4 ] = ( char )( ( i & 0x08 ) >> 3 );
        TabPoints[ 2 ][ i ][ 5 ] = ( char )( ( i & 0x04 ) >> 2 );
        TabPoints[ 2 ][ i ][ 6 ] = ( char )( ( i & 0x02 ) >> 1 );
        TabPoints[ 2 ][ i ][ 7 ] = ( char )( i & 0x01 );
        }

    // Mode 3 = Mode 0 ???
    for ( i = 0; i < 256; i++ )
        for ( a = 0; a < 8; a++ )
            TabPoints[ 3 ][ i ][ a ] = TabPoints[ 0 ][ i ][ a ];
}


/********************************************************* !NAME! **************
* Nom : CopyRight
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Affiche les informations de copyright
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
static void CopyRight( void )
{
    static char Cop1[] = "(C) 1996-2004 L.DEPLANQUE  (ludovic.deplanque@libertysurf.fr)             ";
    static char Cop2[] = "Free-Software                                                             ";

    SetTextColor( DeviceContext, RGB( 0, 0, 0 ) );
    SetBkColor( DeviceContext, RGB( 255, 255, 255 ) );
    TextOut( DeviceContext, 20, 544, Cop1, strlen( Cop1 ) );
    TextOut( DeviceContext, 20, 556, Cop2, strlen( Cop2 ) );
}


/********************************************************* !NAME! **************
* Nom : TouchesFonctions
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Gestion des touches fonctions pendant l'mulation
*
* Rsultat    : /
*
* Variables globales modifies : DebugMode, Cont, Turbo, MultifaceEnable
*
********************************************************** !0! ****************/
static void TouchesFonctions( WPARAM wParam )
{
    static char * Nom;
    static char Tmp[ 100 ];

    switch( wParam )
        {
#ifdef USE_DEBUG
        case 0x20 :
            Cont = 1;
            break;
#endif
        /* 
            Touche F1 :
            Mode Turbo ON
        */
        case 0x70 :
#ifdef USE_LOG
            Log( "Mode Turbo = ON", LOG_INFO );
#endif
            Turbo = 1;
            break;

        /*
            Touche F2 :
            Mode Turbo OFF
        */
        case 0x71 :
#ifdef USE_LOG
            Log( "Mode Turbo = OFF", LOG_INFO );
#endif
            Turbo = 0;
            break;

        /*
            Touche F3 :
            Bp de la multiface
        */
#ifdef USE_MULTIFACE
        case 0x72 :
            if ( ! MultifaceEnable && Multiface )
                {
#ifdef USE_LOG
                Log( "Appui BP Multiface", LOG_INFO );
#endif
                MultifaceEnable = 1;
                Z80_NMI();
                WriteVGA( 0x89 );
                }
            break;
#endif

        /*
            Touche F4 :
            Lecture fichier snapshot
        */
        case 0x73 :
#ifdef USE_SOUND
            if ( Sound )
                EndSound();
#endif
            Nom = OpenNewFile( "Snapshot files (*.SNA)\0*.SNA\0"
                             , "*.SNA"
                             , DirSnap
                             , FALSE
                             );
            if ( * Nom )
                LireSnap( Nom );

#ifdef USE_SOUND
            if ( Sound )
                InitSound();
#endif
            break;

        /*
            Touche F5 :
            Ecriture fichier snapshot
        */
        case 0x74 :
#ifdef USE_SOUND
            if ( Sound )
                EndSound();
#endif
            Nom = OpenNewFile( "Snapshot files (*.SNA)\0*.SNA\0"
                             , "*.SNA"
                             , DirSnap
                             , TRUE
                             );
            if ( * Nom )
                SauveSnap( Nom );

#ifdef USE_SOUND
            if ( Sound )
                InitSound();
#endif
            break;

        /*
            Touche F6 :
            Passage en mode debug
        */
#ifdef USE_DEBUG
        case 0x75 :
            if ( ! SmallScreen )
                {
                DebugMode ^= 1;
                Cont = 1;
                if ( ! DebugMode )
                    CopyRight();
                }
            break;
#endif
        /*
            Touche F7 :
            Lecture fichier disquette (.DSK)
        */
        case 0x76 :
#ifdef USE_SOUND
            if ( Sound )
                EndSound();
#endif
            Nom = OpenNewFile( "DSK files (*.DSK)\0*.DSK\0"
                             , "*.DSK"
                             , DirDisc
                             , FALSE
                             );
            if ( * Nom )
                {
#ifdef USE_LOG
                sprintf( Tmp, "Chargement disquette : %s", Nom );
                Log( Tmp, LOG_INFO );
#endif
                EjectDiskUPD();
                SetDiskUPD( Nom );
                }
#ifdef USE_SOUND
            if ( Sound )
                InitSound();
#endif
            break;

        /*
            Touche F8 :
            Reset du CPC
        */
        case 0x77 :
            WriteVGA( 0x89 );
            ResetZ80();
#ifdef USE_SOUND
            if ( Sound )
                {
                EndSound();
                InitSound();
                }
#endif
            break;

#ifdef USE_TAPE
        /*
            Touche F9 : 
            Lecture fichier cassette
        */
        case 0x78 :
#ifdef USE_SOUND
            if ( Sound )
                EndSound();
#endif
            Nom = OpenNewFile( "TAP files (*.TAP)\0*.TAP\0"
                             , "*.TAP"
                             , DirTape
                             , FALSE
                             );
            if ( * Nom )
                {
#ifdef USE_LOG
                sprintf( Tmp, "Lecture fichier cassette : %s", Nom );
                Log( Tmp, LOG_INFO );
#endif
                OpenTapRead( Nom );
                }
#ifdef USE_SOUND
            if ( Sound )
                InitSound();
#endif
            break;

        /*
            Touche F11 :
            Ecriture fichier cassette
        */
        case 0x7A :
#ifdef USE_SOUND
            if ( Sound )
                EndSound();
#endif
            Nom = OpenNewFile( "TAP files (*.TAP)\0*.TAP\0"
                             , "*.TAP"
                             , DirTape
                             , TRUE
                             );
            if ( * Nom )
                {
#ifdef USE_LOG
                sprintf( Tmp, "Ecriture fichier cassette : %s", Nom );
                Log( Tmp, LOG_INFO );
#endif
                OpenTapWrite( Nom );
                }
#ifdef USE_SOUND
            if ( Sound )
                InitSound();
#endif
            break;
#endif

        /*
            Touche F12 :
            Lecture fichier direct
        */
#ifdef USE_NEWDISC
        case 0x7B :
            NewDiscOn ^= 1;
            FlushCloseIn();
            FlushCloseOut();
            if ( NewDiscOn )
                Info( "Mode disque = acces direct" );
            else
                Info( "Mode disque = emulation par fichier .DSK" );
            break;
#endif
        }
}


/********************************************************* !NAME! **************
* Nom : WndProc
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Gestion des messages de Windows
*
* Rsultat    : /
*
* Variables globales modifies : finMain, clav
*
********************************************************** !0! ****************/
LRESULT CALLBACK WndProc( HWND hWnd
                        , UINT message
                        , WPARAM wParam
                        , LPARAM lParam
                        )
{
    switch( message )
        {
        case WM_DESTROY :
            finMain = 1;
            break;

        case WM_KEYUP :
            TouchesFonctions( wParam );
            clav[ TrKey[ wParam ].Ligne ] |= ~TrKey[ wParam ].Port;
            clav[ JoyKey[ wParam ].Ligne ] |= ~JoyKey[ wParam ].Port;
            break;

        case WM_KEYDOWN :
#ifdef USE_DEBUG
            if ( wParam == 0x0D )
                Cont = 1;
#endif
            clav[ TrKey[ wParam ].Ligne ] &= TrKey[ wParam ].Port;
            clav[ JoyKey[ wParam ].Ligne ] &= JoyKey[ wParam ].Port;
            break;
        }

    return( DefWindowProc( hWnd, message, wParam, lParam ) );
}


/********************************************************* !NAME! **************
* Nom : MyRegisterClass
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Enregistrement de la classe de la fentre
*
* Rsultat    : Identifian classe
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
ATOM MyRegisterClass( HINSTANCE hInstance )
{
    WNDCLASSEX wcex;

    wcex.cbSize = sizeof( WNDCLASSEX ); 
    wcex.style              = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc        = ( WNDPROC )WndProc;
    wcex.cbClsExtra         = 0;
    wcex.cbWndExtra         = 0;
    wcex.hInstance          = hInstance;
    wcex.hIcon              = NULL;
    wcex.hCursor            = NULL;
    wcex.hbrBackground      = ( HBRUSH )( COLOR_WINDOW+1 );
    wcex.lpszMenuName       = NULL;
    wcex.lpszClassName      = Titre;
    wcex.hIconSm            = NULL;
    return( RegisterClassEx( &wcex ) );
}


/********************************************************* !NAME! **************
* Nom : InitInstance
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Initialisation de l'instance du programme
*
* Rsultat    : TRUE si ok, FALSE sinon
*
* Variables globales modifies : MemBitmap
*
********************************************************** !0! ****************/
BOOL InitInstance( HINSTANCE hInstance, int nCmdShow )
{
    HWND hWnd;
    BITMAPINFO pbmi;
    HBITMAP bm;
    HFONT f;
    int i, x, y;

    if ( SmallScreen )
        {
        if ( ScreenDepth == 8 )
            DrawFct = TraceLigne8B320;
        else
            if ( ScreenDepth == 16 )
                DrawFct = TraceLigne16B320;
            else
                DrawFct = TraceLigne32B320;
        }
    else
        {
        if ( ScreenDepth == 8 )
            DrawFct = TraceLigne8B640;
        else
            if ( ScreenDepth == 16 )
                DrawFct = TraceLigne16B640;
            else
                DrawFct = TraceLigne32B640;
        }
    hInst = hInstance;
    if ( SmallScreen )
        {
        x = 326;
        y = 291;
        }
    else
        {
        x = 686;
        y = 600;
        }
    hWnd = CreateWindow( Titre
                       , Titre
                       , WS_SYSMENU
                       , CW_USEDEFAULT, CW_USEDEFAULT
                       , x, y
                       , NULL, NULL, hInstance, NULL
                       );

    if ( hWnd )
        {
        ShowWindow( hWnd, nCmdShow );
        UpdateWindow( hWnd );
        DeviceContext = GetDC( hWnd );
        pbmi.bmiHeader.biSize = sizeof( BITMAPINFOHEADER );
        if ( SmallScreen )
            {
            pbmi.bmiHeader.biWidth = 320;
            pbmi.bmiHeader.biHeight = -313;
            }
        else
            {
            pbmi.bmiHeader.biWidth = 640;
            pbmi.bmiHeader.biHeight = -625;
            }
        pbmi.bmiHeader.biPlanes = 1;
        pbmi.bmiHeader.biBitCount = ( USHORT )( ScreenDepth );
        pbmi.bmiHeader.biCompression = BI_RGB;
        pbmi.bmiHeader.biSizeImage = 0;
        pbmi.bmiHeader.biXPelsPerMeter = 0;
        pbmi.bmiHeader.biYPelsPerMeter = 0;
        pbmi.bmiHeader.biClrUsed = ScreenDepth == 8 ? 32 : 0;
        pbmi.bmiHeader.biClrImportant = ScreenDepth == 8 ? 32 : 0;
        bm = CreateDIBSection( DeviceContext
                             , &pbmi
                             , DIB_RGB_COLORS
                             , &MemBitmap
                             , NULL
                             , 0
                             );
        if ( bm )
            {
            DcBitmap = CreateCompatibleDC( DeviceContext );
            if ( DcBitmap )
                {
                SelectObject( DcBitmap, bm );
                if ( ScreenDepth == 8 )
                    SetDIBColorTable( DcBitmap, 0, 32, ( RGBQUAD * )RgbCPC );

                f = CreateFont( 14, 0, 0, 0, FW_DONTCARE, 0, 0, 0
                              , OEM_CHARSET
                              , OUT_DEFAULT_PRECIS
                              , CLIP_DEFAULT_PRECIS
                              , DEFAULT_QUALITY
                              , FIXED_PITCH | FF_DONTCARE,NULL
                              );
                if ( f )
                    {
                    SelectObject( DeviceContext, f );
                    SetBkColor( DeviceContext, RGB( 0, 0, 0 ) );
                    SetTextColor( DeviceContext, RGB( 255, 255, 255 ) );
                    }
                if ( ScreenDepth == 8 )
                    for ( i = 0; i < 32; i++ )
                        RgbCPC[ i ] = i;
                else
                    if ( ScreenDepth == 16 )
                        for ( i = 0; i < 32; i++ )
                            {
                            int r = ( RgbCPC[ i ] >> 19 ) & 0x1F;
                            int v = ( RgbCPC[ i ] >> 11 ) & 0x1F;
                            int b = ( RgbCPC[ i ] >> 3 ) & 0x1F;
                            RgbCPC[ i ] = b + ( v << 5 ) + ( r << 10 );
                            }
                SetStretchBltMode( DcBitmap, COLORONCOLOR );
                SetStretchBltMode( DeviceContext, COLORONCOLOR );
                return( TRUE );
                }
            }
        }
    return( FALSE );
}


/********************************************************* !NAME! **************
* Nom : OpenNewFile
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Ouverture d'une boite de dialogue de slection de nom de fichier
*
* Rsultat    : Le nom du fichier choisi
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
char * OpenNewFile( char * Filtre, char * Ext, char * Dir, BOOL Save )
{
    static char NomFic[ 256 ];
    OPENFILENAME ofn;
    BOOL ret;
    char * p;

    p = strchr( Dir, '.' );
    * NomFic = 0;
    if ( p )
        {
        while( * p != '\\' )
            * p-- = 0;
        }
    memset( &ofn, 0, sizeof( ofn ) );
    ofn.lStructSize = sizeof( OPENFILENAME );
    ofn.lpstrFilter = Filtre;
    ofn.lpstrCustomFilter = ( LPSTR )NULL;
    ofn.nFilterIndex = 1L;
//    ofn.lpstrFile = Dir;
    ofn.lpstrFile = NomFic;
    ofn.nMaxFile = sizeof( NomFic );
    ofn.lpstrDefExt = Ext;
    ofn.lpstrInitialDir = Dir;
    ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST;

    if ( Save )
        ret = GetSaveFileName( &ofn );
    else
        ret = GetOpenFileName( &ofn );

    if ( ret )
        strcpy( Dir, ofn.lpstrFile );

    return( ( char * )ofn.lpstrFile );
}


/********************************************************* !NAME! **************
* Nom : InitPlateforme
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Initialisation diverses
*
* Rsultat    : /
*
* Variables globales modifies : JoyKey, clav
*
********************************************************** !0! ****************/
void InitPlateforme( void )
{
    int i;

    CalcPoints();
    for ( i = 0; i < 256; i++ )
        {
        JoyKey[ i ].Port = 0xFF;
        JoyKey[ i ].Ligne = 0x0F;
        }
    JoyKey[ JoyUp ].Port       = 0xFE;
    JoyKey[ JoyUp ].Ligne      = 0x09;
    JoyKey[ JoyDown ].Port     = 0xFD;
    JoyKey[ JoyDown ].Ligne    = 0x09;
    JoyKey[ JoyLeft ].Port     = 0xFB;
    JoyKey[ JoyLeft ].Ligne    = 0x09;
    JoyKey[ JoyRight ].Port    = 0xF7;
    JoyKey[ JoyRight ].Ligne   = 0x09;
    JoyKey[ JoyFire1 ].Port    = 0xEF;
    JoyKey[ JoyFire1 ].Ligne   = 0x09;
    JoyKey[ JoyFire2 ].Port    = 0xDF;
    JoyKey[ JoyFire2 ].Ligne   = 0x09;
    memset( clav, 0xFF, sizeof( clav ) );
    if ( ! SmallScreen )
        CopyRight();
}


/********************************************************* !NAME! **************
* Nom : Erreur
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Affichage d'un message d'erreur
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void Erreur( char * Msg )
{
    MessageBox( NULL, Msg, "Emulateur CPC - Erreur", MB_ICONWARNING );
}


/********************************************************* !NAME! **************
* Nom : Info
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Affichage d'un message d'information
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void Info( char * Msg )
{
    MessageBox( NULL, Msg, "Emulateur CPC - Information", MB_ICONINFORMATION );
}


/********************************************************* !NAME! **************
* Nom : TraceLigne32B640
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Trace une ligne cran de 640 points en couleurs 32 bits
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void TraceLigne32B640( int y )
{
    int x, adr = y * 80;

    int * p = ( int * )MemBitmap;
    p += y * 640;
    for ( x = 0; x < 80; x++, adr++ )
        {
        int adCrtc = TabAdrCrtc[ adr ];
        if ( adCrtc > -1 )
            {
            char * ad = TabPoints[ lastMode ][ MemCPC[ adCrtc + OfsEcr ] ];
            * p++ = TabCoul[ * ad++ ];
            * p++ = TabCoul[ * ad++ ];
            * p++ = TabCoul[ * ad++ ];
            * p++ = TabCoul[ * ad++ ];
            * p++ = TabCoul[ * ad++ ];
            * p++ = TabCoul[ * ad++ ];
            * p++ = TabCoul[ * ad++ ];
            * p++ = TabCoul[ * ad ];
            }
        else
            {
            int Border = TabCoul[ 16 ];
            * p++ = Border;
            * p++ = Border;
            * p++ = Border;
            * p++ = Border;
            * p++ = Border;
            * p++ = Border;
            * p++ = Border;
            * p++ = Border;
            }
        }
}


/********************************************************* !NAME! **************
* Nom : TraceLigne32B320
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Trace une ligne cran de 320 points en couleurs 32 bits
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void TraceLigne32B320( int y )
{
    int x, adr = y * 80;

    int * p = ( int * )MemBitmap;
    p += y * 320;
    for ( x = 0; x < 80; x++, adr++ )
        {
        int adCrtc = TabAdrCrtc[ adr ];
        if ( adCrtc != 0xFFFF )
            {
            char * ad = TabPoints[ lastMode ][ MemCPC[ adCrtc + OfsEcr ] ];
            * p++ = TabCoul[ ad[ 0 ] ];
            * p++ = TabCoul[ ad[ 2 ] ];
            * p++ = TabCoul[ ad[ 4 ] ];
            * p++ = TabCoul[ ad[ 6 ] ];
            }
        else
            {
            int Border = TabCoul[ 16 ];
            * p++ = Border;
            * p++ = Border;
            * p++ = Border;
            * p++ = Border;
            }
        }
}


/********************************************************* !NAME! **************
* Nom : TraceLigne16B640
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Trace une ligne cran de 640 points en couleurs 16 bits
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void TraceLigne16B640( int y )
{
    int x, adr = y * 80;

    USHORT * p = ( USHORT * )MemBitmap;
    p += y * 640;
    for ( x = 0; x < 80; x++, adr++ )
        {
        int adCrtc = TabAdrCrtc[ adr ];
        if ( adCrtc > -1 )
            {
            char * ad = TabPoints[ lastMode ][ MemCPC[ adCrtc + OfsEcr ] ];
            * p++ = ( USHORT )TabCoul[ * ad++ ];
            * p++ = ( USHORT )TabCoul[ * ad++ ];
            * p++ = ( USHORT )TabCoul[ * ad++ ];
            * p++ = ( USHORT )TabCoul[ * ad++ ];
            * p++ = ( USHORT )TabCoul[ * ad++ ];
            * p++ = ( USHORT )TabCoul[ * ad++ ];
            * p++ = ( USHORT )TabCoul[ * ad++ ];
            * p++ = ( USHORT )TabCoul[ * ad ];
            }
        else
            {
            int Border = TabCoul[ 16 ];
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            }
        }
}


/********************************************************* !NAME! **************
* Nom : TraceLigne16B320
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Trace une ligne cran de 320 points en couleurs 16 bits
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void TraceLigne16B320( int y )
{
    int x, adr = y * 80;

    USHORT * p = ( USHORT * )MemBitmap;
    p += y * 320;
    for ( x = 0; x < 80; x++, adr++ )
        {
        int adCrtc = TabAdrCrtc[ adr ];
        if ( adCrtc > -1 )
            {
            char * ad = TabPoints[ lastMode ][ MemCPC[ adCrtc + OfsEcr ] ];
            * p++ = ( USHORT )TabCoul[ ad[ 0 ] ];
            * p++ = ( USHORT )TabCoul[ ad[ 2 ] ];
            * p++ = ( USHORT )TabCoul[ ad[ 4 ] ];
            * p++ = ( USHORT )TabCoul[ ad[ 6 ] ];
            }
        else
            {
            int Border = TabCoul[ 16 ];
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            * p++ = ( USHORT )Border;
            }
        }
}


/********************************************************* !NAME! **************
* Nom : TraceLigne8B640
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Trace une ligne cran de 640 points en couleurs 8 bits
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void TraceLigne8B640( int y )
{
    int x, adr = y * 80;

    UBYTE * p = ( UBYTE * )MemBitmap;
    p += adr << 3;
    for ( x = 0; x < 80; x++, adr++ )
        {
        int adCrtc = TabAdrCrtc[ adr ];
        if ( adCrtc > -1 )
            {
            char * ad = TabPoints[ lastMode ][ MemCPC[ adCrtc + OfsEcr ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 0 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 1 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 2 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 3 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 4 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 5 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 6 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 7 ] ];
            }
        else
            {
            memset( p, TabCoul[ 16 ], 8 );
            p += 8;
            }
        }
}


/********************************************************* !NAME! **************
* Nom : TraceLigne8B320
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Trace une ligne cran de 320 points en couleurs 8 bits
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void TraceLigne8B320( int y )
{
    int x, adr = y * 80;

    UBYTE * p = ( UBYTE * )MemBitmap;
    p += adr << 2;
    for ( x = 0; x < 80; x++, adr++ )
        {
        int adCrtc = TabAdrCrtc[ adr ];
        if ( adCrtc != 0xFFFF )
            {
            char * ad = TabPoints[ lastMode ][ MemCPC[ adCrtc + OfsEcr ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 0 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 2 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 4 ] ];
            * p++ = ( UBYTE )TabCoul[ ad[ 6 ] ];
            }
        else
            {
            memset( p, TabCoul[ 16 ], 4 );
            p += 4;
            }
        }
}


/********************************************************* !NAME! **************
* Nom : UpdateScreen
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Affiche l'cran du CPC
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void UpdateScreen( void )
{
    GdiFlush();
    if ( SmallScreen )
        BitBlt( DeviceContext, 0, 0, 320, 266
              , DcBitmap, 0, 0
              , SRCCOPY
              );
    else
        StretchBlt( DeviceContext, 20, 6, 640, 532
                  , DcBitmap, 0, 0, 640, 266
                  , SRCCOPY
                  );
}
