/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Chips!
// Dfinition du module        !CONFIG!=/V4!VGA!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Chips
* ------------------------------------------------------------------------------
*  Fichier     : VGA.C                 | Version : 0.1p
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Emulation du circuit VGA
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <stdio.h>

#include  "types.h"
#ifdef USE_MULTIFACE
#include  "multiface.h"
#endif
#include  "config.h"
#ifdef USE_LOG
#include  "log.h"
#endif
#include  "z80.h"
#include  "vga.h"


extern int CntHSync;


/********************************************************* !NAME! **************
* Nom : MemCPC
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Mmoire du CPC
*
********************************************************** !0! ****************/
UBYTE MemCPC[ 0x20000 ];


/********************************************************* !NAME! **************
* Nom : TabPOKE
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Mapping des critures vers mmoire CPC
*
********************************************************** !0! ****************/
UBYTE * TabPOKE[ 4 ];


/********************************************************* !NAME! **************
* Nom : TabPEEK
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Mapping des lectures depuis mmoire CPC
*
********************************************************** !0! ****************/
UBYTE * TabPEEK[ 4 ];


/********************************************************* !NAME! **************
* Nom : TabCoul
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Couleurs R,V,B
*
********************************************************** !0! ****************/
int TabCoul[ 32 ];


/********************************************************* !NAME! **************
* Nom : TabInk
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Numro de couleur
*
********************************************************** !0! ****************/
int TabInk[ 32 ];


/********************************************************* !NAME! **************
* Nom : RamSelect
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Numro de ram slectionne (128K)
*
********************************************************** !0! ****************/
int RamSelect;


/********************************************************* !NAME! **************
* Nom : lastMode
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Mode cran slectionn
*
********************************************************** !0! ****************/
int lastMode;


/********************************************************* !NAME! **************
* Nom : DecodeurAdresse
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : ROMs actives/dsactives
*
********************************************************** !0! ****************/
int DecodeurAdresse;


/********************************************************* !NAME! **************
* Nom : RomExt
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Numro de rom suprieure slectionne
*
********************************************************** !0! ****************/
int RomExt;


/********************************************************* !NAME! **************
* Nom : PenSelect
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Numro de stylot slectionn
*
********************************************************** !0! ****************/
int PenSelect;


/********************************************************* !NAME! **************
* Nom : ROMINF
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Rom infrieure
*
********************************************************** !0! ****************/
static UBYTE ROMINF[ 0x4000 ];


/********************************************************* !NAME! **************
* Nom : ROMSUP
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Rom suprieure
*
********************************************************** !0! ****************/
static UBYTE ROMSUP[ 0x4000 ];


/********************************************************* !NAME! **************
* Nom : ROMDISC
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Rom disque (Amsdos)
*
********************************************************** !0! ****************/
static UBYTE ROMDISC[ 0x4000 ];


/********************************************************* !NAME! **************
* Nom : RgbCPC
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Couleurs R,V,B du cpc
*
********************************************************** !0! ****************/
int RgbCPC[ 32 ] =
    {
     0x7F7F7F,                 // Blanc            (13)
     0x7F7F7F,                 // Blanc            (13)
     0x00FF7F,                 // Vert Marin       (19)
     0xFFFF7F,                 // Jaune Pastel     (25)
     0x00007F,                 // Bleu              (1)
     0xFF007F,                 // Pourpre           (7)
     0x007F7F,                 // Turquoise        (10)
     0xFF7F7F,                 // Rose             (16)
     0xFF007F,                 // Pourpre           (7)
     0xFFFF00,                 // Jaune vif        (24)
     0xFFFF00,                 // Jaune vif        (24)
     0xFFFFFF,                 // Blanc Brillant   (26)
     0xFF0000,                 // Rouge vif         (6)
     0xFF00FF,                 // Magenta vif       (8)
     0xFF7F00,                 // Orange           (15)
     0xFF7FFF,                 // Magenta pastel   (17)
     0x00007F,                 // Bleu              (1)
     0x00FF7F,                 // Vert Marin       (19)
     0x00FF00,                 // Vert vif         (18)
     0x00FFFF,                 // Turquoise vif    (20)
     0x000000,                 // Noir              (0)
     0x0000FF,                 // Bleu vif          (2)
     0x007F00,                 // Vert              (9)
     0x007FFF,                 // Bleu ciel        (11)
     0x7F007F,                 // Magenta           (4)
     0x7FFF7F,                 // Vert pastel      (22)
     0x7FFF00,                 // Vert citron      (21)
     0x7FFFFF,                 // Turquoise pastel (23)
     0x7F0000,                 // Rouge             (3)
     0x7F00FF,                 // Mauve             (5)
     0x7F7F00,                 // Jaune            (12)
     0x7F7FFF                  // Bleu pastel      (14)
    };


/********************************************************* !NAME! **************
* Nom : AdjRam
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Configuration de la ram en fonction du registre de slection
*
********************************************************** !0! ****************/
static int AdjRam[ 4 ][ 8 ] =
    {
    0x00000, 0x00000, 0x10000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
    0x04000, 0x04000, 0x14000, 0x0C000, 0x10000, 0x14000, 0x18000, 0x1C000,
    0x08000, 0x08000, 0x18000, 0x08000, 0x08000, 0x08000, 0x08000, 0x08000,
    0x0C000, 0x1C000, 0x1C000, 0x1C000, 0x0C000, 0x0C000, 0x0C000, 0x0C000
    };


/********************************************************* !NAME! **************
* Nom : SetMemCPC
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Mapping de la mmoire du CPC en fonction de la slection des
*               roms et rams
*
* Rsultat    : /
*
* Variables globales modifies : TabPOKE, TabPEEK
*
********************************************************** !0! ****************/
static void SetMemCPC( void )
{
#ifdef USE_MULTIFACE
    TabPOKE[ 0 ] = MultifaceEnable && ( ! ( DecodeurAdresse & ROMINF_OFF ) ) ?
                       MULTIFACE_ROM :
                       &MemCPC[ AdjRam[ 0 ][ RamSelect ] ];
    TabPEEK[ 0 ] = ( DecodeurAdresse & ROMINF_OFF ) ?
                       &MemCPC[ AdjRam[ 0 ][ RamSelect ] ] :
                       MultifaceEnable ?
                           MULTIFACE_ROM :
                           ROMINF;
#else
    TabPOKE[ 0 ] = &MemCPC[ AdjRam[ 0 ][ RamSelect ] ];
    TabPEEK[ 0 ] = ( DecodeurAdresse & ROMINF_OFF ) ?
                       &MemCPC[ AdjRam[ 0 ][ RamSelect ] ] :
                       ROMINF;
#endif
    TabPOKE[ 1 ] =
    TabPEEK[ 1 ] = &MemCPC[ AdjRam[ 1 ][ RamSelect ] ];

    TabPOKE[ 2 ] =
    TabPEEK[ 2 ] = &MemCPC[ AdjRam[ 2 ][ RamSelect ] ];

    TabPOKE[ 3 ] = &MemCPC[ AdjRam[ 3 ][ RamSelect ] ];

    TabPEEK[ 3 ] = ( DecodeurAdresse & ROMSUP_OFF ) ?
                   &MemCPC[ AdjRam[ 3 ][ RamSelect ] ] :
                       ( RomExt == 7 ) ?
                       ROMDISC :
                       ROMSUP;
}


/********************************************************* !NAME! **************
* Nom : WriteVGA
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Ecriture d'un registre du VGA
*
* Rsultat    : /
*
* Variables globales modifies : PenSelect, TabCoul, TabInk, DecodeurAdresse,
*                                lastMode, CntHSync, IRQ, RamSelect
*
********************************************************** !0! ****************/
void WriteVGA( int val )
{
    int newVal = val & 0x1F;

    switch( val >> 6 )
        {
        case 0 :
            PenSelect = newVal;
            break;

        case 1 :
            TabCoul[ PenSelect ] = RgbCPC[ newVal ];
            TabInk[ PenSelect ] = newVal;
            break;

        case 2 :
            DecodeurAdresse = val;
            lastMode = val & 3;
            SetMemCPC();
            if ( val & 16 )
                {
                CntHSync = 0;
                IRQ = 0;
                }
            break;

        case 3 :
            RamSelect = val & 7;
            SetMemCPC();
            break;
        }
}


/********************************************************* !NAME! **************
* Nom : WriteROM
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Slection du numro de rom suprieure
*
* Rsultat    : /
*
* Variables globales modifies : RomExt
*
********************************************************** !0! ****************/
void WriteROM( int val )
{
    RomExt = val;
    SetMemCPC();
}


/********************************************************* !NAME! **************
* Nom : InitMemCPC
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Initialisation : lecture des roms du cpc
*
* Rsultat    : TRUE si ok, FALSE sinon
*
* Variables globales modifies : ROMINF, ROMSUP, ROMDISC
*
********************************************************** !0! ****************/
BOOL InitMemCPC( void )
{
    FILE * fp;
#ifdef USE_LOG
    char Msg[ 80 ];
#endif

    fp = fopen( LocRomInf, "rb" );
    if ( fp )
        {
        fread( ROMINF, sizeof( ROMINF ), 1, fp );
        fclose( fp );
        fp = fopen( LocRomSup, "rb" );
        if ( fp )
            {
            fread( ROMSUP, sizeof( ROMSUP ), 1, fp );
            fclose( fp );
            fp = fopen( LocRomDisc, "rb" );
            if ( fp )
                {
                fread( ROMDISC, sizeof( ROMDISC ), 1, fp );
                fclose( fp );
                WriteVGA( 0x89 );
                WriteVGA( 0xC0 );
                return( TRUE );
                }
#ifdef USE_LOG
            else
                {
                sprintf( Msg, "Fichier %s non trouv.", LocRomDisc );
                Log( Msg, LOG_WARNING );
                }
#endif
            }
#ifdef USE_LOG
        else
            {
            sprintf( Msg, "Fichier %s non trouv.", LocRomSup );
            Log( Msg, LOG_WARNING );
            }
#endif
        }
#ifdef USE_LOG
    else
        {
        sprintf( Msg, "Fichier %s non trouv.", LocRomInf );
        Log( Msg, LOG_WARNING );
        }
#endif
    return( FALSE );
}
